# RV1106 Release Note

## rv1106_usbplug_w25n01xx_v1.09.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2025-03-20 | rv1106_usbplug_w25n01xx_v1.09.bin | 2c14bb7e419    | moderate |

### New

1. Support w25n0xxx spinand continues read mode.

------

## rv1106_tee_ta_v1.13.bin

| Date       | File                    | Build commit | Severity  |
| ---------- | :---------------------- | ------------ | --------- |
| 2024-10-31 | rv1106_tee_ta_v1.13.bin | 9f2aca7d1    | important |

### New

1. Change the TEE loading address to 61M position.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | check whether the rpmb key has been burned before changing security level | upgrading from weak security level to strong security level may result in rpmb key verification failure |              |
| 2     | important | fixed RSA OAEP MGF1 algorithm                                | TA will report an error when using RSA algorithm OAEP MGF1 padding method | -            |
| 3     | important | fixed condition of whether secure boot is enabled            | Under unstable hardware conditions, it may be mistakenly believed that secure boot is enabled | -            |

------

## rv1106_tee_ta_v1.12.bin

| Date       | File                    | Build commit | Severity  |
| ---------- | :---------------------- | ------------ | --------- |
| 2024-09-02 | rv1106_tee_ta_v1.12.bin | 6c78a7d8c    | important |

### New

1. Support software TA encryption key, customers can use TA encryption function without burning the key.
2. Enable dynamic shared memory, default to using reserved shared memory.
3. Support OTP hardware lock, allowing secure and non secure OTP access simultaneously.
4. RPMB change read data to multiple times.
5. Increase MPI_MEMPOOL_SIZE size.

------

## rv1106_tee_ta_v1.11.bin

| Date       | File                    | Build commit | Severity  |
| ---------- | :---------------------- | ------------ | --------- |
| 2024-04-16 | rv1106_tee_ta_v1.11.bin | 185dc3c92    | important |

### New

1. Optimization parameter check to enhance security.
2. Support printing TEE memory usage information.
3. Hardware crypto supports addresses exceeding 4G.
4. Support printing FWVER information.

------

## rv1106_hpmcu_wrap_v1.70.bin

| Date      | File                        | Build commit                     | Severity |
| --------- | :-------------------------- | ------------------------------- | -------- |
| 2024-04-03 | rv1106_hpmcu_wrap_v1.70.bin | rockit_ko:db3c2c7#hal:a76806e7 | important     |

### New

1. Support double channel wrap.

------

## rv1106_usbplug_v1.09.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2024-02-06 | rv1106_usbplug_v1.09.bin | 20b8d8f8d    | important |

### New

1. Support new SPI Flash.

------

## rv1106_hpmcu_tb_sc450ai_v1.91.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2024-01-26 | rv1106_hpmcu_tb_sc450ai_v1.91.bin | rtt:4f71a2d#hal:8966acbf#battery_ipc:1497fb5 | important |

### New

1. Add sc450ai thunder boot mcu image.

------

## rv1106_hpmcu_tb_sc3336_sc3338_v1.91.bin

| Date       | File                                     | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | --------------| -------- |
| 2024-01-25 | rv1106_hpmcu_tb_sc3336_sc3338_v1.91.bin | rtt:4797a34#hal:8966acbf#battery_ipc:1497fb5 | important |

### Fixed

| Index | Severity  | Update                            | Issue description | Issue source |
| ----- | --------- | --------------------------        | ----------------- | ------------ |
| 1     | important | fix SC3338's first frame too dark | -                 | -            |

------

## rv1106_ddr_{924...792}MHz{_tb}_v1.15.bin

| Date       | File                                     | Build commit | Severity  |
| ---------- | :--------------------------------------- | ------------ | --------- |
| 2023-12-21 | rv1106_ddr_{924...792}MHz{_tb}_v1.15.bin | 306b9977f5   | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ----------------- | ------------ |
| 1     | moderate  | Fix possible exceptions when size of SPL is too large        | -                 | -            |
| 2     | important | Enhanced stability of DDR bin stage at low temperatures      | -                 | -            |
| 3     | important | Modify timer configuration to fit suspend & resume requirements | -                 | -            |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,sc200ai,dual_sc3338,dual_sc301iot_sc230ai}_v1.90.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | --------------| -------- |
| 2023-12-15 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,sc200ai,dual_sc3338,dual_sc301iot_sc230ai}_v1.90.bin | rtt:e31465907#hal:8966acbf#battery_ipc:1497fb5 | important |

### New

1. Update fastae to V2.3.2-rc1.

------

## rv1106_hpmcu_tb_sc200ai_v1.80.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | --------------| -------- |
| 2023-12-07 | rv1106_hpmcu_tb_sc200ai_v1.80.bin | rtt:0329fd0d9#hal:8966acbf#battery_ipc:0766081 | important   |

### New

1. Add ssc200ai thunder boot mcu image.

------

## rv1106_hpmcu_tb_gc2093_v1.80.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | --------------| -------- |
| 2023-11-30 | rv1106_hpmcu_tb_gc2093_v1.80.bin | rtt:0329fd0#hal:8966acbf#battery_ipc:0766081 | important |

### Fixed

| Index | Severity | Update                 | Issue description | Issue source |
| ----- | -------- | --------------------- | ------------------------ | -------- |
| 1     | important| update with AOV | update with AOV | -        |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.80.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------------------------------------------- | --------------| -------- |
| 2023-11-15 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.80.bin | rtt:e31465907#hal:8966acbf#battery_ipc:0766081 | important |

### Fixed

| Index | Severity | Update                 | Issue description | Issue source |
| ----- | -------- | --------------------- | ------------------------ | -------- |
| 1     | important| update with AOV | update with AOV | -        |

------

## rv1106_hpmcu_tb_dual_camera_sc230ai_sc230ai_v1.71.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2023-11-03 | rv1106_hpmcu_tb_dual_camera_sc230ai_sc230ai_v1.71.bin | rtt:6245841#hal:d93ef9fd#battery_ipc:58c85a0 | important |

### New

1. Add master/slaver mode for sc230ai dual camera.

------

## rv1106_ddr_{924...792}MHz{_tb}_v1.14.bin

| Date       | File                                     | Build commit | Severity |
| ---------- | :--------------------------------------- | ------------ | -------- |
| 2023-10-24 | rv1106_ddr_{924...792}MHz{_tb}_v1.14.bin | 1df264c461   | moderate |

### New

1. Add rv1106_ddr_792MHz_tb_v1.14.bin for RV1106MINIALL_SPI_NOR_WAKEUP.ini.

### Fixed

| Index | Severity | Update                 | Issue description | Issue source |
| ----- | -------- | ---------------------- | ----------------- | ------------ |
| 1     | moderate | Optimize DDR SI of BGA | -                 | -            |

------

## rv1106_usbplug_v1.08.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2023-10-10 | rv1106_usbplug_v1.08.bin | I0043a8b1    | important |

### New

1. Upgrade using pre made images for 4KB page size spinand.

------

## rv1106_spl_v1.02.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2023-09-28 | rv1106_spl_v1.02.bin | f1d94e1902   | important |

### New

1. Support for A/B systems.
2. Print and pass the firmware version number.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that the backup image is not loaded when the SPL load or check u-boot.dtb fails | When u-boot.dtb of the first uboot.img is corrupted, SPL doesn't load the backup image. | -            |

------

## rv1106_hpmcu_tb_gc2093_v1.71.bin

| Date       | File                                                     | Build commit                                   | Severity |
| ---------- | :------------------------------------------------------- | ------------------------------------------------ | -------- |
| 2023-09-25 | rv1106_hpmcu_tb_gc2093_v1.71.bin | rtt:85fc0c39#hal:d93ef9fd#battery_ipc:7ca1398 | moderate     |

### Fixed

| Index | Severity  | Update                                  | Issue description      | Issue source |
| ----- | -------- | ---------------------------------------- | ----------------------- | -------- |
| 1     | moderate | change the output of the mcu log | -       | -        |

------

## rv1106_spl_spi_nand_tb_v1.00.bin

| Date       | File                             | Build commit     | Severity |
| ---------- | :--------------------------------| -----------------| -------- |
| 2023-09-20 | rv1106_spl_spi_nand_tb_v1.00.bin | fe3a439f27 | important|

### New

1. Add SPI NAND with fastboot for RV1106.

------

## rv1106_hpmcu_tb_gc2093_v1.70.bin

| Date       | File                                                     | Build commit                                   | Severity |
| ---------- | :------------------------------------------------------- | ------------------------------------------------ | -------- |
| 2023-09-05 | rv1106_hpmcu_tb_gc2093_v1.70.bin | rtt:3b74006#hal:d93ef9fd#battery_ipc:7ca1398 | important     |

### Fixed

| Index | Severity  | Update                                  | Issue description      | Issue source |
| ----- | -------- | ---------------------------------------- | ----------------------- | -------- |
| 1     | important | update fastae to V2.2.4, fix bug of gc2093 init sequence | Optimize image effects | -        |

------

## rv1106_hpmcu_wakeup_v1.00.bin

| Date       | File                          | Build Commit                                   | Severity  |
| ---------- | :---------------------------- | ---------------------------------------------- | --------- |
| 2023-08-12 | rv1106_hpmcu_wakeup_v1.00.bin | rtt:b8797aaef#hal:db7ed87c#battery_ipc:37ee045 | important |

### New

1. The RV1106 platform supports the HPMCU sleep wake-up process.

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.70.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-08-15 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.70.bin | rtt:b753ad6#hal:d93ef9fd#battery_ipc:7ca1398 | important  |

### Fixed

| Index | Severity  | Update    | Issue description      | Issue source |
| ----- | --------- | --------- | --------------------   | ------------ |
| 1     | important | update fastae to V2.2.4  | Optimize image effects | -        |

------

## rv1106_hpmcu_wrap_v1.60.bin

| Date       | File                        | Build commit                     | Severity |
| ---------- | :-------------------------- | ------------------------------- | -------- |
| 2023-08-11 | rv1106_hpmcu_wrap_v1.60.bin | rockit_ko:a9f7a933#hal:a76806e7 | important     |

### New

1. Optimize LOG printing.
2. Frame loss CNT not reset.
3. Optimize frame loss detection mechanism.

------

## rv1106_tee_ta_v1.10.bin

| Date       | File                    | Build commit | Severity  |
| ---------- | :---------------------- | ------------ | --------- |
| 2023-08-02 | rv1106_tee_ta_v1.10.bin | 494b5c8d3    | important |

### New

1. Support MCU config.
2. Support security level, the derived secure storage key is different, so the secure storage is not compatible with the previous version.

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.69.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-07-28 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.69.bin | rtt:b753ad6#hal:d93ef9fd#battery_ipc:1ced039 | important  |

### Fixed

| Index | Severity  | Update    | Issue description      | Issue source |
| ----- | --------- | --------- | --------------------   | ------------ |
| 1     | important | update fastae to V2.2.3  | Solve soft light-sensitive exposure problems | -        |
| 2 | important | update SC230AI dgain | Solve SC230AI exposure problem | - |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.68.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-07-20 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.68.bin | rtt:097fece#hal:d93ef9fd#battery_ipc:21165ac | important  |

### Fixed

| Index | Severity  | Update                       | Issue description                                                  | Issue source |
| ----- | --------- | --------------------------   | ----------------------------------------                           | ------------ |
| 1     | important | Fixes init thread stack overflow | rtt thread init overflow | -        |
| 2 | important | Fixes isp's share memory was destroied by meta | RISC-V cost 1f more than before | - |
| 3 | important | Disable rtt serial port log printing | - | - |

------

## rv1106_ddr_924MHz{_tb}_v1.13.bin

| Date       | File                             | Build commit | Severity |
| ---------- | :------------------------------- | ------------ | -------- |
| 2023-07-10 | rv1106_ddr_924MHz{_tb}_v1.13.bin | 37a6671fc7   | moderate |

### New

1. Supports DDR sleep and resume.

------

## rv1106_hpmcu_tb_gc2093_v1.66.bin

| Date       | File                        | Build commit                     | Severity |
| ---------- | :-------------------------- | ------------------------------- | -------- |
| 2023-07-04 | rv1106_hpmcu_tb_gc2093_v1.66.bin | rtt:f047d6a191#hal:d93ef9fd#battery_ipc:68c599d | important |

### Fixed

| Index | Severity  | Update                     | Issue description                        | Issue source |
| ----- | --------- | -------------------------- | ---------------------------------------- | ------------ |
| 1     | important | AIQ update to v5.0x1.2-rc5; Fixes null ptr; | -                  | -        |

------

## rv1106_hpmcu_tb_gc2093_v1.65.bin

| Date       | File                        | Build commit                     | Severity |
| ---------- | :-------------------------- | ------------------------------- | -------- |
| 2023-06-25 | rv1106_hpmcu_tb_gc2093_v1.65.bin | rtt:d2d09ba#hal:d93ef9fd#battery_ipc:0534d87 | important     |

### Fixed

| Index | Severity  | Update                     | Issue description                        | Issue source |
| ----- | --------- | -------------------------- | ---------------------------------------- | ------------ |
| 1     | important | AIQ update to v5.0x1.2-rc4 | Resolve RTT boot-up coredump             | -        |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.67.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-06-21 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338,dual_sc301iot_sc230ai}_v1.67.bin | rtt:f047d6a191#hal:d93ef9fd#battery_ipc:68c599d | important  |

### Fixed

| Index | Severity  | Update                       | Issue description                                                  | Issue source |
| ----- | --------- | --------------------------   | ----------------------------------------                           | ------------ |
| 1     | important | Fixes null ptr | Resolve  kernel can't startup on dual cameras scenario | -        |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338}_v1.66.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-06-07 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338}_v1.66.bin | rtt:07ac6e9#hal:d93ef9fd#battery_ipc:04a4e08 | important  |

### Fixed

| Index | Severity  | Update                       | Issue description                                                  | Issue source |
| ----- | --------- | --------------------------   | ----------------------------------------                           | ------------ |
| 1     | important | AIQ update to v5.0x1.2-rc5  | Resolve RTT boot-up coredump                  | -        |

------

## rv1106_tee_ta_v1.00.bin

| Date       | File                    | Build commit | Severity  |
| ---------- | :---------------------- | ------------ | --------- |
| 2023-06-02 | rv1106_tee_ta_v1.00.bin | eda5ab67     | important |

### New

1. The RV1106 platform supports OPTEE.

------

## rv1106_ddr_924MHz{_tb}_v1.12.bin

| Date       | File                             | Build commit | Severity |
| ---------- | :------------------------------- | ------------ | -------- |
| 2023-05-31 | rv1106_ddr_924MHz{_tb}_v1.12.bin | 6cf9a2f250   | critical |

### Fixed

| Index | Severity  | Update                                   | Issue description                                            | Issue source |
| ----- | --------- | ---------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | critical  | Change DDR3 power down mode to fast exit | DDR3 power down in slow exit mode may be unstable in certain scenarios | -            |
| 2     | important | Change default DDR refresh rate to 4x    | Enhance the stability of DDR in high temperature environment | -            |

------

## rv1106_hpmcu_wrap_v1.56.bin

| Date       | File                        | Build commit                     | Severity |
| ---------- | :-------------------------- | ------------------------------- | -------- |
| 2023-05-11 | rv1106_hpmcu_wrap_v1.56.bin | rockit_ko:d1a2dabb#hal:a76806e7 | important     |

### New

1. Use new wrap struct.

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338}_v1.65.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-05-06 | rv1106_hpmcu_tb_{sc230ai,sc3338,sc4336,dual_sc3338}_v1.65.bin | rtt:d2d09ba#hal:d93ef9fd#battery_ipc:0534d87 | important  |

### Fixed

| Index | Severity  | Update                       | Issue description                                                  | Issue source |
| ----- | --------- | --------------------------   | ----------------------------------------                           | ------------ |
| 1     | important | AIQ update to v5.0x1.2-rc4  | Resolve RTT boot-up coredump                  | -        |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336,dual_sc3338}_v1.64.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-04-04 | rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336,dual_sc3338}_v1.64.bin | rtt:c6b03745b#hal:d93ef9fd#battery_ipc:12da3e7 | critical |

### Fixed

| Index | Severity  | Update                       | Issue description                                                  | Issue source |
| ----- | --------- | --------------------------   | ----------------------------------------                           | ------------ |
| 1     | critical | Fix the camera_num not init. | If camera_num not init, it causes the drop cache to take much time | -            |
| 2     | important | Sync meta's head file.       | Modify the partition of meta                                       | -            |
| 3 | important | Fix the secondary camera mirror and flip parameter config error | the secondary camera mirror and flip parameter use the wrong config | - |

------

## rv1106_hpmcu_tb_gc2093_v1.64.bin

| Date       | File                                                     | Build commit                                   | Severity  |
| ---------- | :------------------------------------------------------- | ------------------------------------------------ | -------- |
| 2023-03-31 | rv1106_hpmcu_tb_gc2093_v1.64.bin | rtt:bd3010959#hal:e2f3eac3#battery_ipc:61d3fb5 | important     |

### New

1. Sync with AIQ V5.0x1.2-rc2.

------

## rv1106_usbplug_v1.07.bin

| Date       | File                                                     | Build commit                                   | Severity  |
| ---------- | :------------------------------------------------------- | ------------------------------------------------ | -------- |
| 2023-03-16 | rv1106_usbplug_v1.07.bin                                 | I6b73e5e                            | important    |

### New

1. Support new spi flash.

------

## rv1106_ddr_924MHz{_tb}_v1.11.bin

| Date       | File                             | Build commit | Severity  |
| ---------- | :------------------------------- | ------------ | --------- |
| 2023-03-28 | rv1106_ddr_924MHz{_tb}_v1.11.bin | 285bced5c1   | important |

### Fixed

| Index | Severity  | Update                     | Issue description                        | Issue source |
| ----- | --------- | -------------------------- | ---------------------------------------- | ------------ |
| 1     | important | Change DDR3 CLK drv of QFN | DDR may be unstable in certain scenarios | -            |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336,dual_sc3338}_v1.63.bin

| Date       | File                                                         | Build commit                                   | Severity |
| ---------- | :----------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-03-24 | rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336,dual_sc3338}_v1.63.bin | rtt:c6b03745b#hal:d93ef9fd#battery_ipc:f52bf08 | critical |

### New

1. Add dual sc3338 camera driver support.
2. Support to get DPHY, VICAP, CSI2HOST device info from board config.
3. Support dual camera fastboot.

------

## rv1106_hpmcu_tb_gc2093_v1.63.bin

| Date       | File                                                     | Build commit                                   | Severity  |
| ---------- | :------------------------------------------------------- | ------------------------------------------------ | -------- |
| 2023-03-07 | rv1106_hpmcu_tb_gc2093_v1.63.bin | rtt:831ea1368#hal:d93ef9fd#battery_ipc:12d4661 | important     |

### New

1. Gc2093 add 1920x1080@25fps 27M mclk.

------

## rv1106_hpmcu_tb_gc2093_v1.62.bin

| Date       | File                                                     | Build commit                                   | Severity  |
| ---------- | :------------------------------------------------------- | ---------------------------------------------- | --------- |
| 2023-02-16 | rv1106_hpmcu_tb_gc2093_v1.62.bin | rtt:5a5a088d0#hal:d93ef9fd#battery_ipc:12d4661 | critical |

### New

1. Fast ae supports up to 20 frames as default.
2. Add IR/white light mode support.
3. Add support for nonlinear single range ADC.
4. Add support for soft light sensor.
5. Supports the configuration of fast ae run frame number.

### Fixed

| 1     | critical | Limit camera convergence time. | Camera spends too much time converging，it causes the thunderboot isp driver in kernel fails to start stream. | -            |
| 2     | critical | Fixed repeated ircut and light Settings. | Under analog light sensor, after setting night mode to 3/4, ircut and light will be set again in frame 6. | -            |
| 1     | critical | In the soft light sensor scheme, the fastae converges before the fill light is stabilized in the night vision mode | Fastae converges before the fill light is stabilized in night vision mode, resulting in abnormal exposure. | -     |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336}_v1.62.bin

| Date       | File                                                     | Build commit                                   | Severity  |
| ---------- | :------------------------------------------------------- | ---------------------------------------------- | --------- |
| 2023-02-01 | rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336}_v1.62.bin | rtt:5a5a088d0#hal:d93ef9fd#battery_ipc:12d4661 | critical |

### Fixed

| Index | Severity  | Update                                                       | Issue source                                                 | Issue |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ----- |
| 1     | critical | In the soft light sensor scheme, the fastae converges before the fill light is stabilized in the night vision mode | Fastae converges before the fill light is stabilized in night vision mode, resulting in abnormal exposure. | -     |

------

## rv1106_hpmcu_wrap_v1.54.bin

| Date       | File                        | Build commit                     | Severity |
| ---------- | :-------------------------- | ------------------------------- | -------- |
| 2023-1-15 | rv1106_hpmcu_wrap_v1.54.bin | rockit_ko:69d42563#hal:a76806e7 | important     |

### Fixed

| Index | Severity  | Update                    | Issue source                          | Issue |
| ----- | --------- | --------------------------- | --------------------------------- | -------- |
| 1     | important | Increase the monitoring conditions of wrap OVERFLOW | image tear possiable | -        |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336}_v1.61.bin

| Date       | File                                                     | Build commit                                   | Severity |
| ---------- | :------------------------------------------------------- | ---------------------------------------------- | -------- |
| 2023-01-05 | rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336}_v1.61.bin | rtt:5a5a088d0#hal:d93ef9fd#battery_ipc:dacbbc1 | critical |

### Fixed

| Index | Severity | Update                                   | Issue description                                            | Issue source |
| ----- | -------- | ---------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | critical | Fixed the gc3003 pre-opening problem.    | If sensor stream on advanced，isp will met dqbuf sem failed error. | -            |
| 2     | critical | Fixed repeated ircut and light Settings. | Under analog light sensor, after setting night mode to 3/4, ircut and light will be set again in frame 6. | -            |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336}_v1.60.bin
| Date       | File                                                     | build commit                                     | Severity |
| ---------- | :------------------------------------------------------- | ------------------------------------------------ | -------- |
| 2022-12-22 | rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003,sc4336}_v1.60.bin | rtt:755701b24#hal:d93ef9fd#battery_ipc:18df679ea | critical |

### New

1. Add sc4336 support.
2. Fast ae supports up to 20 frames as default.
3. Add IR/white light mode support.
4. Add support for nonlinear single range ADC.
5. Add support for soft light sensor.
6. Supports the configuration of fast ae run frame number.

### Fixed

| Index | Severity | Update                                | Issue description                                            | Issue source |
| ----- | -------- | ------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | critical | Fixed the gc3003 pre-opening problem. | If sensor stream on advanced，isp will met dqbuf sem failed error. | -            |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003}_v1.50.bin

| Date       | File                                              | Build commit                                | Severity |
| ---------- | :------------------------------------------------ | ------------------------------------------- | -------- |
| 2022-11-17 | rv1106_hpmcu_tb_{sc230ai,sc3338,gc3003}_v1.50.bin | rtt:a40f17d#hal:b569247#battery_ipc:c62dd55 | critical |

### New

1. Sc3338 add 1152x648@60fps 27M mclk bining config，chose this config as default.
2. Add gc3003 sensor support.

### Fixed

| Index | Severity | Update                         | Issue description                                            | Issue source |
| ----- | -------- | ------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | critical | Limit camera convergence time. | Camera spends too much time converging，it causes the thunderboot isp driver in kernel fails to start stream. | -            |

------

## rv1106_hpmcu_wrap_v1.53.bin

| Date       | File                        | Build commit                     | Severity |
| ---------- | :-------------------------- | ------------------------------- | -------- |
| 2022-11-16 | rv1106_hpmcu_wrap_v1.53.bin | rockit_ko:c9653fe9#hal:a76806e7 | important     |

### Fixed

| Index | Severity  | Update                    | Issue source                          | Issue |
| ----- | --------- | --------------------------- | --------------------------------- | -------- |
| 1     | important | adjust QOS policy           | ISP probabilistic mipi drop frame | -        |
| 2     | important | stop the mcu when rebooting | probabilistic stuck during reboot | -        |

------

## rv1106_ddr_924MHz{_tb}_v1.10.bin

| Date       | File                             | Build commit | Severity  |
| ---------- | :------------------------------- | ------------ | --------- |
| 2022-11-15 | rv1106_ddr_924MHz{_tb}_v1.10.bin | ec2fae0c96   | important |

### Fixed

| Index | Severity  | Update                                              | Issue description                                   | Issue source |
| ----- | --------- | --------------------------------------------------- | --------------------------------------------------- | ------------ |
| 1     | important | Change reg_fb1xclk_invdelaysel_dqcmd（except DDR2） | DDR may be unstable under specific freq and voltage | -            |
| 2     | moderate  | Improve write trian pattern                         | Improve the accuracy of write train                 | -            |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338}_v1.40.bin

| Date      | File                                       | Build commit                                   | Severity  |
| --------- | :----------------------------------------- | ---------------------------------------------- | --------- |
| 2022-11-1 | rv1106_hpmcu_tb_{sc230ai,sc3338}_v1.40.bin | rtt:05d3e965d#hal:b569247c#battery_ipc:bc3785d | important |

### Fixed

| Index | Severity  | Update                                                  | Issue description                                | Issue source |
| ----- | --------- | ------------------------------------------------------- | ------------------------------------------------ | ------------ |
| 1     | important | Fixed sc3338 horizontal stripes when in dark brightness | sc3338 has horizontal stripes in dark brightness | -            |

------

## rv1106_hpmcu_tb_gc2093_v1.30.bin

| Date       | File                             | Build commit                                                  | Severity |
| ---------- | :------------------------------- | ------------------------------------------------------------ | -------- |
| 2022-10-27 | rv1106_hpmcu_tb_gc2093_v1.30.bin | rtt:2ede82a43#hal:b569247c#battery_ipc:efaec692c#rtt-cherry-pick:8b1555259 | important     |

### New

1. Add gc2093 sensor support.

------

## rv1106_hpmcu_tb_{sc230ai,sc3338}_v1.30.bin

| Date       | File                                       | Build Commit                                     | Severity |
| ---------- | :----------------------------------------- | ------------------------------------------------ | -------- |
| 2022-10-20 | rv1106_hpmcu_tb_{sc230ai,sc3338}_v1.30.bin | rtt:2ede82a43#hal:b569247c#battery_ipc:efaec692c | important |

### New

1. Add support for LTR308 digital light sensor.
2. Add support for hdr.

### Fixed

| Index | Severity  | Update                                | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed 0 address flushed               | When the spi nor flash is in 1-wire mode, spl data is flushed, so spl cannot be started. | -            |
| 2     | important | Fix the shared memory cache operation | The ARM core cannot obtain the shared memory data in time.   | -            |

------

## rv1106_hpmcu_wrap_v1.50.bin

| Date       | File                        | Build commit                    | Severity |
| ---------- | :-------------------------- | ------------------------------- | -------- |
| 2022-09-29 | rv1106_hpmcu_wrap_v1.50.bin | rockit_ko:576377cb#hal:a76806e7 | critical |

### Fixed

| Index | Severity  | Update                     | Issue description                          | Issue source |
| ----- | --------- | -------------------------- | ------------------------------------------ | ------------ |
| 1     | moderate  | optimize code              | decrease code size and add log information | -            |
| 2     | important | increase encoder ddr qos   | slove some wrap overflow                   | -            |
| 3     | critical  | invalite icache and dcache | destory linux memory for cache exchange    | -            |

------

## rv1106_hpmcu_wrap_v1.46.bin

| Date       | File                        | Build commit                    | Severity  |
| ---------- | :-------------------------- | ------------------------------- | --------- |
| 2022-09-08 | rv1106_hpmcu_wrap_v1.46.bin | rockit_ko:7e8fe8af#hal:a76806e7 | important |

### Fixed

| Index | Severity  | Update                                                    | Issue description                                            | Issue source |
| ----- | --------- | --------------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | repair the bug of v1.40 cause                             | after venc start double stream，mcu maube can not check wrap frame end，casuse main stream off | -            |
| 2     | important | repair the bug  destory memory when reset working mcu     | when mcu is working, if  it is reset will destory system memory | -            |
| 3     | important | mcu check overflow, bug venc can not lost the error frame | if venc start too slow, mcu will make a overflow event to venc, but venc can not lost the error frame | -            |

------

## rv1106_hpmcu_tb_{sc230ai,sc3338}_v1.20.bin

| Date       | File                              | Build Commit     | Severity  |
| ---------- | :-------------------------------- | ---------- | --------- |
| 2022-09-03 | rv1106_hpmcu_tb_{sc230ai,sc3338}_v1.20.bin | rtt:efa791c#hal:b569247#battery_ipc:d5fb92e | critical |

### New

1. Support full parameters in aiq for the first frame in fastboot.
2. Support set resolution and fps from meta partition.
3. Support sync meta header file.
4. Optimize the iq result for fast AE,The exposure decomposition is exactly consistent with aiq, supports DB gain synsensor, and supports the check exposure register.
5. Enable AE statistics in full-parameter parallel solution.
6. Meta addresses can be configured using menuconfig.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | resolve "thread:tidle stack overflow" problem                | Sometimes "Thread: Tidle Stack Overflow" is displayed. RTT exits abnormally | -         |
| 2     | important | Suppore get  AE calibration parameters from iq bin           | AE calibration data is not vaild.                            | -         |
| 3     | important | To solve the problem of the change of denoising and sharpening effect and the dimming of brightness after AIQ startup in dark environment | The connection between kernel phase and aiq is not smooth in dark environment | -         |
| 4     | critical  | To solve the problem of full-parameter image effect, it needs to match the AIQ submission 0ed3f415d3, otherwise the image will turn green | the image effect is abnormal in full-parameter               | -         |
