use strict;
use warnings;

use RT::Test tests => undef;

my ( $baseurl, $m ) = RT::Test->started_ok;
ok $m->login, 'logged in';
for my $invalid_page ( 'https://example.com', '/Ticket/Display.html' ) {
    $m->get_ok("/Search/Build.html?ResultPage=$invalid_page&Query=id<10&DoSearch=1");
    like( $m->uri, qr{/Search/Results.html}, 'Redirected to normal results page' );
    $m->warning_like(qr{ResultPage $invalid_page is not whitelisted, ignoring});
}

done_testing;
