#!/bin/sh
# geninitrd mod: blkid
USE_BLKID=${USE_BLKID:-yes}

# true if we should parse UUID= or LABEL= for root parameter

# setup geninitrd module
# @access	public
setup_mod_blkid() {
	blkid=$(find_tool $initrd_dir/blkid /sbin/initrd-blkid)

	if [ ! -x "$blkid" ]; then
		USE_BLKID=no
	fi
}

# generate initrd functions
# @access	public
initrd_gen_blkid_functions() {
	if ! is_yes "$USE_BLKID"; then
		add_linuxrc <<-'EOF'
			find_blk_dev_blkid() {
				return 2
			}
		EOF
		return
	fi

	inst_exec $blkid /sbin/blkid
	add_linuxrc <<-'EOF'
		find_blk_dev_blkid() {
			local blkid
			# if built with blkid change ROOT=LABEL=something into ROOT=/dev/device parsed by blkid
			if [ "${1##LABEL=}" != "${1}" -o "${1##UUID=}" != "${1}" ]; then
				blkid="$(/sbin/blkid -t $1 -o device -l)"
				if [ -n "$blkid" ]; then
					echo $blkid
					return 0
				fi
				return 1
			else
				return 2
			fi
		}
	EOF
}

# generate initrd fragment
# @access	public
initrd_gen_blkid() {
	if ! is_yes "$USE_BLKID"; then
		return
	fi
	verbose "Adding BLKID support to initrd"

	inst_exec $blkid /sbin/blkid
	initrd_gen_devices
	add_linuxrc <<-'EOF'
		blkid=$(find_blk_dev_blkid "$ROOT")
		if [ -n "$blkid" ]; then
			ROOT=$blkid
		fi
	EOF
}
