#!/bin/sh
# geninitrd mod: bootsplash
BOOT_SPLASH=${BOOT_SPLASH:-no}

# requires bootsplash package to operate

# setup geninitrd module
# @access	public
setup_mod_bootsplash() {
	bootsplash_geninitramfs=$(find_tool /bin/splash.bin)
	if [ ! -x "$bootsplash_geninitramfs" ]; then
		BOOT_SPLASH=no
	fi

	# NOTE: this check must be also in fbsplash module as the order of module load may change
	if is_yes "$FB_SPLASH"  && is_yes "$BOOT_SPLASH"; then
		warn "bootsplash and fbsplash are exclusive!"
	fi
}

# generate initrd fragment
# @access	public
initrd_gen_bootsplash() {
	if ! is_yes "$BOOT_SPLASH"; then
		return
	fi
	local target="$1"

	verbose "Generating bootsplash"

	if [ ! -x /bin/splash.bin ]; then
		warn "Failed to execute /bin/splash.bin. Is bootsplash package installed?"
		return
	fi

	if [ -r /etc/sysconfig/bootsplash ]; then
		. /etc/sysconfig/bootsplash
	fi

	if [ -z "$THEME" ]; then
		warn "Please configure your /etc/sysconfig/bootsplash first."
		warn "Generating bootsplashes skipped."
		return
	fi

	if [ -z "$BOOT_SPLASH_RESOLUTIONS" ]; then
		warn "No BOOT_SPLASH_RESOLUTIONS specified in /etc/sysconfig/bootsplash."
		warn "Not adding bootsplash to initrd."
	fi

	local res
	for res in $BOOT_SPLASH_RESOLUTIONS; do
		if [ -f "/etc/bootsplash/themes/$THEME/config/bootsplash-$res.cfg" ]; then
			$bootsplash_geninitramfs -s -f "/etc/bootsplash/themes/$THEME/config/bootsplash-$res.cfg" >> "$target" && \
			verbose "Added $res $THEME theme to initrd."
		else
			warn "/etc/bootsplash/themes/$THEME/config/bootsplash-$res.cfg doesn't exist, skipped"
		fi
	done
}
