#!/bin/sh
# geninitrd mod: condecor
FB_CON_DECOR=${FB_CON_DECOR:-no}

# requires splashutils package to operate

# setup geninitrd module
# @access	public
setup_mod_condecor() {
	condecor_geninitramfs=$(find_tool /usr/sbin/splash_geninitramfs /usr/bin/splash_geninitramfs)
	if [ ! -x "$condecor_geninitramfs" ]; then
		FB_CON_DECOR=no
	fi

	if is_yes "$FB_CON_DECOR" && [ "$INITRDFS" != "initramfs" ]; then
		warn "Using fbcondecor requires INITRDFS=initramfs; skipping fbcondecor generation"
		FB_CON_DECOR=no
	fi
}

# generate initrd fragment
# @access	public
initrd_gen_fbcondecor() {
	if ! is_yes "$FB_CON_DECOR"; then
		return
	fi
	verbose "Generating fbcondecor"

	if [ -r /etc/sysconfig/splash ]; then
		. /etc/sysconfig/splash
	fi

	if [ -z "$SPLASH_THEME" ]; then
		warn "Please configure your /etc/sysconfig/splash first."
		warn "Generating of splashes skipped."
		return
	fi

	if [ -z "$FB_SPLASH_RESOLUTIONS" ]; then
		warn "No FB_SPLASH_RESOLUTIONS specified in /etc/sysconfig/splash."
		warn "Not adding fbcondecor to initramfs."
		return
	fi

	local res
	for res in $FB_SPLASH_RESOLUTIONS; do
		if [ -f "/etc/splash/$SPLASH_THEME/$res.cfg" ]; then
			$condecor_geninitramfs -c $DESTDIR -r $res $SPLASH_THEME && \
			verbose "Added $res $SPLASH_THEME theme to initramfs."
		else
			warn "/etc/splash/$SPLASH_THEME/$res.cfg doesn't exist, skipped"
		fi
	done
}
