#!/bin/sh
# geninitrd mod: ide

PREIDEMODS="-ide-core unknown -ide-detect -ide-disk -ide-gd_mod"
PREIDEMODSOLD="-ide-probe -ide-probe-mod -ide-disk -ide-gd_mod"

# ???
ide_only_root=${ide_only_root:-no}

# allow forcing loading IDE modules, likely from sysconfig/geninitrd
ADDIDE=${ADDIDE:-no}

# return true if node is ide device
# @param	string $node device node to be examined
# @access	public
is_ide() {
	local node="$1"
	if [ ! -e "$node" ]; then
		warn "is_ide(): node $node doesn't exist!"
		return 1
	fi

	# TODO: more sophisticated check, not just pathname check
	if is_yes "$(echo "$node" | awk '/^\/dev\/(hd[a-l]|ide\/)/ { print "yes"; }')"; then
		return 0
	fi

	return 1
}

# find modules for $devpath
# @param	$devpath	device to be examined
# @access	public
find_modules_ide() {
	local devpath=$1
	# remove partition, if any
	local disk=${devpath%[0-9]*}
	# set blockdev for rootfs (hda, sdc, ...)
	local rootblkdev=${disk#/dev/}

	local n
	if [ "$kernel_version_long" -lt "002004021" ]; then
		verbose "Finding IDE modules for kernels <= 2.4.20"
		for n in $PREIDEMODSOLD; do
			find_module "$n"
		done
	else
		local tryauto=1
		for n in $PREIDEMODS; do
			if [ "X$n" = "Xunknown" ]; then
				verbose "Finding IDE modules using ide_hostadapter"
				local mod idemodules=$(modprobe_conf | awk '/ide_hostadapter/ { print $3 }')
				for mod in $idemodules; do
					tryauto=0
					find_module "$mod"
				done

				if [ "$tryauto" -eq 1 ]; then
					# If tryauto {{{
					if [ -r /usr/share/pci-database/ide.pci -a -r /proc/bus/pci/devices ]; then
						verbose "Finding IDE modules using PCI ID database"
						# Finding IDE modules using PCI ID database {{{
						if is_yes "${ide_only_root}"; then
							if [ -f /sys/block/${rootblkdev}/device/../../vendor -a -f /sys/block/${rootblkdev}/device/../../device ]; then
								vendorid="$(awk ' { gsub(/0x/,NUL); print $0 } ' /sys/block/${rootblkdev}/device/../../vendor)"
								deviceid="$(awk ' { gsub(/0x/,NUL); print $0 } ' /sys/block/${rootblkdev}/device/../../device)"
								searchpciid="${vendorid}${deviceid}"
							elif [ -f /proc/ide/${rootblkdev}/../config ]; then
								searchpciid="$(awk ' /pci bus/ { print $7$9 } ' /proc/ide/${rootblkdev}/../config)"
							fi
						fi

						if [ -z "${searchpciid}" ]; then
							searchpciid="$(awk ' { print $2 } ' /proc/bus/pci/devices)"
						fi

						idemodules=""

						for nb in $searchpciid; do
							eval `awk -v pciid="$nb" '{
								gsub("\t"," ");
								gsub("  +", " ");
								gsub("^ ","");
								if (/^[\t ]*#/)
									next;
								compmod = $1 "";	# make sure comparison type will be string
											# cause pci IDs are hexadecimal numeric
								if (compmod == pciid) {
									module=$2;
							#		min_kernel=$3;  # now in ide.pci $3,$4 = vendor and device name
							#		max_kernel=$4;  #
									exit 0;
								}
							}

							END {
								print "module=" module "\nmin_kernel=" min_kernel "\nmax_kernel=\"" max_kernel "\"\n";
							}' /usr/share/pci-database/ide.pci`
							[ -n "$module" ] && idemodules="$idemodules $module"
						done
						if is_yes "$(awk ' /ide=reverse/ { print "yes" } ' /proc/cmdline)"; then
							new_idemodules=""
							for nc in idemodules; do
								new_idemodules="$nc $new_idemodules"
							done
							idemodules="${new_idemodules}"
						fi

						if [ -z "$idemodules" ]; then
							warn "rootfs on IDE device but no related modules found, loading ide-generic."
							idemodules="ide-generic"
						fi

						# }}}
						for nd in $idemodules; do
							find_module "-$nd"
						done
					# }}}
					# else tryauto {{{
					else
						[ -r /usr/share/pci-database/ide.pci ] || warn "/usr/share/pci-database/ide.pci missing."
						[ -r /proc/bus/pci/devices ] || warn "/proc/bus/pci/devices missing."
						warn "Automatic IDE modules finding not available."
					fi
					# }}}
				fi
			else
				find_module "$n"
			fi
		done
	fi
}

# generate initrd fragment for ide device init
# @access	public
initrd_gen_ide() {
	# nothing to do here
	return 0
}
