#!/bin/sh
# geninitrd mod: tuxonice
USE_TUXONICE=${USE_TUXONICE:-no}

#
# setup geninitrd module
# @access	public
setup_mod_tuxonice() {
	# backwards compatible

	if [ "$USE_SUSPEND2" ]; then
		USE_TUXONICE=$USE_SUSPEND2
		warn "USE_SUSPEND2 is deprecated, use USE_TUXONICE now instead."
	fi
}

# generate initrd fragment
# @access	public
initrd_gen_tuxonice() {
	if ! is_yes "$USE_TUXONICE"; then
		return
	fi
	mount_sys
	add_linuxrc <<-'EOF'
		resume=no
		for arg in $CMDLINE; do
			if [ "${arg##resume=}" != "${arg}" -o "${arg##resume2=}" != "${arg}" ]; then
				resume=yes
			fi
		done
		if [ "$resume" = "yes" ]; then
			[ -e /proc/suspend2/do_resume ] && echo 1 > /proc/suspend2/do_resume
			[ -e /sys/power/suspend2/do_resume ] && echo 1 > /sys/power/suspend2/do_resume
			[ -e /sys/power/tuxonice/do_resume ] && echo 1 > /sys/power/tuxonice/do_resume
		fi
	EOF
}
