#!/bin/sh

. ../mod-sata.sh

warn() {
	echo "WARNING: $*" >&2
}
debug() {
	echo "debug: $*" >&2
}
modinfo() {
	/sbin/modinfo "$@"
}

lspci() {
	echo "
03:00.0 0106: 197b:2363 (rev 02)
03:00.1 0101: 197b:2363 (rev 02
"
}

lspci=lspci
kernel=2.6.33.4-1
kernel=`uname -r`
#pcimap=modules.pcimap-$kernel
#pcimap=new
pcimap="/lib/modules/$kernel/modules.pcimap"

# our test succeeds if these modules get matched:
#modules.pcimap-2.6.33.4-1:jmicron              0x0000197b 0x0000ffff 0x0000ffff 0x0000ffff 0x00010100 0x00ffff00 0x0
#modules.pcimap-2.6.33.4-1:pata_jmicron         0x0000197b 0x0000ffff 0x0000ffff 0x0000ffff 0x00010100 0x00ffff00 0x0
#modules.pcimap-2.6.33.4-1:ahci                 0x0000197b 0x0000ffff 0x0000ffff 0x0000ffff 0x00010601 0x00ffffff 0x0

load_modules=""
find_module() {
	load_modules="$load_modules $1"
}

find_modules_sata

# trim modules
modules=$(echo $load_modules)

if [ "$modules" != "pata_jmicron ahci jmicron" ]; then
	warn "FAIL: [$modules]"
else
	echo "OK: [$modules]"
fi
