#!/bin/sh

# this should be overriden by test
runtest_run() {
	:
}

fail=0 ok=0
fail() {
	echo "FAIL: $@"
	fail=$((fail+1))
	return 1
}
ok() {
	echo "OK: $@"
	ok=$((ok+1))
	return 0
}
runtest() {
	local exp=$(mktemp) out=$(mktemp)
	cat > $exp
	eval $@
	runtest_run > $out
	diff -u $out $exp || fail "$@" && ok "$@\n$(cat $exp)"
	rm -f $exp $out
}

# here should be tests
