# [drm_info]

Small utility to dump info about DRM devices.

## Building

Requires libdrm and json-c.

Build with:

    meson setup build/
    ninja -C build/

If you don't have the minimum required version of dependencies, Meson will
automatically download and compile them for you. If you don't want this, run
the first Meson command with:

    meson setup build/ --wrap-mode=nofallback

## Usage

    drm_info [-j] [--] [path]...

- `-j`: Output info in JSON. Otherwise the output is pretty-printed.
- `path`: Zero or more paths to a DRM device to print info about, e.g.
  `/dev/dri/card0`. If no paths are given, all devices found in
  `/dev/dri/card*` are printed.

## DRM database

[drmdb] is a database of Direct Rendering Manager dumps. This database is used
to keep track of GPUs and DRM driver features support.

Please help us gather more data! You can do so by uploading DRM information
from your GPU.

    drm_info -j | curl -d @- https://drmdb.emersion.fr/submit

This will upload information about your GPUs, your GPU drivers and your
screens.

[drm_info]: https://gitlab.freedesktop.org/emersion/drm_info
[drmdb]: https://drmdb.emersion.fr
