/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef IMX94_SCMI_DEF_H
#define IMX94_SCMI_DEF_H

#define SCMI_PWR_MIX_SLICE_IDX_ANA           0U
#define SCMI_PWR_MIX_SLICE_IDX_AON           1U
#define SCMI_PWR_MIX_SLICE_IDX_BBSM          2U
#define SCMI_PWR_MIX_SLICE_IDX_M7_1          3U
#define SCMI_PWR_MIX_SLICE_IDX_CCMSRCGPC     4U
#define SCMI_PWR_MIX_SLICE_IDX_A55C0         5U
#define SCMI_PWR_MIX_SLICE_IDX_A55C1         6U
#define SCMI_PWR_MIX_SLICE_IDX_A55C2         7U
#define SCMI_PWR_MIX_SLICE_IDX_A55C3         8U
#define SCMI_PWR_MIX_SLICE_IDX_A55P          9U
#define SCMI_PWR_MIX_SLICE_IDX_DDR           10U
#define SCMI_PWR_MIX_SLICE_IDX_DISPLAY       11U
#define SCMI_PWR_MIX_SLICE_IDX_M7_0          12U
#define SCMI_PWR_MIX_SLICE_IDX_HSIO_TOP      13U
#define SCMI_PWR_MIX_SLICE_IDX_HSIO_WAON     14U
#define SCMI_PWR_MIX_SLICE_IDX_NETC          15U
#define SCMI_PWR_MIX_SLICE_IDX_NOC           16U
#define SCMI_PWR_MIX_SLICE_IDX_NPU           17U
#define SCMI_PWR_MIX_SLICE_IDX_WAKEUP        18U

#define SCMI_PWR_MEM_SLICE_IDX_AON           0U
#define SCMI_PWR_MEM_SLICE_IDX_M7_1          1U
#define SCMI_PWR_MEM_SLICE_IDX_A55C0         2U
#define SCMI_PWR_MEM_SLICE_IDX_A55C1         3U
#define SCMI_PWR_MEM_SLICE_IDX_A55C2         4U
#define SCMI_PWR_MEM_SLICE_IDX_A55C3         5U
#define SCMI_PWR_MEM_SLICE_IDX_A55P          6U
#define SCMI_PWR_MEM_SLICE_IDX_A55L3         7U
#define SCMI_PWR_MEM_SLICE_IDX_DDR           8U
#define SCMI_PWR_MEM_SLICE_IDX_DISPLAY       9U
#define SCMI_PWR_MEM_SLICE_IDX_M7_0          10U
#define SCMI_PWR_MEM_SLICE_IDX_HSIO          11U
#define SCMI_PWR_MEM_SLICE_IDX_NETC          12U
#define SCMI_PWR_MEM_SLICE_IDX_NOC_OCRAM     13U
#define SCMI_PWR_MEM_SLICE_IDX_NOC2          14U
#define SCMI_PWR_MEM_SLICE_IDX_NPU           15U
#define SCMI_PWR_MEM_SLICE_IDX_WAKEUP        16U

#define CPU_PER_LPI_IDX_GPIO1			0U
#define CPU_PER_LPI_IDX_GPIO2			1U
#define CPU_PER_LPI_IDX_GPIO3			2U
#define CPU_PER_LPI_IDX_GPIO4			3U
#define CPU_PER_LPI_IDX_GPIO5			4U
#define CPU_PER_LPI_IDX_GPIO6			5U
#define CPU_PER_LPI_IDX_GPIO7			6U
#define CPU_PER_LPI_IDX_CAN1			7U
#define CPU_PER_LPI_IDX_CAN2			8U
#define CPU_PER_LPI_IDX_CAN3			9U
#define CPU_PER_LPI_IDX_CAN4			10U
#define CPU_PER_LPI_IDX_CAN5			11U
#define CPU_PER_LPI_IDX_LPUART1			12U
#define CPU_PER_LPI_IDX_LPUART2			13U
#define CPU_PER_LPI_IDX_LPUART3			14U
#define CPU_PER_LPI_IDX_LPUART4			15U
#define CPU_PER_LPI_IDX_LPUART5			16U
#define CPU_PER_LPI_IDX_LPUART6			17U
#define CPU_PER_LPI_IDX_LPUART7			18U
#define CPU_PER_LPI_IDX_LPUART8			19U
#define CPU_PER_LPI_IDX_LPUART9			20U
#define CPU_PER_LPI_IDX_LPUART10		21U
#define CPU_PER_LPI_IDX_LPUART11		22U
#define CPU_PER_LPI_IDX_LPUART12		23U
#define CPU_PER_LPI_IDX_WDOG3			24U
#define CPU_PER_LPI_IDX_WDOG4			25U
#define CPU_PER_LPI_IDX_WDOG5			26U
#define CPU_PER_LPI_IDX_WDOG6			27U
#define CPU_PER_LPI_IDX_WDOG7			28U
#define CPU_PER_LPI_IDX_WDOG8			29U

#define IMX9_A55P_IDX				4U

#define IMX9_SCMI_CPU_A55C0			2U
#define IMX9_SCMI_CPU_A55C1			3U
#define IMX9_SCMI_CPU_A55C2			4U
#define IMX9_SCMI_CPU_A55C3			5U
#define IMX9_SCMI_CPU_A55P			6U

#define DEBUG_WAKEUP_MASK			BIT(1)
#define EVENT_WAKEUP_MASK			BIT(0)

#endif /* IMX94_SCMI_DEF_H */
