/*
 * Copyright 2024-2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef IMX95_SCMI_DEF_H
#define IMX95_SCMI_DEF_H

#define IMR_NUM					U(12)
#define IMX95_A55P_IDX				6U

#define IMX9_SCMI_CPU_A55C0			2U
#define IMX9_SCMI_CPU_A55C1			3U
#define IMX9_SCMI_CPU_A55C2			4U
#define IMX9_SCMI_CPU_A55C3			5U
#define IMX9_SCMI_CPU_A55C4			6U
#define IMX9_SCMI_CPU_A55C5			7U
#define IMX9_SCMI_CPU_A55P			8U

#define SCMI_PWR_MIX_SLICE_IDX_ANA		0U
#define SCMI_PWR_MIX_SLICE_IDX_AON		1U
#define SCMI_PWR_MIX_SLICE_IDX_BBSM		2U
#define SCMI_PWR_MIX_SLICE_IDX_CAMERA		3U
#define SCMI_PWR_MIX_SLICE_IDX_CCMSRCGPC	4U
#define SCMI_PWR_MIX_SLICE_IDX_A55C0		5U
#define SCMI_PWR_MIX_SLICE_IDX_A55C1		6U
#define SCMI_PWR_MIX_SLICE_IDX_A55C2		7U
#define SCMI_PWR_MIX_SLICE_IDX_A55C3		8U
#define SCMI_PWR_MIX_SLICE_IDX_A55C4		9U
#define SCMI_PWR_MIX_SLICE_IDX_A55C5		10U
#define SCMI_PWR_MIX_SLICE_IDX_A55P		11U
#define SCMI_PWR_MIX_SLICE_IDX_DDR		12U
#define SCMI_PWR_MIX_SLICE_IDX_DISPLAY		13U
#define SCMI_PWR_MIX_SLICE_IDX_GPU		14U
#define SCMI_PWR_MIX_SLICE_IDX_HSIO_TOP		15U
#define SCMI_PWR_MIX_SLICE_IDX_HSIO_WAON	16U
#define SCMI_PWR_MIX_SLICE_IDX_M7		17U
#define SCMI_PWR_MIX_SLICE_IDX_NETC		18U
#define SCMI_PWR_MIX_SLICE_IDX_NOC		19U
#define SCMI_PWR_MIX_SLICE_IDX_NPU		20U
#define SCMI_PWR_MIX_SLICE_IDX_VPU		21U
#define SCMI_PWR_MIX_SLICE_IDX_WAKEUP		22U

#define SCMI_PWR_MEM_SLICE_IDX_AON		0U
#define SCMI_PWR_MEM_SLICE_IDX_CAMERA		1U
#define SCMI_PWR_MEM_SLICE_IDX_A55C0		2U
#define SCMI_PWR_MEM_SLICE_IDX_A55C1		3U
#define SCMI_PWR_MEM_SLICE_IDX_A55C2		4U
#define SCMI_PWR_MEM_SLICE_IDX_A55C3		5U
#define SCMI_PWR_MEM_SLICE_IDX_A55C4		6U
#define SCMI_PWR_MEM_SLICE_IDX_A55C5		7U
#define SCMI_PWR_MEM_SLICE_IDX_A55P		8U
#define SCMI_PWR_MEM_SLICE_IDX_A55L3		9U
#define SCMI_PWR_MEM_SLICE_IDX_DDR		10U
#define SCMI_PWR_MEM_SLICE_IDX_DISPLAY		11U
#define SCMI_PWR_MEM_SLICE_IDX_GPU		12U
#define SCMI_PWR_MEM_SLICE_IDX_HSIO		13U
#define SCMI_PWR_MEM_SLICE_IDX_M7		14U
#define SCMI_PWR_MEM_SLICE_IDX_NETC		15U
#define SCMI_PWR_MEM_SLICE_IDX_NOC_OCRAM	16U
#define SCMI_PWR_MEM_SLICE_IDX_NOC2		17U
#define SCMI_PWR_MEM_SLICE_IDX_NPU		18U
#define SCMI_PWR_MEM_SLICE_IDX_VPU		19U
#define SCMI_PWR_MEM_SLICE_IDX_WAKEUP		20U

/* Peripheral LPI index */
#define CPU_PER_LPI_IDX_GPIO1			0U
#define CPU_PER_LPI_IDX_GPIO2			1U
#define CPU_PER_LPI_IDX_GPIO3			2U
#define CPU_PER_LPI_IDX_GPIO4			3U
#define CPU_PER_LPI_IDX_GPIO5			4U
#define CPU_PER_LPI_IDX_CAN1			5U
#define CPU_PER_LPI_IDX_CAN2			6U
#define CPU_PER_LPI_IDX_CAN3			7U
#define CPU_PER_LPI_IDX_CAN4			8U
#define CPU_PER_LPI_IDX_CAN5			9U
#define CPU_PER_LPI_IDX_LPUART1			10U
#define CPU_PER_LPI_IDX_LPUART2			11U
#define CPU_PER_LPI_IDX_LPUART3			12U
#define CPU_PER_LPI_IDX_LPUART4			13U
#define CPU_PER_LPI_IDX_LPUART5			14U
#define CPU_PER_LPI_IDX_LPUART6			15U
#define CPU_PER_LPI_IDX_LPUART7			16U
#define CPU_PER_LPI_IDX_LPUART8			17U
#define CPU_PER_LPI_IDX_WDOG3			18U
#define CPU_PER_LPI_IDX_WDOG4			19U
#define CPU_PER_LPI_IDX_WDOG5			20U


#define DEBUG_WAKEUP_MASK			BIT(1)
#define EVENT_WAKEUP_MASK			BIT(0)

#endif /* IMX95_SCMI_DEF_H */
