/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MT_VCORE_DVFSRC_PLAT_DEF_H
#define MT_VCORE_DVFSRC_PLAT_DEF_H

#define VCORE_BASE_UV 400000
#define VCORE_STEP_UV 6250

/* PMIC */
#define VCORE_PMIC_TO_UV(pmic) (((pmic) * VCORE_STEP_UV) + VCORE_BASE_UV)
#define VCORE_UV_TO_PMIC(uv) \
	((((uv) - VCORE_BASE_UV) + (VCORE_STEP_UV - 1)) / VCORE_STEP_UV)

static const struct reg_config dvfsrc_init_configs[] = {
	{ DVFSRC_TIMEOUT_NEXTREQ, 0x00001AFF },
	{ DVFSRC_VCORE_USER_REQ, 0x00010F51 },
	/* EMI Monitor */
	{ DVFSRC_DDR_REQUEST, 0x00004321 },
	/* SW QOS */
	{ DVFSRC_QOS_EN, 0x08F3007C },
	{ DVFSRC_DDR_QOS0, 0x00000042 },
	{ DVFSRC_DDR_QOS1, 0x00000062 },
	{ DVFSRC_DDR_QOS2, 0x00000086 },
	{ DVFSRC_DDR_QOS3, 0x000000AF },
	{ DVFSRC_DDR_QOS4, 0x000000AF },
	{ DVFSRC_DDR_QOS5, 0x000000AF },
	{ DVFSRC_DDR_REQUEST5, 0x00444321 },
	/* LEVEL */
	{ DVFSRC_LEVEL_LABEL_0_1, 0x30344044 },
	{ DVFSRC_LEVEL_LABEL_2_3, 0x20243033 },
	{ DVFSRC_LEVEL_LABEL_4_5, 0x20222023 },
	{ DVFSRC_LEVEL_LABEL_6_7, 0x10131014 },
	{ DVFSRC_LEVEL_LABEL_8_9, 0x10111012 },
	{ DVFSRC_LEVEL_LABEL_10_11, 0x00030004 },
	{ DVFSRC_LEVEL_LABEL_12_13, 0x00010002 },
	{ DVFSRC_LEVEL_LABEL_14_15, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_16_17, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_18_19, 0x00000000 },
	/* HRT */
	{ DVFSRC_HRT_REQ_UNIT, 0x0000011E },
	{ DVFSRC_HRT_BW_BASE, 0x00000004 },
	{ DVFSRC_HRT_REQUEST, 0x00444321 },
	{ DVFSRC_HRT_HIGH, 0x1E281428 },
	{ DVFSRC_HRT_HIGH_1, 0x3C5D2B54 },
	{ DVFSRC_HRT_HIGH_2, 0xFFFFFFFF },
	{ DVFSRC_HRT_HIGH_3, 0xFFFFFFFF },
	{ DVFSRC_HRT_LOW, 0x1E271427 },
	{ DVFSRC_HRT_LOW_1, 0x3C5C2B53 },
	{ DVFSRC_HRT_LOW_2, 0xFFFFFFFF },
	{ DVFSRC_HRT_LOW_3, 0xFFFFFFFF },
	/* MDDDR */
	{ DVFSRC_95MD_SCEN_BW7, 0x40000000 },
	{ DVFSRC_95MD_SCEN_BW7_T, 0x40000000 },
	{ DVFSRC_95MD_SCEN_BWU, 0x00000004 },
	/* RISING */
	{ DVFSRC_DDR_ADD_REQUEST, 0x44443210 },
	{ DVFSRC_DDR_ADD_REQUEST_1, 0x44444444 },
	{ DVFSRC_EMI_ADD_REQUEST, 0x44443210 },
	{ DVFSRC_EMI_ADD_REQUEST_1, 0x44444444 },
	{ DVFSRC_EMI_MON_DEBOUNCE_TIME, 0x4C2D0000 },
	/* MISC */
	{ DVFSRC_DEFAULT_OPP_1, 0x00000000 },
	{ DVFSRC_BASIC_CONTROL_4, 0x00000000 },
	/* ENABLE */
	{ DVFSRC_INT_EN, 0x00000002 },
	{ DVFSRC_CURRENT_FORCE_2, 0x00000001 },
	{ DVFSRC_BASIC_CONTROL, 0x24E6222B },
	{ DVFSRC_BASIC_CONTROL, 0x24E602AB },
	{ DVFSRC_CURRENT_FORCE_2, 0x00000000 },
};

static const struct reg_config lp4_init_configs[] = {
	/* LEVEL */
	{ DVFSRC_LEVEL_LABEL_0_1, 0x10122022 },
	{ DVFSRC_LEVEL_LABEL_2_3, 0x00021011 },
	{ DVFSRC_LEVEL_LABEL_4_5, 0x00000001 },
	{ DVFSRC_LEVEL_LABEL_6_7, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_8_9, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_10_11, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_12_13, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_14_15, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_16_17, 0x00000000 },
	{ DVFSRC_LEVEL_LABEL_18_19, 0x00000000 },
	/* HRT */
	{ DVFSRC_HRT_REQUEST, 0x00222221 },
	{ DVFSRC_HRT_HIGH, 0x24301693 },
	{ DVFSRC_HRT_HIGH_1, 0xFFFFFFFF },
	{ DVFSRC_HRT_HIGH_2, 0xFFFFFFFF },
	{ DVFSRC_HRT_LOW, 0x242F1692 },
	{ DVFSRC_HRT_LOW_1, 0xFFFFFFFF },
	{ DVFSRC_HRT_LOW_2, 0xFFFFFFFF },
	/* SW QOS */
	{ DVFSRC_DDR_REQUEST5, 0x00222221 },
	/* MDDDR */
	{ DVFSRC_95MD_SCEN_BW7, 0x20000000 },
	{ DVFSRC_95MD_SCEN_BW7_T, 0x20000000 },
	{ DVFSRC_95MD_SCEN_BWU, 0x00000002 },
	/* RISING */
	{ DVFSRC_DDR_ADD_REQUEST, 0x22222210 },
	{ DVFSRC_DDR_ADD_REQUEST_1, 0x22222222 },
	{ DVFSRC_EMI_ADD_REQUEST, 0x22222210 },
	{ DVFSRC_EMI_ADD_REQUEST_1, 0x22222222 },
	{ DVFSRC_BASIC_CONTROL, 0x2456222B },
	{ DVFSRC_BASIC_CONTROL, 0x245602AB },
};

#endif /* MT_VCORE_DVFSRC_PLAT_DEF_H */
