/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef PMIF_H
#define PMIF_H

#include <stdint.h>

#include <platform_def.h>

#include <drivers/spmi/pmif_common.h>
#include <drivers/spmi/spmi_common.h>

enum pmif_regs {
	PMIF_INIT_DONE,
	PMIF_INF_EN,
	PMIF_ARB_EN,
	PMIF_IRQ_EVENT_EN_0,
	PMIF_IRQ_FLAG_0,
	PMIF_IRQ_CLR_0,
	PMIF_IRQ_EVENT_EN_2,
	PMIF_IRQ_FLAG_2,
	PMIF_IRQ_CLR_2,
	PMIF_WDT_CTRL,
	PMIF_WDT_EVENT_EN_1,
	PMIF_WDT_FLAG_1,
	PMIF_SWINF_2_ACC,
	PMIF_SWINF_2_WDATA_31_0,
	PMIF_SWINF_2_WDATA_63_32,
	PMIF_SWINF_2_RDATA_31_0,
	PMIF_SWINF_2_RDATA_63_32,
	PMIF_SWINF_2_VLD_CLR,
	PMIF_SWINF_2_STA,
	PMIF_SWINF_3_ACC,
	PMIF_SWINF_3_WDATA_31_0,
	PMIF_SWINF_3_WDATA_63_32,
	PMIF_SWINF_3_RDATA_31_0,
	PMIF_SWINF_3_RDATA_63_32,
	PMIF_SWINF_3_VLD_CLR,
	PMIF_SWINF_3_STA,
	/* HW MPU */
	PMIF_PMIC_ALL_RGN_EN_1,
	PMIF_PMIC_ALL_RGN_EN_2,
	PMIF_PMIC_ALL_RGN_0_START,
	PMIF_PMIC_ALL_RGN_0_END,
	PMIF_PMIC_ALL_RGN_1_START,
	PMIF_PMIC_ALL_RGN_1_END,
	PMIF_PMIC_ALL_RGN_2_START,
	PMIF_PMIC_ALL_RGN_2_END,
	PMIF_PMIC_ALL_RGN_3_START,
	PMIF_PMIC_ALL_RGN_3_END,
	PMIF_PMIC_ALL_RGN_31_START,
	PMIF_PMIC_ALL_RGN_31_END,
	PMIF_PMIC_ALL_INVLD_SLVID,
	PMIF_PMIC_ALL_RGN_0_PER0,
	PMIF_PMIC_ALL_RGN_0_PER1,
	PMIF_PMIC_ALL_RGN_1_PER0,
	PMIF_PMIC_ALL_RGN_2_PER0,
	PMIF_PMIC_ALL_RGN_3_PER0,
	PMIF_PMIC_ALL_RGN_31_PER0,
	PMIF_PMIC_ALL_RGN_31_PER1,
	PMIF_PMIC_ALL_RGN_OTHERS_PER0,
	PMIF_PMIC_ALL_RGN_OTHERS_PER1,
};
#endif
