/*
 * Copyright (c) 2015-2025, Renesas Electronics Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef RCAR_DEF_H
#define RCAR_DEF_H

#include <common/tbbr/tbbr_img_def.h>
#include <lib/utils_def.h>

#define RCAR_DOMAIN			UL(0x0)

#define RCAR_TRUSTED_SRAM_BASE		UL(0x46400000)
#define RCAR_TRUSTED_SRAM_SIZE		UL(0x00022000)
#define RCAR_SHARED_MEM_BASE		(RCAR_TRUSTED_SRAM_BASE + \
					RCAR_TRUSTED_SRAM_SIZE)
#define RCAR_SHARED_MEM_SIZE		UL(0x00001000)
#define	RCAR_BL31_CRASH_BASE		(RCAR_TRUSTED_SRAM_BASE + UL(0x3F000))
#define RCAR_BL31_CRASH_SIZE		UL(0x00001000)
#define DEVICE_RCAR_BASE		UL(0xE6000000)
#define DEVICE_RCAR_SIZE		UL(0x00300000)
#define DEVICE_SRAM_BASE		UL(0xE6342000)
#define DEVICE_SRAM_SIZE		UL(0x00002000)
#define DEVICE_SRAM_DATA_BASE		(DEVICE_SRAM_BASE + DEVICE_SRAM_SIZE)
#define DEVICE_SRAM_DATA_SIZE		UL(0x00000100)
#define DEVICE_SRAM_STACK_BASE		(DEVICE_SRAM_DATA_BASE + DEVICE_SRAM_DATA_SIZE)
#define DEVICE_SRAM_STACK_SIZE		(UL(0x00001000) - DEVICE_SRAM_DATA_SIZE)
#define DEVICE_RCAR_BASE2		UL(0xE6370000)
#define DEVICE_RCAR_SIZE2		UL(0x19C90000)
/* Entrypoint mailboxes */
#define MBOX_BASE			RCAR_SHARED_MEM_BASE
#define MBOX_SIZE			UL(0x200)
/* Base address where parameters to BL31 are stored */
#define PARAMS_BASE			(MBOX_BASE + MBOX_SIZE)
#define BOOT_KIND_BASE			(RCAR_SHARED_MEM_BASE + \
					RCAR_SHARED_MEM_SIZE - UL(0x100))
/*
 * The number of regions like RO(code), coherent and data required by
 * different BL stages which need to be mapped in the MMU
 */
#define RCAR_BL_REGIONS			2
/*
 * The RCAR_MAX_MMAP_REGIONS depends on the number of entries in rcar_mmap[]
 * defined for each BL stage in platform_common.c.
 */
#define RCAR_MMAP_ENTRIES		8
/* BL31 */
#define RCAR_CRASH_STACK		RCAR_BL31_CRASH_BASE

/* CCI related constants */
#define CCI500_BASE			UL(0xF1200000)
#define CCI500_CLUSTER0_SL_IFACE_IX	0
#define CCI500_CLUSTER1_SL_IFACE_IX	1
#define CCI500_CLUSTER2_SL_IFACE_IX	2
#define CCI500_CLUSTER3_SL_IFACE_IX	3
#define RCAR_CCI_BASE			CCI500_BASE

/* APSREG boot configuration */
#define APSREG_BASE			UL(0xE6280000)
#define APSREG_CCI500_AUX		(APSREG_BASE + UL(0x9010))
#define APSREG_P_CCI500_AUX		(APSREG_BASE + UL(0x29010))

#define APSREG_AP_CLUSTER_AUX0_INIT	0x00000003U
#define APSREG_CCI500_AUX_INIT		0x00000001U
#define APSREG_P_CCI500_AUX_INIT	0x00000002U

/* GIC */
#define PLAT_ARM_GICD_BASE		UL(0xF1000000)
#define PLAT_ARM_GICR_BASE		UL(0xF1060000)
#define ARM_IRQ_SEC_PHY_TIMER		29U
#define ARM_IRQ_SEC_SGI_0		8U
#define ARM_IRQ_SEC_SGI_1		9U
#define ARM_IRQ_SEC_SGI_2		10U
#define ARM_IRQ_SEC_SGI_3		11U
#define ARM_IRQ_SEC_SGI_4		12U
#define ARM_IRQ_SEC_SGI_5		13U
#define ARM_IRQ_SEC_SGI_6		14U
#define ARM_IRQ_SEC_SGI_7		15U

/* Timer control */
#define RCAR_CNTC_BASE			UL(0xE6080000)
#if (RCAR_LSI == RCAR_S4)
#define RCAR_CNTC_EXTAL			16666666U
#elif (RCAR_LSI == RCAR_V4H)
#define RCAR_CNTC_EXTAL			16666600U
#elif (RCAR_LSI == RCAR_V4M)
#define RCAR_CNTC_EXTAL			16666600U
#endif
/* Conversion value from seconds to micro seconds */
#define RCAR_CONV_MICROSEC		1000000UL

/* APMU */
#define RCAR_APMU_BASE			(UL(0xE6170000) + (RCAR_DOMAIN * UL(0x1000)))
#define RCAR_APMU_PWRCTRLCL_PCHPDNEN	BIT(17)

#define RCAR_APMU_PWRCTRLC_WUP_REQ	BIT(0)
#define RCAR_APMU_PWRCTRLC_IWUP_EN	BIT(4)
#define RCAR_APMU_PWRCTRLC_PCHPDNEN	BIT(17)

#define RCAR_APMU_SAFECTRLC_DBGGEN	BIT(13)

#define RCAR_APMU_FSMSTSRC_STATE_OFF	0x00000000U

#define RCAR_APMU_RVBARPLC_MASK		0xFFFFFFFCU
#define RCAR_APMU_RVBARPL_VLD		0x00000001U

/* Soft Power On Reset Control Register 0 */
#define RCAR_SRESCR			(UL(0xE6160018) + (RCAR_DOMAIN * UL(0x4000)))

/* Product register */
#define RCAR_PRR			UL(0xFFF00044)
#define RCAR_CPU_HAVE_CAXX		0x00000000U
#define PRR_CAXX_XX_EN_CLUSTER_MASK	0x00000004U

/* Memory mapped Generic timer interfaces */
#define ARM_SYS_CNTCTL_BASE		RCAR_CNTC_BASE

/* MPIDR_EL1 */
#define	RCAR_MPIDR_AFFMASK		0x00FFFF00U

/* CPUPWRCTLR */
#define CPUPWRCTLR_PWDN			0x00000001U

/* For DDR self refresh */
#define DBSC4_REG_BASE				UL(0xE6790000)
#define DBSC4_REG_DBSYSCNT0			(DBSC4_REG_BASE + UL(0x0100))
#define DBSC4_REG_DBACEN			(DBSC4_REG_BASE + UL(0x0200))
#define DBSC4_REG_DBRFEN			(DBSC4_REG_BASE + UL(0x0204))
#define DBSC4_REG_DBCMD				(DBSC4_REG_BASE + UL(0x0208))
#define DBSC4_REG_DBWAIT			(DBSC4_REG_BASE + UL(0x0210))
#define DBSC4_REG_DBCALCNF			(DBSC4_REG_BASE + UL(0x0424))
#define DBSC4_REG_DBDFIPMSTRCNF			(DBSC4_REG_BASE + UL(0x0520))
#define DBSC4_REG_DBCAM0CTRL0			(DBSC4_REG_BASE + UL(0x0940))
#define DBSC4_REG_DBCAM0STAT0			(DBSC4_REG_BASE + UL(0x0980))

#define DBSC4_SET_DBSYSCNT0_WRITE_ENABLE	0x00001234U
#define DBSC4_SET_DBSYSCNT0_WRITE_DISABLE	0x00000000U
#define DBSC4_SET_DBCMD_OPC_PRE			0x04000000U
#define DBSC4_SET_DBCMD_OPC_SR			0x0A000000U
#define DBSC4_SET_DBCMD_OPC_MRW			0x0E000000U
#define DBSC4_SET_DBCMD_OPC_PD			0x08000000U
#define DBSC4_SET_DBCMD_CH_ALL			0x00800000U
#define DBSC4_SET_DBCMD_RANK_ALL		0x00040000U
#define DBSC4_SET_DBCMD_ARG_ALL			0x00000010U
#define DBSC4_SET_DBCMD_ARG_ENTER		0x00000000U
#define DBSC4_SET_DBCMD_ARG_MRW_ODTC		0x00000B00U
#define DBSC4_BIT_DBDFIPMSTRCNF_PMSTREN		0x00000001U
#define DBSC4_BIT_DBCAM0STAT0			0x00000001U
#define RCAR_WAIT_DBCS4_FLUSH			50UL

#endif /* RCAR_DEF_H */
