/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame2.driver.config;

import org.openrdf.repository.Repository;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;
import virtuoso.sesame2.driver.VirtuosoRepository;
import virtuoso.sesame2.driver.config.VirtuosoRepositoryConfig;

public class VirtuosoRepositoryFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "openrdf:VirtuosoRepository";

    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    public RepositoryImplConfig getConfig() {
        return new VirtuosoRepositoryConfig();
    }

    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        VirtuosoRepository result = null;
        if (!(config instanceof VirtuosoRepositoryConfig)) {
            throw new RepositoryConfigException("Invalid configuration class: " + config.getClass());
        }
        VirtuosoRepositoryConfig vConfig = (VirtuosoRepositoryConfig)config;
        result = new VirtuosoRepository(vConfig.getHostList(), vConfig.getUsername(), vConfig.getPassword(), vConfig.getDefGraph(), vConfig.getUseLazyAdd());
        result.setFetchSize(vConfig.getFetchSize());
        result.setRoundrobin(vConfig.getRoundRobin());
        result.setFetchSize(vConfig.getFetchSize());
        result.setRuleSet(vConfig.getRuleSet());
        result.setBatchSize(vConfig.getBatchSize());
        result.setInsertBNodeAsVirtuosoIRI(vConfig.getInsertBNodeAsVirtuosoIRI());
        return result;
    }
}

