/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapAdapter;
import org.apache.jena.shared.AlreadyExistsException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockNone;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.ExtendedIterator;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtIsolationLevel;
import virtuoso.jena.driver.VirtModel;
import virtuoso.jena.driver.VirtPrefixMapping;
import virtuoso.jena.driver.VirtResSetQIter;
import virtuoso.jena.driver.VirtTransactionHandler;

public class VirtDataset
extends VirtGraph
implements Dataset {
    private Model defaultModel = null;
    private Context m_context = new Context();
    private final HashSet<VirtGraph> graphs = new HashSet();
    private Lock lock = null;

    public VirtDataset() {
    }

    public VirtDataset(String _graphName, DataSource _ds) {
        super(_graphName, _ds);
    }

    public VirtDataset(DataSource _ds) {
        super(_ds);
    }

    public VirtDataset(String _graphName, ConnectionPoolDataSource _ds) {
        super(_graphName, _ds);
    }

    public VirtDataset(ConnectionPoolDataSource _ds) {
        super(_ds);
    }

    public VirtDataset(String _graphName, XADataSource _ds) {
        super(_graphName, _ds);
    }

    public VirtDataset(XADataSource _ds) {
        super(_ds);
    }

    protected VirtDataset(VirtGraph g) {
        this.graphName = g.getGraphName();
        this.setReadFromAllGraphs(g.getReadFromAllGraphs());
        this.url_hostlist = g.getGraphUrl();
        this.user = g.getGraphUser();
        this.password = g.getGraphPassword();
        this.roundrobin = g.roundrobin;
        this.setFetchSize(g.getFetchSize());
        this.setMacroLib(g.getMacroLib());
        this.setRuleSet(g.getRuleSet());
        this.connection = g.getConnection();
    }

    public VirtDataset(String url_hostlist, String user, String password) {
        super(url_hostlist, user, password);
    }

    public synchronized Model getDefaultModel() {
        if (this.defaultModel == null) {
            VirtGraph g = new VirtGraph(null, this);
            this.defaultModel = new VirtModel(g);
            this.addLink(g);
        }
        return this.defaultModel;
    }

    public Model getUnionModel() {
        throw new UnsupportedOperationException();
    }

    public VirtDataset setDefaultModel(Model model) {
        if (model instanceof VirtModel && ((VirtGraph)model.getGraph()).getConnection() == this.connection) {
            VirtGraph g = (VirtGraph)model.getGraph();
            this.defaultModel = model;
            this.removeLink(g);
            return this;
        }
        throw new IllegalArgumentException("VirtDataset supports only VirtModel with the same DB connection");
    }

    public synchronized Model getNamedModel(String name) {
        try {
            VirtGraph g = new VirtGraph(name, this);
            VirtModel m = new VirtModel(g);
            this.addLink(g);
            return m;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public synchronized Model getNamedModel(Resource resource) {
        return this.getNamedModel(resource.toString());
    }

    public boolean containsNamedModel(String name) {
        String query = "select count(*) from (sparql select * where { graph `iri(??)` { ?s ?p ?o }})f";
        ResultSet rs = null;
        PreparedStatement ps = null;
        int ret = 0;
        this.checkOpen();
        try {
            ps = this.prepareStatement(query, false);
            ps.setString(1, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                ret = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret != 0;
    }

    public boolean containsNamedModel(Resource resource) {
        return this.containsNamedModel(resource.toString());
    }

    public VirtDataset addNamedModel(String name, Model model, boolean checkExists) {
        String query = "select count(*) from (sparql select * where { graph `iri(??)` { ?s ?p ?o }})f";
        ResultSet rs = null;
        int ret = 0;
        PreparedStatement ps = null;
        this.checkOpen();
        if (checkExists) {
            try {
                ps = this.prepareStatement(query, false);
                ps.setString(1, name);
                rs = ps.executeQuery();
                if (rs.next()) {
                    ret = rs.getInt(1);
                }
                rs.close();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception exception) {}
            }
            if (ret != 0) {
                throw new AlreadyExistsException("A model with ID '" + name + "' already exists.");
            }
        }
        Graph g = model.getGraph();
        this.add(name, (Iterator<Triple>)g.find(Node.ANY, Node.ANY, Node.ANY), null);
        return this;
    }

    public VirtDataset addNamedModel(String name, Model model) {
        this.addNamedModel(name, model, true);
        return this;
    }

    public Dataset addNamedModel(Resource resource, Model model) {
        return this.addNamedModel(resource.toString(), model);
    }

    public VirtDataset removeNamedModel(String name) {
        String exec_text = "sparql clear graph <" + name + ">";
        Statement stmt = null;
        this.checkOpen();
        try {
            stmt = this.createStatement(true);
            stmt.executeQuery(exec_text);
            VirtDataset virtDataset = this;
            return virtDataset;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Dataset removeNamedModel(Resource resource) {
        return this.removeNamedModel(resource.toString());
    }

    public VirtDataset replaceNamedModel(String name, Model model) {
        try {
            this.removeNamedModel(name);
            this.addNamedModel(name, model, false);
            return this;
        }
        catch (Exception e) {
            throw new JenaException("Could not replace model:", (Throwable)e);
        }
    }

    public VirtDataset replaceNamedModel(Resource resource, Model model) {
        try {
            this.removeNamedModel(resource.toString());
            this.addNamedModel(resource.toString(), model, false);
            return this;
        }
        catch (Exception e) {
            throw new JenaException("Could not replace model", (Throwable)e);
        }
    }

    public Iterator<String> listNames() {
        String exec_text = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        ResultSet rs = null;
        Statement stmt = null;
        this.checkOpen();
        try {
            LinkedList<String> names = new LinkedList<String>();
            stmt = this.createStatement(false);
            rs = stmt.executeQuery(exec_text);
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            rs.close();
            Iterator<String> iterator = names.iterator();
            return iterator;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Iterator<Resource> listModelNames() {
        String exec_text = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        ResultSet rs = null;
        Statement stmt = null;
        this.checkOpen();
        try {
            LinkedList<ResourceImpl> names = new LinkedList<ResourceImpl>();
            stmt = this.createStatement(false);
            rs = stmt.executeQuery(exec_text);
            while (rs.next()) {
                names.add(new ResourceImpl(rs.getString(1)));
            }
            rs.close();
            Iterator<Resource> iterator = names.iterator();
            return iterator;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Lock getLock() {
        if (this.lock == null) {
            this.lock = new LockNone();
        }
        return this.lock;
    }

    public Context getContext() {
        return this.m_context;
    }

    public boolean supportsTransactions() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        return handler.transactionsSupported();
    }

    public boolean supportsXATransactions() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        return handler.transactionsXASupported();
    }

    public boolean supportsTransactionAbort() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        return handler.transactionsSupported();
    }

    public void begin(TxnType txnType) {
        VirtTransactionHandler handler = this.getTransactionHandler();
        handler.begin(txnType);
    }

    public void begin(ReadWrite readWrite) {
        VirtTransactionHandler handler = this.getTransactionHandler();
        handler.begin(readWrite);
    }

    public boolean promote(Transactional.Promote promote) {
        return true;
    }

    public void commit() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        handler.commit();
    }

    public void abort() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        handler.abort();
    }

    public boolean isInTransaction() {
        try {
            return !this.getConnection().getAutoCommit();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setIsolationLevel(VirtIsolationLevel level) {
        VirtTransactionHandler handler = this.getTransactionHandler();
        handler.setIsolationLevel(level);
    }

    public VirtIsolationLevel getIsolationLevel() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        return handler.getIsolationLevel();
    }

    public void end() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        handler.abort();
    }

    public ReadWrite transactionMode() {
        VirtTransactionHandler handler = this.getTransactionHandler();
        return handler.getReadWrite();
    }

    public TxnType transactionType() {
        if (!this.isInTransaction()) {
            return null;
        }
        VirtTransactionHandler handler = this.getTransactionHandler();
        return handler.getTxnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        HashSet<VirtGraph> hashSet = this.graphs;
        synchronized (hashSet) {
            HashSet copy = (HashSet)this.graphs.clone();
            for (VirtGraph g : copy) {
                try {
                    g.close();
                }
                catch (Exception exception) {}
            }
            this.graphs.clear();
            copy.clear();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLink(VirtGraph obj) {
        HashSet<VirtGraph> hashSet = this.graphs;
        synchronized (hashSet) {
            this.graphs.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLink(VirtGraph obj) {
        HashSet<VirtGraph> hashSet = this.graphs;
        synchronized (hashSet) {
            this.graphs.remove((Object)obj);
        }
    }

    public DatasetGraph asDatasetGraph() {
        return new VirtDataSetGraph(this);
    }

    public class VirtDataSetGraph
    implements DatasetGraph {
        VirtDataset vd = null;

        public VirtDataSetGraph(VirtDataset vds) {
            this.vd = vds;
        }

        public Graph getDefaultGraph() {
            return this.vd;
        }

        public Graph getGraph(Node graphNode) {
            try {
                return new VirtGraph(graphNode.toString(), this.vd.getGraphUrl(), this.vd.getGraphUser(), this.vd.getGraphPassword());
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
        }

        public Graph getUnionGraph() {
            throw new UnsupportedOperationException();
        }

        public boolean containsGraph(Node graphNode) {
            return VirtDataset.this.containsNamedModel(graphNode.toString());
        }

        protected List<Node> getListGraphNodes() {
            String exec_text = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
            ResultSet rs = null;
            Statement stmt = null;
            this.vd.checkOpen();
            try {
                LinkedList<Node> names = new LinkedList<Node>();
                stmt = this.vd.createStatement(false);
                rs = stmt.executeQuery(exec_text);
                while (rs.next()) {
                    names.add(NodeFactory.createURI((String)rs.getString(1)));
                }
                rs.close();
                LinkedList<Node> linkedList = names;
                return linkedList;
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public Iterator<Node> listGraphNodes() {
            return this.getListGraphNodes().iterator();
        }

        public Lock getLock() {
            return this.vd.getLock();
        }

        public long size() {
            return this.vd.size();
        }

        public void close() {
            this.vd.close();
        }

        public Context getContext() {
            return this.vd.m_context;
        }

        public PrefixMap prefixes() {
            return new PrefixMapAdapter((PrefixMapping)new VirtPrefixMapping(this.vd));
        }

        public void setDefaultGraph(Graph g) {
            if (!(g instanceof VirtGraph)) {
                throw new IllegalArgumentException("VirtDataSetGraph.setDefaultGraph() supports only VirtGraph as default graph");
            }
            this.vd = new VirtDataset((VirtGraph)g);
        }

        public void addGraph(Node graphName, Graph graph) {
            try {
                this.vd.clear(graphName);
                ExtendedIterator it = graph.find(Node.ANY, Node.ANY, Node.ANY);
                this.vd.add(graphName.toString(), (Iterator<Triple>)it, null);
            }
            catch (Exception e) {
                throw new JenaException("Error in addGraph", (Throwable)e);
            }
        }

        public void removeGraph(Node graphName) {
            try {
                this.vd.clear(graphName);
            }
            catch (Exception e) {
                throw new JenaException("Error in removeGraph", (Throwable)e);
            }
        }

        public void add(Quad quad) {
            this.vd.performAdd(quad.getGraph().toString(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public void delete(Quad quad) {
            this.vd.performDelete(quad.getGraph().toString(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public void add(Node g, Node s, Node p, Node o) {
            this.vd.performAdd(g.toString(), s, p, o);
        }

        public void delete(Node g, Node s, Node p, Node o) {
            this.vd.performDelete(g.toString(), s, p, o);
        }

        public void deleteAny(Node g, Node s, Node p, Node o) {
            g = g != null ? g : Node.ANY;
            s = s != null ? s : Node.ANY;
            p = p != null ? p : Node.ANY;
            o = o != null ? o : Node.ANY;
            Triple t = Triple.create((Node)s, (Node)p, (Node)o);
            if (Node.ANY.equals((Object)g)) {
                String exec_text = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
                ResultSet rs = null;
                Statement stmt = null;
                this.vd.checkOpen();
                try {
                    stmt = this.vd.createStatement(false);
                    rs = stmt.executeQuery(exec_text);
                    while (rs.next()) {
                        this.vd.delete_match(rs.getString(1), t);
                    }
                }
                catch (Exception e) {
                    throw new JenaException("Error in deleteAny():" + String.valueOf(e));
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            this.vd.delete_match(g.toString(), t);
        }

        public Iterator<Quad> find() {
            return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        }

        public Iterator<Quad> find(Quad quad) {
            if (quad == null) {
                return this.find();
            }
            return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
            List<Node> graphs;
            s = s != null ? s : Node.ANY;
            p = p != null ? p : Node.ANY;
            Node node = o = o != null ? o : Node.ANY;
            if (this.isWildcard(g)) {
                graphs = this.getListGraphNodes();
            } else {
                graphs = new LinkedList<Node>();
                graphs.add(g);
            }
            return new VirtResSetQIter(this.vd, graphs.iterator(), Triple.create((Node)s, (Node)p, (Node)o));
        }

        public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
            return this.find(g, s, p, o);
        }

        public boolean contains(Node g, Node s, Node p, Node o) {
            s = s != null ? s : Node.ANY;
            p = p != null ? p : Node.ANY;
            Node node = o = o != null ? o : Node.ANY;
            if (this.isWildcard(g)) {
                boolean save = this.vd.getReadFromAllGraphs();
                this.vd.setReadFromAllGraphs(true);
                boolean ret = this.vd.graphBaseContains(null, Triple.create((Node)s, (Node)p, (Node)o));
                this.vd.setReadFromAllGraphs(save);
                return ret;
            }
            return this.vd.graphBaseContains(g.toString(), Triple.create((Node)s, (Node)p, (Node)o));
        }

        public boolean contains(Quad quad) {
            return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public void clear() {
            this.vd.clear();
        }

        public boolean isEmpty() {
            return this.contains(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        }

        boolean isWildcard(Node g) {
            return g == null || Node.ANY.equals((Object)g);
        }

        public boolean supportsTransactions() {
            return this.vd.supportsTransactions();
        }

        public boolean supportsTransactionAbort() {
            return this.vd.supportsTransactionAbort();
        }

        public boolean isInTransaction() {
            return this.vd.isInTransaction();
        }

        public void begin(TxnType txnType) {
            this.vd.begin(txnType);
        }

        public void begin(ReadWrite readWrite) {
            this.vd.begin(readWrite);
        }

        public boolean promote(Transactional.Promote promote) {
            return this.vd.promote(promote);
        }

        public void commit() {
            this.vd.commit();
        }

        public void abort() {
            this.vd.abort();
        }

        public void end() {
            this.vd.end();
        }

        public ReadWrite transactionMode() {
            return this.vd.transactionMode();
        }

        public TxnType transactionType() {
            return this.vd.transactionType();
        }
    }
}

