#include <vector>

/* Test pattern for KEM algorithms */
/** Kyber KAT from https://www.pq-crystals.org/kyber/data/kyber-submission-nist-round3.zip **/
// Test vector KYBER512
std::vector<uint8_t> sk_KYBER512 = {0x6C, 0x89, 0x2B, 0x02, 0x97, 0xA9, 0xC7, 0x64, 0x14, 0x93, 0xF8, 0x7D, 0xAF, 0x35, 0x33, 0xEE, 0xD6, 0x1F, 0x07, 0xF4, 0x65, 0x20, 0x66, 0x33, 0x7E, 0xD7, 0x40, 0x46, 0xDC, 0xC7, 0x1B, 0xA0, 0x3F, 0x30, 0x96, 0x01, 0x03, 0x16, 0x1F, 0x7D, 0xEB, 0x53, 0xA7, 0x1B, 0x11, 0x61, 0x72, 0x63, 0xFE, 0x2A, 0x80, 0x97, 0x69, 0xCE, 0x6D, 0x70, 0xA8, 0x5F, 0xE6, 0x00, 0xEC, 0xE2, 0x9D, 0x7F, 0x36, 0xA1, 0x6D, 0x33, 0x1B, 0x8B, 0x2A, 0x9E, 0x1D, 0xB8, 0xC0, 0x90, 0x74, 0x2D, 0xF0, 0x73, 0x9F, 0xF0, 0x60, 0xCE, 0xB4, 0xEC, 0xC5, 0xAB, 0x1C, 0x5E, 0x55, 0xAC, 0x97, 0xBB, 0x66, 0xA7, 0xF8, 0x95, 0x10, 0x5D, 0x57, 0x78, 0x2B, 0x22, 0x95, 0x38, 0xE3, 0x42, 0x15, 0x44, 0xA3, 0x42, 0x14, 0x08, 0xDB, 0xF4, 0x49, 0x10, 0x93, 0x4C, 0xC4, 0x23, 0x77, 0x4F, 0x16, 0x76, 0xFF, 0x1C, 0x30, 0x6F, 0x97, 0x55, 0x5F, 0x57, 0xB4, 0xAE, 0xD7, 0xA6, 0xBA, 0xB9, 0x50, 0xA8, 0x16, 0x3C, 0x8D, 0x31, 0x8D, 0xEA, 0x62, 0x75, 0x1B, 0xD6, 0xAB, 0xC5, 0x06, 0x9C, 0x06, 0xC8, 0x8F, 0x33, 0x00, 0x26, 0xA1, 0x98, 0x06, 0xA0, 0x3B, 0x97, 0xA7, 0x69, 0x6B, 0x56, 0xDA, 0x21, 0x82, 0x7B, 0xB4, 0xE8, 0xDC, 0x03, 0x11, 0x52, 0xB4, 0x1B, 0x89, 0x2A, 0x9E, 0x99, 0xAD, 0xF6, 0xE1, 0x96, 0x3E, 0x96, 0x57, 0x88, 0x28, 0x15, 0x4F, 0x46, 0x70, 0x33, 0x84, 0x69, 0x20, 0xFB, 0xB4, 0xB8, 0x05, 0x44, 0xE7, 0xE8, 0xA8, 0x1A, 0xE9, 0x63, 0xCF, 0x36, 0x8C, 0x9B, 0xA0, 0x37, 0xA8, 0xC2, 0xAD, 0x62, 0xE3, 0x2B, 0x6E, 0x61, 0xC9, 0x1D, 0x75, 0xCE, 0x00, 0x5A, 0xB3, 0x0F, 0x80, 0x99, 0xA1, 0xF2, 0x9D, 0x7B, 0x63, 0x05, 0xB4, 0xDC, 0x06, 0xE2, 0x56, 0x80, 0xBB, 0x00, 0x99, 0x2F, 0x71, 0x7F, 0xE6, 0xC1, 0x15, 0xA8, 0x08, 0x42, 0x31, 0xCC, 0x79, 0xDD, 0x70, 0x0E, 0xA6, 0x91, 0x2A, 0xC7, 0xFA, 0x0D, 0x93, 0x7B, 0xB6, 0xA7, 0x56, 0x66, 0x22, 0x30, 0x47, 0x0C, 0x18, 0x9B, 0x5A, 0xA1, 0x65, 0x3D, 0xEB, 0x93, 0x7D, 0x5A, 0x9C, 0x25, 0xA2, 0x1D, 0x93, 0xB1, 0x90, 0x74, 0xFC, 0x23, 0x9D, 0x81, 0x53, 0x53, 0x97, 0x97, 0xC7, 0xD4, 0xAB, 0x62, 0x64, 0x9D, 0x76, 0xAA, 0x55, 0x37, 0x36, 0xA9, 0x49, 0x02, 0x2C, 0x22, 0xC5, 0x2B, 0xAE, 0xEC, 0x60, 0x5B, 0x32, 0xCE, 0x9E, 0x5B, 0x93, 0x84, 0x90, 0x35, 0x58, 0xCA, 0x9D, 0x6A, 0x3A, 0xBA, 0x90, 0x42, 0x3E, 0xED, 0xA0, 0x1C, 0x94, 0x19, 0x8B, 0x19, 0x2A, 0x8B, 0xA9, 0x06, 0x34, 0x97, 0xA0, 0xC5, 0x01, 0x33, 0x07, 0xDD, 0xD8, 0x63, 0x52, 0x64, 0x71, 0xA4, 0xD9, 0x95, 0x23, 0xEB, 0x41, 0x7F, 0x29, 0x1A, 0xAC, 0x0C, 0x3A, 0x58, 0x1B, 0x6D, 0xA0, 0x07, 0x32, 0xE5, 0xE8, 0x1B, 0x1F, 0x7C, 0x87, 0x9B, 0x16, 0x93, 0xC1, 0x3B, 0x6F, 0x9F, 0x79, 0x31, 0x62, 0x24, 0x29, 0xE5, 0x42, 0xAF, 0x40, 0x69, 0x22, 0x2F, 0x04, 0x55, 0x44, 0xE0, 0xCC, 0x4F, 0xB2, 0x4D, 0x44, 0x48, 0xCF, 0x2C, 0x65, 0x96, 0xF5, 0xCB, 0x08, 0x62, 0x4B, 0x11, 0x85, 0x01, 0x3B, 0x6B, 0x02, 0x08, 0x92, 0xF9, 0x6B, 0xDF, 0xD4, 0xAD, 0xA9, 0x17, 0x9D, 0xE7, 0x27, 0xB8, 0xD9, 0x42, 0x6E, 0x09, 0x96, 0xB5, 0xD3, 0x49, 0x48, 0xCE, 0x02, 0xD0, 0xC3, 0x69, 0xB3, 0x7C, 0xBB, 0x54, 0xD3, 0x47, 0x9E, 0xD8, 0xB5, 0x82, 0xE9, 0xE7, 0x28, 0x92, 0x9B, 0x4C, 0x71, 0xC9, 0xBE, 0x11, 0xD4, 0x5B, 0x20, 0xC4, 0xBD, 0xC3, 0xC7, 0x43, 0x13, 0x22, 0x3F, 0x58, 0x27, 0x4E, 0x8B, 0xA5, 0x24, 0x44, 0x47, 0xC4, 0x95, 0x95, 0x0B, 0x84, 0xCB, 0x0C, 0x3C, 0x27, 0x36, 0x40, 0x10, 0x8A, 0x33, 0x97, 0x94, 0x45, 0x73, 0x27, 0x93, 0x28, 0x99, 0x6C, 0xDC, 0x0C, 0x91, 0x3C, 0x95, 0x8A, 0xD6, 0x20, 0xBA, 0x8B, 0x5E, 0x5E, 0xCB, 0xBB, 0x7E, 0x13, 0xCB, 0x9C, 0x70, 0xBD, 0x5A, 0xB3, 0x0E, 0xB7, 0x48, 0x8C, 0x97, 0x00, 0x1C, 0x20, 0x49, 0x8F, 0x1D, 0x7C, 0xC0, 0x6D, 0xA7, 0x6B, 0xF5, 0x20, 0xC6, 0x58, 0xCC, 0xAD, 0xFA, 0x29, 0x56, 0x42, 0x45, 0x57, 0xAB, 0xEA, 0x8A, 0xB8, 0x92, 0x39, 0xC1, 0x78, 0x33, 0xDC, 0x3A, 0x49, 0xB3, 0x6A, 0x9A, 0xE9, 0xA4, 0x86, 0x94, 0x05, 0x40, 0xEB, 0x44, 0x4F, 0x97, 0x15, 0x23, 0x57, 0xE0, 0x20, 0x35, 0x93, 0x9D, 0x75, 0xA3, 0xC0, 0x25, 0xF4, 0x1A, 0x40, 0x08, 0x23, 0x82, 0xA0, 0x73, 0x3C, 0x39, 0xB0, 0x62, 0x2B, 0x74, 0x0E, 0x40, 0x75, 0x92, 0xC6, 0x2E, 0xCA, 0xEB, 0x14, 0x32, 0xC4, 0x45, 0xB3, 0x70, 0x3A, 0x86, 0xF6, 0x98, 0x1A, 0x27, 0x81, 0x57, 0xEA, 0x95, 0xA6, 0xE9, 0x2D, 0x55, 0xE4, 0xB9, 0x72, 0xF9, 0x36, 0xC2, 0xF0, 0xA6, 0x58, 0x28, 0x0E, 0xA2, 0xB0, 0x7A, 0x48, 0x99, 0x2D, 0xF8, 0x93, 0x7E, 0x0A, 0x2A, 0xC1, 0xDC, 0xC9, 0x74, 0xFE, 0x00, 0xAA, 0xE1, 0xF5, 0x61, 0xFA, 0x25, 0x8E, 0x2D, 0x25, 0x9C, 0x3E, 0x86, 0x1D, 0xCE, 0x23, 0x60, 0x39, 0x12, 0x76, 0x06, 0xFC, 0x1C, 0xE0, 0x09, 0x00, 0x3A, 0x7B, 0xAC, 0x94, 0x21, 0x01, 0xDC, 0xB8, 0x22, 0xB1, 0xF3, 0xC1, 0x2B, 0xF7, 0x32, 0x38, 0xF5, 0x46, 0xE0, 0x1C, 0x36, 0xB5, 0xA6, 0x93, 0x61, 0x92, 0x99, 0x5C, 0xC6, 0x9C, 0x63, 0x23, 0x74, 0x09, 0xCB, 0x53, 0xC2, 0xE3, 0x5D, 0x74, 0x89, 0x0D, 0x18, 0x88, 0x53, 0x76, 0xFA, 0x55, 0x03, 0xB1, 0x07, 0xA2, 0xA3, 0x92, 0x11, 0x5A, 0xCE, 0x0E, 0x64, 0x67, 0x7C, 0xBB, 0x7D, 0xCF, 0xC9, 0x3C, 0x16, 0xD3, 0xA3, 0x05, 0xF6, 0x76, 0x15, 0xA4, 0x88, 0xD7, 0x11, 0xAA, 0x56, 0x69, 0x8C, 0x56, 0x63, 0xAB, 0x7A, 0xC9, 0xCE, 0x66, 0xD5, 0x47, 0xC0, 0x59, 0x5F, 0x98, 0xA4, 0x3F, 0x46, 0x50, 0xBB, 0xE0, 0x8C, 0x36, 0x4D, 0x97, 0x67, 0x89, 0x11, 0x7D, 0x34, 0xF6, 0xAE, 0x51, 0xAC, 0x06, 0x3C, 0xB5, 0x5C, 0x6C, 0xA3, 0x25, 0x58, 0x22, 0x7D, 0xFE, 0xF8, 0x07, 0xD1, 0x9C, 0x30, 0xDE, 0x41, 0x44, 0x24, 0x09, 0x7F, 0x6A, 0xA2, 0x36, 0xA1, 0x05, 0x3B, 0x4A, 0x07, 0xA7, 0x6B, 0xE3, 0x72, 0xA5, 0xC6, 0xB6, 0x00, 0x27, 0x91, 0xEB, 0xE0, 0xAF, 0xDA, 0xF5, 0x4E, 0x1C, 0xA2, 0x37, 0xFF, 0x54, 0x5B, 0xA6, 0x83, 0x43, 0xE7, 0x45, 0xC0, 0x4A, 0xD1, 0x63, 0x9D, 0xBC, 0x59, 0x03, 0x46, 0xB6, 0xB9, 0x56, 0x9B, 0x56, 0xDB, 0xBF, 0xE5, 0x31, 0x51, 0x91, 0x30, 0x66, 0xE5, 0xC8, 0x55, 0x27, 0xDC, 0x94, 0x68, 0x11, 0x0A, 0x13, 0x6A, 0x41, 0x14, 0x97, 0xC2, 0x27, 0xDC, 0xB8, 0xC9, 0xB2, 0x55, 0x70, 0xB7, 0xA0, 0xE4, 0x2A, 0xAD, 0xA6, 0x70, 0x9F, 0x23, 0x20, 0x8F, 0x5D, 0x49, 0x6E, 0xBA, 0xB7, 0x84, 0x3F, 0x64, 0x83, 0xBF, 0x0C, 0x0C, 0x73, 0xA4, 0x02, 0x96, 0xEC, 0x2C, 0x64, 0x40, 0x00, 0x13, 0x94, 0xC9, 0x9C, 0xA1, 0x73, 0xD5, 0xC7, 0x75, 0xB7, 0xF4, 0x15, 0xD0, 0x2A, 0x5A, 0x26, 0xA0, 0x74, 0x07, 0x91, 0x85, 0x87, 0xC4, 0x11, 0x69, 0xF2, 0xB7, 0x17, 0x87, 0x55, 0xAC, 0xC2, 0x7F, 0xC8, 0xB1, 0x9C, 0x4C, 0x4B, 0x3F, 0xCD, 0x41, 0x05, 0x3F, 0x2C, 0x74, 0xC8, 0xA1, 0x0A, 0x83, 0x21, 0x24, 0x1B, 0x28, 0x02, 0x43, 0x28, 0x75, 0xAE, 0x80, 0x8B, 0x9E, 0xF1, 0x36, 0x5C, 0x7B, 0x8A, 0x52, 0x90, 0x2F, 0x13, 0x17, 0xBA, 0x2F, 0xB0, 0x26, 0x9F, 0x47, 0x93, 0x06, 0x72, 0x10, 0x7B, 0x47, 0x26, 0xFE, 0xF6, 0x45, 0x47, 0x39, 0x4D, 0x33, 0x20, 0xC8, 0xF1, 0x20, 0xB3, 0xC2, 0xF4, 0x72, 0x5B, 0x03, 0x05, 0xFA, 0xB8, 0x8C, 0xC7, 0x98, 0x1F, 0xCB, 0x09, 0xA7, 0x6A, 0x1C, 0xBF, 0x7F, 0x17, 0x9F, 0x43, 0xBB, 0x0A, 0x4C, 0x8B, 0x05, 0x90, 0x85, 0x7F, 0x1E, 0x69, 0x70, 0x84, 0x66, 0xC7, 0xF8, 0x60, 0x73, 0x91, 0xE7, 0xBC, 0x52, 0x68, 0xBF, 0xD3, 0xD7, 0xA1, 0xDF, 0xFC, 0xB4, 0xEC, 0xA2, 0xA1, 0xC9, 0xB5, 0x97, 0x59, 0x30, 0x13, 0xD5, 0xFC, 0x42, 0x02, 0xEC, 0x2B, 0x74, 0xE5, 0x7A, 0xB7, 0x6B, 0xBC, 0xF3, 0x63, 0x2B, 0xBA, 0xF9, 0x7C, 0xDC, 0x41, 0x8A, 0x6F, 0x16, 0x39, 0x28, 0x38, 0xCA, 0x9B, 0xF4, 0x5D, 0xDF, 0x02, 0x37, 0x77, 0xB7, 0x56, 0x18, 0x33, 0xC1, 0x05, 0x19, 0x0F, 0x94, 0xF3, 0x02, 0xC5, 0x9B, 0x53, 0x19, 0x00, 0xBB, 0xC8, 0x16, 0x36, 0x1F, 0xAA, 0x5B, 0x33, 0x80, 0xCA, 0x3A, 0x89, 0x31, 0x04, 0xCA, 0x73, 0x88, 0xB1, 0x85, 0x67, 0x1B, 0x3E, 0x5F, 0xE3, 0x79, 0x0E, 0x9A, 0x62, 0x6E, 0xC4, 0x6D, 0x9B, 0x0B, 0x33, 0xC7, 0xA4, 0x19, 0xAF, 0x7B, 0x32, 0xB6, 0x85, 0x98, 0x94, 0xF5, 0x75, 0xD8, 0x2A, 0xC5, 0x45, 0x6B, 0x54, 0x90, 0xA7, 0xAF, 0x8F, 0xE6, 0x10, 0x46, 0x36, 0x05, 0x89, 0xEC, 0xBA, 0x72, 0x44, 0x23, 0x6F, 0x41, 0x23, 0x11, 0x6B, 0x61, 0x74, 0xAA, 0x17, 0x92, 0x49, 0xA4, 0x91, 0x95, 0xB3, 0x56, 0xC7, 0x2F, 0xC6, 0x64, 0x1F, 0x02, 0x51, 0x81, 0x2E, 0xAA, 0x98, 0x57, 0x0B, 0x04, 0x66, 0x99, 0x07, 0x0E, 0x08, 0x19, 0xDC, 0x27, 0x13, 0xF4, 0x69, 0x13, 0x7D, 0xFC, 0x6A, 0x3D, 0x7B, 0x92, 0xB2, 0x98, 0x99, 0x5E, 0xE7, 0x80, 0x36, 0x91, 0x53, 0xAC, 0x36, 0x6B, 0x06, 0xD7, 0x24, 0x9C, 0xD0, 0x9E, 0x1B, 0x33, 0x78, 0xFB, 0x04, 0x39, 0x9C, 0xEC, 0xB8, 0x65, 0x05, 0x81, 0xD6, 0x37, 0xC7, 0x9A, 0xE6, 0x7D, 0x6F, 0x2C, 0xAF, 0x6A, 0xBA, 0xCF, 0x59, 0x81, 0x59, 0xA7, 0x79, 0x2C, 0xB3, 0xC9, 0x71, 0xD1, 0x49, 0x9D, 0x23, 0x73, 0xAD, 0x20, 0xF6, 0x3F, 0x03, 0xBB, 0x59, 0xED, 0x13, 0x73, 0x84, 0xAC, 0x61, 0xA7, 0x15, 0x51, 0x43, 0xB8, 0xCA, 0x49, 0x32, 0x61, 0x2E, 0xC9, 0x15, 0xE4, 0xCA, 0x34, 0x6A, 0x9B, 0xCE, 0x5D, 0xD6, 0x04, 0x17, 0xC6, 0xB2, 0xA8, 0x9B, 0x1C, 0xC4, 0x35, 0x64, 0x3F, 0x87, 0x5B, 0xDC, 0x5A, 0x7E, 0x5B, 0x34, 0x81, 0xCF, 0x91, 0x9E, 0xA0, 0x91, 0x72, 0xFE, 0xBC, 0x46, 0xD4, 0xFC, 0x3F, 0xB0, 0xCB, 0x95, 0x91, 0x70, 0x4E, 0xE2, 0xDB, 0xB6, 0x18, 0x44, 0xB2, 0xF3, 0x31, 0x4A, 0x06, 0xBB, 0x6C, 0x6D, 0x34, 0x00, 0x5E, 0x48, 0x5C, 0xE6, 0x67, 0xBD, 0xC7, 0xD0, 0x98, 0x58, 0x69, 0x28, 0xD2, 0xD9, 0x13, 0x40, 0xF0, 0x04, 0x19, 0xEA, 0x40, 0x13, 0x51, 0xA2, 0x40, 0xA0, 0xB0, 0x41, 0x05, 0x8B, 0xEF, 0xB0, 0xC2, 0xFD, 0x32, 0x64, 0x5B, 0x7A, 0x2D, 0xF8, 0xF5, 0xCB, 0xFD, 0x87, 0x33, 0x27, 0xC9, 0x78, 0xD7, 0xB3, 0x51, 0xA2, 0x80, 0x88, 0x43, 0x88, 0x37, 0x02, 0x4C, 0x52, 0xB9, 0xC2, 0x95, 0xCD, 0x71, 0x36, 0x46, 0xFB, 0x5D, 0x6C, 0x0C, 0xCF, 0xB4, 0x70, 0x73, 0x4A, 0xC2, 0xB2, 0xBC, 0x81, 0x23, 0xC2, 0xC1, 0x3D, 0xF6, 0x93, 0x8E, 0x92, 0x45, 0x5A, 0x86, 0x26, 0x39, 0xFE, 0xB8, 0xA6, 0x4B, 0x85, 0x16, 0x3E, 0x32, 0x70, 0x7E, 0x03, 0x7B, 0x38, 0xD8, 0xAC, 0x39, 0x22, 0xB4, 0x51, 0x87, 0xBB, 0x65, 0xEA, 0xFD, 0x46, 0x5F, 0xC6, 0x4A, 0x0C, 0x5F, 0x8F, 0x3F, 0x90, 0x03, 0x48, 0x94, 0x15, 0x89, 0x9D, 0x59, 0xA5, 0x43, 0xD8, 0x20, 0x8C, 0x54, 0xA3, 0x16, 0x65, 0x29, 0xB5, 0x39, 0x22, 0x7F, 0xFA, 0xD1, 0xBC, 0x8A, 0xF7, 0x3B, 0x7E, 0x87, 0x49, 0x56, 0xB8, 0x1C, 0x2A, 0x2E, 0xF0, 0xBF, 0xAB, 0xE8, 0xDC, 0x93, 0xD7, 0x7B, 0x2F, 0xBC, 0x9E, 0x0C, 0x64, 0xEF, 0xA0, 0x1E, 0x84, 0x86, 0x26, 0xED, 0x79, 0xD4, 0x51, 0x14, 0x08, 0x00, 0xE0, 0x3B, 0x59, 0xB9, 0x56, 0xF8, 0x21, 0x0E, 0x55, 0x60, 0x67, 0x40, 0x7D, 0x13, 0xDC, 0x90, 0xFA, 0x9E, 0x8B, 0x87, 0x2B, 0xFB, 0x8F};
std::vector<uint8_t> pk_KYBER512 = {0x11, 0x5A, 0xCE, 0x0E, 0x64, 0x67, 0x7C, 0xBB, 0x7D, 0xCF, 0xC9, 0x3C, 0x16, 0xD3, 0xA3, 0x05, 0xF6, 0x76, 0x15, 0xA4, 0x88, 0xD7, 0x11, 0xAA, 0x56, 0x69, 0x8C, 0x56, 0x63, 0xAB, 0x7A, 0xC9, 0xCE, 0x66, 0xD5, 0x47, 0xC0, 0x59, 0x5F, 0x98, 0xA4, 0x3F, 0x46, 0x50, 0xBB, 0xE0, 0x8C, 0x36, 0x4D, 0x97, 0x67, 0x89, 0x11, 0x7D, 0x34, 0xF6, 0xAE, 0x51, 0xAC, 0x06, 0x3C, 0xB5, 0x5C, 0x6C, 0xA3, 0x25, 0x58, 0x22, 0x7D, 0xFE, 0xF8, 0x07, 0xD1, 0x9C, 0x30, 0xDE, 0x41, 0x44, 0x24, 0x09, 0x7F, 0x6A, 0xA2, 0x36, 0xA1, 0x05, 0x3B, 0x4A, 0x07, 0xA7, 0x6B, 0xE3, 0x72, 0xA5, 0xC6, 0xB6, 0x00, 0x27, 0x91, 0xEB, 0xE0, 0xAF, 0xDA, 0xF5, 0x4E, 0x1C, 0xA2, 0x37, 0xFF, 0x54, 0x5B, 0xA6, 0x83, 0x43, 0xE7, 0x45, 0xC0, 0x4A, 0xD1, 0x63, 0x9D, 0xBC, 0x59, 0x03, 0x46, 0xB6, 0xB9, 0x56, 0x9B, 0x56, 0xDB, 0xBF, 0xE5, 0x31, 0x51, 0x91, 0x30, 0x66, 0xE5, 0xC8, 0x55, 0x27, 0xDC, 0x94, 0x68, 0x11, 0x0A, 0x13, 0x6A, 0x41, 0x14, 0x97, 0xC2, 0x27, 0xDC, 0xB8, 0xC9, 0xB2, 0x55, 0x70, 0xB7, 0xA0, 0xE4, 0x2A, 0xAD, 0xA6, 0x70, 0x9F, 0x23, 0x20, 0x8F, 0x5D, 0x49, 0x6E, 0xBA, 0xB7, 0x84, 0x3F, 0x64, 0x83, 0xBF, 0x0C, 0x0C, 0x73, 0xA4, 0x02, 0x96, 0xEC, 0x2C, 0x64, 0x40, 0x00, 0x13, 0x94, 0xC9, 0x9C, 0xA1, 0x73, 0xD5, 0xC7, 0x75, 0xB7, 0xF4, 0x15, 0xD0, 0x2A, 0x5A, 0x26, 0xA0, 0x74, 0x07, 0x91, 0x85, 0x87, 0xC4, 0x11, 0x69, 0xF2, 0xB7, 0x17, 0x87, 0x55, 0xAC, 0xC2, 0x7F, 0xC8, 0xB1, 0x9C, 0x4C, 0x4B, 0x3F, 0xCD, 0x41, 0x05, 0x3F, 0x2C, 0x74, 0xC8, 0xA1, 0x0A, 0x83, 0x21, 0x24, 0x1B, 0x28, 0x02, 0x43, 0x28, 0x75, 0xAE, 0x80, 0x8B, 0x9E, 0xF1, 0x36, 0x5C, 0x7B, 0x8A, 0x52, 0x90, 0x2F, 0x13, 0x17, 0xBA, 0x2F, 0xB0, 0x26, 0x9F, 0x47, 0x93, 0x06, 0x72, 0x10, 0x7B, 0x47, 0x26, 0xFE, 0xF6, 0x45, 0x47, 0x39, 0x4D, 0x33, 0x20, 0xC8, 0xF1, 0x20, 0xB3, 0xC2, 0xF4, 0x72, 0x5B, 0x03, 0x05, 0xFA, 0xB8, 0x8C, 0xC7, 0x98, 0x1F, 0xCB, 0x09, 0xA7, 0x6A, 0x1C, 0xBF, 0x7F, 0x17, 0x9F, 0x43, 0xBB, 0x0A, 0x4C, 0x8B, 0x05, 0x90, 0x85, 0x7F, 0x1E, 0x69, 0x70, 0x84, 0x66, 0xC7, 0xF8, 0x60, 0x73, 0x91, 0xE7, 0xBC, 0x52, 0x68, 0xBF, 0xD3, 0xD7, 0xA1, 0xDF, 0xFC, 0xB4, 0xEC, 0xA2, 0xA1, 0xC9, 0xB5, 0x97, 0x59, 0x30, 0x13, 0xD5, 0xFC, 0x42, 0x02, 0xEC, 0x2B, 0x74, 0xE5, 0x7A, 0xB7, 0x6B, 0xBC, 0xF3, 0x63, 0x2B, 0xBA, 0xF9, 0x7C, 0xDC, 0x41, 0x8A, 0x6F, 0x16, 0x39, 0x28, 0x38, 0xCA, 0x9B, 0xF4, 0x5D, 0xDF, 0x02, 0x37, 0x77, 0xB7, 0x56, 0x18, 0x33, 0xC1, 0x05, 0x19, 0x0F, 0x94, 0xF3, 0x02, 0xC5, 0x9B, 0x53, 0x19, 0x00, 0xBB, 0xC8, 0x16, 0x36, 0x1F, 0xAA, 0x5B, 0x33, 0x80, 0xCA, 0x3A, 0x89, 0x31, 0x04, 0xCA, 0x73, 0x88, 0xB1, 0x85, 0x67, 0x1B, 0x3E, 0x5F, 0xE3, 0x79, 0x0E, 0x9A, 0x62, 0x6E, 0xC4, 0x6D, 0x9B, 0x0B, 0x33, 0xC7, 0xA4, 0x19, 0xAF, 0x7B, 0x32, 0xB6, 0x85, 0x98, 0x94, 0xF5, 0x75, 0xD8, 0x2A, 0xC5, 0x45, 0x6B, 0x54, 0x90, 0xA7, 0xAF, 0x8F, 0xE6, 0x10, 0x46, 0x36, 0x05, 0x89, 0xEC, 0xBA, 0x72, 0x44, 0x23, 0x6F, 0x41, 0x23, 0x11, 0x6B, 0x61, 0x74, 0xAA, 0x17, 0x92, 0x49, 0xA4, 0x91, 0x95, 0xB3, 0x56, 0xC7, 0x2F, 0xC6, 0x64, 0x1F, 0x02, 0x51, 0x81, 0x2E, 0xAA, 0x98, 0x57, 0x0B, 0x04, 0x66, 0x99, 0x07, 0x0E, 0x08, 0x19, 0xDC, 0x27, 0x13, 0xF4, 0x69, 0x13, 0x7D, 0xFC, 0x6A, 0x3D, 0x7B, 0x92, 0xB2, 0x98, 0x99, 0x5E, 0xE7, 0x80, 0x36, 0x91, 0x53, 0xAC, 0x36, 0x6B, 0x06, 0xD7, 0x24, 0x9C, 0xD0, 0x9E, 0x1B, 0x33, 0x78, 0xFB, 0x04, 0x39, 0x9C, 0xEC, 0xB8, 0x65, 0x05, 0x81, 0xD6, 0x37, 0xC7, 0x9A, 0xE6, 0x7D, 0x6F, 0x2C, 0xAF, 0x6A, 0xBA, 0xCF, 0x59, 0x81, 0x59, 0xA7, 0x79, 0x2C, 0xB3, 0xC9, 0x71, 0xD1, 0x49, 0x9D, 0x23, 0x73, 0xAD, 0x20, 0xF6, 0x3F, 0x03, 0xBB, 0x59, 0xED, 0x13, 0x73, 0x84, 0xAC, 0x61, 0xA7, 0x15, 0x51, 0x43, 0xB8, 0xCA, 0x49, 0x32, 0x61, 0x2E, 0xC9, 0x15, 0xE4, 0xCA, 0x34, 0x6A, 0x9B, 0xCE, 0x5D, 0xD6, 0x04, 0x17, 0xC6, 0xB2, 0xA8, 0x9B, 0x1C, 0xC4, 0x35, 0x64, 0x3F, 0x87, 0x5B, 0xDC, 0x5A, 0x7E, 0x5B, 0x34, 0x81, 0xCF, 0x91, 0x9E, 0xA0, 0x91, 0x72, 0xFE, 0xBC, 0x46, 0xD4, 0xFC, 0x3F, 0xB0, 0xCB, 0x95, 0x91, 0x70, 0x4E, 0xE2, 0xDB, 0xB6, 0x18, 0x44, 0xB2, 0xF3, 0x31, 0x4A, 0x06, 0xBB, 0x6C, 0x6D, 0x34, 0x00, 0x5E, 0x48, 0x5C, 0xE6, 0x67, 0xBD, 0xC7, 0xD0, 0x98, 0x58, 0x69, 0x28, 0xD2, 0xD9, 0x13, 0x40, 0xF0, 0x04, 0x19, 0xEA, 0x40, 0x13, 0x51, 0xA2, 0x40, 0xA0, 0xB0, 0x41, 0x05, 0x8B, 0xEF, 0xB0, 0xC2, 0xFD, 0x32, 0x64, 0x5B, 0x7A, 0x2D, 0xF8, 0xF5, 0xCB, 0xFD, 0x87, 0x33, 0x27, 0xC9, 0x78, 0xD7, 0xB3, 0x51, 0xA2, 0x80, 0x88, 0x43, 0x88, 0x37, 0x02, 0x4C, 0x52, 0xB9, 0xC2, 0x95, 0xCD, 0x71, 0x36, 0x46, 0xFB, 0x5D, 0x6C, 0x0C, 0xCF, 0xB4, 0x70, 0x73, 0x4A, 0xC2, 0xB2, 0xBC, 0x81, 0x23, 0xC2, 0xC1, 0x3D, 0xF6, 0x93, 0x8E, 0x92, 0x45, 0x5A, 0x86, 0x26, 0x39, 0xFE, 0xB8, 0xA6, 0x4B, 0x85, 0x16, 0x3E, 0x32, 0x70, 0x7E, 0x03, 0x7B, 0x38, 0xD8, 0xAC, 0x39, 0x22, 0xB4, 0x51, 0x87, 0xBB, 0x65, 0xEA, 0xFD, 0x46, 0x5F, 0xC6, 0x4A, 0x0C, 0x5F, 0x8F, 0x3F, 0x90, 0x03, 0x48, 0x94, 0x15, 0x89, 0x9D, 0x59, 0xA5, 0x43, 0xD8, 0x20, 0x8C, 0x54, 0xA3, 0x16, 0x65, 0x29, 0xB5, 0x39, 0x22};
std::vector<uint8_t> ct_KYBER512 = {0xED, 0xF2, 0x41, 0x45, 0xE4, 0x3B, 0x4F, 0x6D, 0xC6, 0xBF, 0x83, 0x32, 0xF5, 0x4E, 0x02, 0xCA, 0xB0, 0x2D, 0xBF, 0x3B, 0x56, 0x05, 0xDD, 0xC9, 0x0A, 0x15, 0xC8, 0x86, 0xAD, 0x3E, 0xD4, 0x89, 0x46, 0x26, 0x99, 0xE4, 0xAB, 0xED, 0x44, 0x35, 0x0B, 0xC3, 0x75, 0x7E, 0x26, 0x96, 0xFB, 0xFB, 0x25, 0x34, 0x41, 0x2E, 0x8D, 0xD2, 0x01, 0xF1, 0xE4, 0x54, 0x0A, 0x39, 0x70, 0xB0, 0x55, 0xFE, 0x3B, 0x0B, 0xEC, 0x3A, 0x71, 0xF9, 0xE1, 0x15, 0xB3, 0xF9, 0xF3, 0x91, 0x02, 0x06, 0x5B, 0x1C, 0xCA, 0x83, 0x14, 0xDC, 0xC7, 0x95, 0xE3, 0xC0, 0xE8, 0xFA, 0x98, 0xEE, 0x83, 0xCA, 0x66, 0x28, 0x45, 0x70, 0x28, 0xA4, 0xD0, 0x9E, 0x83, 0x9E, 0x55, 0x48, 0x62, 0xCF, 0x0B, 0x7B, 0xF5, 0x6C, 0x5C, 0x0A, 0x82, 0x9E, 0x86, 0x57, 0x94, 0x79, 0x45, 0xFE, 0x9C, 0x22, 0x56, 0x4F, 0xBA, 0xEB, 0xC1, 0xB3, 0xAF, 0x35, 0x0D, 0x79, 0x55, 0x50, 0x8A, 0x26, 0xD8, 0xA8, 0xEB, 0x54, 0x7B, 0x8B, 0x1A, 0x2C, 0xF0, 0x3C, 0xCA, 0x1A, 0xAB, 0xCE, 0x6C, 0x34, 0x97, 0x78, 0x3B, 0x64, 0x65, 0xBA, 0x0B, 0x6E, 0x7A, 0xCB, 0xA8, 0x21, 0x19, 0x51, 0x24, 0xAE, 0xF0, 0x9E, 0x62, 0x83, 0x82, 0xA1, 0xF9, 0x14, 0x04, 0x3B, 0xE7, 0x09, 0x6E, 0x95, 0x2C, 0xBC, 0x4F, 0xB4, 0xAF, 0xED, 0x13, 0x60, 0x90, 0x46, 0x11, 0x7C, 0x01, 0x1F, 0xD7, 0x41, 0xEE, 0x28, 0x6C, 0x83, 0x77, 0x16, 0x90, 0xF0, 0xAE, 0xB5, 0x0D, 0xA0, 0xD7, 0x12, 0x85, 0xA1, 0x79, 0xB2, 0x15, 0xC6, 0x03, 0x6D, 0xEB, 0x78, 0x0F, 0x4D, 0x16, 0x76, 0x9F, 0x72, 0xDE, 0x16, 0xFD, 0xAD, 0xAC, 0x73, 0xBE, 0xFA, 0x5B, 0xEF, 0x89, 0x43, 0x19, 0x7F, 0x44, 0xC5, 0x95, 0x89, 0xDC, 0x9F, 0x49, 0x73, 0xDE, 0x14, 0x50, 0xBA, 0x1D, 0x0C, 0x32, 0x90, 0xD6, 0xB1, 0xD6, 0x83, 0xF2, 0x94, 0xE7, 0x59, 0xC9, 0x54, 0xAB, 0xE8, 0xA7, 0xDA, 0x5B, 0x10, 0x54, 0xFD, 0x6D, 0x21, 0x32, 0x9B, 0x8E, 0x73, 0xD3, 0x75, 0x6A, 0xFD, 0xA0, 0xDC, 0xB1, 0xFC, 0x8B, 0x15, 0x82, 0xD1, 0xF9, 0x0C, 0xF2, 0x75, 0xA1, 0x02, 0xAB, 0xC6, 0xAC, 0x69, 0x9D, 0xF0, 0xC5, 0x87, 0x0E, 0x50, 0xA1, 0xF9, 0x89, 0xE4, 0xE6, 0x24, 0x1B, 0x60, 0xAA, 0xA2, 0xEC, 0xF9, 0xE8, 0xE3, 0x3E, 0x0F, 0xFC, 0xF4, 0x0F, 0xE8, 0x31, 0xE8, 0xFD, 0xC2, 0xE8, 0x3B, 0x52, 0xCA, 0x7A, 0xB6, 0xD9, 0x3F, 0x14, 0x6D, 0x29, 0xDC, 0xA5, 0x3C, 0x7D, 0xA1, 0xDB, 0x4A, 0xC4, 0xF2, 0xDB, 0x39, 0xEA, 0x12, 0x0D, 0x90, 0xFA, 0x60, 0xF4, 0xD4, 0x37, 0xC6, 0xD0, 0x0E, 0xF4, 0x83, 0xBC, 0x94, 0xA3, 0x17, 0x5C, 0xDA, 0x16, 0x3F, 0xC1, 0xC2, 0x82, 0x8B, 0xE4, 0xDB, 0xD6, 0x43, 0x05, 0x07, 0xB5, 0x84, 0xBB, 0x51, 0x77, 0xE1, 0x71, 0xB8, 0xDD, 0xA9, 0xA4, 0x29, 0x3C, 0x32, 0x00, 0x29, 0x5C, 0x80, 0x3A, 0x86, 0x5D, 0x6D, 0x21, 0x66, 0xF6, 0x6B, 0xA5, 0x40, 0x1F, 0xB7, 0xA0, 0xE8, 0x53, 0x16, 0x86, 0x00, 0xA2, 0x94, 0x84, 0x37, 0xE0, 0x36, 0xE3, 0xBF, 0x19, 0xE1, 0x2F, 0xD3, 0xF2, 0xA2, 0xB8, 0xB3, 0x43, 0xF7, 0x84, 0x24, 0x8E, 0x8D, 0x68, 0x5E, 0xB0, 0xAF, 0xDE, 0x63, 0x15, 0x33, 0x87, 0x30, 0xE7, 0xA1, 0x00, 0x1C, 0x27, 0xD8, 0xD2, 0xA7, 0x6F, 0xA6, 0x9D, 0x15, 0x7B, 0xA1, 0xAC, 0x7A, 0xD5, 0x6D, 0xA5, 0xA8, 0xC7, 0x0F, 0xE4, 0xB5, 0xB8, 0xD7, 0x86, 0xDC, 0x6F, 0xC0, 0x56, 0x6B, 0xA8, 0xE1, 0xB8, 0x81, 0x63, 0x34, 0xD3, 0x2A, 0x3F, 0xB1, 0xCE, 0x7D, 0x4D, 0x5E, 0x4C, 0x33, 0x2A, 0xF7, 0xB0, 0x03, 0xD0, 0x91, 0x74, 0x1A, 0x3D, 0x5C, 0x96, 0x52, 0x92, 0x25, 0x5D, 0xFF, 0x8E, 0xD2, 0xBB, 0xF1, 0xF9, 0x11, 0x6B, 0xE5, 0x0C, 0x17, 0xB8, 0xE5, 0x48, 0x74, 0x8A, 0xD4, 0xB2, 0xE9, 0x57, 0xBB, 0xD1, 0x95, 0x34, 0x82, 0xA2, 0xE1, 0x71, 0x8C, 0xEC, 0x66, 0xCD, 0x2C, 0x81, 0xF5, 0x72, 0xD5, 0x52, 0xB7, 0x18, 0x78, 0x85, 0xE6, 0xB8, 0x94, 0x3D, 0x64, 0x31, 0x41, 0x3C, 0x59, 0xEB, 0xB7, 0xE0, 0x36, 0x04, 0x84, 0x90, 0xBE, 0x52, 0x89, 0xE9, 0x5B, 0x20, 0xA8, 0x9E, 0x8B, 0x15, 0x9F, 0x61, 0xA9, 0xA9, 0x88, 0x6E, 0x14, 0x75, 0x68, 0xF4, 0xC9, 0x02, 0x1F, 0x36, 0x2F, 0x02, 0x68, 0x8A, 0x1C, 0x8C, 0x3B, 0xB0, 0xD2, 0x40, 0x86, 0x88, 0x0E, 0x55, 0xB6, 0xED, 0xB4, 0x3F, 0x37, 0x45, 0xD2, 0xC1, 0x66, 0xDC, 0x1C, 0xB7, 0x43, 0xC7, 0x6F, 0xE6, 0xBE, 0x52, 0x3A, 0x89, 0x3C, 0xC7, 0x64, 0xD1, 0x64, 0x35, 0xC3, 0x78, 0x51, 0x25, 0x2A, 0x81, 0xE2, 0xFF, 0xBA, 0x0F, 0x18, 0x97, 0x1A, 0x3D, 0xEE, 0x37, 0xD4, 0x87, 0x7C, 0xB9, 0x28, 0xE3, 0x6E, 0x52, 0x35, 0x03, 0x7A, 0x6B, 0x20, 0x57, 0x89, 0x7D, 0x51, 0x8A, 0x5F, 0x0E, 0x34, 0x8E, 0x3A, 0xB6, 0xD5, 0xB5, 0x2D, 0xFC, 0x60, 0x75, 0x7F, 0x3B, 0x41, 0xA4, 0xFE, 0xC7, 0x82, 0x8F, 0x1D, 0xEE, 0xAF, 0x45, 0x87, 0xCC, 0xC8, 0xEA, 0xDF, 0x64, 0x7F, 0x4D, 0x20, 0x3B, 0x2F, 0xAA, 0x05, 0xA6, 0x49, 0xB5, 0x82, 0x34, 0x0C, 0xB4, 0xCA, 0xCE, 0x57, 0xA3, 0x07, 0x11, 0xBE, 0x75, 0x2F, 0xAC, 0xF0, 0x22, 0x7D, 0x0A, 0x80, 0xC4, 0x12, 0x84, 0x42, 0xDD, 0xC5, 0x44, 0xBE, 0x80, 0x5B, 0x9C, 0xFE, 0x8F, 0xE9, 0xB1, 0x23, 0x7C, 0x80, 0xF9, 0x67, 0x87, 0xCD, 0x92, 0x81, 0xCC, 0xF2, 0x70, 0xC1, 0xAF, 0xC0, 0x67, 0x0D};
std::vector<uint8_t> ss_KYBER512 = {0x0A, 0x69, 0x25, 0x67, 0x6F, 0x24, 0xB2, 0x2C, 0x28, 0x6F, 0x4C, 0x81, 0xA4, 0x22, 0x4C, 0xEC, 0x50, 0x6C, 0x9B, 0x25, 0x7D, 0x48, 0x0E, 0x02, 0xE3, 0xB4, 0x9F, 0x44, 0xCA, 0xA3, 0x23, 0x7F};

std::vector<uint8_t> sk_MLKEM512 = {0x69, 0xF9, 0xCB, 0xFD, 0x12, 0x37, 0xBA, 0x16, 0x1C, 0xF6, 0xE6, 0xC1, 0x8F, 0x48, 0x8F, 0xC6, 0xE3, 0x9A, 0xB4, 0xA5, 0xC9, 0xE6, 0xC2, 0x2E, 0xA4, 0xE3, 0xAD, 0x8F, 0x26, 0x7A, 0x9C, 0x44, 0x20, 0x10, 0xD3, 0x2E, 0x61, 0xF8, 0x3E, 0x6B, 0xFA, 0x5C, 0x58, 0x70, 0x61, 0x45, 0x37, 0x6D, 0xBB, 0x84, 0x95, 0x28, 0xF6, 0x80, 0x07, 0xC8, 0x22, 0xB3, 0x3A, 0x95, 0xB8, 0x49, 0x04, 0xDC, 0xD2, 0x70, 0x8D, 0x03, 0x40, 0xC8, 0xB8, 0x08, 0xBC, 0xD3, 0xAA, 0xD0, 0xE4, 0x8B, 0x85, 0x84, 0x95, 0x83, 0xA1, 0xB4, 0xE5, 0x94, 0x5D, 0xD9, 0x51, 0x4A, 0x7F, 0x64, 0x61, 0xE0, 0x57, 0xB7, 0xEC, 0xF6, 0x19, 0x57, 0xE9, 0x7C, 0xF6, 0x28, 0x15, 0xF9, 0xC3, 0x22, 0x94, 0xB3, 0x26, 0xE1, 0xA1, 0xC4, 0xE3, 0x60, 0xB9, 0x49, 0x8B, 0xA8, 0x0F, 0x8C, 0xA9, 0x15, 0x32, 0xB1, 0x71, 0xD0, 0xAE, 0xFC, 0x48, 0x49, 0xFA, 0x53, 0xBC, 0x61, 0x79, 0x32, 0xE2, 0x08, 0xA6, 0x77, 0xC6, 0x04, 0x4A, 0x66, 0x00, 0xB8, 0xD8, 0xB8, 0x3F, 0x26, 0xA7, 0x47, 0xB1, 0x8C, 0xFB, 0x78, 0xBE, 0xAF, 0xC5, 0x51, 0xAD, 0x52, 0xB7, 0xCA, 0x6C, 0xB8, 0x8F, 0x3B, 0x5D, 0x9C, 0xE2, 0xAF, 0x6C, 0x67, 0x95, 0x6C, 0x47, 0x8C, 0xEF, 0x49, 0x1F, 0x59, 0xE0, 0x19, 0x1B, 0x3B, 0xBE, 0x92, 0x9B, 0x94, 0xB6, 0x66, 0xC1, 0x76, 0x13, 0x8B, 0x00, 0xF4, 0x97, 0x24, 0x34, 0x1E, 0xE2, 0xE1, 0x64, 0xB9, 0x4C, 0x05, 0x3C, 0x18, 0x5A, 0x51, 0xF9, 0x3E, 0x00, 0xF3, 0x68, 0x61, 0x61, 0x3A, 0x7F, 0xD7, 0x2F, 0xEB, 0xD2, 0x3A, 0x8B, 0x96, 0xA2, 0x60, 0x23, 0x42, 0x39, 0xC9, 0x62, 0x8F, 0x99, 0x5D, 0xC1, 0x38, 0x07, 0xB4, 0x3A, 0x69, 0x46, 0x81, 0x67, 0xCB, 0x1A, 0x8F, 0x9D, 0xD0, 0x7E, 0xE3, 0xB3, 0x32, 0x38, 0xF6, 0x30, 0x96, 0xEB, 0xC4, 0x9D, 0x50, 0x51, 0xC4, 0xB6, 0x59, 0x63, 0xD7, 0x4A, 0x47, 0x66, 0xC2, 0x26, 0xF0, 0xB9, 0x4F, 0x18, 0x62, 0xC2, 0x12, 0x4C, 0x8C, 0x74, 0x97, 0x48, 0xC0, 0xBC, 0x4D, 0xC1, 0x4C, 0xB3, 0x49, 0x06, 0xB8, 0x1C, 0x55, 0x24, 0xFB, 0x81, 0x00, 0x79, 0x85, 0x42, 0xDC, 0x6C, 0xC2, 0xAA, 0x0A, 0x70, 0x85, 0x75, 0xEA, 0xBC, 0xC1, 0x1F, 0x96, 0xA9, 0xE6, 0x1C, 0x01, 0x7A, 0x96, 0xA7, 0xCE, 0x93, 0xC4, 0x20, 0x91, 0x73, 0x71, 0x13, 0xAE, 0x78, 0x3C, 0x0A, 0xE8, 0x75, 0x5E, 0x59, 0x41, 0x11, 0xED, 0xFA, 0xBF, 0xD8, 0x6C, 0x32, 0x12, 0xC6, 0x12, 0xA7, 0xB6, 0x2A, 0xFD, 0x3C, 0x7A, 0x5C, 0x78, 0xB2, 0xF0, 0x73, 0x44, 0xB7, 0x89, 0xC2, 0xB2, 0xDB, 0xB5, 0xF4, 0x44, 0x8B, 0xE9, 0x7B, 0xBA, 0x42, 0x33, 0xC0, 0x03, 0x9C, 0x0F, 0xE8, 0x43, 0x00, 0xF9, 0xB0, 0x3A, 0xC9, 0x94, 0x97, 0xE6, 0xD4, 0x6B, 0x6E, 0x95, 0x30, 0x8F, 0xF8, 0x47, 0x90, 0xF6, 0x12, 0xCF, 0x18, 0x6E, 0xC1, 0x68, 0x11, 0xE8, 0x0C, 0x17, 0x93, 0x16, 0xA6, 0x3B, 0x25, 0x70, 0x3F, 0x60, 0xB8, 0x42, 0xB6, 0x19, 0x07, 0xE6, 0x28, 0x94, 0xE7, 0x36, 0x64, 0x7B, 0x3C, 0x09, 0xDA, 0x6F, 0xEC, 0x59, 0x32, 0x78, 0x2B, 0x36, 0xE0, 0x63, 0x50, 0x85, 0xA3, 0x94, 0x9E, 0x69, 0x4D, 0x7E, 0x17, 0xCB, 0xA3, 0xD9, 0x06, 0x43, 0x30, 0x43, 0x8C, 0x07, 0x1B, 0x58, 0x36, 0xA7, 0x70, 0xC5, 0x5F, 0x62, 0x13, 0xCC, 0x14, 0x25, 0x84, 0x5D, 0xE5, 0xA3, 0x34, 0xD7, 0x5D, 0x3E, 0x50, 0x58, 0xC7, 0x80, 0x9F, 0xDA, 0x4B, 0xCD, 0x78, 0x19, 0x1D, 0xA9, 0x79, 0x73, 0x25, 0xE6, 0x23, 0x6C, 0x26, 0x50, 0xFC, 0x60, 0x4E, 0xE4, 0x3A, 0x83, 0xCE, 0xB3, 0x49, 0x80, 0x08, 0x44, 0x03, 0xA3, 0x32, 0x59, 0x85, 0x79, 0x07, 0x79, 0x9A, 0x9D, 0x2A, 0x71, 0x3A, 0x63, 0x3B, 0x5C, 0x90, 0x47, 0x27, 0xF6, 0x1E, 0x42, 0x52, 0x09, 0x91, 0xD6, 0x55, 0x70, 0x5C, 0xB6, 0xBC, 0x1B, 0x74, 0xAF, 0x60, 0x71, 0x3E, 0xF8, 0x71, 0x2F, 0x14, 0x08, 0x68, 0x69, 0xBE, 0x8E, 0xB2, 0x97, 0xD2, 0x28, 0xB3, 0x25, 0xA0, 0x60, 0x9F, 0xD6, 0x15, 0xEA, 0xB7, 0x08, 0x15, 0x40, 0xA6, 0x1A, 0x82, 0xAB, 0xF4, 0x3B, 0x7D, 0xF9, 0x8A, 0x59, 0x5B, 0xE1, 0x1F, 0x41, 0x6B, 0x41, 0xE1, 0xEB, 0x75, 0xBB, 0x57, 0x97, 0x7C, 0x25, 0xC6, 0x4E, 0x97, 0x43, 0x7D, 0x88, 0xCA, 0x5F, 0xDA, 0x61, 0x59, 0xD6, 0x68, 0xF6, 0xBA, 0xB8, 0x15, 0x75, 0x55, 0xB5, 0xD5, 0x4C, 0x0F, 0x47, 0xCB, 0xCD, 0x16, 0x84, 0x3B, 0x1A, 0x0A, 0x0F, 0x02, 0x10, 0xEE, 0x31, 0x03, 0x13, 0x96, 0x7F, 0x3D, 0x51, 0x64, 0x99, 0x01, 0x8F, 0xDF, 0x31, 0x14, 0x77, 0x24, 0x70, 0xA1, 0x88, 0x9C, 0xC0, 0x6C, 0xB6, 0xB6, 0x69, 0x0A, 0xC3, 0x1A, 0xBC, 0xFA, 0xF4, 0xBC, 0x70, 0x76, 0x84, 0x54, 0x5B, 0x00, 0x0B, 0x58, 0x0C, 0xCB, 0xFC, 0xBC, 0xE9, 0xFA, 0x70, 0xAA, 0xEA, 0x0B, 0xBD, 0x91, 0x10, 0x99, 0x2A, 0x7C, 0x6C, 0x06, 0xCB, 0x36, 0x85, 0x27, 0xFD, 0x22, 0x90, 0x90, 0x75, 0x7E, 0x6F, 0xE7, 0x57, 0x05, 0xFA, 0x59, 0x2A, 0x76, 0x08, 0xF0, 0x50, 0xC6, 0xF8, 0x87, 0x03, 0xCC, 0x28, 0xCB, 0x00, 0x0C, 0x1D, 0x7E, 0x77, 0xB8, 0x97, 0xB7, 0x2C, 0x62, 0xBC, 0xC7, 0xAE, 0xA2, 0x1A, 0x57, 0x72, 0x94, 0x83, 0xD2, 0x21, 0x18, 0x32, 0xBE, 0xD6, 0x12, 0x43, 0x0C, 0x98, 0x31, 0x03, 0xC6, 0x9E, 0x8C, 0x07, 0x2C, 0x0E, 0xA7, 0x89, 0x8F, 0x22, 0x83, 0xBE, 0xC4, 0x8C, 0x5A, 0xC8, 0x19, 0x84, 0xD4, 0xA5, 0xA8, 0x36, 0x19, 0x73, 0x5A, 0x84, 0x2B, 0xD1, 0x72, 0xC0, 0xD1, 0xB3, 0x9F, 0x43, 0x58, 0x8A, 0xF1, 0x70, 0x45, 0x8B, 0xA9, 0xEE, 0x74, 0x92, 0xEA, 0xAA, 0x94, 0xEA, 0x53, 0xA4, 0xD3, 0x84, 0x98, 0xEC, 0xBB, 0x98, 0xA5, 0xF4, 0x07, 0xE7, 0xC9, 0x7B, 0x4E, 0x16, 0x6E, 0x39, 0x71, 0x92, 0xC2, 0x16, 0x03, 0x30, 0x14, 0xB8, 0x78, 0xE9, 0x38, 0x07, 0x5C, 0x6C, 0x1F, 0x10, 0xA0, 0x06, 0x5A, 0xBC, 0x31, 0x63, 0x72, 0x2F, 0x1A, 0x2E, 0xFF, 0xEC, 0x8D, 0x6E, 0x3A, 0x0C, 0x4F, 0x71, 0x74, 0xFC, 0x16, 0xB7, 0x9F, 0xB5, 0x18, 0x6A, 0x75, 0x16, 0x8F, 0x81, 0xA5, 0x6A, 0xA4, 0x8A, 0x20, 0xA0, 0x4B, 0xDD, 0xF1, 0x82, 0xC6, 0xE1, 0x79, 0xC3, 0xF6, 0x90, 0x61, 0x55, 0x5E, 0xF7, 0x39, 0x6D, 0xD0, 0xB7, 0x49, 0x96, 0x01, 0xA6, 0xEB, 0x3A, 0x96, 0xA9, 0xA2, 0x2D, 0x04, 0xF1, 0x16, 0x8D, 0xB5, 0x63, 0x55, 0xB0, 0x76, 0x00, 0xA2, 0x03, 0x70, 0x63, 0x7B, 0x64, 0x59, 0x76, 0xBB, 0xD9, 0x7B, 0x6D, 0x62, 0x88, 0xA0, 0xD3, 0x03, 0x63, 0x60, 0x47, 0x2E, 0x3A, 0xC7, 0x1D, 0x56, 0x6D, 0xB8, 0xFB, 0xB1, 0xB1, 0xD7, 0x6C, 0xB7, 0x55, 0xCD, 0x0D, 0x68, 0xBD, 0xBF, 0xC0, 0x48, 0xEB, 0xA2, 0x52, 0x5E, 0xEA, 0x9D, 0xD5, 0xB1, 0x44, 0xFB, 0x3B, 0x60, 0xFB, 0xC3, 0x42, 0x39, 0x32, 0x0C, 0xBC, 0x06, 0x9B, 0x35, 0xAB, 0x16, 0xB8, 0x75, 0x65, 0x36, 0xFB, 0x33, 0xE8, 0xA6, 0xAF, 0x1D, 0xD4, 0x2C, 0x79, 0xF4, 0x8A, 0xD1, 0x20, 0xAE, 0x4B, 0x15, 0x9D, 0x3D, 0x8C, 0x31, 0x90, 0x60, 0xCC, 0xE5, 0x69, 0xC3, 0xF6, 0x03, 0x53, 0x65, 0x58, 0x5D, 0x34, 0x41, 0x37, 0x95, 0xA6, 0xA1, 0x8E, 0xC5, 0x13, 0x6A, 0xB1, 0x3C, 0x90, 0xE3, 0xAF, 0x14, 0xC0, 0xB8, 0xA4, 0x64, 0xC8, 0x6B, 0x90, 0x73, 0x22, 0x2B, 0x56, 0xB3, 0xF7, 0x32, 0x8A, 0xEA, 0x79, 0x81, 0x55, 0x32, 0x59, 0x11, 0x25, 0x0E, 0xF0, 0x16, 0xD7, 0x28, 0x02, 0xE3, 0x87, 0x8A, 0xA5, 0x05, 0x40, 0xCC, 0x98, 0x39, 0x56, 0x97, 0x1D, 0x6E, 0xFA, 0x35, 0x2C, 0x02, 0x55, 0x4D, 0xC7, 0x60, 0xA5, 0xA9, 0x13, 0x58, 0xEA, 0x56, 0x37, 0x08, 0x84, 0xFD, 0x5B, 0x3F, 0x85, 0xB7, 0x0E, 0x83, 0xE4, 0x69, 0x7D, 0xEB, 0x17, 0x05, 0x16, 0x9E, 0x9C, 0x60, 0xA7, 0x45, 0x28, 0xCF, 0x15, 0x28, 0x1C, 0xB1, 0xB1, 0xC4, 0x57, 0xD4, 0x67, 0xB5, 0xF9, 0x3A, 0x60, 0x37, 0x3D, 0x10, 0xE0, 0xCF, 0x6A, 0x83, 0x7A, 0xA3, 0xC9, 0x59, 0x6A, 0x72, 0xBE, 0xC2, 0x9B, 0x2D, 0x7E, 0x58, 0x65, 0x3D, 0x53, 0x30, 0x61, 0xD3, 0x81, 0xD5, 0x17, 0x59, 0x75, 0x22, 0x17, 0xEB, 0x46, 0xCA, 0xC7, 0x80, 0x7C, 0x4A, 0xD3, 0x8B, 0x61, 0x16, 0x44, 0xAC, 0xF0, 0xA3, 0xF2, 0x6B, 0x6B, 0x08, 0x4A, 0xB4, 0x7A, 0x83, 0xBF, 0x0D, 0x69, 0x6F, 0x8A, 0x47, 0x68, 0xFC, 0x35, 0xBC, 0xA6, 0xBC, 0x79, 0x03, 0xB2, 0xA2, 0x37, 0xC2, 0x77, 0x49, 0xF5, 0x51, 0x0C, 0x86, 0x38, 0x69, 0xE6, 0xAE, 0x56, 0xBB, 0x2A, 0xFE, 0x47, 0x71, 0xC9, 0x22, 0x18, 0x74, 0xF5, 0x0F, 0x5B, 0x14, 0xBA, 0xAD, 0x59, 0x93, 0xB4, 0x92, 0x38, 0xFD, 0x0A, 0x0C, 0x9F, 0x79, 0xB7, 0xB4, 0x58, 0x4E, 0x41, 0x30, 0x1F, 0x7A, 0x88, 0x5C, 0x9F, 0x91, 0x81, 0x9B, 0xEA, 0x00, 0xD5, 0x12, 0x58, 0x17, 0x30, 0x53, 0x9F, 0xB3, 0x7E, 0x59, 0xE8, 0x6A, 0x6D, 0x19, 0xCA, 0x25, 0xF0, 0xA8, 0x11, 0xC9, 0xB4, 0x28, 0xBA, 0x86, 0x14, 0xAA, 0x4F, 0x94, 0x80, 0x7B, 0xC0, 0x31, 0xCB, 0xCC, 0x18, 0x3F, 0x3B, 0xF0, 0x7F, 0xE2, 0xC1, 0xA6, 0xEB, 0xA8, 0x0D, 0x5A, 0x70, 0x6E, 0xE0, 0xDA, 0xB2, 0x7E, 0x23, 0x14, 0x58, 0x02, 0x5D, 0x84, 0xA7, 0xA9, 0xB0, 0x23, 0x05, 0x01, 0x11, 0x6C, 0x29, 0x0A, 0x6B, 0xB5, 0x06, 0x26, 0xD9, 0x7B, 0x93, 0x98, 0x50, 0x94, 0x28, 0x28, 0x39, 0x0B, 0x0A, 0x20, 0x01, 0xB7, 0x85, 0x3A, 0xD1, 0xAE, 0x9B, 0x01, 0x1B, 0x2D, 0xB3, 0x6C, 0xAE, 0xEA, 0x73, 0xA2, 0x32, 0x8E, 0x3C, 0x56, 0x48, 0x5B, 0x49, 0x1C, 0x29, 0x91, 0x15, 0xA0, 0x17, 0xC9, 0x07, 0xAB, 0x54, 0x31, 0x72, 0x60, 0xA5, 0x93, 0xA0, 0xD7, 0xBA, 0x6D, 0x06, 0x61, 0x5D, 0x6E, 0x2C, 0xA8, 0x4B, 0x86, 0x0E, 0xFF, 0x3C, 0xCB, 0x59, 0x72, 0x11, 0xBF, 0xE3, 0x6B, 0xDE, 0xF8, 0x06, 0x9A, 0xFA, 0x36, 0xC5, 0xA7, 0x33, 0x92, 0x72, 0x26, 0x50, 0xE4, 0x95, 0x7D, 0xCA, 0x59, 0x7A, 0xCB, 0xA5, 0x60, 0x5B, 0x63, 0xC1, 0x63, 0xCF, 0xA9, 0x4B, 0x64, 0xDD, 0xD6, 0x23, 0x01, 0xA4, 0x33, 0x20, 0x83, 0x36, 0x19, 0x72, 0x58, 0x9D, 0xB0, 0x59, 0x9A, 0x69, 0x4D, 0xD4, 0x54, 0x7A, 0x5E, 0xE9, 0x19, 0x65, 0x77, 0xC2, 0x2E, 0xD4, 0x27, 0xAC, 0x89, 0xBB, 0x8B, 0xA3, 0x75, 0x3E, 0xB7, 0x6C, 0x41, 0xF2, 0xC1, 0x12, 0x9C, 0x8A, 0x77, 0xD6, 0x80, 0x5F, 0xA7, 0x19, 0xB1, 0xB6, 0xCA, 0x11, 0xB7, 0x40, 0xA7, 0x8A, 0x3D, 0x41, 0xB5, 0x33, 0x05, 0x26, 0xAB, 0x87, 0xD5, 0x8D, 0x59, 0x25, 0x31, 0x5A, 0x14, 0x85, 0xED, 0xC6, 0x47, 0xC1, 0x60, 0x4E, 0xB3, 0x81, 0x38, 0xDE, 0x63, 0x7A, 0xD2, 0xC6, 0xCA, 0x5B, 0xE4, 0x4E, 0x10, 0x08, 0xB2, 0xC0, 0x86, 0x7B, 0x22, 0x9C, 0xCC, 0x36, 0x61, 0x9E, 0x27, 0x58, 0xC4, 0xC2, 0x02, 0x9E, 0xAE, 0xB2, 0x6E, 0x7A, 0x80, 0x3F, 0xCA, 0x30, 0x5A, 0x59, 0xCD, 0x58, 0x5E, 0x11, 0x7D, 0x69, 0x8E, 0xCE, 0x01, 0x1C, 0xC3, 0xFC, 0xE5, 0x4D, 0x2E, 0x11, 0x45, 0x45, 0xA2, 0x1A, 0xC5, 0xBE, 0x67, 0x71, 0xAB, 0x8F, 0x13, 0x12, 0x2F, 0xAD, 0x29, 0x5E, 0x74, 0x5A, 0x50, 0x3B, 0x14, 0x2F, 0x91, 0xAE, 0xF7, 0xBD, 0xE9, 0x99, 0x98, 0x84, 0x5F, 0xDA, 0x04, 0x35, 0x55, 0xC9, 0xC1, 0xEE, 0x53, 0x5B, 0xE1, 0x25, 0xE5, 0xDC, 0xE5, 0xD2, 0x66, 0x66, 0x7E, 0x72, 0x3E, 0x67, 0xB6, 0xBA, 0x89, 0x1C, 0x16, 0xCB, 0xA1, 0x74, 0x09, 0x8A, 0x3F, 0x35, 0x17, 0x78, 0xB0, 0x88, 0x8C, 0x95, 0x90, 0xA9, 0x09, 0x0C, 0xD4, 0x04};
std::vector<uint8_t> ct_MLKEM512 = {0x16, 0x1C, 0xD2, 0x59, 0xFE, 0xAA, 0x7E, 0xC6, 0xB2, 0x86, 0x49, 0x8A, 0x9A, 0x6F, 0x69, 0xF8, 0xB2, 0x62, 0xA2, 0xE2, 0x09, 0x3D, 0x0F, 0xBD, 0x76, 0xD5, 0xDC, 0x1C, 0x9F, 0xDE, 0x0D, 0xED, 0xB3, 0x65, 0x81, 0x00, 0x4C, 0xB4, 0x81, 0x12, 0xF8, 0x52, 0xE7, 0xF8, 0x7F, 0x64, 0x9E, 0x8A, 0x42, 0xCD, 0x9E, 0x03, 0x49, 0xE7, 0xDA, 0xBD, 0xF0, 0xA9, 0xAC, 0x1B, 0x52, 0x1C, 0x37, 0xEA, 0x52, 0x41, 0x37, 0x0A, 0x8A, 0xB2, 0x91, 0x1C, 0xC7, 0x99, 0x02, 0xC9, 0x5D, 0x28, 0x22, 0x4F, 0xA8, 0x89, 0x6A, 0xD7, 0x15, 0x20, 0x9E, 0xCD, 0xD5, 0xD7, 0x84, 0xE9, 0x1D, 0xD9, 0xD0, 0xBE, 0x91, 0x6B, 0x45, 0x65, 0xF4, 0xD5, 0x66, 0x9A, 0xEE, 0x0D, 0xEF, 0x93, 0x1E, 0x97, 0x68, 0x29, 0x4E, 0xEC, 0x52, 0x58, 0xDE, 0x83, 0x91, 0xEC, 0xE2, 0x71, 0xE7, 0xE4, 0xCF, 0xD9, 0xD2, 0x3A, 0x79, 0xFA, 0xC3, 0xA8, 0xE0, 0xDB, 0x5D, 0xDD, 0x6E, 0x01, 0x07, 0x23, 0x56, 0x88, 0xBB, 0xDF, 0x7B, 0xC5, 0xD5, 0x63, 0x2F, 0x20, 0x6C, 0x63, 0xA0, 0xC9, 0x56, 0x4F, 0x30, 0x96, 0x5C, 0xA5, 0x8C, 0x69, 0xFF, 0x92, 0xD2, 0x5A, 0x4F, 0x93, 0xA0, 0x9E, 0xAB, 0x9B, 0x90, 0x85, 0x94, 0x7E, 0x07, 0x8A, 0x23, 0xE4, 0xD9, 0xC1, 0x3B, 0x8A, 0x56, 0xE7, 0x3E, 0x18, 0xDF, 0x42, 0xD6, 0x94, 0x9F, 0xAF, 0x59, 0x21, 0xF2, 0xE3, 0x73, 0xD4, 0x50, 0xC8, 0xC0, 0x9D, 0x07, 0xB1, 0x52, 0xA9, 0x7C, 0x24, 0x54, 0x47, 0x42, 0x94, 0x81, 0xD4, 0x98, 0xBE, 0xB7, 0x25, 0x6B, 0xC4, 0x7F, 0x68, 0xF9, 0x92, 0x2B, 0x0B, 0x1C, 0x62, 0xD9, 0xC2, 0x3F, 0x9F, 0x73, 0x3D, 0xD7, 0x37, 0x92, 0xCF, 0xC7, 0xB4, 0x3C, 0xBC, 0xEA, 0x27, 0x7D, 0x51, 0xB2, 0xB8, 0xAD, 0x4A, 0x4F, 0x52, 0x2F, 0x64, 0x2C, 0xAD, 0x5C, 0x5D, 0xEB, 0x21, 0xF3, 0x62, 0x7F, 0x8A, 0xF4, 0xD3, 0xE5, 0xBC, 0x9E, 0x91, 0xD4, 0xCB, 0x2F, 0x12, 0x4B, 0x5B, 0xD7, 0xC2, 0xF4, 0xA0, 0x50, 0xCA, 0x75, 0x5B, 0xDB, 0x80, 0x56, 0x60, 0x96, 0x63, 0xFB, 0x95, 0x11, 0xC9, 0xAD, 0x83, 0xB5, 0x03, 0x90, 0x88, 0xCC, 0x01, 0xF0, 0xDD, 0x54, 0x35, 0x3B, 0x0D, 0xD7, 0x43, 0x3F, 0x0C, 0x6C, 0xEE, 0x0D, 0x07, 0x59, 0x59, 0x81, 0x0D, 0xEC, 0x54, 0x16, 0x52, 0x2B, 0xB1, 0xF1, 0xF6, 0x55, 0x47, 0xA0, 0xC2, 0xE9, 0xCC, 0x9B, 0xC1, 0x7F, 0x8D, 0x39, 0xD2, 0x93, 0x09, 0xEB, 0xE7, 0x9F, 0x21, 0x33, 0x1B, 0x75, 0xE1, 0x2A, 0xF2, 0xE9, 0x3F, 0x03, 0xF7, 0x4F, 0x7F, 0x87, 0xD3, 0x60, 0xF1, 0xDA, 0xF8, 0x6C, 0xED, 0x73, 0x60, 0x92, 0xA2, 0x11, 0xA8, 0x15, 0x88, 0x59, 0xC4, 0x2E, 0x22, 0x3C, 0xFE, 0x2E, 0x6E, 0x55, 0x34, 0x37, 0xD8, 0x05, 0x76, 0xCF, 0xD1, 0x94, 0x4E, 0x97, 0xEE, 0xFF, 0x9B, 0x49, 0xE5, 0xEC, 0xCF, 0xC6, 0x78, 0xEE, 0x16, 0x52, 0x68, 0xDF, 0xE3, 0xD3, 0x59, 0x6B, 0x4B, 0x86, 0x20, 0x4A, 0x81, 0xC6, 0x06, 0x3B, 0x0C, 0xDC, 0xE6, 0x19, 0xFD, 0xBB, 0x96, 0xDF, 0x7D, 0xE6, 0xE0, 0xBD, 0x52, 0x70, 0xB4, 0xD5, 0x9C, 0x4D, 0xC5, 0x08, 0x47, 0x6E, 0x7F, 0x07, 0x08, 0xF9, 0x8C, 0x7A, 0x4F, 0x66, 0x45, 0xC4, 0x9D, 0x06, 0x10, 0x0C, 0x76, 0x0C, 0x59, 0x95, 0x28, 0xD1, 0xB8, 0xBB, 0xFE, 0x62, 0x81, 0x91, 0xCC, 0x08, 0x3C, 0x8D, 0x22, 0x5A, 0x09, 0x3F, 0x9F, 0x17, 0xE3, 0x55, 0x74, 0x98, 0x6F, 0x86, 0xBA, 0xA4, 0x68, 0x98, 0xB5, 0x89, 0xF3, 0xCB, 0x7D, 0xB4, 0x6A, 0x45, 0xF3, 0xED, 0xD4, 0xFA, 0xC2, 0x08, 0x08, 0xF4, 0xCD, 0x02, 0x49, 0xDA, 0x69, 0x3F, 0x8F, 0xAB, 0xFB, 0xD4, 0xE1, 0x0C, 0x02, 0xC6, 0x5B, 0xA8, 0xC8, 0x61, 0x0F, 0xA8, 0xC6, 0xDF, 0x3D, 0xBA, 0xEB, 0x67, 0x63, 0xDD, 0x48, 0x2A, 0xF4, 0x15, 0x58, 0xB1, 0xE1, 0x5C, 0xC9, 0xC7, 0xA7, 0x2E, 0x07, 0x16, 0x85, 0xAC, 0x19, 0xA0, 0x51, 0xF1, 0x92, 0x45, 0xB9, 0xF7, 0x7C, 0x30, 0x38, 0xA5, 0x4E, 0x29, 0x58, 0x62, 0x3E, 0xB8, 0x10, 0x59, 0x55, 0x60, 0x9E, 0x27, 0xD6, 0x7C, 0xF7, 0x2E, 0xC5, 0xC4, 0xA8, 0xE9, 0xB9, 0xC2, 0x92, 0x4A, 0x9E, 0x22, 0x98, 0x50, 0x8B, 0xAB, 0xA1, 0x3C, 0xF1, 0x11, 0xFD, 0xFB, 0x06, 0x2C, 0x96, 0x07, 0xAC, 0x1A, 0xAA, 0x6C, 0x63, 0x73, 0x10, 0xA8, 0x89, 0x4B, 0xF0, 0xB9, 0x6F, 0x0C, 0x19, 0x13, 0x61, 0x86, 0xB6, 0x18, 0xDF, 0xFB, 0x27, 0x55, 0x28, 0xBE, 0xD1, 0xCC, 0x27, 0x15, 0xDE, 0xF4, 0x12, 0xF7, 0x7A, 0x3C, 0xF9, 0x66, 0x45, 0x73, 0x3B, 0x04, 0x8A, 0x78, 0x47, 0x43, 0x20, 0xD1, 0xA3, 0x80, 0xF5, 0xEE, 0xDB, 0xDA, 0x21, 0xFA, 0x01, 0x25, 0xC9, 0x1D, 0x3C, 0x37, 0xC5, 0x4B, 0xF3, 0x75, 0x2A, 0x1F, 0x84, 0x71, 0xC8, 0x1F, 0xCA, 0xE2, 0xD3, 0xED, 0xA9, 0x66, 0xE1, 0x4E, 0x66, 0xF2, 0x23, 0xB0, 0x54, 0xD7, 0x98, 0x48, 0xFF, 0x94, 0x11, 0xD6, 0x34, 0x02, 0x4A, 0x09, 0x89, 0x70, 0xAD, 0xE6, 0xA8, 0x8B, 0x5F, 0x90, 0x69, 0xF7, 0x60, 0x58, 0x4D, 0xC4, 0xCF, 0xFF, 0xCE, 0xA8, 0xEC, 0xE1, 0x1B, 0xB5, 0x56, 0x6B, 0xD2, 0x36, 0x0A, 0xB7, 0x07, 0xDF, 0x2D, 0x21, 0xB6, 0x74, 0x88, 0xD9, 0x31, 0xF0, 0x20, 0x06, 0x91, 0x76, 0x42, 0x3E, 0x69, 0x44, 0x49, 0x0C, 0xB3, 0x85, 0xE7, 0x0B, 0x35, 0x8A, 0x25, 0x34, 0x6B, 0xAF, 0xCD, 0xD0, 0x6D, 0x40, 0x2F, 0xF2, 0x4D, 0x6C, 0x1E, 0x5F, 0x61, 0xA8, 0x5D}; 
std::vector<uint8_t> ss_MLKEM512 = {0xDF, 0x46, 0x2A, 0xD6, 0x8F, 0x1E, 0xC8, 0x97, 0x2E, 0xD9, 0xB0, 0x2D, 0x6D, 0xE0, 0x60, 0x4B, 0xDE, 0xC7, 0x57, 0x20, 0xE0, 0x50, 0x49, 0x73, 0x51, 0xE6, 0xEC, 0x93, 0x3E, 0x71, 0xF8, 0x82}; 

std::vector<uint8_t> sk_MLKEM1024 = {0x84, 0x45, 0xC3, 0x36, 0xF3, 0x51, 0x8B, 0x29, 0x81, 0x63, 0xDC, 0xBB, 0x63, 0x57, 0x59, 0x79, 0x83, 0xCA, 0x2E, 0x87, 0x3D, 0xCB, 0x49, 0x61, 0x0C, 0xF5, 0x2F, 0x14, 0xDB, 0xCB, 0x94, 0x7C, 0x1F, 0x3E, 0xE9, 0x26, 0x69, 0x67, 0x27, 0x6B, 0x0C, 0x57, 0x6C, 0xF7, 0xC3, 0x0E, 0xE6, 0xB9, 0x3D, 0xEA, 0x51, 0x18, 0x67, 0x6C, 0xBE, 0xE1, 0xB1, 0xD4, 0x79, 0x42, 0x06, 0xFB, 0x36, 0x9A, 0xBA, 0x41, 0x16, 0x7B, 0x43, 0x93, 0x85, 0x5C, 0x84, 0xEB, 0xA8, 0xF3, 0x23, 0x73, 0xC0, 0x5B, 0xAE, 0x76, 0x31, 0xC8, 0x02, 0x74, 0x4A, 0xAD, 0xB6, 0xC2, 0xDE, 0x41, 0x25, 0x0C, 0x49, 0x43, 0x15, 0x23, 0x0B, 0x52, 0x82, 0x6C, 0x34, 0x58, 0x7C, 0xB2, 0x1B, 0x18, 0x3B, 0x49, 0xB2, 0xA5, 0xAC, 0x04, 0x92, 0x1A, 0xC6, 0xBF, 0xAC, 0x1B, 0x24, 0xA4, 0xB3, 0x7A, 0x93, 0xA4, 0xB1, 0x68, 0xCC, 0xE7, 0x59, 0x1B, 0xE6, 0x11, 0x1F, 0x47, 0x62, 0x60, 0xF2, 0x76, 0x29, 0x59, 0xF5, 0xC1, 0x64, 0x01, 0x18, 0xC2, 0x42, 0x37, 0x72, 0xE2, 0xAD, 0x03, 0xDC, 0x71, 0x68, 0xA3, 0x8C, 0x6D, 0xD3, 0x9F, 0x5F, 0x72, 0x54, 0x26, 0x42, 0x80, 0xC8, 0xBC, 0x10, 0xB9, 0x14, 0x16, 0x80, 0x70, 0x47, 0x2F, 0xA8, 0x80, 0xAC, 0xB8, 0x60, 0x1A, 0x8A, 0x08, 0x37, 0xF2, 0x5F, 0xE1, 0x94, 0x68, 0x7C, 0xD6, 0x8B, 0x7D, 0xE2, 0x34, 0x0F, 0x03, 0x6D, 0xAD, 0x89, 0x1D, 0x38, 0xD1, 0xB0, 0xCE, 0x9C, 0x26, 0x33, 0x35, 0x5C, 0xF5, 0x7B, 0x50, 0xB8, 0x96, 0x03, 0x6F, 0xCA, 0x26, 0x0D, 0x26, 0x69, 0xF8, 0x5B, 0xAC, 0x79, 0x71, 0x4F, 0xDA, 0xFB, 0x41, 0xEF, 0x80, 0xB8, 0xC3, 0x02, 0x64, 0xC3, 0x13, 0x86, 0xAE, 0x60, 0xB0, 0x5F, 0xAA, 0x54, 0x2A, 0x26, 0xB4, 0x1E, 0xB8, 0x5F, 0x67, 0x06, 0x8F, 0x08, 0x80, 0x34, 0xFF, 0x67, 0xAA, 0x2E, 0x81, 0x5A, 0xAB, 0x8B, 0xCA, 0x6B, 0xF7, 0x1F, 0x70, 0xEC, 0xC3, 0xCB, 0xCB, 0xC4, 0x5E, 0xF7, 0x01, 0xFC, 0xD5, 0x42, 0xBD, 0x21, 0xC7, 0xB0, 0x95, 0x68, 0xF3, 0x69, 0xC6, 0x69, 0xF3, 0x96, 0x47, 0x38, 0x44, 0xFB, 0xA1, 0x49, 0x57, 0xF5, 0x19, 0x74, 0xD8, 0x52, 0xB9, 0x78, 0x01, 0x46, 0x03, 0xA2, 0x10, 0xC0, 0x19, 0x03, 0x62, 0x87, 0x00, 0x89, 0x94, 0xF2, 0x12, 0x55, 0xB2, 0x50, 0x99, 0xAD, 0x82, 0xAA, 0x13, 0x24, 0x38, 0x96, 0x3B, 0x2C, 0x0A, 0x47, 0xCD, 0xF5, 0xF3, 0x2B, 0xA4, 0x6B, 0x76, 0xC7, 0xA6, 0x55, 0x9F, 0x18, 0xBF, 0xD5, 0x55, 0xB7, 0x62, 0xE4, 0x87, 0xB6, 0xAC, 0x99, 0x2F, 0xE2, 0x0E, 0x28, 0x3C, 0xA0, 0xB3, 0xF6, 0x16, 0x44, 0x96, 0x95, 0x59, 0x95, 0xC3, 0xB2, 0x8A, 0x57, 0xBB, 0xC2, 0x98, 0x26, 0xF0, 0x6F, 0xB3, 0x8B, 0x25, 0x34, 0x70, 0xAF, 0x63, 0x1B, 0xC4, 0x6C, 0x3A, 0x8F, 0x9C, 0xE8, 0x24, 0x32, 0x19, 0x85, 0xDD, 0x01, 0xC0, 0x5F, 0x69, 0xB8, 0x24, 0xF9, 0x16, 0x63, 0x3B, 0x40, 0x65, 0x4C, 0x75, 0xAA, 0xEB, 0x93, 0x85, 0x57, 0x6F, 0xFD, 0xE2, 0x99, 0x0A, 0x6B, 0x0A, 0x3B, 0xE8, 0x29, 0xD6, 0xD8, 0x4E, 0x34, 0xF1, 0x78, 0x05, 0x89, 0xC7, 0x92, 0x04, 0xC6, 0x3C, 0x79, 0x8F, 0x55, 0xD2, 0x31, 0x87, 0xE4, 0x61, 0xD4, 0x8C, 0x21, 0xE5, 0xC0, 0x47, 0xE5, 0x35, 0xB1, 0x9F, 0x45, 0x8B, 0xBA, 0x13, 0x45, 0xB9, 0xE4, 0x1E, 0x0C, 0xB4, 0xA9, 0xC2, 0xD8, 0xC4, 0x0B, 0x49, 0x0A, 0x3B, 0xAB, 0xC5, 0x53, 0xB3, 0x02, 0x6B, 0x16, 0x72, 0xD2, 0x8C, 0xBC, 0x8B, 0x49, 0x8A, 0x3A, 0x99, 0x57, 0x9A, 0x83, 0x2F, 0xEA, 0xE7, 0x46, 0x10, 0xF0, 0xB6, 0x25, 0x0C, 0xC3, 0x33, 0xE9, 0x49, 0x3E, 0xB1, 0x62, 0x1E, 0xD3, 0x4A, 0xA4, 0xAB, 0x17, 0x5F, 0x2C, 0xA2, 0x31, 0x15, 0x25, 0x09, 0xAC, 0xB6, 0xAC, 0x86, 0xB2, 0x0F, 0x6B, 0x39, 0x10, 0x84, 0x39, 0xE5, 0xEC, 0x12, 0xD4, 0x65, 0xA0, 0xFE, 0xF3, 0x50, 0x03, 0xE1, 0x42, 0x77, 0xA2, 0x18, 0x12, 0x14, 0x6B, 0x25, 0x44, 0x71, 0x6D, 0x6A, 0xB8, 0x2D, 0x1B, 0x07, 0x26, 0xC2, 0x7A, 0x98, 0xD5, 0x89, 0xEB, 0xDA, 0xCC, 0x4C, 0x54, 0xBA, 0x77, 0xB2, 0x49, 0x8F, 0x21, 0x7E, 0x14, 0xE3, 0x4E, 0x66, 0x02, 0x5A, 0x2A, 0x14, 0x3A, 0x99, 0x25, 0x20, 0xA6, 0x1C, 0x06, 0x72, 0xCC, 0x9C, 0xCE, 0xD7, 0xC9, 0x45, 0x0C, 0x68, 0x3E, 0x90, 0xA3, 0xE4, 0x65, 0x1D, 0xB6, 0x23, 0xA6, 0xDB, 0x39, 0xAC, 0x26, 0x12, 0x5B, 0x7F, 0xC1, 0x98, 0x6D, 0x7B, 0x04, 0x93, 0xB8, 0xB7, 0x2D, 0xE7, 0x70, 0x7D, 0xC2, 0x0B, 0xBD, 0xD4, 0x37, 0x13, 0x15, 0x6A, 0xF7, 0xD9, 0x43, 0x0E, 0xF4, 0x53, 0x99, 0x66, 0x3C, 0x22, 0x02, 0x73, 0x91, 0x68, 0x69, 0x2D, 0xD6, 0x57, 0x54, 0x5B, 0x05, 0x6D, 0x9C, 0x92, 0x38, 0x5A, 0x7F, 0x41, 0x4B, 0x34, 0xB9, 0x0C, 0x79, 0x60, 0xD5, 0x7B, 0x35, 0xBA, 0x7D, 0xDE, 0x7B, 0x81, 0xFC, 0xA0, 0x11, 0x9D, 0x74, 0x1B, 0x12, 0x78, 0x09, 0x26, 0x01, 0x8F, 0xE4, 0xC8, 0x03, 0x0B, 0xF0, 0x38, 0xE1, 0x8B, 0x4F, 0xA3, 0x37, 0x43, 0xD0, 0xD3, 0xC8, 0x46, 0x41, 0x7E, 0x9D, 0x59, 0x15, 0xC2, 0x46, 0x31, 0x59, 0x38, 0xB1, 0xE2, 0x33, 0x61, 0x45, 0x01, 0xD0, 0x26, 0x95, 0x95, 0x51, 0x25, 0x8B, 0x23, 0x32, 0x30, 0xD4, 0x28, 0xB1, 0x81, 0xB1, 0x32, 0xF1, 0xD0, 0xB0, 0x26, 0x06, 0x7B, 0xA8, 0x16, 0x99, 0x9B, 0xC0, 0xCD, 0x6B, 0x54, 0x7E, 0x54, 0x8B, 0x63, 0xC9, 0xEA, 0xA0, 0x91, 0xBA, 0xC4, 0x93, 0xDC, 0x59, 0x8D, 0xBC, 0x2B, 0x0E, 0x14, 0x6A, 0x25, 0x91, 0xC2, 0xA8, 0xC0, 0x09, 0xDD, 0x51, 0x70, 0xAA, 0xE0, 0x27, 0xC5, 0x41, 0xA1, 0xB5, 0xE6, 0x6E, 0x45, 0xC6, 0x56, 0x12, 0x98, 0x4C, 0x46, 0x77, 0x04, 0x93, 0xEC, 0x89, 0x6E, 0xF2, 0x5A, 0xA9, 0x30, 0x5E, 0x9F, 0x06, 0x69, 0x2C, 0xD0, 0xB2, 0xF0, 0x69, 0x62, 0xE2, 0x05, 0xBE, 0xBE, 0x11, 0x3A, 0x34, 0xEB, 0xB1, 0xA4, 0x83, 0x0A, 0x9B, 0x37, 0x49, 0x64, 0x1B, 0xB9, 0x35, 0x00, 0x7B, 0x23, 0xB2, 0x4B, 0xFE, 0x57, 0x69, 0x56, 0x25, 0x4D, 0x7A, 0x35, 0xAA, 0x49, 0x6A, 0xC4, 0x46, 0xC6, 0x7A, 0x7F, 0xEC, 0x85, 0xA6, 0x00, 0x57, 0xE8, 0x58, 0x06, 0x17, 0xBC, 0xB3, 0xFA, 0xD1, 0x5C, 0x76, 0x44, 0x0F, 0xED, 0x54, 0xCC, 0x78, 0x93, 0x94, 0xFE, 0xA2, 0x44, 0x52, 0xCC, 0x6B, 0x05, 0x85, 0xB7, 0xEB, 0x0A, 0x88, 0xBB, 0xA9, 0x50, 0x0D, 0x98, 0x00, 0xE6, 0x24, 0x1A, 0xFE, 0xB5, 0x23, 0xB5, 0x5A, 0x96, 0xA5, 0x35, 0x15, 0x1D, 0x10, 0x49, 0x57, 0x32, 0x06, 0xE5, 0x9C, 0x7F, 0xEB, 0x07, 0x09, 0x66, 0x82, 0x36, 0x34, 0xF7, 0x7D, 0x5F, 0x12, 0x91, 0x75, 0x5A, 0x24, 0x31, 0x19, 0x62, 0x1A, 0xF8, 0x08, 0x4A, 0xB7, 0xAC, 0x1E, 0x22, 0xA0, 0x56, 0x8C, 0x62, 0x01, 0x41, 0x7C, 0xBE, 0x36, 0x55, 0xD8, 0xA0, 0x8D, 0xD5, 0xB5, 0x13, 0x88, 0x4C, 0x98, 0xD5, 0xA4, 0x93, 0xFD, 0x49, 0x38, 0x2E, 0xA4, 0x18, 0x60, 0xF1, 0x33, 0xCC, 0xD6, 0x01, 0xE8, 0x85, 0x96, 0x64, 0x26, 0xA2, 0xB1, 0xF2, 0x3D, 0x42, 0xD8, 0x2E, 0x24, 0x58, 0x2D, 0x99, 0x72, 0x51, 0x92, 0xC2, 0x17, 0x77, 0x46, 0x7B, 0x14, 0x57, 0xB1, 0xDD, 0x42, 0x9A, 0x0C, 0x41, 0xA5, 0xC3, 0xD7, 0x04, 0xCE, 0xA0, 0x62, 0x78, 0xC5, 0x99, 0x41, 0xB4, 0x38, 0xC6, 0x27, 0x27, 0x09, 0x78, 0x09, 0xB4, 0x53, 0x0D, 0xBE, 0x83, 0x7E, 0xA3, 0x96, 0xB6, 0xD3, 0x10, 0x77, 0xFA, 0xD3, 0x73, 0x30, 0x53, 0x98, 0x9A, 0x84, 0x42, 0xAA, 0xC4, 0x25, 0x5C, 0xB1, 0x63, 0xB8, 0xCA, 0x2F, 0x27, 0x50, 0x1E, 0xA9, 0x67, 0x30, 0x56, 0x95, 0xAB, 0xD6, 0x59, 0xAA, 0x02, 0xC8, 0x3E, 0xE6, 0x0B, 0xB5, 0x74, 0x20, 0x3E, 0x99, 0x37, 0xAE, 0x1C, 0x62, 0x1C, 0x8E, 0xCB, 0x5C, 0xC1, 0xD2, 0x1D, 0x55, 0x69, 0x60, 0xB5, 0xB9, 0x16, 0x1E, 0xA9, 0x6F, 0xFF, 0xEB, 0xAC, 0x72, 0xE1, 0xB8, 0xA6, 0x15, 0x4F, 0xC4, 0xD8, 0x8B, 0x56, 0xC0, 0x47, 0x41, 0xF0, 0x90, 0xCB, 0xB1, 0x56, 0xA7, 0x37, 0xC9, 0xE6, 0xA2, 0x2B, 0xA8, 0xAC, 0x70, 0x4B, 0xC3, 0x04, 0xF8, 0xE1, 0x7E, 0x5E, 0xA8, 0x45, 0xFD, 0xE5, 0x9F, 0xBF, 0x78, 0x8C, 0xCE, 0x0B, 0x97, 0xC8, 0x76, 0x1F, 0x89, 0xA2, 0x42, 0xF3, 0x05, 0x25, 0x83, 0xC6, 0x84, 0x4A, 0x63, 0x20, 0x31, 0xC9, 0x64, 0xA6, 0xC4, 0xA8, 0x5A, 0x12, 0x8A, 0x28, 0x61, 0x9B, 0xA1, 0xBB, 0x3D, 0x1B, 0xEA, 0x4B, 0x49, 0x84, 0x1F, 0xC8, 0x47, 0x61, 0x4A, 0x06, 0x68, 0x41, 0xF5, 0x2E, 0xD0, 0xEB, 0x8A, 0xE0, 0xB8, 0xB0, 0x96, 0xE9, 0x2B, 0x81, 0x95, 0x40, 0x58, 0x15, 0xB2, 0x31, 0x26, 0x6F, 0x36, 0xB1, 0x8C, 0x1A, 0x53, 0x33, 0x3D, 0xAB, 0x95, 0xD2, 0xA9, 0xA3, 0x74, 0xB5, 0x47, 0x8A, 0x4A, 0x41, 0xFB, 0x87, 0x59, 0x95, 0x7C, 0x9A, 0xB2, 0x2C, 0xAE, 0x54, 0x5A, 0xB5, 0x44, 0xBA, 0x8D, 0xD0, 0x5B, 0x83, 0xF3, 0xA6, 0x13, 0xA2, 0x43, 0x7A, 0xDB, 0x07, 0x3A, 0x96, 0x35, 0xCB, 0x4B, 0xBC, 0x96, 0x5F, 0xB4, 0x54, 0xCF, 0x27, 0xB2, 0x98, 0xA4, 0x0C, 0xD0, 0xDA, 0x3B, 0x8F, 0x9C, 0xA9, 0x9D, 0x8C, 0xB4, 0x28, 0x6C, 0x5E, 0xB4, 0x76, 0x41, 0x67, 0x96, 0x07, 0x0B, 0xA5, 0x35, 0xAA, 0xA5, 0x8C, 0xDB, 0x45, 0x1C, 0xD6, 0xDB, 0x5C, 0xBB, 0x0C, 0xA2, 0x0F, 0x0C, 0x71, 0xDE, 0x97, 0xC3, 0x0D, 0xA9, 0x7E, 0xC7, 0x90, 0x6D, 0x06, 0xB4, 0xB9, 0x39, 0x39, 0x60, 0x28, 0xC4, 0x6B, 0xA0, 0xE7, 0xA8, 0x65, 0xBC, 0x83, 0x08, 0xA3, 0x81, 0x0F, 0x12, 0x12, 0x00, 0x63, 0x39, 0xF7, 0xBC, 0x16, 0x9B, 0x16, 0x66, 0xFD, 0xF4, 0x75, 0x91, 0x1B, 0xBC, 0x8A, 0xAA, 0xB4, 0x17, 0x55, 0xC9, 0xA8, 0xAA, 0xBF, 0xA2, 0x3C, 0x0E, 0x37, 0xF8, 0x4F, 0xE4, 0x69, 0x99, 0xE0, 0x30, 0x49, 0x4B, 0x92, 0x98, 0xEF, 0x99, 0x34, 0xE8, 0xA6, 0x49, 0xC0, 0xA5, 0xCC, 0xE2, 0xB2, 0x2F, 0x31, 0x80, 0x9A, 0xFE, 0xD2, 0x39, 0x55, 0xD8, 0x78, 0x81, 0xD9, 0x9F, 0xC1, 0xD3, 0x52, 0x89, 0x6C, 0xAC, 0x90, 0x55, 0xBE, 0xA0, 0xD0, 0x16, 0xCC, 0xBA, 0x78, 0x05, 0xA3, 0xA5, 0x0E, 0x22, 0x16, 0x30, 0x37, 0x9B, 0xD0, 0x11, 0x35, 0x22, 0x1C, 0xAD, 0x5D, 0x95, 0x17, 0xC8, 0xCC, 0x42, 0x63, 0x7B, 0x9F, 0xC0, 0x71, 0x8E, 0x9A, 0x9B, 0xB4, 0x94, 0x5C, 0x72, 0xD8, 0xD1, 0x1D, 0x3D, 0x65, 0x9D, 0x83, 0xA3, 0xC4, 0x19, 0x50, 0x9A, 0xF5, 0xB4, 0x70, 0xDD, 0x89, 0xB7, 0xF3, 0xAC, 0xCF, 0x5F, 0x35, 0xCF, 0xC3, 0x22, 0x11, 0x5F, 0xD6, 0x6A, 0x5C, 0xD2, 0x87, 0x56, 0x51, 0x32, 0x6F, 0x9B, 0x31, 0x68, 0x91, 0x3B, 0xE5, 0xB9, 0xC8, 0x7A, 0xE0, 0xB0, 0x25, 0xEC, 0x7A, 0x2F, 0x4A, 0x07, 0x27, 0x50, 0x94, 0x6A, 0xC6, 0x11, 0x70, 0xA7, 0x82, 0x6D, 0x97, 0x04, 0xC5, 0xA2, 0x3A, 0x1C, 0x0A, 0x23, 0x25, 0x14, 0x6C, 0x3B, 0xC1, 0x85, 0x88, 0x26, 0xC6, 0xB3, 0x92, 0x79, 0xC2, 0xDA, 0x74, 0x38, 0xA3, 0x70, 0xED, 0x8A, 0x0A, 0xA5, 0x16, 0x9E, 0x3B, 0xEC, 0x29, 0xED, 0x88, 0x47, 0x87, 0x32, 0x75, 0x8D, 0x45, 0x41, 0x43, 0xE2, 0x27, 0xF8, 0x59, 0x58, 0x83, 0x29, 0x78, 0x42, 0xE6, 0xAF, 0x13, 0x3B, 0x17, 0xE4, 0x81, 0x1B, 0x0F, 0x57, 0x13, 0xAC, 0x73, 0xB7, 0xE3, 0x47, 0x42, 0x3E, 0xB9, 0x28, 0x22, 0xD2, 0x30, 0x6F, 0xA1, 0x45, 0x00, 0xA7, 0x20, 0x7A, 0x06, 0x72, 0x67, 0x20, 0x46, 0x54, 0x4A, 0xCC, 0x4E, 0xA9, 0xC1, 0x6E, 0xD7, 0x42, 0x1A, 0x06, 0x9E, 0x0D, 0x73, 0x7A, 0x98, 0x62, 0x85, 0x19, 0xC6, 0xA2, 0x9A, 0x42, 0x4A, 0x86, 0x8B, 0x46, 0xD9, 0xA0, 0xCC, 0x7C, 0x6C, 0x9D, 0xDD, 0x8B, 0x8B, 0xCB, 0xF4, 0x22, 0xC8, 0xF4, 0x8A, 0x73, 0x14, 0x3D, 0x5A, 0xBB, 0x66, 0xBC, 0x55, 0x49, 0x94, 0x18, 0x43, 0x08, 0x02, 0xBA, 0xC5, 0x44, 0x46, 0x3C, 0xC7, 0x31, 0x9D, 0x17, 0x99, 0x8F, 0x29, 0x41, 0x13, 0x65, 0x76, 0x6D, 0x04, 0xC8, 0x47, 0xF3, 0x12, 0x9D, 0x90, 0x77, 0xB7, 0xD8, 0x33, 0x9B, 0xFB, 0x96, 0xA6, 0x73, 0x9C, 0x3F, 0x6B, 0x74, 0xA8, 0xF0, 0x5F, 0x91, 0x38, 0xAB, 0x2F, 0xE3, 0x7A, 0xCB, 0x57, 0x63, 0x4D, 0x18, 0x20, 0xB5, 0x01, 0x76, 0xF5, 0xA0, 0xB6, 0xBC, 0x29, 0x40, 0xF1, 0xD5, 0x93, 0x8F, 0x19, 0x36, 0xB5, 0xF9, 0x58, 0x28, 0xB9, 0x2E, 0xB7, 0x29, 0x73, 0xC1, 0x59, 0x0A, 0xEB, 0x7A, 0x55, 0x2C, 0xEC, 0xA1, 0x0B, 0x00, 0xC3, 0x03, 0xB7, 0xC7, 0x5D, 0x40, 0x20, 0x71, 0xA7, 0x9E, 0x2C, 0x81, 0x0A, 0xF7, 0xC7, 0x45, 0xE3, 0x33, 0x67, 0x12, 0x49, 0x2A, 0x42, 0x04, 0x3F, 0x29, 0x03, 0xA3, 0x7C, 0x64, 0x34, 0xCE, 0xE2, 0x0B, 0x1D, 0x15, 0x9B, 0x05, 0x76, 0x99, 0xFF, 0x9C, 0x1D, 0x3B, 0xD6, 0x80, 0x29, 0x83, 0x9A, 0x08, 0xF4, 0x3E, 0x6C, 0x1C, 0x81, 0x99, 0x13, 0x53, 0x2F, 0x91, 0x1D, 0xD3, 0x70, 0xC7, 0x02, 0x14, 0x88, 0xE1, 0x1C, 0xB5, 0x04, 0xCB, 0x9C, 0x70, 0x57, 0x0F, 0xFF, 0x35, 0xB4, 0xB4, 0x60, 0x11, 0x91, 0xDC, 0x1A, 0xD9, 0xE6, 0xAD, 0xC5, 0xFA, 0x96, 0x18, 0x79, 0x8D, 0x7C, 0xC8, 0x60, 0xC8, 0x7A, 0x93, 0x9E, 0x4C, 0xCF, 0x85, 0x33, 0x63, 0x22, 0x68, 0xCF, 0x1A, 0x51, 0xAF, 0xF0, 0xCB, 0x81, 0x1C, 0x55, 0x45, 0xCB, 0x16, 0x56, 0xE6, 0x52, 0x69, 0x47, 0x74, 0x30, 0x69, 0x9C, 0xCD, 0xEA, 0x38, 0x00, 0x63, 0x0B, 0x78, 0xCD, 0x58, 0x10, 0x33, 0x4C, 0xCF, 0x02, 0xE0, 0x13, 0xF3, 0xB8, 0x02, 0x44, 0xE7, 0x0A, 0xCD, 0xB0, 0x60, 0xBB, 0xE7, 0xA5, 0x53, 0xB0, 0x63, 0x45, 0x6B, 0x2E, 0xA8, 0x07, 0x47, 0x34, 0x13, 0x16, 0x5C, 0xE5, 0x7D, 0xD5, 0x63, 0x47, 0x3C, 0xFB, 0xC9, 0x06, 0x18, 0xAD, 0xE1, 0xF0, 0xB8, 0x88, 0xAA, 0x48, 0xE7, 0x22, 0xBB, 0x27, 0x51, 0x85, 0x8F, 0xE1, 0x96, 0x87, 0x44, 0x2A, 0x48, 0xE7, 0xCA, 0x0D, 0x2A, 0x29, 0xCD, 0x51, 0xBF, 0xD8, 0xF7, 0x8C, 0x17, 0xB9, 0x66, 0x0B, 0xFB, 0x54, 0xA4, 0x70, 0xB2, 0xAE, 0x9A, 0x95, 0x5C, 0x6A, 0xB8, 0xD6, 0xE5, 0xCC, 0x92, 0xAC, 0x8E, 0xD3, 0xC1, 0x85, 0xDA, 0xA8, 0xBC, 0x29, 0xF0, 0x57, 0x8E, 0xBB, 0x81, 0x2B, 0x97, 0xC9, 0xE5, 0xA8, 0x48, 0xA6, 0x38, 0x4D, 0xE4, 0xE7, 0x5A, 0x31, 0x47, 0x0B, 0x53, 0x06, 0x6A, 0x8D, 0x02, 0x7B, 0xA4, 0x4B, 0x21, 0x74, 0x9C, 0x04, 0x92, 0x46, 0x5F, 0x90, 0x72, 0xB2, 0x83, 0x76, 0xC4, 0xE2, 0x90, 0xB3, 0x0C, 0x18, 0x63, 0xF9, 0xE5, 0xB7, 0x99, 0x96, 0x08, 0x34, 0x22, 0xBD, 0x8C, 0x27, 0x2C, 0x10, 0xEC, 0xC6, 0xEB, 0x9A, 0x0A, 0x82, 0x25, 0xB3, 0x1A, 0xA0, 0xA6, 0x6E, 0x35, 0xB9, 0xC0, 0xB9, 0xA7, 0x95, 0x82, 0xBA, 0x20, 0xA3, 0xC0, 0x4C, 0xD2, 0x99, 0x14, 0xF0, 0x83, 0xA0, 0x15, 0x82, 0x88, 0xBA, 0x4D, 0x6E, 0xB6, 0x2D, 0x87, 0x26, 0x4B, 0x91, 0x2B, 0xCA, 0x39, 0x73, 0x2F, 0xBD, 0xE5, 0x36, 0xA3, 0x77, 0xAD, 0x02, 0xB8, 0xC8, 0x35, 0xD4, 0xA2, 0xF4, 0xE7, 0xB1, 0xCE, 0x11, 0x5D, 0x0C, 0x86, 0x0B, 0xEA, 0xA7, 0x95, 0x5A, 0x49, 0xAD, 0x68, 0x95, 0x86, 0xA8, 0x9A, 0x2B, 0x9F, 0x9B, 0x10, 0xD1, 0x59, 0x5D, 0x2F, 0xC0, 0x65, 0xAD, 0x01, 0x8A, 0x7D, 0x56, 0xC6, 0x14, 0x47, 0x1F, 0x8E, 0x94, 0x6F, 0xE8, 0xAB, 0x49, 0xE8, 0x22, 0x65, 0x91, 0x11, 0x9F, 0xCA, 0xDB, 0x4F, 0x9A, 0x86, 0x16, 0x31, 0x37, 0x87, 0x36, 0xB6, 0x68, 0x8B, 0x78, 0x2D, 0x58, 0xE9, 0x7E, 0x45, 0x72, 0x75, 0x3A, 0x96, 0x64, 0xB6, 0xB8, 0x53, 0x68, 0x12, 0xB2, 0x59, 0x11, 0xAA, 0x76, 0xA2, 0x42, 0x37, 0x54, 0x33, 0x19, 0x27, 0x38, 0xEE, 0xE7, 0x62, 0xF6, 0xB8, 0x43, 0x15, 0xBB, 0x34, 0x36, 0x23, 0x1E, 0x0A, 0x9B, 0x27, 0x7E, 0xD2, 0x8A, 0xE0, 0x05, 0x07, 0x28, 0x34, 0x64, 0x57, 0xE1, 0x34, 0x05, 0x06, 0x2D, 0xB2, 0x80, 0x4B, 0x8D, 0xA6, 0x0B, 0xB5, 0xC7, 0x93, 0xD4, 0xCC, 0x0E, 0x10, 0x1C, 0xBA, 0x2D, 0x91, 0x82, 0xFD, 0x71, 0x24, 0xFF, 0x52, 0xBF, 0x4C, 0xA2, 0x82, 0x92, 0xAC, 0x26, 0xD6, 0x78, 0x08, 0x89, 0x53, 0x97, 0x1D, 0xBA, 0x0B, 0x6F, 0xEC, 0x2C, 0x96, 0x59, 0x35, 0x32, 0x91, 0xC7, 0x0C, 0x5B, 0x92, 0x45, 0xA0, 0xCA, 0x25, 0x33, 0x04, 0xAF, 0xD3, 0xC9, 0x51, 0x02, 0xBE, 0xA6, 0x68, 0x75, 0xC6, 0x20, 0x16, 0x80, 0xB4, 0xBD, 0xA3, 0x86, 0x87, 0xB6, 0x48, 0xC2, 0x8E, 0xB3, 0x74, 0x78, 0xE3, 0xBC, 0x00, 0xCA, 0x8A, 0x3C, 0xC2, 0x72, 0x04, 0x64, 0x2B, 0x42, 0xB6, 0x8F, 0xCB, 0xE7, 0xB2, 0x1A, 0x36, 0x6D, 0x06, 0x68, 0xA5, 0x02, 0x9A, 0x7D, 0xEE, 0xF9, 0x4C, 0xDD, 0x6A, 0x95, 0xD7, 0xEA, 0x89, 0x31, 0x67, 0x3B, 0xF7, 0x11, 0x2D, 0x40, 0x42, 0x10, 0x7B, 0x1B, 0x8B, 0x97, 0x00, 0xC9, 0x74, 0xF9, 0xC4, 0xE8, 0x3A, 0x8F, 0xAC, 0xD8, 0x9B, 0xFE, 0x0C, 0xA3, 0xCC, 0x4C, 0x2F, 0xCE, 0x80, 0xA0, 0x3D, 0x35, 0x76, 0xC2, 0x22, 0xA7, 0x92, 0xB7, 0x2B, 0x1F, 0x07, 0x0A, 0xB7, 0xF6, 0xB6, 0xF2, 0xB5, 0xCA, 0x2A, 0xF5, 0x05, 0x4A, 0xFA, 0x70, 0xA8, 0x96, 0x99, 0x01, 0x59, 0xB4, 0x5D, 0x10, 0x03, 0xE2, 0xA0, 0x56, 0x48, 0x67, 0x5E, 0x59, 0x60, 0x16, 0xF1, 0xB7, 0x1D, 0xD0, 0xF7, 0xBD, 0xA7, 0xE2, 0x09, 0x7F, 0xC7, 0x3B, 0x3A, 0x14, 0x3D, 0x12, 0xC7, 0x26, 0x02, 0x0A, 0xC3, 0x49, 0x58, 0xAD, 0x70, 0x62, 0xB9, 0x2B, 0x9A, 0xBF, 0x3C, 0xA6, 0xBE, 0x5A, 0xE2, 0x9F, 0x57, 0x13, 0x5E, 0x62, 0x5A, 0x36, 0x79, 0x71, 0x83, 0x7E, 0x63, 0x63, 0xD1, 0x53, 0x20, 0x94, 0xE0, 0x22, 0xA2, 0x34, 0x67, 0xCF, 0x93, 0x2E, 0x1F, 0x89, 0xB5, 0xB0, 0x80, 0x3C, 0x1E, 0xC9, 0x9B, 0x58, 0x5A, 0x78, 0xB5, 0x86, 0x50, 0x96, 0x74, 0x6F, 0x32, 0x25, 0x82, 0x14, 0xEC, 0xB3, 0x80, 0x65, 0xC9, 0x7F, 0x45, 0x5E, 0x15, 0x5A, 0xCC, 0x2D, 0xD0, 0x05, 0xA9, 0xC7, 0x6B, 0xED, 0x59, 0xCD, 0xA7, 0x38, 0x37, 0xD3, 0x03, 0x50, 0x4E, 0x6C, 0x97, 0x6A, 0x60, 0x6A, 0x2B, 0xE7, 0xBB, 0xEC, 0x59, 0x48, 0xB9, 0x1A, 0x34, 0x9E, 0x89, 0x36, 0x68, 0x8C, 0xC0, 0x27, 0x97, 0x54, 0xB7, 0x43, 0xAB, 0xC5, 0x86, 0x66, 0xB1, 0x9B, 0x6C, 0x32, 0x60, 0x05, 0x1F, 0x19, 0x20, 0x6B, 0xB9, 0x62, 0xBB, 0x66, 0x33, 0xEB, 0x00, 0x48, 0xE3, 0x2B, 0xAA, 0xCC, 0x5B, 0x02, 0x0D, 0x02, 0xC8, 0x6C, 0xA9, 0x77, 0x0A, 0xD4, 0x69, 0xDB, 0x54, 0xA1, 0x06, 0xAC, 0x73, 0xA3, 0x5B, 0x80, 0x57, 0x42, 0x2B, 0x3D, 0xB2, 0x02, 0xC5, 0xA5, 0xB4, 0xE3, 0xD5, 0x35, 0xF0, 0xFC, 0x99, 0x32, 0x6C, 0x4B, 0x8B, 0x7B, 0x16, 0xF1, 0xCB, 0x5A, 0xF9, 0x68, 0x03, 0xFA, 0x8C, 0x19, 0x5F, 0xC0, 0xBC, 0xED, 0xDA, 0xAF, 0x01, 0x2A, 0x51, 0x72, 0x8B, 0x76, 0x48, 0x90, 0x82, 0x37, 0x3C, 0x91, 0xE9, 0x2C, 0x87, 0xAC, 0xCA, 0x79, 0x51, 0x60, 0x78, 0x2E, 0x3B, 0x0D, 0xD6, 0x43, 0x54, 0x4B, 0xB9, 0x6A, 0xBC, 0x27, 0x08, 0xD4, 0x9B, 0x75, 0x9C, 0xF0, 0x57, 0xAA, 0x22, 0x3B, 0xAF, 0xD9, 0x6A, 0x33, 0x0B, 0xAF, 0x39, 0x81, 0x0F, 0xE8, 0x67, 0x1B, 0x43, 0x43, 0xC2, 0x97, 0xDA, 0x1E, 0x19, 0x69, 0xC9, 0x96, 0x21, 0x6A, 0xB5, 0x10, 0x6D, 0xA6, 0x68, 0x94, 0x1B, 0x16, 0x0D, 0x44, 0x77, 0x01, 0x71, 0x36, 0xCB, 0xCA, 0x5B, 0x5A, 0x8D, 0x44, 0xC4, 0xA8, 0xB1, 0xCF, 0x3E, 0xF7, 0x97, 0x85, 0xE5, 0xAA, 0x25, 0xC3, 0xA1, 0xAD, 0x6C, 0x24, 0xFD, 0x14, 0x0F, 0x79, 0x20, 0x7D, 0xE5, 0xA4, 0x99, 0xF8, 0xA1, 0x53, 0x4F, 0xFA, 0x80, 0x4A, 0xA7, 0xB3, 0x88, 0x9C, 0xBE, 0x25, 0xC0, 0x41, 0x47, 0x04, 0xAA, 0x57, 0x89, 0x7F, 0x17, 0x86, 0x23, 0x64, 0xEC, 0xA5, 0x62, 0x58, 0x00, 0x72, 0x48, 0x81, 0x39, 0x12, 0xB8, 0x36, 0x49, 0x7F, 0x03, 0x59, 0xC2, 0xF7, 0x23, 0x8A, 0x05, 0xD3, 0x05, 0xA0, 0xEA, 0x15, 0x2E, 0x72, 0xB4, 0x44, 0x17, 0xA8, 0x68, 0x13, 0x4E, 0x91, 0xB3, 0xCA, 0x79, 0x31, 0x23, 0x2F, 0xD4, 0xC2, 0x5F, 0x8C, 0x2A, 0x49, 0x2A, 0x33, 0x9C, 0xDC, 0x0A, 0x13, 0x89, 0x67, 0x21, 0x14, 0x51, 0xF2, 0x56, 0x26, 0x78, 0xFA, 0x14, 0x08, 0x0A, 0x34, 0x43, 0x6C, 0x42, 0xB0, 0x78, 0x65, 0xAC, 0x03, 0x6A, 0x81, 0xE9, 0x7A, 0x77, 0x87, 0xA9, 0x38, 0x02, 0x5C, 0xAF, 0x81, 0x34, 0x50, 0x36, 0x8B, 0xED, 0x0C, 0x94, 0xB1, 0x85, 0x76, 0x04, 0x52, 0x64, 0x05, 0xD2, 0x7A, 0x1C, 0x1A, 0xBC, 0x81, 0xB5, 0xB6, 0xEC, 0x13, 0xC7, 0x19, 0x30, 0xA9, 0x7D, 0x92, 0x32, 0xCF, 0x70, 0x21, 0xEF, 0x87, 0xA4, 0xD1, 0x55, 0x32, 0x8E, 0x62, 0xB5, 0x83, 0xA8, 0x3B, 0x4A, 0xF2, 0x1F, 0x9F, 0x57, 0x50, 0xF8, 0x57, 0x51, 0x50, 0x42, 0x4F, 0x63, 0xB8, 0x99, 0xD7, 0x1C, 0xAD, 0x26, 0x7C, 0x09, 0xE4, 0x46, 0x71, 0x46, 0xE1, 0x6E, 0x9B, 0x6C, 0x65, 0x3F, 0x00, 0x8C, 0x31, 0x13, 0x75, 0xE2, 0xE0, 0x06, 0xD4, 0x07, 0x6A, 0x54, 0x6B, 0x82, 0xF5, 0x31, 0x42, 0x22, 0xF7, 0xC6, 0x54, 0x31, 0x7E, 0x79, 0xEC, 0x60, 0x35, 0xB7, 0x3F, 0xAF, 0x49, 0x17, 0x57, 0xE6, 0x1C, 0x82, 0x83, 0x26, 0xD5, 0x30, 0x44, 0x54, 0x1C, 0x4D, 0x45, 0x37, 0xAB, 0xD3, 0xEA, 0x1E, 0x67, 0x99, 0x8C, 0x33, 0x82, 0x97, 0x4C, 0xA7, 0x8A, 0xE1, 0xB1, 0x96, 0x0E, 0x4A, 0x92, 0x26, 0xB0, 0x21, 0x9A, 0xB0, 0x70, 0xF0, 0xD7, 0xAA, 0x66, 0xD7, 0x6F, 0x93, 0x16, 0xAD, 0xB8, 0x0C, 0x54, 0xD6, 0x49, 0x97, 0x71, 0xB4, 0x71, 0xE8, 0x16, 0x8D, 0x47, 0xBC, 0xAA, 0x08, 0x32, 0x4A, 0xB6, 0xBA, 0x92, 0xC3, 0xA7, 0x02, 0x75, 0xF2, 0x4F, 0xA4, 0xDC, 0x10, 0xE2, 0x51, 0x63, 0x3F, 0xB9, 0x8D, 0x16, 0x2B, 0xB5, 0x53, 0x72, 0x02, 0xC6, 0xA5, 0x53, 0xCE, 0x78, 0x41, 0xC4, 0xD4, 0x0B, 0x87, 0x3B, 0x85, 0xCA, 0x03, 0xA0, 0xA1, 0xE1, 0xCF, 0xAD, 0xE6, 0xBA, 0x51, 0x80, 0xAB, 0x13, 0x23, 0xCC, 0xBA, 0x9A, 0x3E, 0x9C, 0x53, 0xD3, 0x75, 0x75, 0xAB, 0x1F, 0xD9, 0xE7, 0x31, 0x6C, 0x6F, 0xEE, 0xCB, 0x0A, 0x14, 0xDF, 0x6F, 0x2D, 0xA5, 0x6C, 0x2F, 0x56, 0xF5, 0x5A, 0x89, 0x63, 0x5C, 0xFC, 0xFD, 0xA4, 0x79, 0x27, 0xAF, 0x1F, 0x0A, 0x47, 0xB2, 0xD4, 0xE4, 0xE6, 0x16, 0x34, 0xB1, 0xB5, 0x1D, 0x37, 0xA3, 0xA3, 0x07, 0xA9, 0x72, 0x42, 0x0D, 0xE1, 0xB7, 0xA4, 0x81, 0xB8, 0x3E, 0x58, 0x3B, 0x6A, 0xF1, 0x6F, 0x63, 0xCB, 0x00, 0xC6};
std::vector<uint8_t> ct_MLKEM1024 = {0x4F, 0x90, 0x10, 0x6F, 0xF7, 0xC3, 0xDC, 0x4E, 0x47, 0x41, 0x7F, 0x31, 0xAB, 0x56, 0xB1, 0xC5, 0xE4, 0x26, 0xC1, 0xEC, 0xD5, 0x87, 0x8A, 0xAD, 0x2B, 0x70, 0x5E, 0x75, 0x06, 0x2D, 0xA5, 0xFA, 0x6F, 0x4D, 0x18, 0xB7, 0x04, 0xC9, 0x41, 0xC6, 0xC6, 0xD9, 0x41, 0xFD, 0x21, 0x19, 0x1A, 0x69, 0x21, 0x0B, 0xC3, 0x9E, 0x24, 0x95, 0x0D, 0x9F, 0x85, 0x1B, 0x6D, 0xE8, 0xCE, 0x30, 0x02, 0x3D, 0xC7, 0x53, 0x64, 0x39, 0x10, 0x4D, 0x42, 0x24, 0x5F, 0x3E, 0x04, 0xE6, 0xAA, 0x67, 0x63, 0xF8, 0xAC, 0x97, 0xAD, 0xBD, 0x04, 0xCC, 0x69, 0x54, 0x7B, 0xCE, 0x0B, 0xF2, 0x90, 0xFF, 0xB5, 0xD1, 0x29, 0x46, 0x30, 0x11, 0x74, 0xAF, 0x1B, 0x08, 0x68, 0xC1, 0x4D, 0x42, 0x93, 0xFA, 0x9D, 0xCC, 0x5B, 0x23, 0xF8, 0x09, 0xB0, 0x2C, 0xC7, 0x8D, 0xEF, 0xE7, 0xF2, 0x79, 0x35, 0xB9, 0xB6, 0x81, 0xE5, 0x31, 0xFC, 0x21, 0xCC, 0xB2, 0xAF, 0x8E, 0xF6, 0x14, 0x4D, 0x84, 0x98, 0xE6, 0x3E, 0x0E, 0xE4, 0x8A, 0xF8, 0xD4, 0xCE, 0xF7, 0xAC, 0x1F, 0x66, 0x9A, 0xC7, 0x40, 0xB0, 0x6F, 0x79, 0xDD, 0xB5, 0x8E, 0x79, 0x4F, 0x2F, 0xC2, 0xCA, 0x83, 0x2E, 0x05, 0xA0, 0x37, 0x4C, 0x18, 0xA4, 0xF2, 0xCC, 0x78, 0x34, 0x3E, 0xEA, 0x06, 0x4A, 0xBC, 0x5F, 0x46, 0x8F, 0x4D, 0xD1, 0x1E, 0x0B, 0x6E, 0x8F, 0xA1, 0xD1, 0x8A, 0x22, 0x1D, 0x82, 0x41, 0x45, 0x0C, 0x05, 0xEB, 0x9E, 0xDF, 0x90, 0xD9, 0xD7, 0xF6, 0x66, 0xAC, 0x82, 0xE7, 0xFD, 0x44, 0xAF, 0x93, 0x28, 0xE0, 0xBC, 0x60, 0x04, 0xD5, 0xB1, 0x14, 0xE8, 0x0E, 0x9B, 0x98, 0x0D, 0x18, 0xE0, 0x81, 0xD7, 0x71, 0xDF, 0xCB, 0x2A, 0xCF, 0xD4, 0x01, 0x42, 0xA2, 0xEB, 0x33, 0x23, 0x4F, 0x75, 0x73, 0x3E, 0xAB, 0x7D, 0x8E, 0xE8, 0xA5, 0xA6, 0xF7, 0x96, 0x68, 0x1A, 0x4A, 0x8A, 0xF8, 0x5C, 0xCE, 0x86, 0x97, 0x1B, 0x82, 0x1D, 0x4A, 0xD8, 0x37, 0x10, 0x49, 0xE9, 0x4E, 0x28, 0x0B, 0x77, 0xB1, 0x5D, 0x11, 0x1A, 0x42, 0xAE, 0xAD, 0xFC, 0x08, 0xD4, 0xF8, 0x04, 0xBD, 0x78, 0x88, 0x54, 0x43, 0xE8, 0x1A, 0x39, 0x3D, 0xF7, 0xC8, 0x75, 0x4C, 0x46, 0x09, 0x15, 0x84, 0x6E, 0x09, 0xA0, 0x59, 0x65, 0x87, 0x46, 0x00, 0x38, 0xF5, 0x5D, 0x06, 0xEC, 0x21, 0x43, 0x4A, 0x1C, 0x2D, 0xF4, 0x4D, 0x0C, 0x16, 0x70, 0x6E, 0x8D, 0x2B, 0x83, 0xF0, 0xE7, 0x83, 0x39, 0x76, 0xEF, 0x05, 0xBF, 0x1D, 0x9F, 0x0D, 0xDC, 0x9A, 0x37, 0x59, 0x7E, 0x40, 0x1B, 0x81, 0x7C, 0x2B, 0xEC, 0x8E, 0x02, 0xEB, 0x9D, 0xF7, 0x59, 0x1E, 0x23, 0x9F, 0x25, 0xF8, 0x64, 0x8E, 0x7F, 0x2F, 0x4F, 0x67, 0x30, 0x93, 0xBD, 0x9C, 0xB7, 0x03, 0xDA, 0x32, 0xB3, 0x53, 0xF5, 0x85, 0x14, 0xC6, 0xAB, 0x55, 0x74, 0x8B, 0x19, 0x4E, 0x52, 0xF1, 0x53, 0xD5, 0x2F, 0x5F, 0x33, 0xFE, 0x95, 0xC5, 0xF9, 0xF6, 0x5E, 0xA9, 0x7B, 0xA7, 0x21, 0xE8, 0xDD, 0xF3, 0x33, 0xB6, 0x4D, 0x23, 0x3A, 0x86, 0x7A, 0x12, 0x70, 0x1E, 0x00, 0xC5, 0xD8, 0xA9, 0xB5, 0xAE, 0x34, 0x4F, 0x3D, 0x84, 0x7C, 0x27, 0xC0, 0x79, 0xDC, 0xC9, 0xC3, 0xB4, 0x0E, 0xC4, 0x60, 0x4A, 0x9F, 0x04, 0x1E, 0x79, 0x87, 0xE8, 0xB9, 0x30, 0xC6, 0x58, 0xB9, 0xA1, 0x32, 0xDE, 0x4E, 0x42, 0x2C, 0x0E, 0x27, 0x55, 0x3A, 0x2A, 0x0E, 0xAB, 0x8C, 0x85, 0x9E, 0xB0, 0xE5, 0x67, 0x7E, 0x83, 0x27, 0x27, 0x25, 0xC5, 0xC1, 0x65, 0x2E, 0x61, 0xB9, 0xBB, 0xF5, 0xC9, 0xC5, 0x9B, 0xC2, 0x35, 0x7A, 0x4D, 0x1D, 0xB9, 0xC6, 0x07, 0xF3, 0x4D, 0xC1, 0xBA, 0x07, 0x4B, 0x84, 0xDF, 0xC6, 0x9E, 0x40, 0x97, 0xA7, 0xAD, 0x2B, 0xA9, 0xA5, 0x80, 0x00, 0x02, 0x72, 0x96, 0xAD, 0x39, 0xFC, 0x1C, 0xE2, 0x18, 0xA5, 0xEE, 0xC7, 0xAD, 0xFA, 0x8A, 0xA3, 0xB9, 0x10, 0x0B, 0x0B, 0x60, 0x3C, 0xFC, 0x83, 0xC1, 0x52, 0x58, 0x9E, 0x12, 0xE6, 0xBD, 0x9E, 0xE1, 0x0C, 0x49, 0x13, 0x1A, 0x70, 0x1D, 0x31, 0x5D, 0xFE, 0xC3, 0x8E, 0x01, 0x83, 0x28, 0x91, 0x6F, 0x9F, 0xFA, 0xA7, 0x30, 0x5C, 0xFB, 0x66, 0x78, 0x17, 0x07, 0xD2, 0xD1, 0x02, 0x0E, 0xB7, 0x82, 0xF9, 0xF0, 0x03, 0xDB, 0x4E, 0x46, 0xB8, 0x7D, 0x69, 0x3F, 0x62, 0xE8, 0xBD, 0xE1, 0x70, 0x14, 0x1F, 0xF7, 0x1F, 0x26, 0xDD, 0xF5, 0x31, 0x0C, 0x00, 0xC9, 0x16, 0x36, 0x55, 0xF5, 0x21, 0x7D, 0xD2, 0xC8, 0xB0, 0x46, 0x6A, 0xC8, 0x9D, 0xB5, 0x5B, 0xD7, 0xFB, 0x3B, 0x09, 0x64, 0xBC, 0x90, 0x09, 0xE9, 0x68, 0x61, 0x85, 0x11, 0x7D, 0xCB, 0x50, 0xD6, 0xD0, 0x29, 0x77, 0x53, 0xCF, 0x7F, 0x12, 0x17, 0xE8, 0x19, 0xEE, 0x60, 0xE3, 0xF0, 0xFA, 0xEC, 0x4A, 0x5A, 0xF0, 0xC2, 0xEA, 0x83, 0xCC, 0xDE, 0x15, 0xCF, 0x04, 0x5C, 0x69, 0x61, 0xDE, 0x8F, 0xF6, 0x23, 0x5C, 0x9D, 0x93, 0xBA, 0x4C, 0x89, 0xB7, 0xA8, 0x2A, 0x74, 0x71, 0xFC, 0xFB, 0x0B, 0x8E, 0xAD, 0x54, 0xD5, 0x6E, 0x8A, 0x1D, 0xE2, 0x1B, 0x39, 0x33, 0xAC, 0x5B, 0x4A, 0x06, 0x89, 0xEE, 0xF3, 0x59, 0x89, 0x26, 0xE1, 0x7B, 0xBB, 0x16, 0xAE, 0xC6, 0x1E, 0xC3, 0x0A, 0x2C, 0xCC, 0x0E, 0x03, 0x23, 0xEC, 0x28, 0x28, 0x87, 0xC1, 0x08, 0xC3, 0xA4, 0xE8, 0x3E, 0x36, 0x66, 0x49, 0x3D, 0x86, 0x53, 0xD0, 0xE9, 0x24, 0x43, 0x80, 0x8C, 0x79, 0xD7, 0x70, 0xBF, 0xF4, 0x8A, 0x49, 0xE6, 0x5A, 0xE0, 0x89, 0xFE, 0xC7, 0x90, 0xBB, 0xA4, 0xC6, 0x63, 0x54, 0xEF, 0x67, 0xA3, 0x34, 0xC1, 0xEA, 0x5C, 0x6C, 0x57, 0x07, 0xB6, 0x92, 0x8E, 0xBD, 0x1B, 0xDB, 0x6A, 0x94, 0x0F, 0xA2, 0x42, 0xC6, 0xEB, 0xD7, 0xF3, 0xE7, 0x12, 0x72, 0x42, 0x1C, 0x90, 0x82, 0x84, 0x1A, 0x6C, 0xAD, 0x28, 0x94, 0xBB, 0x8A, 0xC8, 0x5F, 0x10, 0x5D, 0x8B, 0xBC, 0x9E, 0x6F, 0x0A, 0x3D, 0xF0, 0xD7, 0xC4, 0x6F, 0x6E, 0x2F, 0x4C, 0xAB, 0x90, 0x4E, 0xD1, 0x57, 0xAF, 0xA8, 0x5D, 0x4A, 0x85, 0x22, 0x20, 0xA9, 0x63, 0x6E, 0x1E, 0x88, 0x21, 0x64, 0x3A, 0x9E, 0x40, 0x28, 0xD8, 0x7A, 0x43, 0x04, 0x32, 0xF0, 0x93, 0x54, 0xB3, 0x97, 0x31, 0x82, 0x38, 0x5C, 0xF5, 0xAB, 0xFC, 0x8F, 0x84, 0x98, 0x2B, 0xEE, 0x0B, 0xCB, 0xF5, 0xD1, 0x86, 0x37, 0x39, 0x91, 0x63, 0xA0, 0x9E, 0xB4, 0x57, 0x11, 0xE0, 0x7C, 0x44, 0x58, 0x49, 0x8C, 0x76, 0x97, 0x91, 0x07, 0xCF, 0x91, 0xB3, 0xFC, 0x59, 0x0E, 0xA4, 0xAD, 0x71, 0x5D, 0x65, 0x6D, 0x5E, 0x56, 0xDC, 0x32, 0x14, 0x65, 0x80, 0x10, 0x1C, 0x95, 0x2E, 0x02, 0xED, 0x70, 0x17, 0x96, 0x0D, 0x54, 0xCA, 0xAC, 0xCC, 0x70, 0x60, 0x71, 0x96, 0x98, 0x0A, 0xDB, 0xDA, 0xEA, 0x42, 0x0A, 0x52, 0xC0, 0x55, 0x9E, 0xD2, 0x3C, 0x95, 0x14, 0xF8, 0xCA, 0x7A, 0xB7, 0xF3, 0xBA, 0xAF, 0xD2, 0xFA, 0xB5, 0x89, 0x60, 0xA6, 0x41, 0x28, 0xD5, 0xA5, 0x0E, 0x9A, 0xD8, 0xDB, 0x7D, 0x23, 0xA9, 0x0C, 0xE6, 0x4C, 0x1B, 0xC3, 0x49, 0xD1, 0x18, 0xD3, 0x60, 0x33, 0x58, 0x37, 0x7F, 0x84, 0xFF, 0x5A, 0x64, 0x45, 0x7F, 0xA1, 0xCF, 0x41, 0xB2, 0x70, 0x94, 0xBC, 0xA7, 0x23, 0x60, 0xBD, 0x42, 0x94, 0x15, 0xB9, 0xEF, 0x9A, 0xCC, 0xB7, 0xA5, 0xD7, 0xB9, 0xE5, 0xF5, 0xFD, 0xCA, 0x8F, 0xCF, 0xA4, 0x59, 0x2E, 0x91, 0xD7, 0xE5, 0x12, 0x0D, 0xF7, 0xE3, 0xC6, 0x67, 0x5A, 0xF2, 0x21, 0x1B, 0xB9, 0x4D, 0x85, 0x6A, 0x5D, 0x22, 0x85, 0xFB, 0xBB, 0x36, 0x98, 0x4A, 0x13, 0x45, 0x59, 0x09, 0x30, 0xB1, 0x32, 0x32, 0x56, 0x5D, 0x54, 0x81, 0x2A, 0x93, 0x45, 0x32, 0x4C, 0x23, 0x26, 0x53, 0x19, 0x03, 0x23, 0xCC, 0x67, 0xC8, 0x40, 0xE4, 0x78, 0xD0, 0x9E, 0x6D, 0xDB, 0xCF, 0x99, 0x9F, 0x7A, 0xA3, 0xB5, 0x56, 0xF8, 0x03, 0x32, 0xE6, 0x7A, 0xCA, 0x41, 0xEC, 0x06, 0x61, 0x08, 0x8D, 0x76, 0x96, 0xBB, 0x64, 0xE9, 0xA9, 0x8A, 0x07, 0x49, 0xFA, 0xA9, 0x85, 0x4D, 0x9B, 0x48, 0x75, 0x40, 0x23, 0xBA, 0xCA, 0xF3, 0xC8, 0x08, 0x1A, 0x46, 0x15, 0x7C, 0x64, 0x53, 0xBD, 0xC8, 0x93, 0x41, 0xD3, 0x09, 0x2F, 0x3B, 0x53, 0x37, 0x87, 0x4C, 0xE5, 0xDE, 0x55, 0x9A, 0x56, 0xA2, 0xFF, 0xB7, 0xF4, 0x01, 0xF6, 0xE2, 0x8E, 0xEC, 0xAF, 0x4F, 0xDE, 0x5B, 0x60, 0xDE, 0xA7, 0x3D, 0x6B, 0x21, 0x82, 0xEF, 0x68, 0xE0, 0x7A, 0x82, 0x97, 0xF3, 0xC9, 0x59, 0xE1, 0x71, 0x39, 0xB5, 0xDE, 0xDC, 0x72, 0xC7, 0xA0, 0xE1, 0x03, 0xAF, 0xF8, 0x66, 0xE8, 0x9D, 0x1F, 0x62, 0xA1, 0xF6, 0xB9, 0x7B, 0x61, 0xBC, 0x05, 0x9B, 0xDE, 0x5A, 0x2A, 0x06, 0x08, 0x7E, 0xF7, 0x83, 0xA4, 0x41, 0xF2, 0x3D, 0xD1, 0x91, 0xC6, 0x92, 0xD0, 0x3C, 0x09, 0x7F, 0xF9, 0xEE, 0x83, 0x1F, 0x77, 0x15, 0xC6, 0xE5, 0x08, 0xBF, 0x47, 0x5E, 0x79, 0xA8, 0x35, 0x3E, 0x84, 0xB0, 0x6A, 0x93, 0x56, 0x04, 0x5C, 0x8F, 0xD0, 0x9F, 0xBA, 0x35, 0x87, 0x90, 0x69, 0xB9, 0xA3, 0xF4, 0x78, 0xFB, 0xD0, 0x51, 0x14, 0x3C, 0x13, 0xD7, 0x53, 0xBC, 0x45, 0xF3, 0x04, 0x0E, 0x85, 0x98, 0x5E, 0xFD, 0x6B, 0x14, 0x9E, 0xFA, 0x94, 0x55, 0xA1, 0x8E, 0x28, 0x94, 0xE6, 0xEA, 0x0B, 0xE5, 0x8F, 0x45, 0x1F, 0xF1, 0x15, 0x6F, 0x93, 0xCC, 0x71, 0x17, 0xB5, 0xD0, 0x91, 0xE9, 0xDD, 0x50, 0xD4, 0x1B, 0xFC, 0xCD, 0x44, 0xF2, 0xC4, 0xEB, 0x78, 0x12, 0xAE, 0xFD, 0x13, 0xC8, 0xB6, 0x8D, 0x7F, 0x01, 0x03, 0xBB, 0x6C, 0xA3, 0x8D, 0x23, 0x3B, 0x6A, 0xAD, 0xD0, 0x18, 0x45, 0xB7, 0xE4, 0x4D, 0x13, 0xC1, 0xCB, 0x15, 0x77, 0xD6, 0xC4, 0x35, 0x4B, 0x06, 0x39, 0x91, 0x34, 0x47, 0x87, 0xF8, 0xC0, 0xBE, 0x66, 0x7A, 0x74, 0x40, 0xB9, 0x89, 0x17, 0xAD, 0x64, 0xCC, 0x2E, 0xF2, 0xBC, 0x82, 0xEF, 0xC3, 0x39, 0x8B, 0x3B, 0x1B, 0x23, 0x85, 0x40, 0x75, 0x6C, 0xE9, 0xFC, 0x5E, 0xDD, 0x26, 0xCC, 0x20, 0xE7, 0x61, 0xD5, 0x92, 0xA1, 0xA0, 0x53, 0x0A, 0xA8, 0xBE, 0xFC, 0xFE, 0x8D, 0xAD, 0xBA, 0xC9, 0x9A, 0x41, 0x7C, 0xA0, 0x82, 0x7F, 0x49, 0x83, 0xFF, 0x5B, 0xE6, 0x56, 0x66, 0x9F, 0x2B, 0x5F, 0x98, 0x5F, 0xF6, 0xB1, 0x6C, 0x44, 0xBB, 0xEA, 0x13, 0x1D, 0x1F, 0xCC, 0x70, 0xFC, 0x53, 0xBF, 0x31, 0xEF, 0x22, 0x5D, 0x1F, 0x5D, 0x41, 0x86, 0x3B, 0x51, 0xB5, 0x7E, 0xA6, 0x5C, 0x61, 0x64, 0xF7, 0x53, 0x1A, 0xE4, 0x92, 0xEF, 0xA6, 0x41, 0x61, 0xB7, 0xDA, 0xBA, 0x3E, 0xF4, 0x58, 0x6F, 0x34, 0x59, 0xBE, 0x8A, 0x96, 0x23, 0x67, 0xDC, 0x27, 0x65, 0x97, 0xB9, 0x8E, 0x91, 0xFF, 0x59, 0x4E, 0xFE, 0x88, 0x49, 0xBA, 0xD4, 0xCF, 0x91, 0xB9, 0xE5, 0xF2, 0x44, 0xCF, 0x03, 0xCA, 0x96, 0x15, 0xBE, 0x12, 0x8E, 0x96, 0x95, 0x85, 0x33, 0x54, 0x4A, 0x56, 0xE7, 0x35, 0x99, 0x4B, 0x92, 0xE4, 0xEF, 0x0D, 0x5F, 0xAB, 0x54, 0xB7, 0x8E, 0xC6, 0x66, 0x41, 0xC7, 0x46, 0x3F, 0x22, 0x5D, 0x26, 0x1C, 0x14, 0x4F, 0x00, 0xA0, 0x27, 0x07, 0x41, 0xD7, 0xA5, 0x11, 0x99, 0x48, 0x33, 0x63, 0x5A, 0x8A, 0x9B, 0x67, 0x0C, 0xBF, 0xBE, 0xF2, 0x39, 0xBF, 0x83, 0x32, 0x7E, 0x24, 0x79, 0x43, 0xB2, 0x05, 0xDA, 0x68, 0xDB, 0x94, 0xE3, 0xF3};
std::vector<uint8_t> ss_MLKEM1024 = {0x75, 0x45, 0xCC, 0x45, 0x8E, 0x0A, 0x27, 0x4A, 0x83, 0xB1, 0x35, 0x54, 0x22, 0x4F, 0x0B, 0xD0, 0x1D, 0x57, 0xCC, 0x47, 0x75, 0xAD, 0x12, 0x46, 0x8D, 0x3F, 0xEE, 0x5B, 0x08, 0xC9, 0x3A, 0x6A};
