Minutes from OpenVDB TSC meeting, September 10th, 2025

Attendees: *Dan* B., *Jeff* L., *Nick* A., *Andre* P., *Greg* H., *Jonathan* S.

Additional Attendees: None

Regrets: *Ken* M.

Agenda:

1) Confirm quorum
2) Secretary  
3) Patch release 12.1.1
4) CI fixes and ASWF Docker image issues
5) Houdini version support and compilation issues
6) Charter update PR
7) Aging PRs and issue management
8) Maya plugins repository migration
9) File format work update
10) SIGGRAPH paper discussion - multi-resolution grids
11) SIMD and VCL integration
12) C++20 support
13) OpenVDB 13 release planning
14) Next meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Patch release 12.1.1

Nick reported plans for a patch release (12.1.1) to address two issues:
- An AX missed optimization fix for newer LLVM versions that's already in master (PR 2072)
- A compilation issue with the convex voxelizer/capsule code (GitHub issue 2075)

The AX optimization fix is crucial for newer LLVM versions and represents the main purpose of
the AX work that went into the release. Greg will investigate the capsule compilation issue on
Windows. The patch release will proceed once these issues are resolved.

4) CI fixes and ASWF Docker image issues

Nick presented PR 2077 which fixes multiple CI issues:
- ASWF Docker images are missing dependencies and have CMake issues
- PR reverts to using pinned year-specific images (e.g. 2024, 2025) instead of alias images
- Fixes all CI except Houdini CI on macOS which has compilation errors
- Auto-merge is enabled, so approval will merge immediately

5) Houdini version support and compilation issues

Discussion about Houdini 20.0 compilation failures on macOS CI:
- Template-related compilation errors appearing only on macOS
- Currently support Houdini 20.0, 20.5, and need to add 21.0
- Agreement to update macOS builder from 20.0 to 20.5 first, then add 21.0 support
- Plan to eventually drop 20.0 support when moving to OpenVDB 13
- Nick will investigate bumping Houdini versions in CI

6) Charter update PR

Jeff noted a PR updating the technical charter to point to Academy Foundation PDF instead of
local copy. Dan raised concerns about linking to a mutable reference (blob/main) rather than a
specific commit. Will ask for clarification on the intended behavior.

7) Aging PRs and issue management

Discussion of PR 2037 (quaternion optimization) which should be closed as the quaternion
library will likely be deprecated rather than optimized. Established process: leave comment
explaining reasoning, wait a few days for response, then close if no useful reply.

Nick reported cleaning up GitHub issues and added FVDB and NanoVDB labels to help filter the
~40% of issues related to these subprojects.

8) Maya plugins repository migration

Jonathan reported progress on moving Maya plugins to separate repository:
- Created openvdb-maya repository with filtered git history
- Resolved CLA issues for contributors
- Maya plugins haven't been built in years and serve as reference code only
- Dan approved the PR
- Need to add README to new repo and update main repo to remove plugins and point to new
  location

9) File format work update

Dan reported focusing on architectural aspects of file format changes rather than experimental
work. Priority is ABI-related changes that need to go in before the OpenVDB 13 cutoff. Looking
at migration path from old to new format and reorganizing code to minimize ABI impact.

10) SIGGRAPH paper discussion - multi-resolution grids

Dan shared a SIGGRAPH paper on large-scale two-phase FLIP simulation that claims significant
performance improvements over OpenVDB using a different multi-resolution grid structure. The
paper author provided source code for comparison.

Key discussion points:
- Performance claims may be due to larger leaf node sizes (16³ vs 8³) reducing surface area
- Use of Agner Fog's VCL SIMD library likely contributes to speedup
- Need to investigate whether improvements are from data structure or SIMD optimizations
- Should compare against NanoVDB GPU implementation
- VDB is configurable and could potentially use similar leaf sizes

11) SIMD and VCL integration

Discussion of integrating VCL (Vector Class Library) into OpenVDB:
- Nick has previous work on VCL integration that was closed but can be reopened
- Current approach requires opt-in SIMD flags (SSE 4.2, AVX)
- Jeff reported Houdini moving to x86-64-v3 (requiring AVX, AVX2, F16C)
- Potential to enable SIMD by default based on supported Houdini versions
- Challenges with cross-platform support (need SIMD for ARM/NEON)
- Agreement that SIMD support is important to stay competitive

12) C++20 support

Brief discussion noting C++20 is in VFX Reference Platform 2025. C++20 builds are already
working in weekly CI. C++20 offers useful features like designated initializers for named
parameters.

13) OpenVDB 13 release planning

Discussion of upcoming OpenVDB 13 release (target ~November 1st):
- Need to identify ABI-related changes that must go in
- VDB compression support requested for Houdini integration
- Focus on getting architectural/ABI changes in first, features can follow later
- VFX Platform page no longer shows required release date

14) Next meeting

Next meeting to discuss OpenVDB 13 release planning in more detail.
