Minutes from OpenVDB TSC meeting, October 8th, 2025

Attendees: *Ken* M., *Dan* B., *Andre* P., *Jeff* L., *Greg* H., *Nick* A.

Additional Attendees:

Regrets:

Agenda:

1) Confirm quorum
2) Secretary
3) Meeting notes process
4) Version 13 release planning
5) Half grid support (PR 2101)
6) I/O modes deprecation
7) CI status
8) Next meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Meeting notes process

Dan explained the current AI-assisted meeting notes process using Zoom transcripts. The process still requires human editing to match the existing format and filter out sensitive content. Dan volunteered to handle this meeting's notes.

4) Version 13 release planning

Dan reported that the target is to release version 13 by the end of October (approximately 3 weeks) to align with the next VFX Reference Platform.

No significant ABI changes are anticipated from Dan's I/O. work. While I/O.-related virtual functions could be removed to change ABI, this is not considered necessary for this release.

The team discussed semantic versioning practices. OpenVDB follows a yearly major version cadence similar to other VFX software, which isn't strictly semantic versioning but serves the practical need of maintaining 3 ABI versions and sunsetting older ones.

A deadline of October 22nd was set for any PRs and changes intended for version 13.

5) Half grid support (PR 2101)

Andre presented PR 2101 for half grid support, developed with Greg. The implementation introduces half precision floating-point grids using OpenEXR's half data type.

Key features implemented:
- Half data structure integrated into math.h and types.h
- Extended real grid types to include half grids
- Native half grid registration and initialization
- Support for level set operations, mesh to volume conversion, interpolation, and rendering
- Compute type promotion system that automatically promotes half to float for arithmetic operations

Technical challenges discussed:
- Clang compiler issues with double-to-float conversions requiring pragma workarounds
- Four unit tests still failing and need resolution
- Basic functionality tested including level set creation, morphology operations, and VDB rendering

The team discussed concerns about the compute type implementation and whether it should be configurable per algorithm. Nick raised questions about the design approach and requested time to review the implementation more thoroughly.

There was significant discussion about not rushing the implementation despite external pressure from Autodesk. The team agreed that getting the design right is more important than meeting arbitrary deadlines.

A compromise was proposed to split the PR into two parts:
1. Basic half grid registration and serialization support
2. Tool support with compute type infrastructure

This would allow the grid type to be available in version 13 even if not all tools support it initially.

Jeff noted that Side Effects will need to instantiate half grid support across all Houdini SOPs if it goes into version 13, which represents significant work but is necessary for first-class citizen status.

Nick emphasized the importance of getting the compute type design right before committing to it, as it will affect future algorithm implementations. The team agreed that the current approach doesn't preclude future improvements but should be carefully considered.

6) I/O modes deprecation

Dan requested approval for his PR that removes support for legacy I/O modes including:
- Node mask compression (pre-version 222)
- Legacy frustum functionality

Ken approved the changes. Dan will reach out to DreamWorks to notify them of the upcoming deprecation.

7) CI status

Nick reported that multiple CI builds are currently failing:
- Clang debug builds failing due to tolerance issues
- UBSAN checks failing
- NanoVDB CI failing for some CUDA versions
- Some Windows builds failing

The team agreed these issues need to be resolved before the version 13 release.

8) Next meeting

The team agreed to schedule an additional meeting next week (skipping the TAC meeting) to continue discussion of the half grid implementation and finalize version 13 plans.

Next regular meeting is October 22nd, 2025.