---
layout: news_item
title: "ORC 1.9.0 Released"
date: "2023-06-28 03:00:00 -0800"
author: dongjoon
version: 1.9.0
categories: [release]
---

The ORC team is excited to announce the release of ORC v1.9.0.

{% assign releaseName = "1.9.0" %}
{% include release_description.md %}

New Feature and Notable Changes:

- [ORC-961]({{site.jira}}/ORC-961): Expose metrics of the reader
- [ORC-1167]({{site.jira}}/ORC-1167): Support orc.row.batch.size configuration
- [ORC-1252]({{site.jira}}/ORC-1252): Expose io metrics for write operation
- [ORC-1301]({{site.jira}}/ORC-1301): Enforce C++ 17
- [ORC-1310]({{site.jira}}/ORC-1310): allowlist Support for plugin filter
- [ORC-1356]({{site.jira}}/ORC-1356): Use Intel AVX-512 instructions to accelerate the Rle-bit-packing decode
- [ORC-1385]({{site.jira}}/ORC-1385): Support schema evolution from numeric to numeric
- [ORC-1386]({{site.jira}}/ORC-1386): Support schema evolution from primitive to string group/decimal/timestamp

Improvements:
- [ORC-827]({{site.jira}}/ORC-827): Utilize Array copyOf
- [ORC-1170]({{site.jira}}/ORC-1170): Optimize the RowReader::seekToRow function
- [ORC-1232]({{site.jira}}/ORC-1232) Disable metrics collector by default
- [ORC-1278]({{site.jira}}/ORC-1278) Update Readme.md cmake to 3.12
- [ORC-1279]({{site.jira}}/ORC-1279) Update cmake version
- [ORC-1286]({{site.jira}}/ORC-1286) Replace DataBuffer with BlockBuffer in the BufferedOutputStream
- [ORC-1298]({{site.jira}}/ORC-1298) Support dedicated ColumnVectorBatch of numeric types
- [ORC-1302]({{site.jira}}/ORC-1302) Upgrade Github workflow to build on Windows
- [ORC-1306]({{site.jira}}/ORC-1306) Fixed indented code style for Java modules
- [ORC-1307]({{site.jira}}/ORC-1307) Add coding style enforcement
- [ORC-1314]({{site.jira}}/ORC-1314) Remove macros defined before C++11
- [ORC-1347]({{site.jira}}/ORC-1347) Use make_unique and make_shared when creating unique_ptr and shared_ptr
- [ORC-1348]({{site.jira}}/ORC-1348) TimezoneImpl constructor should pass std::vector<> & instead of std::vector<>
- [ORC-1349]({{site.jira}}/ORC-1349) Remove useless bufStream definition
- [ORC-1352]({{site.jira}}/ORC-1352) Remove ORC_\[NOEXCEPT\|NULLPTR\|OVERRIDE\|UNIQUE_PTR\] macro usages
- [ORC-1355]({{site.jira}}/ORC-1355) Writer::addUserMetadata change parameter to reference
- [ORC-1373]({{site.jira}}/ORC-1373) Add log when DynamicByteArray length overflow
- [ORC-1401]({{site.jira}}/ORC-1401) Allow writing an intermediate footer
- [ORC-1421]({{site.jira}}/ORC-1421) Use PyArrow 12.0.0 in document

The bug fixes:
- [ORC-1225]({{site.jira}}/ORC-1225) Bump maven-assembly-plugin to 3.4.2
- [ORC-1266]({{site.jira}}/ORC-1266) DecimalColumnVector resets the isRepeating flag in the nextVector method
- [ORC-1273]({{site.jira}}/ORC-1273) Bump opencsv to 5.7.0
- [ORC-1297]({{site.jira}}/ORC-1297) Bump opencsv to 5.7.1
- [ORC-1304]({{site.jira}}/ORC-1304) throw ParseError when using SearchArgument with nested struct
- [ORC-1315]({{site.jira}}/ORC-1315) Byte to integer conversions fail on platforms with unsigned char type
- [ORC-1320]({{site.jira}}/ORC-1320) Fix build break of C++ code on docker images
- [ORC-1363]({{site.jira}}/ORC-1363) Upgrade zookeeper to 3.8.1
- [ORC-1368]({{site.jira}}/ORC-1368) Bump commons-csv to 1.10.0
- [ORC-1398]({{site.jira}}/ORC-1398) Bump aircompressor to 0.24
- [ORC-1399]({{site.jira}}/ORC-1399) Fix boolean type with useTightNumericVector enabled
- [ORC-1433]({{site.jira}}/ORC-1433) Fix comment in the Vector.hh
- [ORC-1447]({{site.jira}}/ORC-1447) Fix a bug in CpuInfoUtil.cc to support ARM platform
- [ORC-1449]({{site.jira}}/ORC-1449) Add -Wno-unused-macros for Clang 14.0
- [ORC-1450]({{site.jira}}/ORC-1450) Stop enforcing override keyword
- [ORC-1453]({{site.jira}}/ORC-1453) Fix fall-through warning cases

The test changes:
- [ORC-1231]({{site.jira}}/ORC-1231) Update supported OS list in building.md
- [ORC-1233]({{site.jira}}/ORC-1233) Bump junit to 5.9.0
- [ORC-1234]({{site.jira}}/ORC-1234) Upgrade objenesis to 3.2 in Spark benchmark
- [ORC-1235]({{site.jira}}/ORC-1235) Bump avro to 1.11.1
- [ORC-1240]({{site.jira}}/ORC-1240) Update site README to use apache/orc-dev
- [ORC-1241]({{site.jira}}/ORC-1241) Use apache/orc-dev DockerHub repository in Docker tests
- [ORC-1250]({{site.jira}}/ORC-1250) Bump mockito to 4.7.0
- [ORC-1254]({{site.jira}}/ORC-1254) Add spotbugs check
- [ORC-1258]({{site.jira}}/ORC-1258) Bump byte-buddy to 1.12.14
- [ORC-1262]({{site.jira}}/ORC-1262) Bump maven-checkstyle-plugin to 3.2.0
- [ORC-1265]({{site.jira}}/ORC-1265) Upgrade spotbugs to 4.7.2
- [ORC-1267]({{site.jira}}/ORC-1267) Bump mockito to 4.8.0
- [ORC-1271]({{site.jira}}/ORC-1271) Bump spotbugs-maven-plugin to 4.7.2.0
- [ORC-1272]({{site.jira}}/ORC-1272) Bump byte-buddy to 1.12.16
- [ORC-1300]({{site.jira}}/ORC-1300) Update Spark to 3.3.1 and its dependencies
- [ORC-1303]({{site.jira}}/ORC-1303) Upgrade GoogleTest to 1.12.1
- [ORC-1318]({{site.jira}}/ORC-1318) Upgrade mockito.version to 4.9.0
- [ORC-1319]({{site.jira}}/ORC-1319) Upgrade byte-buddy to 1.12.19
- [ORC-1321]({{site.jira}}/ORC-1321) Bump checkstyle to 10.5.0
- [ORC-1322]({{site.jira}}/ORC-1322) Upgrade centos7 docker image to use gcc9
- [ORC-1324]({{site.jira}}/ORC-1324) Use Java 19 instead of 18 in GHA
- [ORC-1333]({{site.jira}}/ORC-1333) Bump mockito to 4.10.0
- [ORC-1341]({{site.jira}}/ORC-1341) Bump mockito to 4.11.0
- [ORC-1353]({{site.jira}}/ORC-1353) Bump byte-buddy to 1.12.21
- [ORC-1359]({{site.jira}}/ORC-1359) Bump byte-buddy to 1.12.22
- [ORC-1366]({{site.jira}}/ORC-1366) Bump checkstyle to 10.7.0
- [ORC-1367]({{site.jira}}/ORC-1367) Bump maven-enforcer-plugin to 3.2.1
- [ORC-1369]({{site.jira}}/ORC-1369) Bump byte-buddy to 1.12.23
- [ORC-1370]({{site.jira}}/ORC-1370) Bump snappy-java to 1.1.9.1
- [ORC-1374]({{site.jira}}/ORC-1374) Update Spark to 3.3.2
- [ORC-1379]({{site.jira}}/ORC-1379) Upgrade spotbugs to 4.7.3.2
- [ORC-1380]({{site.jira}}/ORC-1380) Upgrade checkstyle to 10.8.0
- [ORC-1394]({{site.jira}}/ORC-1394) Bump maven-assembly-plugin to 3.5.0
- [ORC-1397]({{site.jira}}/ORC-1397) Bump checkstyle to 10.9.2
- [ORC-1405]({{site.jira}}/ORC-1405) Bump spotbugs-maven-plugin to 4.7.3.4
- [ORC-1406]({{site.jira}}/ORC-1406) Bump maven-enforcer-plugin to 3.3.0
- [ORC-1408]({{site.jira}}/ORC-1408) Add testVectorBatchHasNull test case and comment
- [ORC-1415]({{site.jira}}/ORC-1415) Add Java 20 to GitHub Action CI
- [ORC-1417]({{site.jira}}/ORC-1417) Bump checkstyle to 10.10.0
- [ORC-1418]({{site.jira}}/ORC-1418) Bump junit to 5.9.3
- [ORC-1426]({{site.jira}}/ORC-1426) Use Java 21-ea instead of 20 in GitHub Action
- [ORC-1435]({{site.jira}}/ORC-1435) Bump maven-checkstyle-plugin to 3.3.0
- [ORC-1436]({{site.jira}}/ORC-1436) Bump snappy-java to 1.1.10.0
- [ORC-1452]({{site.jira}}/ORC-1452) Use the latest OS versions in variant tests

The tasks:
- [ORC-1164]({{site.jira}}/ORC-1264) Setting version to 1.9.0-SNAPSHOT
- [ORC-1218]({{site.jira}}/ORC-1218) Bump apache pom to 27
- [ORC-1219]({{site.jira}}/ORC-1219) Remove redundant toString
- [ORC-1237]({{site.jira}}/ORC-1237) Remove a wrong image link to article-footer.png
- [ORC-1239]({{site.jira}}/ORC-1239) Upgrade maven-shade-plugin to 3.3.0
- [ORC-1256]({{site.jira}}/ORC-1256) Publish test-jar to maven central
- [ORC-1259]({{site.jira}}/ORC-1259) Bump slf4j to 2.0.0
- [ORC-1269]({{site.jira}}/ORC-1269) Remove FindBugs
- [ORC-1270]({{site.jira}}/ORC-1270) Move opencsv dependency to the tools module.
- [ORC-1274]({{site.jira}}/ORC-1274) Add a checkstyle rule to ban starting LAND and LOR
- [ORC-1275]({{site.jira}}/ORC-1275) Bump maven-jar-plugin to 3.3.0
- [ORC-1276]({{site.jira}}/ORC-1276) Bump slf4j to 2.0.1
- [ORC-1277]({{site.jira}}/ORC-1277) Bump maven-shade-plugin to 3.4.0
- [ORC-1284]({{site.jira}}/ORC-1284) Add permissions to GitHub Action labeler
- [ORC-1296]({{site.jira}}/ORC-1296) Bump reproducible-build-maven-plugin to 0.16
- [ORC-1311]({{site.jira}}/ORC-1311) Bump maven-shade-plugin to 3.4.1
- [ORC-1316]({{site.jira}}/ORC-1316) Bump slf4j.version to 2.0.4
- [ORC-1334]({{site.jira}}/ORC-1334) Bump slf4j.version to 2.0.6
- [ORC-1335]({{site.jira}}/ORC-1335) Bump netty-all to 4.1.86.Final
- [ORC-1351]({{site.jira}}/ORC-1351) Update PR Labeler definition
- [ORC-1358]({{site.jira}}/ORC-1358) Use spotless to format pom files
- [ORC-1371]({{site.jira}}/ORC-1371) Remove unsupported SLF4J bindings from classpath
- [ORC-1372]({{site.jira}}/ORC-1372) Bump zstd to v1.5.4
- [ORC-1375]({{site.jira}}/ORC-1375) Cancel old running ci tasks when a pr has a new commit
- [ORC-1377]({{site.jira}}/ORC-1377) Enforce override keyword
- [ORC-1383]({{site.jira}}/ORC-1383) Upgrade aircompressor to 0.22
- [ORC-1395]({{site.jira}}/ORC-1395) Enforce license check
- [ORC-1396]({{site.jira}}/ORC-1396) Bump slf4j to 2.0.7
- [ORC-1410]({{site.jira}}/ORC-1410) Bump zstd to v1.5.5
- [ORC-1411]({{site.jira}}/ORC-1411) Remove Ubuntu18.04 from docker-based tests
- [ORC-1419]({{site.jira}}/ORC-1419) Bump protobuf-java to 3.22.3
- [ORC-1428]({{site.jira}}/ORC-1428) Setup GitHub Action CI on branch-1.9
- [ORC-1443]({{site.jira}}/ORC-1443) Enforce Java version
- [ORC-1444]({{site.jira}}/ORC-1444) Enforce JDK Bytecode version
- [ORC-1446]({{site.jira}}/ORC-1446) Publish snapshot from branch-1.9
