# RK3588 Release Note

## rk3588_bl32_v1.20.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-05-09 | rk3588_bl32_v1.20.bin | 1e844e4ca    | important |

### New

1. Add OEM OTP KEY hmac support for user ta.

### Fixed

| Index | Severity  | Update                                   | Issue description                | Issue source |
| ----- | --------- | ---------------------------------------- | -------------------------------- | ------------ |
| 1     | important | Merge official security patches          | Address potential security risks | -            |
| 2     | important | Fix the length supported by OEM otp key2 | Failed to burn OEM otp key2      | -            |

------

## rk3588_ddr_lp4_1848MHz_lp5_2112MHz_v1.19.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2025-04-21 | rk3588_ddr_lp4_1848MHz_lp5_2112MHz_v1.19.bin | ff1a08bde6   | important |

### New

1. Add RK3582 support.

------

## rk3588_bl31_v1.51.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-04-25 | rk3588_bl31_v1.51.elf | bc6030fac | important |

### New

1. Add the ddr debug interface to linux.

------

## rk3588_bl31_v1.50.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-13 | rk3588_bl31_v1.50.elf | b23ff75bb    | important |

### New

1. Add more hardware version support.

------

## rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.19.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2025-03-13 | rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.19.bin | ff1a08bde6   | important |

### New

1. Add RK3588 -B/RK3588S-B/RK3588S2-B support.

------

## rk3588_bl31_v1.49.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2025-03-03 | rk3588_bl31_v1.49.elf | 1653f2a08    | important |

### New

1. Optimize the uart usage flow during system suspend.
2. Reduce the BL31 firmware size.

------

## rk3588_bl31_v1.48.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-12-19 | rk3588_bl31_v1.48.elf | 040d2de11    | important |

### New

1. Support to config the sleep pin for system suspend.
2. Support to resets the hptimer after system suspend.
3. Optimize the hptimer usage flow.

------

## rk3588_bl32_v1.19.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-11-15 | rk3588_bl32_v1.19.bin | 57604957e    | important |

### New

1. Added support for Dolby library interfaces.

### Fixed

| Index | Severity  | Update                                                   | Issue description                                     | Issue source |
| ----- | --------- | -------------------------------------------------------- | ----------------------------------------------------- | ------------ |
| 1     | important | Support automatic file recovery after abnormal power off | Abnormal power off causes user ta cannot run normally | 517988       |

------

## rk3588_pcie_v2.20.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | -------- |
| 2024-11-05 | rk3588_pcie_v2.20.bin | 1f74d1059   | important     |

### New

1. Support setting pmic rst_fun as 1.

------

## rk3588_bl32_v1.18.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-10-31 | rk3588_bl32_v1.18.bin | 9f2aca7d1    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | check whether the rpmb key has been burned before changing security level | upgrading from weak security level to strong security level may result in rpmb key verification failure | -            |
| 2     | important | fixed RSA OAEP MGF1 algorithm                                | TA will report an error when using RSA algorithm OAEP MGF1 padding method | -            |
| 3     | important | fixed condition of whether secure boot is enabled            | Under unstable hardware conditions, it may be mistakenly believed that secure boot is enabled | -            |

------

## rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.18.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2024-09-05 | rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.18.bin | 9fa84341ce   | important |

### Warn

1. BL31 should be update to V1.47 or above.

### New

1. Enable dvfs/periodic training to increase SI margin.
2. Added support for (x16/x8)mixed packaging particles.

### Fixed

| Index | Severity  | Update                                                    | Issue description | Issue source |
| ----- | --------- | --------------------------------------------------------- | ----------------- | ------------ |
| 1     | important | Modified tTOT configuration to improve DRAM compatibility | -                 | -            |

------

## rk3588_bl31_v1.47.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-04 | rk3588_bl31_v1.47.elf | 92b1674a5    | important |

### New

1. Support to respond to interrupts of kernel in OPTEE.
2. Improve stability of VOP.
3. Restored status of dvfs/periodic training after system wake up.

------

## rk3588_bl32_v1.17.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-09-02 | rk3588_bl32_v1.17.bin | 6c78a7d8c    | important |

### New

1.  Support software TA encryption key, customers can use TA encryption function without burning the key.
2.  RPMB change read data to multiple times.
3.  Increase MPI_MEMPOOL_SIZE size.

------

## rk3588_bl31_v1.46.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-29 | rk3588_bl31_v1.46.elf | 588059758    | important |

### New

1. Support to config pmu_mcu in kernel.
2. Improve  stability of DFS in single chip lpddr5.

------

## rk3588_bl32_v1.16.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2024-04-16 | rk3588_bl32_v1.16.bin | 185dc3c92    | important |

### New

1.  Optimization parameter check to enhance security.
2.  Support printing TEE memory usage information.
3.  Hardware crypto supports addresses exceeding 4G.

------

## rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.17.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2024-04-12 | rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.17.bin | 3488111f83   | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed the error of pll_id setting when boot_fsp!=0，the default value of boot_fsp is 0. | Maybe hang in ddr initialization when boot_fsp is configured to a non-zero value. | -            |

------

## rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.16.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2024-02-04 | rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.16.bin | 9fffbe1e78   | important |

### New

1. Modify the LPDDR5 frequency to improve stability.
2. Add support dram with CS0 capacity less than CS1 capacity.
3. Modify the DERATEINT.mr4_read_interval configuration.

### Fixed

| Index | Severity  | Update                                      | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed derate issue with LPDDR5 of one rank. | Maybe hang in kernel when switch the frequency for LPDDR5 of one rank. | -            |

------

## rk3588_bl31_v1.45.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-12-27 | rk3588_bl31_v1.45.elf | 4ca8a8422    | important |

### New

1. Optimize the time of DFS atfter system resume.
2. Cpu switch to hight frequency when systeme resume.
3. Support config pvtpll parameters by sip.

------

## rk3588_pcie_v2.10.bin

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-12-18 | rk3588_pcie_v2.10.bin | 35f57cde3    | moderate |

### New

1. Update the version.

------

## rk3588_pcie_v2.00.bin

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-12-06 | rk3588_pcie_v2.00.bin | I3e280b78    | moderate |

### New

1. Fix bar capacity.

------

## rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.15.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2023-11-23 | rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.15.bin | d5483af87d   | important |

### New

1. Avoid PHY skew value greater than dll lock value，improve the stability for 528MHz.
2. Fix the data training process，improve the stability.
3. Resume ZQ background calibration for LPDDR5.

------

## rk3588_usbplug_v1.11.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2023-11-20 | rk3588_usbplug_v1.11.bin | dcac518e7    | important |

### New

1. Add rk3583 upgrade support.

------

## rk3583_ddr_lp4_1848MHz_lp5_2112MHz_v1.14.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2023-11-10 | rk3583_ddr_lp4_1848MHz_lp5_2112MHz_v1.14.bin | 73dffea49e   | important |

### New

1. Add RK3583 support.

------

## rk3588_bl31_v1.44.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-11-07 | rk3588_bl31_v1.44.elf | 4acbe711b    | important |

### New

1. Add pvtpll support rk3583.
2. Add support to read secure otp.
3. Optimize the time of dmc restore.

------

## rk3588_pcie_v1.00.bin

| Date       | File                  | Build commit | Severity |
| ---------- | --------------------- | ------------ | -------- |
| 2023-10-07 | rk3588_pcie_v1.00.bin | I01c2c7d7    | moderate |

### New

1. Add bare system executable firmware that supports PCIe EP initialization.

------

## rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.14.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2023-09-26 | rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.14.bin | 73dffea49e   | important |

### New

1. Improve the stability of LPDDR5.
2. Add fwver support.

------

## rk3588_bl32_v1.15.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-09-25 | rk3588_bl32_v1.15.bin | 62aa10b7     | important |

### New

1.  Support print firmware version, and support transmit firmware version to subsequent firmware.

------

## rk3588_bl31_v1.43.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-09-26 | rk3588_bl31_v1.43.elf | 24b7dd41a    | important |

### New

1. Supports to pass bl31 version number through rk atags.
2. Support to configure wake sources for virtual-poweroff through dts.

------

## rk3588_spl_v1.13.bin

| Date       | File                 | Build commit | Severity  |
| ---------- | :------------------- | ------------ | --------- |
| 2023-09-25 | rk3588_spl_v1.13.bin | e4e124926e   | important |

### New

1. Print and pass the firmware version number.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the issue that the backup image is not loaded when the SPL load or check u-boot.dtb fails | When u-boot.dtb of the first uboot.img is corrupted, SPL doesn't load the backup image. | -            |
------

## rk3588_bl31_v1.42.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-09-09 | rk3588_bl31_v1.42.elf | 87bcc5dfe    | important |

### New

1. Optimize the time of system resume.
2. Support any cpu to do system suspend/resume.
3. Support all pwm int to wakeup when virtual-poweroff.

------

## rk3588_bl32_v1.14.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-28 | rk3588_bl32_v1.14.bin | b5340fd65    | important |

### New

1.  Pseudo random number seed will be set by default.
2.  Supports read and write security flag interfaces.
3.  Support check ta encryption key is written.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                 | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------- | ------------ |
| 1     | important | Fixed hardware crypto probability crash issue after enabling dynamic memory | Error will be reported when using hardware crypto | -            |

------

## rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.13.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2023-08-11 | rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.13.bin | 25cee80c4f   | important |

### Warn

1. BL31 should be update to V1.41 or above.

### New

1. Improve the stability of LPDDR5 528MHz.
2. Update vref_inner for each channel in fsp_param to improve stability.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                         | Issue source |
| ----- | --------- | ------------------------------------------------------------ | --------------------------------------------------------- | ------------ |
| 1     | important | Fixed init fail issue that boot in high temperature environment | Panic in ddrbin when boot in high temperature environment | -            |

------

## rk3588_bl31_v1.41.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-08-10 | rk3588_bl31_v1.41.elf | b7c5102a2    | important |

### New

1. Support L3 partition.
2. Update configuration of ddr vref_inner.
3. Support to config MCU sleep parameter through DTS.

------

## rk3588_bl31_v1.40.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-07-13 | rk3588_bl31_v1.40.elf | dc1125f48    | important |

### New

1. Add support to reset vop sub mem pd.

------

## rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.12.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2023-07-06 | rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.12.bin | 52218f4949   | important |

### New

1. Add support print training result and mr value.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Fixed init fail issue that max freq between 1066-1600MHz     | Panic in ddrbin when max DDR freq between 1066-1600MHz.      | -            |
| 2     | important | Fixed the issue painc in ddrbin caused by multiple initialization of DDR | When the first SPL firmware failed to load, reloading the second firmware would result in repeated initialization of the DDR. This caused a panic in ddrbin. | -            |

------

## rk3588_bl31_v1.39.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-06-27 | rk3588_bl31_v1.39.elf | 001b4889e    | important |

### New

1. Change read size to 128 bytes.
2. Adjust pvtpll table by otp.
3. Modify pvtpll table for rk3588j/m.

------

## rk3588_bl31_v1.38.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-05-09 | rk3588_bl31_v1.38.elf | 3389cfdda    | important |

### Warn

1. DDR bin should be update to V1.11 or above.

### New

1. Update configuration of ddr lp5 mr.
2. Improve the stability of hdmirx.
3. Support ddr spread spectrum mode.

------

## rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.11.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2023-05-09 | rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.11.bin | f1474cf52f   | important |

### Warn

1. BL31 should be update to V1.38 or above.

### New

1. Added more print info when initialization fails to help locate soldering issues.
2. Optimizing boot time.
3. Enable per bank refresh function.
4. LPDDR5 4 channels use different write vref values to improve stability.
5. First init LPDDR4x.
6. LPDDR5 cavref update to 36%.
7. Add support spread spectrum mode.

------

## rk3588_bl32_v1.13.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-04-19 | rk3588_bl32_v1.13.bin | 7f1ea6d6e    | important |

### New

1. OTP supports burst read to accelerate BL32 startup speed.
2. Kernel support read secure boot flag and public key hash.
3. Support dynamic shared memory, and the secure and normal world can transfer more larger data.
4. BL32 supports pstore, and the kernel can view print info of BL32 through pstore node.

------

## rk3588_bl31_v1.37.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-03-08 | rk3588_bl31_v1.37.elf | 9609b9c19    | important |

### New

1. Save/restore u2phy_grf registers when system suspend/resume.
2. Save/restore more ddr related registers when system suspend/resume.
3. Compatible with system suspend/resume in QNX.

------

## rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.10.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2022-11-21 | rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.10.bin | 75d050770f   | important |

### New

1. Pageclose can be enable/disable by ddrbin_tool.

### Fixed

| Index | Severity  | Update                       | Issue description                                            | Issue source |
| ----- | --------- | ---------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | fix total 24GB bug           | If the DDR total capacity is 24GB, it will be stuck and unable to enter kernel. | -            |
| 2     | important | fix LP4/LP4X stability issue | Some LP4/LP4X board need to update read odt to 40ohm to fix stability issue. Note: BL31 should be update to V1.37. | -            |
| 3     | important | improve LP5 performance      | LPDDR5 timing tWTR  calculate error lead to slow performance | -            |

------

## rk3588_bl31_v1.36.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-01-30 | rk3588_bl31_v1.36.elf | 78ee25fe7    | important |

### New

1. Supports analyze infrared signals of various protocols during system suspend by software, which needs to be used together with mcu.

------

## rk3588_bl31_v1.35.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-01-16 | rk3588_bl31_v1.35.elf | bd7bac37a    | important |

### New

1. Improve the stability of hdmirx.

------

## rk3588_bl31_v1.34.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2023-01-10 | rk3588_bl31_v1.34.elf | e63a16361    | important |

### New

1. Support hptimer to use soft adjust mode.
2. Support pvtpll to add length.

### Fixed

| Index | Severity  | Update                                                | Issue description                                            | Issue source |
| ----- | --------- | ----------------------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Avoid pmu mcu to boot accidentally in system suspend. | With pmu mcu's accidental boot, linux kernel's code and data may be overwrite after system resume. | -            |

------

## rk3588_spl_v1.12.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-12-26 | rk3588_spl_v1.12.bin  | 5f53abfa     | important |

### New

1. Support SPL AB.

------

## rk3588_bl31_v1.33.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-12-07 | rk3588_bl31_v1.33.elf | 17b41886e    | important |

### New

1. Support rk3588m, rk3588j.

------

## rk3588_usbplug_v1.10.bin

| Date       | File                     | Build commit | Severity  |
| ---------- | :----------------------- | ------------ | --------- |
| 2022-11-22 | rk3588_usbplug_v1.10.bin | b0e3c43c2    | important |

### New

1. Improve compatibility.

------

## rk3588_bl31_v1.32.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-11-21 | rk3588_bl31_v1.32.elf | e529a2760    | important |

### New

1. Support bus auto CS.

------

## rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.09.bin

| Date       | File                                         | Build commit | Severity  |
| ---------- | :------------------------------------------- | ------------ | --------- |
| 2022-11-21 | rk3588_ddr_lp4_2112MHz_lp5_2736MHz_v1.09.bin | a930779e06   | important |

### New

1. Derate/perbank refresh can be enable/disable by ddrbin_tool.
2. Support pstore function.
3. Boot FSP configurable by ddrbin_tool.
4. Enable LPDDR5 DMC function.
5. Support LPDDR5 byte mode DRAM.
6. Recycle 256MB memory(overlap with REG space). This function can be disable by ddrbin_tool.

### Fixed

| Index | Severity  | Update                                   | Issue description                                            | Issue source |
| ----- | --------- | ---------------------------------------- | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix WRTRN Bug                            | Fix WRTRN bug when ddr freq between 533MHz - 1066MHz         | -            |
| 2     | important | Fix ZQCALIB bug                          | Increase auto ZQCALIB command period to 470ms                | -            |
| 3     | important | Fix 528M bug                             | 528MHz undo RDTRN, SW*skew should be clean before clean before switch to 528MHz. | -            |
| 4     | important | Improve LPDDR5 stability and performance | Fix some LPDDR5 timing like rd2wr,wr2rd and hash config to improve stability and performance. | -            |
| 5     | important | LP4/LP4x support 32GB cap                | LP4/LP4x support 32GB cap                                    | -            |

------

## rk3588_bl31_v1.31.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-11-09 | rk3588_bl31_v1.31.elf | 91e396185    | important |

### New

1. Enable RK_ENABLE_A76_L2_FLUSH_TO_L3 function.
2. Support amp function.

### Fixed

| Index | Severity  | Update                                                       | Issue description | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ----------------- | ------------ |
| 1     | important | Save/restore some performance setting in system suspend/resume | -                 | -            |

------

## rk3588_bl31_v1.30.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-10-12 | rk3588_bl31_v1.30.elf | 1450d21e8    | important |

### New

1. Support pstore.

------

## rk3588_bl31_v1.29.elf

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ----------- | --------- |
| 2022-09-29 | rk3588_bl31_v1.29.elf | 686b5c48b   | important |

### New

1. Add A55 AT speculative patches.
2. Add LPDDR5 DFS patches, support DFS between rows.
3. Config FW-DSU region according to the specific DDR channel.

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Fix problem about CEC wakeup.                  | When waiting for CEC wakeup source in system suspend, gpio1/3 irq will wakeup both AP and mcu . | -        |
| 2     | important | Fix configuration about ddr.                   | Fix ddr-unstable problem.                                    | -        |
| 3     | important | Fix problem in system suspend if disable uart. | If loader disable uart, system suspend will panic.           | -        |

------

## rk3588_bl32_v1.12.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-09-20 | rk3588_bl32_v1.12.bin | 4542e1efd    | important |

### New

1. Config FW-DSU region according to the specific DDR channel.

------

## rk3588_bl32_v1.11.bin

| Date       | File                  | Build commit | Severity  |
| ---------- | :-------------------- | ------------ | --------- |
| 2022-09-15 | rk3588_bl32_v1.11.bin | d84087907    | important |

### Fixed

| Index | Severity  | Update                                                       | Issue description                                            | Issue source |
| ----- | --------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------ |
| 1     | important | Solve the problem that OPTEE is stuck during startup when printing is closed | User use /rkbin/tools/ddrbin_tool to close printing ,  then rk_atags will notify OPTEE to disable printing, When OPTEE starts, it will be stuck and unable to enter U-Boot | -            |

------

