# The Docker client object


{{autogenerated}}

## Sub-commands

* [`docker.buildx`](sub-commands/buildx.md)
* [`docker.compose`](sub-commands/compose.md)
* [`docker.config`](sub-commands/config.md)
* [`docker.container`](sub-commands/container.md)
* [`docker.context`](sub-commands/context.md)
* [`docker.image`](sub-commands/image.md)
* [`docker.manifest`](sub-commands/manifest.md)
* [`docker.network`](sub-commands/network.md)
* [`docker.node`](sub-commands/node.md)
* [`docker.secret`](sub-commands/secret.md)
* [`docker.service`](sub-commands/service.md)
* [`docker.stack`](sub-commands/stack.md)
* [`docker.swarm`](sub-commands/swarm.md)
* [`docker.system`](sub-commands/system.md)
* [`docker.trust`](sub-commands/trust.md)
* [`docker.volume`](sub-commands/volume.md)
* [`podman.pod`](sub-commands/pod.md)


## Other commands

They're actually aliases

* [`docker.attach`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.attach)
* [`docker.build`](sub-commands/buildx.md#python_on_whales.components.buildx.cli_wrapper.BuildxCLI.build)
* [`docker.commit`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.commit)
* [`docker.copy`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.copy)
* [`docker.create`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.create)
* [`docker.diff`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.diff)
* [`docker.execute`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.execute)
* [`docker.export`](sub-commands/container.md#python_on_whales.components.image.cli_wrapper.ImageCLI.export)
* [`docker.images`](sub-commands/image.md#python_on_whales.components.image.cli_wrapper.ImageCLI.list)
* [`docker.import_`](sub-commands/image.md#python_on_whales.components.image.cli_wrapper.ImageCLI.import_)
* [`docker.info`](sub-commands/system.md#python_on_whales.components.system.cli_wrapper.SystemCLI.info)
* [`docker.kill`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.kill)
* [`docker.load`](sub-commands/image.md#python_on_whales.components.image.cli_wrapper.ImageCLI.load)
* [`docker.logs`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.logs)
* [`docker.pause`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.pause)
* [`docker.ps`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.list)
* [`docker.pull`](sub-commands/image.md#python_on_whales.components.image.cli_wrapper.ImageCLI.pull)
* [`docker.push`](sub-commands/image.md#python_on_whales.components.image.cli_wrapper.ImageCLI.push)
* [`docker.rename`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.rename)
* [`docker.restart`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.rename)
* [`docker.remove`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.rename)
* [`docker.run`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.rename)
* [`docker.save`](sub-commands/image.md#python_on_whales.components.image.cli_wrapper.ImageCLI.save)
* [`docker.start`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.start)
* [`docker.stats`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.stats)
* [`docker.stop`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.stop)
* [`docker.tag`](sub-commands/image.md#python_on_whales.components.image.cli_wrapper.ImageCLI.tag)
* [`docker.top`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.top)
* [`docker.unpause`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.unpause)
* [`docker.update`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.update)
* [`docker.wait`](sub-commands/container.md#python_on_whales.components.container.cli_wrapper.ContainerCLI.wait)


## About multithreading and multiprocessing

Behind the scenes, Python on whales calls the Docker command line interface with
subprocess. The Python on whales client does not store any intermediate state so it's safe 
to use with multithreading. 

The Docker objects store some intermediate states (the attributes 
that you would normally get with `docker ... inspect`but no logic in 
the codebase depends on those attributes. They're just here so that users can look at them. 
So you can share them between process/threads and pickle containers, images, networks...

The Docker daemon works with its own objects internally and handles concurrent and conflicting requests. 
For example, if you create two containers with the same name from different threads, only one will 
succeed. If you pull the same docker image from multiple processes/threads, the Docker daemon will 
only pull the image and layers once.

Just be careful with some scenario similar to this one

```
Thread 1: my_container = docker.run(..., detach=True)
...
# my_container finishes
...
Thread 2: docker.container.prune()
...
Thread 1: docker.logs(my_container)  # will fail because the container was removed by thread 2
```

In the end, unless you use this type of logic in your code, 
Python-on-whales is safe to use with multithreading and multiprocessing.


## The Docker/Podman CLI

Python-on-whales needs the Docker or Podman CLI to work (unlike docker-py).
Most of the time, users already have the CLI installed on their machines. It's possible to 
verify that the CLI is there by doing `docker --help` (or `podman --help`) in the command line.

Sometimes, the CLI might not be available on the system, it can happen if you want to control
Docker from within a container with `-v /var/run/docker.sock:/var/run/docker.sock`, or if you
want to connect to a remote daemon with the `host` argument.

Instructions for installing Docker can be found at <https://docs.docker.com/engine/install/>,
and Podman at <https://podman.io/docs/installation/>. Note that if connecting to Docker/Podman
remotely then the Docker daemon (`dockerd`) is not needed, and similarly for Podman it is
possible to use `podman-remote` (available as a static binary from
<https://github.com/containers/podman/releases/latest>).

Previously, when using python-on-whales, the Docker CLI was downloaded automatically, but
this functionality was removed under <https://github.com/gabrieldemarmiesse/python-on-whales/pull/633>.


### Handling an unavailable client

Trying to use Python-on-whales when it cannot find or download a Docker client binary
will trigger a `python_on_whales.ClientNotFoundError`. You can use a try-except around 
a first `docker.ps()` call to handle the case when Python-on-whales won't work.
