/* SPDX-License-Identifier: GPL-2.0+ OR BSD-3-Clause */
/*
 * Copyright (C) 2018, STMicroelectronics - All Rights Reserved
 *
 */

#ifndef _DT_BINDINGS_CLOCK_STM32MP13_CLKSRC_H_
#define _DT_BINDINGS_CLOCK_STM32MP13_CLKSRC_H_

/* PLL output is enable when x=1, with x=p,q or r */
#define PQR(p, q, r)	(((p) & 1) | (((q) & 1) << 1) | (((r) & 1) << 2))

/* st,clksrc: mandatory clock source */

#define CMD_DIV		0
#define CMD_MUX		1
#define CMD_CLK		2
#define CMD_RESERVED1	3

#define CMD_SHIFT	26
#define CMD_MASK	0xFC000000
#define CMD_DATA_MASK	0x03FFFFFF

#define DIV_ID_SHIFT	8
#define DIV_ID_MASK	0x0000FF00

#define DIV_DIVN_SHIFT	0
#define DIV_DIVN_MASK	0x000000FF

#define MUX_ID_SHIFT	4
#define MUX_ID_MASK	0x00000FF0

#define MUX_SEL_SHIFT	0
#define MUX_SEL_MASK	0x0000000F

#define CLK_ID_MASK	GENMASK_32(19, 11)
#define CLK_ID_SHIFT	11
#define CLK_ON_MASK	0x00000400
#define CLK_ON_SHIFT	10
#define CLK_DIV_MASK	GENMASK_32(9, 4)
#define CLK_DIV_SHIFT	4
#define CLK_SEL_MASK	GENMASK_32(3, 0)
#define CLK_SEL_SHIFT	0

#define DIV_PLL1DIVP	0
#define DIV_PLL2DIVP	1
#define DIV_PLL2DIVQ	2
#define DIV_PLL2DIVR	3
#define DIV_PLL3DIVP	4
#define DIV_PLL3DIVQ	5
#define DIV_PLL3DIVR	6
#define DIV_PLL4DIVP	7
#define DIV_PLL4DIVQ	8
#define DIV_PLL4DIVR	9
#define DIV_MPU		10
#define DIV_AXI		11
#define DIV_MLAHB	12
#define DIV_APB1	13
#define DIV_APB2	14
#define DIV_APB3	15
#define DIV_APB4	16
#define DIV_APB5	17
#define DIV_APB6	18
#define DIV_RTC		19
#define DIV_MCO1	20
#define DIV_MCO2	21
#define DIV_HSI		22
#define DIV_TRACE	23
#define DIV_ETH1PTP	24
#define DIV_ETH2PTP	25
#define DIV_MAX		26

#define DIV(div_id, div)	((CMD_DIV << CMD_SHIFT) |\
				 ((div_id) << DIV_ID_SHIFT |\
				 (div)))

#define CLKSRC(mux_id, sel)	((CMD_MUX << CMD_SHIFT) |\
				 ((mux_id) << MUX_ID_SHIFT |\
				 (sel)))

/* MCO output is enable */
#define MCO_SRC(mco_id, sel)	((CMD_CLK << CMD_SHIFT) |\
				 (((mco_id) << CLK_ID_SHIFT) |\
				 (sel)) | CLK_ON_MASK)

#define MCO_DISABLED(mco_id)	((CMD_CLK << CMD_SHIFT) |\
				 ((mco_id) << CLK_ID_SHIFT))

/* CLK output is enable */
#define CLK_SRC(clk_id, sel)	((CMD_CLK << CMD_SHIFT) |\
				 (((clk_id) << CLK_ID_SHIFT) |\
				 (sel)) | CLK_ON_MASK)

#define CLK_DISABLED(clk_id)	((CMD_CLK << CMD_SHIFT) |\
				 ((clk_id) << CLK_ID_SHIFT))

#define MUX_MPU			0
#define MUX_AXI			1
#define MUX_MLAHB		2
#define MUX_PLL12		3
#define MUX_PLL3		4
#define MUX_PLL4		5
#define MUX_RTC			6
#define MUX_MCO1		7
#define MUX_MCO2		8
#define MUX_CKPER		9
#define MUX_KERNEL_BEGIN	10
#define MUX_ADC1		10
#define MUX_ADC2		11
#define MUX_DCMIPP		12
#define MUX_ETH1		13
#define MUX_ETH2		14
#define MUX_FDCAN		15
#define MUX_FMC			16
#define MUX_I2C12		17
#define MUX_I2C3		18
#define MUX_I2C4		19
#define MUX_I2C5		20
#define MUX_LPTIM1		21
#define MUX_LPTIM2		22
#define MUX_LPTIM3		23
#define MUX_LPTIM45		24
#define MUX_QSPI		25
#define MUX_RNG1		26
#define MUX_SAES		27
#define MUX_SAI1		28
#define MUX_SAI2		29
#define MUX_SDMMC1		30
#define MUX_SDMMC2		31
#define MUX_SPDIF		32
#define MUX_SPI1		33
#define MUX_SPI23		34
#define MUX_SPI4		35
#define MUX_SPI5		36
#define MUX_STGEN		37
#define MUX_UART1		38
#define MUX_UART2		39
#define MUX_UART35		40
#define MUX_UART4		41
#define MUX_UART6		42
#define MUX_UART78		43
#define MUX_USBO		44
#define MUX_USBPHY		45
#define MUX_MAX			46

#define CLK_MPU_HSI		CLKSRC(MUX_MPU, 0)
#define CLK_MPU_HSE		CLKSRC(MUX_MPU, 1)
#define CLK_MPU_PLL1P		CLKSRC(MUX_MPU, 2)
#define CLK_MPU_PLL1P_DIV	CLKSRC(MUX_MPU, 3)

#define CLK_AXI_HSI		CLKSRC(MUX_AXI, 0)
#define CLK_AXI_HSE		CLKSRC(MUX_AXI, 1)
#define CLK_AXI_PLL2P		CLKSRC(MUX_AXI, 2)

#define CLK_MLAHBS_HSI		CLKSRC(MUX_MLAHB, 0)
#define CLK_MLAHBS_HSE		CLKSRC(MUX_MLAHB, 1)
#define CLK_MLAHBS_CSI		CLKSRC(MUX_MLAHB, 2)
#define CLK_MLAHBS_PLL3		CLKSRC(MUX_MLAHB, 3)

#define CLK_PLL12_HSI		CLKSRC(MUX_PLL12, 0)
#define CLK_PLL12_HSE		CLKSRC(MUX_PLL12, 1)

#define CLK_PLL3_HSI		CLKSRC(MUX_PLL3, 0)
#define CLK_PLL3_HSE		CLKSRC(MUX_PLL3, 1)
#define CLK_PLL3_CSI		CLKSRC(MUX_PLL3, 2)

#define CLK_PLL4_HSI		CLKSRC(MUX_PLL4, 0)
#define CLK_PLL4_HSE		CLKSRC(MUX_PLL4, 1)
#define CLK_PLL4_CSI		CLKSRC(MUX_PLL4, 2)

#define CLK_RTC_DISABLED	CLK_DISABLED(RTC)
#define CLK_RTC_LSE		CLK_SRC(RTC, 1)
#define CLK_RTC_LSI		CLK_SRC(RTC, 2)
#define CLK_RTC_HSE		CLK_SRC(RTC, 3)

#define CLK_MCO1_HSI		CLK_SRC(CK_MCO1, 0)
#define CLK_MCO1_HSE		CLK_SRC(CK_MCO1, 1)
#define CLK_MCO1_CSI		CLK_SRC(CK_MCO1, 2)
#define CLK_MCO1_LSI		CLK_SRC(CK_MCO1, 3)
#define CLK_MCO1_LSE		CLK_SRC(CK_MCO1, 4)
#define CLK_MCO1_DISABLED	CLK_DISABLED(CK_MCO1)

#define CLK_MCO2_MPU		CLK_SRC(CK_MCO2, 0)
#define CLK_MCO2_AXI		CLK_SRC(CK_MCO2, 1)
#define CLK_MCO2_MLAHB		CLK_SRC(CK_MCO2, 2)
#define CLK_MCO2_PLL4		CLK_SRC(CK_MCO2, 3)
#define CLK_MCO2_HSE		CLK_SRC(CK_MCO2, 4)
#define CLK_MCO2_HSI		CLK_SRC(CK_MCO2, 5)
#define CLK_MCO2_DISABLED	CLK_DISABLED(CK_MCO2)

#define CLK_CKPER_HSI		CLKSRC(MUX_CKPER, 0)
#define CLK_CKPER_CSI		CLKSRC(MUX_CKPER, 1)
#define CLK_CKPER_HSE		CLKSRC(MUX_CKPER, 2)
#define CLK_CKPER_DISABLED	CLKSRC(MUX_CKPER, 3)

#define CLK_I2C12_PCLK1		CLKSRC(MUX_I2C12, 0)
#define CLK_I2C12_PLL4R		CLKSRC(MUX_I2C12, 1)
#define CLK_I2C12_HSI		CLKSRC(MUX_I2C12, 2)
#define CLK_I2C12_CSI		CLKSRC(MUX_I2C12, 3)

#define CLK_I2C3_PCLK6		CLKSRC(MUX_I2C3, 0)
#define CLK_I2C3_PLL4R		CLKSRC(MUX_I2C3, 1)
#define CLK_I2C3_HSI		CLKSRC(MUX_I2C3, 2)
#define CLK_I2C3_CSI		CLKSRC(MUX_I2C3, 3)

#define CLK_I2C4_PCLK6		CLKSRC(MUX_I2C4, 0)
#define CLK_I2C4_PLL4R		CLKSRC(MUX_I2C4, 1)
#define CLK_I2C4_HSI		CLKSRC(MUX_I2C4, 2)
#define CLK_I2C4_CSI		CLKSRC(MUX_I2C4, 3)

#define CLK_I2C5_PCLK6		CLKSRC(MUX_I2C5, 0)
#define CLK_I2C5_PLL4R		CLKSRC(MUX_I2C5, 1)
#define CLK_I2C5_HSI		CLKSRC(MUX_I2C5, 2)
#define CLK_I2C5_CSI		CLKSRC(MUX_I2C5, 3)

#define CLK_SPI1_PLL4P		CLKSRC(MUX_SPI1, 0)
#define CLK_SPI1_PLL3Q		CLKSRC(MUX_SPI1, 1)
#define CLK_SPI1_I2SCKIN	CLKSRC(MUX_SPI1, 2)
#define CLK_SPI1_CKPER		CLKSRC(MUX_SPI1, 3)
#define CLK_SPI1_PLL3R		CLKSRC(MUX_SPI1, 4)

#define CLK_SPI23_PLL4P		CLKSRC(MUX_SPI23, 0)
#define CLK_SPI23_PLL3Q		CLKSRC(MUX_SPI23, 1)
#define CLK_SPI23_I2SCKIN	CLKSRC(MUX_SPI23, 2)
#define CLK_SPI23_CKPER		CLKSRC(MUX_SPI23, 3)
#define CLK_SPI23_PLL3R		CLKSRC(MUX_SPI23, 4)

#define CLK_SPI4_PCLK6		CLKSRC(MUX_SPI4, 0)
#define CLK_SPI4_PLL4Q		CLKSRC(MUX_SPI4, 1)
#define CLK_SPI4_HSI		CLKSRC(MUX_SPI4, 2)
#define CLK_SPI4_CSI		CLKSRC(MUX_SPI4, 3)
#define CLK_SPI4_HSE		CLKSRC(MUX_SPI4, 4)
#define CLK_SPI4_I2SCKIN	CLKSRC(MUX_SPI4, 5)

#define CLK_SPI5_PCLK6		CLKSRC(MUX_SPI5, 0)
#define CLK_SPI5_PLL4Q		CLKSRC(MUX_SPI5, 1)
#define CLK_SPI5_HSI		CLKSRC(MUX_SPI5, 2)
#define CLK_SPI5_CSI		CLKSRC(MUX_SPI5, 3)
#define CLK_SPI5_HSE		CLKSRC(MUX_SPI5, 4)

#define CLK_UART1_PCLK6		CLKSRC(MUX_UART1, 0)
#define CLK_UART1_PLL3Q		CLKSRC(MUX_UART1, 1)
#define CLK_UART1_HSI		CLKSRC(MUX_UART1, 2)
#define CLK_UART1_CSI		CLKSRC(MUX_UART1, 3)
#define CLK_UART1_PLL4Q		CLKSRC(MUX_UART1, 4)
#define CLK_UART1_HSE		CLKSRC(MUX_UART1, 5)

#define CLK_UART2_PCLK6		CLKSRC(MUX_UART2, 0)
#define CLK_UART2_PLL3Q		CLKSRC(MUX_UART2, 1)
#define CLK_UART2_HSI		CLKSRC(MUX_UART2, 2)
#define CLK_UART2_CSI		CLKSRC(MUX_UART2, 3)
#define CLK_UART2_PLL4Q		CLKSRC(MUX_UART2, 4)
#define CLK_UART2_HSE		CLKSRC(MUX_UART2, 5)

#define CLK_UART35_PCLK1	CLKSRC(MUX_UART35, 0)
#define CLK_UART35_PLL4Q	CLKSRC(MUX_UART35, 1)
#define CLK_UART35_HSI		CLKSRC(MUX_UART35, 2)
#define CLK_UART35_CSI		CLKSRC(MUX_UART35, 3)
#define CLK_UART35_HSE		CLKSRC(MUX_UART35, 4)

#define CLK_UART4_PCLK1		CLKSRC(MUX_UART4, 0)
#define CLK_UART4_PLL4Q		CLKSRC(MUX_UART4, 1)
#define CLK_UART4_HSI		CLKSRC(MUX_UART4, 2)
#define CLK_UART4_CSI		CLKSRC(MUX_UART4, 3)
#define CLK_UART4_HSE		CLKSRC(MUX_UART4, 4)

#define CLK_UART6_PCLK2		CLKSRC(MUX_UART6, 0)
#define CLK_UART6_PLL4Q		CLKSRC(MUX_UART6, 1)
#define CLK_UART6_HSI		CLKSRC(MUX_UART6, 2)
#define CLK_UART6_CSI		CLKSRC(MUX_UART6, 3)
#define CLK_UART6_HSE		CLKSRC(MUX_UART6, 4)

#define CLK_UART78_PCLK1	CLKSRC(MUX_UART78, 0)
#define CLK_UART78_PLL4Q	CLKSRC(MUX_UART78, 1)
#define CLK_UART78_HSI		CLKSRC(MUX_UART78, 2)
#define CLK_UART78_CSI		CLKSRC(MUX_UART78, 3)
#define CLK_UART78_HSE		CLKSRC(MUX_UART78, 4)

#define CLK_LPTIM1_PCLK1	CLKSRC(MUX_LPTIM1, 0)
#define CLK_LPTIM1_PLL4P	CLKSRC(MUX_LPTIM1, 1)
#define CLK_LPTIM1_PLL3Q	CLKSRC(MUX_LPTIM1, 2)
#define CLK_LPTIM1_LSE		CLKSRC(MUX_LPTIM1, 3)
#define CLK_LPTIM1_LSI		CLKSRC(MUX_LPTIM1, 4)
#define CLK_LPTIM1_CKPER	CLKSRC(MUX_LPTIM1, 5)

#define CLK_LPTIM2_PCLK3	CLKSRC(MUX_LPTIM2, 0)
#define CLK_LPTIM2_PLL4Q	CLKSRC(MUX_LPTIM2, 1)
#define CLK_LPTIM2_CKPER	CLKSRC(MUX_LPTIM2, 2)
#define CLK_LPTIM2_LSE		CLKSRC(MUX_LPTIM2, 3)
#define CLK_LPTIM2_LSI		CLKSRC(MUX_LPTIM2, 4)

#define CLK_LPTIM3_PCLK3	CLKSRC(MUX_LPTIM3, 0)
#define CLK_LPTIM3_PLL4Q	CLKSRC(MUX_LPTIM3, 1)
#define CLK_LPTIM3_CKPER	CLKSRC(MUX_LPTIM3, 2)
#define CLK_LPTIM3_LSE		CLKSRC(MUX_LPTIM3, 3)
#define CLK_LPTIM3_LSI		CLKSRC(MUX_LPTIM3, 4)

#define CLK_LPTIM45_PCLK3	CLKSRC(MUX_LPTIM45, 0)
#define CLK_LPTIM45_PLL4P	CLKSRC(MUX_LPTIM45, 1)
#define CLK_LPTIM45_PLL3Q	CLKSRC(MUX_LPTIM45, 2)
#define CLK_LPTIM45_LSE		CLKSRC(MUX_LPTIM45, 3)
#define CLK_LPTIM45_LSI		CLKSRC(MUX_LPTIM45, 4)
#define CLK_LPTIM45_CKPER	CLKSRC(MUX_LPTIM45, 5)

#define CLK_SAI1_PLL4Q		CLKSRC(MUX_SAI1, 0)
#define CLK_SAI1_PLL3Q		CLKSRC(MUX_SAI1, 1)
#define CLK_SAI1_I2SCKIN	CLKSRC(MUX_SAI1, 2)
#define CLK_SAI1_CKPER		CLKSRC(MUX_SAI1, 3)
#define CLK_SAI1_PLL3R		CLKSRC(MUX_SAI1, 4)

#define CLK_SAI2_PLL4Q		CLKSRC(MUX_SAI2, 0)
#define CLK_SAI2_PLL3Q		CLKSRC(MUX_SAI2, 1)
#define CLK_SAI2_I2SCKIN	CLKSRC(MUX_SAI2, 2)
#define CLK_SAI2_CKPER		CLKSRC(MUX_SAI2, 3)
#define CLK_SAI2_SPDIF		CLKSRC(MUX_SAI2, 4)
#define CLK_SAI2_PLL3R		CLKSRC(MUX_SAI2, 5)

#define CLK_FDCAN_HSE		CLKSRC(MUX_FDCAN, 0)
#define CLK_FDCAN_PLL3Q		CLKSRC(MUX_FDCAN, 1)
#define CLK_FDCAN_PLL4Q		CLKSRC(MUX_FDCAN, 2)
#define CLK_FDCAN_PLL4R		CLKSRC(MUX_FDCAN, 3)

#define CLK_SPDIF_PLL4P		CLKSRC(MUX_SPDIF, 0)
#define CLK_SPDIF_PLL3Q		CLKSRC(MUX_SPDIF, 1)
#define CLK_SPDIF_HSI		CLKSRC(MUX_SPDIF, 2)

#define CLK_ADC1_PLL4R		CLKSRC(MUX_ADC1, 0)
#define CLK_ADC1_CKPER		CLKSRC(MUX_ADC1, 1)
#define CLK_ADC1_PLL3Q		CLKSRC(MUX_ADC1, 2)

#define CLK_ADC2_PLL4R		CLKSRC(MUX_ADC2, 0)
#define CLK_ADC2_CKPER		CLKSRC(MUX_ADC2, 1)
#define CLK_ADC2_PLL3Q		CLKSRC(MUX_ADC2, 2)

#define CLK_SDMMC1_HCLK6	CLKSRC(MUX_SDMMC1, 0)
#define CLK_SDMMC1_PLL3R	CLKSRC(MUX_SDMMC1, 1)
#define CLK_SDMMC1_PLL4P	CLKSRC(MUX_SDMMC1, 2)
#define CLK_SDMMC1_HSI		CLKSRC(MUX_SDMMC1, 3)

#define CLK_SDMMC2_HCLK6	CLKSRC(MUX_SDMMC2, 0)
#define CLK_SDMMC2_PLL3R	CLKSRC(MUX_SDMMC2, 1)
#define CLK_SDMMC2_PLL4P	CLKSRC(MUX_SDMMC2, 2)
#define CLK_SDMMC2_HSI		CLKSRC(MUX_SDMMC2, 3)

#define CLK_ETH1_PLL4P		CLKSRC(MUX_ETH1, 0)
#define CLK_ETH1_PLL3Q		CLKSRC(MUX_ETH1, 1)

#define CLK_ETH2_PLL4P		CLKSRC(MUX_ETH2, 0)
#define CLK_ETH2_PLL3Q		CLKSRC(MUX_ETH2, 1)

#define CLK_USBPHY_HSE		CLKSRC(MUX_USBPHY, 0)
#define CLK_USBPHY_PLL4R	CLKSRC(MUX_USBPHY, 1)
#define CLK_USBPHY_HSE_DIV2	CLKSRC(MUX_USBPHY, 2)

#define CLK_USBO_PLL4R		CLKSRC(MUX_USBO, 0)
#define CLK_USBO_USBPHY		CLKSRC(MUX_USBO, 1)

#define CLK_QSPI_ACLK		CLKSRC(MUX_QSPI, 0)
#define CLK_QSPI_PLL3R		CLKSRC(MUX_QSPI, 1)
#define CLK_QSPI_PLL4P		CLKSRC(MUX_QSPI, 2)
#define CLK_QSPI_CKPER		CLKSRC(MUX_QSPI, 3)

#define CLK_FMC_ACLK		CLKSRC(MUX_FMC, 0)
#define CLK_FMC_PLL3R		CLKSRC(MUX_FMC, 1)
#define CLK_FMC_PLL4P		CLKSRC(MUX_FMC, 2)
#define CLK_FMC_CKPER		CLKSRC(MUX_FMC, 3)

#define CLK_RNG1_CSI		CLKSRC(MUX_RNG1, 0)
#define CLK_RNG1_PLL4R		CLKSRC(MUX_RNG1, 1)
/* WARNING: POSITION 2 OF RNG1 MUX IS RESERVED */
#define CLK_RNG1_LSI		CLKSRC(MUX_RNG1, 3)

#define CLK_STGEN_HSI		CLKSRC(MUX_STGEN, 0)
#define CLK_STGEN_HSE		CLKSRC(MUX_STGEN, 1)

#define CLK_DCMIPP_ACLK		CLKSRC(MUX_DCMIPP, 0)
#define CLK_DCMIPP_PLL2Q	CLKSRC(MUX_DCMIPP, 1)
#define CLK_DCMIPP_PLL4P	CLKSRC(MUX_DCMIPP, 2)
#define CLK_DCMIPP_CKPER	CLKSRC(MUX_DCMIPP, 3)

#define CLK_SAES_AXI		CLKSRC(MUX_SAES, 0)
#define CLK_SAES_CKPER		CLKSRC(MUX_SAES, 1)
#define CLK_SAES_PLL4R		CLKSRC(MUX_SAES, 2)
#define CLK_SAES_LSI		CLKSRC(MUX_SAES, 3)

/* PLL output is enable when x=1, with x=p,q or r */
#define PQR(p, q, r)	(((p) & 1) | (((q) & 1) << 1) | (((r) & 1) << 2))

/* define for st,pll /csg */
#define SSCG_MODE_CENTER_SPREAD	0
#define SSCG_MODE_DOWN_SPREAD	1

/* define for st,drive */
#define LSEDRV_LOWEST		0
#define LSEDRV_MEDIUM_LOW	1
#define LSEDRV_MEDIUM_HIGH	2
#define LSEDRV_HIGHEST		3

#endif
