use strict;
use warnings;

use RT::Test;
use Time::HiRes qw(tv_interval gettimeofday);

my ( $baseurl, $m ) = RT::Test->started_ok;

my $existing_user = 'root';
my $nonexistent_user = 'quux-cabbage';
my $disabled_user = 'disabled';

my $d = RT::Test->load_or_create_user(Name => 'disabled');
$d->SetDisabled(1);
$d->SetPassword('testing123ok');
sub login
{
    my ($user) = @_;
    my $t0 = [gettimeofday()];

    $m->get($baseurl);
    $m->submit_form(
        form_id => 'login',
        fields  => {
            user => $user,
            pass => 'testing123ok',
        }
        );
    $m->warning_like(qr/FAILED LOGIN for $user from/, 'Got expected warning');
    return tv_interval($t0);
}

my $t_existing = 0.0;
my $t_nonexisting = 0.0;
my $t_disabled = 0.0;

for ( 1 .. 100 ) {
    $t_existing += login($existing_user);
    $t_nonexisting += login($nonexistent_user);
    $t_disabled += login($disabled_user);
}

ok ($t_existing >= 0.9 * $t_nonexisting && $t_nonexisting >= 0.9 * $t_existing,
    "Login timings for existing and nonexisting users are within 10%: $t_existing VS $t_nonexisting");
ok ($t_existing >= 0.9 * $t_disabled && $t_disabled >= 0.9 * $t_existing,
    "Login timings for existing and disabled users are within 10%: $t_existing VS $t_disabled");
ok ($t_nonexisting >= 0.9 * $t_disabled && $t_disabled >= 0.9 * $t_nonexisting,
    "Login timings for nonexisting and disabled users are within 10%: $t_nonexisting VS $t_disabled");

done_testing();
