/*
 * Copyright (c) 2023-2024, STMicroelectronics - All Rights Reserved
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef STM32MP2_RCC_H
#define STM32MP2_RCC_H

#include <lib/utils_def.h>

#define RCC_SECCFGR0				U(0x0)
#define RCC_SECCFGR1				U(0x4)
#define RCC_SECCFGR2				U(0x8)
#define RCC_SECCFGR3				U(0xC)
#define RCC_PRIVCFGR0				U(0x10)
#define RCC_PRIVCFGR1				U(0x14)
#define RCC_PRIVCFGR2				U(0x18)
#define RCC_PRIVCFGR3				U(0x1C)
#define RCC_RCFGLOCKR0				U(0x20)
#define RCC_RCFGLOCKR1				U(0x24)
#define RCC_RCFGLOCKR2				U(0x28)
#define RCC_RCFGLOCKR3				U(0x2C)
#define RCC_R0CIDCFGR				U(0x30)
#define RCC_R0SEMCR				U(0x34)
#define RCC_R1CIDCFGR				U(0x38)
#define RCC_R1SEMCR				U(0x3C)
#define RCC_R2CIDCFGR				U(0x40)
#define RCC_R2SEMCR				U(0x44)
#define RCC_R3CIDCFGR				U(0x48)
#define RCC_R3SEMCR				U(0x4C)
#define RCC_R4CIDCFGR				U(0x50)
#define RCC_R4SEMCR				U(0x54)
#define RCC_R5CIDCFGR				U(0x58)
#define RCC_R5SEMCR				U(0x5C)
#define RCC_R6CIDCFGR				U(0x60)
#define RCC_R6SEMCR				U(0x64)
#define RCC_R7CIDCFGR				U(0x68)
#define RCC_R7SEMCR				U(0x6C)
#define RCC_R8CIDCFGR				U(0x70)
#define RCC_R8SEMCR				U(0x74)
#define RCC_R9CIDCFGR				U(0x78)
#define RCC_R9SEMCR				U(0x7C)
#define RCC_R10CIDCFGR				U(0x80)
#define RCC_R10SEMCR				U(0x84)
#define RCC_R11CIDCFGR				U(0x88)
#define RCC_R11SEMCR				U(0x8C)
#define RCC_R12CIDCFGR				U(0x90)
#define RCC_R12SEMCR				U(0x94)
#define RCC_R13CIDCFGR				U(0x98)
#define RCC_R13SEMCR				U(0x9C)
#define RCC_R14CIDCFGR				U(0xA0)
#define RCC_R14SEMCR				U(0xA4)
#define RCC_R15CIDCFGR				U(0xA8)
#define RCC_R15SEMCR				U(0xAC)
#define RCC_R16CIDCFGR				U(0xB0)
#define RCC_R16SEMCR				U(0xB4)
#define RCC_R17CIDCFGR				U(0xB8)
#define RCC_R17SEMCR				U(0xBC)
#define RCC_R18CIDCFGR				U(0xC0)
#define RCC_R18SEMCR				U(0xC4)
#define RCC_R19CIDCFGR				U(0xC8)
#define RCC_R19SEMCR				U(0xCC)
#define RCC_R20CIDCFGR				U(0xD0)
#define RCC_R20SEMCR				U(0xD4)
#define RCC_R21CIDCFGR				U(0xD8)
#define RCC_R21SEMCR				U(0xDC)
#define RCC_R22CIDCFGR				U(0xE0)
#define RCC_R22SEMCR				U(0xE4)
#define RCC_R23CIDCFGR				U(0xE8)
#define RCC_R23SEMCR				U(0xEC)
#define RCC_R24CIDCFGR				U(0xF0)
#define RCC_R24SEMCR				U(0xF4)
#define RCC_R25CIDCFGR				U(0xF8)
#define RCC_R25SEMCR				U(0xFC)
#define RCC_R26CIDCFGR				U(0x100)
#define RCC_R26SEMCR				U(0x104)
#define RCC_R27CIDCFGR				U(0x108)
#define RCC_R27SEMCR				U(0x10C)
#define RCC_R28CIDCFGR				U(0x110)
#define RCC_R28SEMCR				U(0x114)
#define RCC_R29CIDCFGR				U(0x118)
#define RCC_R29SEMCR				U(0x11C)
#define RCC_R30CIDCFGR				U(0x120)
#define RCC_R30SEMCR				U(0x124)
#define RCC_R31CIDCFGR				U(0x128)
#define RCC_R31SEMCR				U(0x12C)
#define RCC_R32CIDCFGR				U(0x130)
#define RCC_R32SEMCR				U(0x134)
#define RCC_R33CIDCFGR				U(0x138)
#define RCC_R33SEMCR				U(0x13C)
#define RCC_R34CIDCFGR				U(0x140)
#define RCC_R34SEMCR				U(0x144)
#define RCC_R35CIDCFGR				U(0x148)
#define RCC_R35SEMCR				U(0x14C)
#define RCC_R36CIDCFGR				U(0x150)
#define RCC_R36SEMCR				U(0x154)
#define RCC_R37CIDCFGR				U(0x158)
#define RCC_R37SEMCR				U(0x15C)
#define RCC_R38CIDCFGR				U(0x160)
#define RCC_R38SEMCR				U(0x164)
#define RCC_R39CIDCFGR				U(0x168)
#define RCC_R39SEMCR				U(0x16C)
#define RCC_R40CIDCFGR				U(0x170)
#define RCC_R40SEMCR				U(0x174)
#define RCC_R41CIDCFGR				U(0x178)
#define RCC_R41SEMCR				U(0x17C)
#define RCC_R42CIDCFGR				U(0x180)
#define RCC_R42SEMCR				U(0x184)
#define RCC_R43CIDCFGR				U(0x188)
#define RCC_R43SEMCR				U(0x18C)
#define RCC_R44CIDCFGR				U(0x190)
#define RCC_R44SEMCR				U(0x194)
#define RCC_R45CIDCFGR				U(0x198)
#define RCC_R45SEMCR				U(0x19C)
#define RCC_R46CIDCFGR				U(0x1A0)
#define RCC_R46SEMCR				U(0x1A4)
#define RCC_R47CIDCFGR				U(0x1A8)
#define RCC_R47SEMCR				U(0x1AC)
#define RCC_R48CIDCFGR				U(0x1B0)
#define RCC_R48SEMCR				U(0x1B4)
#define RCC_R49CIDCFGR				U(0x1B8)
#define RCC_R49SEMCR				U(0x1BC)
#define RCC_R50CIDCFGR				U(0x1C0)
#define RCC_R50SEMCR				U(0x1C4)
#define RCC_R51CIDCFGR				U(0x1C8)
#define RCC_R51SEMCR				U(0x1CC)
#define RCC_R52CIDCFGR				U(0x1D0)
#define RCC_R52SEMCR				U(0x1D4)
#define RCC_R53CIDCFGR				U(0x1D8)
#define RCC_R53SEMCR				U(0x1DC)
#define RCC_R54CIDCFGR				U(0x1E0)
#define RCC_R54SEMCR				U(0x1E4)
#define RCC_R55CIDCFGR				U(0x1E8)
#define RCC_R55SEMCR				U(0x1EC)
#define RCC_R56CIDCFGR				U(0x1F0)
#define RCC_R56SEMCR				U(0x1F4)
#define RCC_R57CIDCFGR				U(0x1F8)
#define RCC_R57SEMCR				U(0x1FC)
#define RCC_R58CIDCFGR				U(0x200)
#define RCC_R58SEMCR				U(0x204)
#define RCC_R59CIDCFGR				U(0x208)
#define RCC_R59SEMCR				U(0x20C)
#define RCC_R60CIDCFGR				U(0x210)
#define RCC_R60SEMCR				U(0x214)
#define RCC_R61CIDCFGR				U(0x218)
#define RCC_R61SEMCR				U(0x21C)
#define RCC_R62CIDCFGR				U(0x220)
#define RCC_R62SEMCR				U(0x224)
#define RCC_R63CIDCFGR				U(0x228)
#define RCC_R63SEMCR				U(0x22C)
#define RCC_R64CIDCFGR				U(0x230)
#define RCC_R64SEMCR				U(0x234)
#define RCC_R65CIDCFGR				U(0x238)
#define RCC_R65SEMCR				U(0x23C)
#define RCC_R66CIDCFGR				U(0x240)
#define RCC_R66SEMCR				U(0x244)
#define RCC_R67CIDCFGR				U(0x248)
#define RCC_R67SEMCR				U(0x24C)
#define RCC_R68CIDCFGR				U(0x250)
#define RCC_R68SEMCR				U(0x254)
#define RCC_R69CIDCFGR				U(0x258)
#define RCC_R69SEMCR				U(0x25C)
#define RCC_R70CIDCFGR				U(0x260)
#define RCC_R70SEMCR				U(0x264)
#define RCC_R71CIDCFGR				U(0x268)
#define RCC_R71SEMCR				U(0x26C)
#define RCC_R72CIDCFGR				U(0x270)
#define RCC_R72SEMCR				U(0x274)
#define RCC_R73CIDCFGR				U(0x278)
#define RCC_R73SEMCR				U(0x27C)
#define RCC_R74CIDCFGR				U(0x280)
#define RCC_R74SEMCR				U(0x284)
#define RCC_R75CIDCFGR				U(0x288)
#define RCC_R75SEMCR				U(0x28C)
#define RCC_R76CIDCFGR				U(0x290)
#define RCC_R76SEMCR				U(0x294)
#define RCC_R77CIDCFGR				U(0x298)
#define RCC_R77SEMCR				U(0x29C)
#define RCC_R78CIDCFGR				U(0x2A0)
#define RCC_R78SEMCR				U(0x2A4)
#define RCC_R79CIDCFGR				U(0x2A8)
#define RCC_R79SEMCR				U(0x2AC)
#define RCC_R80CIDCFGR				U(0x2B0)
#define RCC_R80SEMCR				U(0x2B4)
#define RCC_R81CIDCFGR				U(0x2B8)
#define RCC_R81SEMCR				U(0x2BC)
#define RCC_R82CIDCFGR				U(0x2C0)
#define RCC_R82SEMCR				U(0x2C4)
#define RCC_R83CIDCFGR				U(0x2C8)
#define RCC_R83SEMCR				U(0x2CC)
#define RCC_R84CIDCFGR				U(0x2D0)
#define RCC_R84SEMCR				U(0x2D4)
#define RCC_R85CIDCFGR				U(0x2D8)
#define RCC_R85SEMCR				U(0x2DC)
#define RCC_R86CIDCFGR				U(0x2E0)
#define RCC_R86SEMCR				U(0x2E4)
#define RCC_R87CIDCFGR				U(0x2E8)
#define RCC_R87SEMCR				U(0x2EC)
#define RCC_R88CIDCFGR				U(0x2F0)
#define RCC_R88SEMCR				U(0x2F4)
#define RCC_R89CIDCFGR				U(0x2F8)
#define RCC_R89SEMCR				U(0x2FC)
#define RCC_R90CIDCFGR				U(0x300)
#define RCC_R90SEMCR				U(0x304)
#define RCC_R91CIDCFGR				U(0x308)
#define RCC_R91SEMCR				U(0x30C)
#define RCC_R92CIDCFGR				U(0x310)
#define RCC_R92SEMCR				U(0x314)
#define RCC_R93CIDCFGR				U(0x318)
#define RCC_R93SEMCR				U(0x31C)
#define RCC_R94CIDCFGR				U(0x320)
#define RCC_R94SEMCR				U(0x324)
#define RCC_R95CIDCFGR				U(0x328)
#define RCC_R95SEMCR				U(0x32C)
#define RCC_R96CIDCFGR				U(0x330)
#define RCC_R96SEMCR				U(0x334)
#define RCC_R97CIDCFGR				U(0x338)
#define RCC_R97SEMCR				U(0x33C)
#define RCC_R98CIDCFGR				U(0x340)
#define RCC_R98SEMCR				U(0x344)
#define RCC_R99CIDCFGR				U(0x348)
#define RCC_R99SEMCR				U(0x34C)
#define RCC_R100CIDCFGR				U(0x350)
#define RCC_R100SEMCR				U(0x354)
#define RCC_R101CIDCFGR				U(0x358)
#define RCC_R101SEMCR				U(0x35C)
#define RCC_R102CIDCFGR				U(0x360)
#define RCC_R102SEMCR				U(0x364)
#define RCC_R103CIDCFGR				U(0x368)
#define RCC_R103SEMCR				U(0x36C)
#define RCC_R104CIDCFGR				U(0x370)
#define RCC_R104SEMCR				U(0x374)
#define RCC_R105CIDCFGR				U(0x378)
#define RCC_R105SEMCR				U(0x37C)
#define RCC_R106CIDCFGR				U(0x380)
#define RCC_R106SEMCR				U(0x384)
#define RCC_R107CIDCFGR				U(0x388)
#define RCC_R107SEMCR				U(0x38C)
#define RCC_R108CIDCFGR				U(0x390)
#define RCC_R108SEMCR				U(0x394)
#define RCC_R109CIDCFGR				U(0x398)
#define RCC_R109SEMCR				U(0x39C)
#define RCC_R110CIDCFGR				U(0x3A0)
#define RCC_R110SEMCR				U(0x3A4)
#define RCC_R111CIDCFGR				U(0x3A8)
#define RCC_R111SEMCR				U(0x3AC)
#define RCC_R112CIDCFGR				U(0x3B0)
#define RCC_R112SEMCR				U(0x3B4)
#define RCC_R113CIDCFGR				U(0x3B8)
#define RCC_R113SEMCR				U(0x3BC)
#define RCC_GRSTCSETR				U(0x400)
#define RCC_C1RSTCSETR				U(0x404)
#define RCC_C1P1RSTCSETR			U(0x408)
#define RCC_C2RSTCSETR				U(0x40C)
#define RCC_HWRSTSCLRR				U(0x410)
#define RCC_C1HWRSTSCLRR			U(0x414)
#define RCC_C2HWRSTSCLRR			U(0x418)
#define RCC_C1BOOTRSTSSETR			U(0x41C)
#define RCC_C1BOOTRSTSCLRR			U(0x420)
#define RCC_C2BOOTRSTSSETR			U(0x424)
#define RCC_C2BOOTRSTSCLRR			U(0x428)
#define RCC_C1SREQSETR				U(0x42C)
#define RCC_C1SREQCLRR				U(0x430)
#define RCC_CPUBOOTCR				U(0x434)
#define RCC_STBYBOOTCR				U(0x438)
#define RCC_LEGBOOTCR				U(0x43C)
#define RCC_BDCR				U(0x440)
#define RCC_D3DCR				U(0x444)
#define RCC_D3DSR				U(0x448)
#define RCC_RDCR				U(0x44C)
#define RCC_C1MSRDCR				U(0x450)
#define RCC_PWRLPDLYCR				U(0x454)
#define RCC_C1CIESETR				U(0x458)
#define RCC_C1CIFCLRR				U(0x45C)
#define RCC_C2CIESETR				U(0x460)
#define RCC_C2CIFCLRR				U(0x464)
#define RCC_IWDGC1FZSETR			U(0x468)
#define RCC_IWDGC1FZCLRR			U(0x46C)
#define RCC_IWDGC1CFGSETR			U(0x470)
#define RCC_IWDGC1CFGCLRR			U(0x474)
#define RCC_IWDGC2FZSETR			U(0x478)
#define RCC_IWDGC2FZCLRR			U(0x47C)
#define RCC_IWDGC2CFGSETR			U(0x480)
#define RCC_IWDGC2CFGCLRR			U(0x484)
#define RCC_IWDGC3CFGSETR			U(0x488)
#define RCC_IWDGC3CFGCLRR			U(0x48C)
#define RCC_C3CFGR				U(0x490)
#define RCC_MCO1CFGR				U(0x494)
#define RCC_MCO2CFGR				U(0x498)
#define RCC_OCENSETR				U(0x49C)
#define RCC_OCENCLRR				U(0x4A0)
#define RCC_OCRDYR				U(0x4A4)
#define RCC_HSICFGR				U(0x4A8)
#define RCC_CSICFGR				U(0x4AC)
#define RCC_RTCDIVR				U(0x4B0)
#define RCC_APB1DIVR				U(0x4B4)
#define RCC_APB2DIVR				U(0x4B8)
#define RCC_APB3DIVR				U(0x4BC)
#define RCC_APB4DIVR				U(0x4C0)
#define RCC_APBDBGDIVR				U(0x4C4)
#define RCC_TIMG1PRER				U(0x4C8)
#define RCC_TIMG2PRER				U(0x4CC)
#define RCC_LSMCUDIVR				U(0x4D0)
#define RCC_DDRCPCFGR				U(0x4D4)
#define RCC_DDRCAPBCFGR				U(0x4D8)
#define RCC_DDRPHYCAPBCFGR			U(0x4DC)
#define RCC_DDRPHYCCFGR				U(0x4E0)
#define RCC_DDRCFGR				U(0x4E4)
#define RCC_DDRITFCFGR				U(0x4E8)
#define RCC_SYSRAMCFGR				U(0x4F0)
#define RCC_VDERAMCFGR				U(0x4F4)
#define RCC_SRAM1CFGR				U(0x4F8)
#define RCC_SRAM2CFGR				U(0x4FC)
#define RCC_RETRAMCFGR				U(0x500)
#define RCC_BKPSRAMCFGR				U(0x504)
#define RCC_LPSRAM1CFGR				U(0x508)
#define RCC_LPSRAM2CFGR				U(0x50C)
#define RCC_LPSRAM3CFGR				U(0x510)
#define RCC_OSPI1CFGR				U(0x514)
#define RCC_OSPI2CFGR				U(0x518)
#define RCC_FMCCFGR				U(0x51C)
#define RCC_DBGCFGR				U(0x520)
#define RCC_STM500CFGR				U(0x524)
#define RCC_ETRCFGR				U(0x528)
#define RCC_GPIOACFGR				U(0x52C)
#define RCC_GPIOBCFGR				U(0x530)
#define RCC_GPIOCCFGR				U(0x534)
#define RCC_GPIODCFGR				U(0x538)
#define RCC_GPIOECFGR				U(0x53C)
#define RCC_GPIOFCFGR				U(0x540)
#define RCC_GPIOGCFGR				U(0x544)
#define RCC_GPIOHCFGR				U(0x548)
#define RCC_GPIOICFGR				U(0x54C)
#define RCC_GPIOJCFGR				U(0x550)
#define RCC_GPIOKCFGR				U(0x554)
#define RCC_GPIOZCFGR				U(0x558)
#define RCC_HPDMA1CFGR				U(0x55C)
#define RCC_HPDMA2CFGR				U(0x560)
#define RCC_HPDMA3CFGR				U(0x564)
#define RCC_LPDMACFGR				U(0x568)
#define RCC_HSEMCFGR				U(0x56C)
#define RCC_IPCC1CFGR				U(0x570)
#define RCC_IPCC2CFGR				U(0x574)
#define RCC_RTCCFGR				U(0x578)
#define RCC_SYSCPU1CFGR				U(0x580)
#define RCC_BSECCFGR				U(0x584)
#define RCC_IS2MCFGR				U(0x58C)
#define RCC_PLL2CFGR1				U(0x590)
#define RCC_PLL2CFGR2				U(0x594)
#define RCC_PLL2CFGR3				U(0x598)
#define RCC_PLL2CFGR4				U(0x59C)
#define RCC_PLL2CFGR5				U(0x5A0)
#define RCC_PLL2CFGR6				U(0x5A8)
#define RCC_PLL2CFGR7				U(0x5AC)
#define RCC_PLL3CFGR1				U(0x5B8)
#define RCC_PLL3CFGR2				U(0x5BC)
#define RCC_PLL3CFGR3				U(0x5C0)
#define RCC_PLL3CFGR4				U(0x5C4)
#define RCC_PLL3CFGR5				U(0x5C8)
#define RCC_PLL3CFGR6				U(0x5D0)
#define RCC_PLL3CFGR7				U(0x5D4)
#define RCC_HSIFMONCR				U(0x5E0)
#define RCC_HSIFVALR				U(0x5E4)
#define RCC_TIM1CFGR				U(0x700)
#define RCC_TIM2CFGR				U(0x704)
#define RCC_TIM3CFGR				U(0x708)
#define RCC_TIM4CFGR				U(0x70C)
#define RCC_TIM5CFGR				U(0x710)
#define RCC_TIM6CFGR				U(0x714)
#define RCC_TIM7CFGR				U(0x718)
#define RCC_TIM8CFGR				U(0x71C)
#define RCC_TIM10CFGR				U(0x720)
#define RCC_TIM11CFGR				U(0x724)
#define RCC_TIM12CFGR				U(0x728)
#define RCC_TIM13CFGR				U(0x72C)
#define RCC_TIM14CFGR				U(0x730)
#define RCC_TIM15CFGR				U(0x734)
#define RCC_TIM16CFGR				U(0x738)
#define RCC_TIM17CFGR				U(0x73C)
#define RCC_TIM20CFGR				U(0x740)
#define RCC_LPTIM1CFGR				U(0x744)
#define RCC_LPTIM2CFGR				U(0x748)
#define RCC_LPTIM3CFGR				U(0x74C)
#define RCC_LPTIM4CFGR				U(0x750)
#define RCC_LPTIM5CFGR				U(0x754)
#define RCC_SPI1CFGR				U(0x758)
#define RCC_SPI2CFGR				U(0x75C)
#define RCC_SPI3CFGR				U(0x760)
#define RCC_SPI4CFGR				U(0x764)
#define RCC_SPI5CFGR				U(0x768)
#define RCC_SPI6CFGR				U(0x76C)
#define RCC_SPI7CFGR				U(0x770)
#define RCC_SPI8CFGR				U(0x774)
#define RCC_SPDIFRXCFGR				U(0x778)
#define RCC_USART1CFGR				U(0x77C)
#define RCC_USART2CFGR				U(0x780)
#define RCC_USART3CFGR				U(0x784)
#define RCC_UART4CFGR				U(0x788)
#define RCC_UART5CFGR				U(0x78C)
#define RCC_USART6CFGR				U(0x790)
#define RCC_UART7CFGR				U(0x794)
#define RCC_UART8CFGR				U(0x798)
#define RCC_UART9CFGR				U(0x79C)
#define RCC_LPUART1CFGR				U(0x7A0)
#define RCC_I2C1CFGR				U(0x7A4)
#define RCC_I2C2CFGR				U(0x7A8)
#define RCC_I2C3CFGR				U(0x7AC)
#define RCC_I2C4CFGR				U(0x7B0)
#define RCC_I2C5CFGR				U(0x7B4)
#define RCC_I2C6CFGR				U(0x7B8)
#define RCC_I2C7CFGR				U(0x7BC)
#define RCC_I2C8CFGR				U(0x7C0)
#define RCC_SAI1CFGR				U(0x7C4)
#define RCC_SAI2CFGR				U(0x7C8)
#define RCC_SAI3CFGR				U(0x7CC)
#define RCC_SAI4CFGR				U(0x7D0)
#define RCC_MDF1CFGR				U(0x7D8)
#define RCC_ADF1CFGR				U(0x7DC)
#define RCC_FDCANCFGR				U(0x7E0)
#define RCC_HDPCFGR				U(0x7E4)
#define RCC_ADC12CFGR				U(0x7E8)
#define RCC_ADC3CFGR				U(0x7EC)
#define RCC_ETH1CFGR				U(0x7F0)
#define RCC_ETH2CFGR				U(0x7F4)
#define RCC_USB2CFGR				U(0x7FC)
#define RCC_USB2PHY1CFGR			U(0x800)
#define RCC_USB2PHY2CFGR			U(0x804)
#define RCC_USB3DRCFGR				U(0x808)
#define RCC_USB3PCIEPHYCFGR			U(0x80C)
#define RCC_PCIECFGR				U(0x810)
#define RCC_UCPDCFGR				U(0x814)
#define RCC_ETHSWCFGR				U(0x818)
#define RCC_ETHSWACMCFGR			U(0x81C)
#define RCC_ETHSWACMMSGCFGR			U(0x820)
#define RCC_STGENCFGR				U(0x824)
#define RCC_SDMMC1CFGR				U(0x830)
#define RCC_SDMMC2CFGR				U(0x834)
#define RCC_SDMMC3CFGR				U(0x838)
#define RCC_GPUCFGR				U(0x83C)
#define RCC_LTDCCFGR				U(0x840)
#define RCC_DSICFGR				U(0x844)
#define RCC_LVDSCFGR				U(0x850)
#define RCC_CSI2CFGR				U(0x858)
#define RCC_DCMIPPCFGR				U(0x85C)
#define RCC_CCICFGR				U(0x860)
#define RCC_VDECCFGR				U(0x864)
#define RCC_VENCCFGR				U(0x868)
#define RCC_RNGCFGR				U(0x870)
#define RCC_PKACFGR				U(0x874)
#define RCC_SAESCFGR				U(0x878)
#define RCC_HASHCFGR				U(0x87C)
#define RCC_CRYP1CFGR				U(0x880)
#define RCC_CRYP2CFGR				U(0x884)
#define RCC_IWDG1CFGR				U(0x888)
#define RCC_IWDG2CFGR				U(0x88C)
#define RCC_IWDG3CFGR				U(0x890)
#define RCC_IWDG4CFGR				U(0x894)
#define RCC_IWDG5CFGR				U(0x898)
#define RCC_WWDG1CFGR				U(0x89C)
#define RCC_WWDG2CFGR				U(0x8A0)
#define RCC_VREFCFGR				U(0x8A8)
#define RCC_TMPSENSCFGR				U(0x8AC)
#define RCC_CRCCFGR				U(0x8B4)
#define RCC_SERCCFGR				U(0x8B8)
#define RCC_OSPIIOMCFGR				U(0x8BC)
#define RCC_GICV2MCFGR				U(0x8C0)
#define RCC_I3C1CFGR				U(0x8C8)
#define RCC_I3C2CFGR				U(0x8CC)
#define RCC_I3C3CFGR				U(0x8D0)
#define RCC_I3C4CFGR				U(0x8D4)
#define RCC_MUXSELCFGR				U(0x1000)
#define RCC_XBAR0CFGR				U(0x1018)
#define RCC_XBAR1CFGR				U(0x101C)
#define RCC_XBAR2CFGR				U(0x1020)
#define RCC_XBAR3CFGR				U(0x1024)
#define RCC_XBAR4CFGR				U(0x1028)
#define RCC_XBAR5CFGR				U(0x102C)
#define RCC_XBAR6CFGR				U(0x1030)
#define RCC_XBAR7CFGR				U(0x1034)
#define RCC_XBAR8CFGR				U(0x1038)
#define RCC_XBAR9CFGR				U(0x103C)
#define RCC_XBAR10CFGR				U(0x1040)
#define RCC_XBAR11CFGR				U(0x1044)
#define RCC_XBAR12CFGR				U(0x1048)
#define RCC_XBAR13CFGR				U(0x104C)
#define RCC_XBAR14CFGR				U(0x1050)
#define RCC_XBAR15CFGR				U(0x1054)
#define RCC_XBAR16CFGR				U(0x1058)
#define RCC_XBAR17CFGR				U(0x105C)
#define RCC_XBAR18CFGR				U(0x1060)
#define RCC_XBAR19CFGR				U(0x1064)
#define RCC_XBAR20CFGR				U(0x1068)
#define RCC_XBAR21CFGR				U(0x106C)
#define RCC_XBAR22CFGR				U(0x1070)
#define RCC_XBAR23CFGR				U(0x1074)
#define RCC_XBAR24CFGR				U(0x1078)
#define RCC_XBAR25CFGR				U(0x107C)
#define RCC_XBAR26CFGR				U(0x1080)
#define RCC_XBAR27CFGR				U(0x1084)
#define RCC_XBAR28CFGR				U(0x1088)
#define RCC_XBAR29CFGR				U(0x108C)
#define RCC_XBAR30CFGR				U(0x1090)
#define RCC_XBAR31CFGR				U(0x1094)
#define RCC_XBAR32CFGR				U(0x1098)
#define RCC_XBAR33CFGR				U(0x109C)
#define RCC_XBAR34CFGR				U(0x10A0)
#define RCC_XBAR35CFGR				U(0x10A4)
#define RCC_XBAR36CFGR				U(0x10A8)
#define RCC_XBAR37CFGR				U(0x10AC)
#define RCC_XBAR38CFGR				U(0x10B0)
#define RCC_XBAR39CFGR				U(0x10B4)
#define RCC_XBAR40CFGR				U(0x10B8)
#define RCC_XBAR41CFGR				U(0x10BC)
#define RCC_XBAR42CFGR				U(0x10C0)
#define RCC_XBAR43CFGR				U(0x10C4)
#define RCC_XBAR44CFGR				U(0x10C8)
#define RCC_XBAR45CFGR				U(0x10CC)
#define RCC_XBAR46CFGR				U(0x10D0)
#define RCC_XBAR47CFGR				U(0x10D4)
#define RCC_XBAR48CFGR				U(0x10D8)
#define RCC_XBAR49CFGR				U(0x10DC)
#define RCC_XBAR50CFGR				U(0x10E0)
#define RCC_XBAR51CFGR				U(0x10E4)
#define RCC_XBAR52CFGR				U(0x10E8)
#define RCC_XBAR53CFGR				U(0x10EC)
#define RCC_XBAR54CFGR				U(0x10F0)
#define RCC_XBAR55CFGR				U(0x10F4)
#define RCC_XBAR56CFGR				U(0x10F8)
#define RCC_XBAR57CFGR				U(0x10FC)
#define RCC_XBAR58CFGR				U(0x1100)
#define RCC_XBAR59CFGR				U(0x1104)
#define RCC_XBAR60CFGR				U(0x1108)
#define RCC_XBAR61CFGR				U(0x110C)
#define RCC_XBAR62CFGR				U(0x1110)
#define RCC_XBAR63CFGR				U(0x1114)
#define RCC_PREDIV0CFGR				U(0x1118)
#define RCC_PREDIV1CFGR				U(0x111C)
#define RCC_PREDIV2CFGR				U(0x1120)
#define RCC_PREDIV3CFGR				U(0x1124)
#define RCC_PREDIV4CFGR				U(0x1128)
#define RCC_PREDIV5CFGR				U(0x112C)
#define RCC_PREDIV6CFGR				U(0x1130)
#define RCC_PREDIV7CFGR				U(0x1134)
#define RCC_PREDIV8CFGR				U(0x1138)
#define RCC_PREDIV9CFGR				U(0x113C)
#define RCC_PREDIV10CFGR			U(0x1140)
#define RCC_PREDIV11CFGR			U(0x1144)
#define RCC_PREDIV12CFGR			U(0x1148)
#define RCC_PREDIV13CFGR			U(0x114C)
#define RCC_PREDIV14CFGR			U(0x1150)
#define RCC_PREDIV15CFGR			U(0x1154)
#define RCC_PREDIV16CFGR			U(0x1158)
#define RCC_PREDIV17CFGR			U(0x115C)
#define RCC_PREDIV18CFGR			U(0x1160)
#define RCC_PREDIV19CFGR			U(0x1164)
#define RCC_PREDIV20CFGR			U(0x1168)
#define RCC_PREDIV21CFGR			U(0x116C)
#define RCC_PREDIV22CFGR			U(0x1170)
#define RCC_PREDIV23CFGR			U(0x1174)
#define RCC_PREDIV24CFGR			U(0x1178)
#define RCC_PREDIV25CFGR			U(0x117C)
#define RCC_PREDIV26CFGR			U(0x1180)
#define RCC_PREDIV27CFGR			U(0x1184)
#define RCC_PREDIV28CFGR			U(0x1188)
#define RCC_PREDIV29CFGR			U(0x118C)
#define RCC_PREDIV30CFGR			U(0x1190)
#define RCC_PREDIV31CFGR			U(0x1194)
#define RCC_PREDIV32CFGR			U(0x1198)
#define RCC_PREDIV33CFGR			U(0x119C)
#define RCC_PREDIV34CFGR			U(0x11A0)
#define RCC_PREDIV35CFGR			U(0x11A4)
#define RCC_PREDIV36CFGR			U(0x11A8)
#define RCC_PREDIV37CFGR			U(0x11AC)
#define RCC_PREDIV38CFGR			U(0x11B0)
#define RCC_PREDIV39CFGR			U(0x11B4)
#define RCC_PREDIV40CFGR			U(0x11B8)
#define RCC_PREDIV41CFGR			U(0x11BC)
#define RCC_PREDIV42CFGR			U(0x11C0)
#define RCC_PREDIV43CFGR			U(0x11C4)
#define RCC_PREDIV44CFGR			U(0x11C8)
#define RCC_PREDIV45CFGR			U(0x11CC)
#define RCC_PREDIV46CFGR			U(0x11D0)
#define RCC_PREDIV47CFGR			U(0x11D4)
#define RCC_PREDIV48CFGR			U(0x11D8)
#define RCC_PREDIV49CFGR			U(0x11DC)
#define RCC_PREDIV50CFGR			U(0x11E0)
#define RCC_PREDIV51CFGR			U(0x11E4)
#define RCC_PREDIV52CFGR			U(0x11E8)
#define RCC_PREDIV53CFGR			U(0x11EC)
#define RCC_PREDIV54CFGR			U(0x11F0)
#define RCC_PREDIV55CFGR			U(0x11F4)
#define RCC_PREDIV56CFGR			U(0x11F8)
#define RCC_PREDIV57CFGR			U(0x11FC)
#define RCC_PREDIV58CFGR			U(0x1200)
#define RCC_PREDIV59CFGR			U(0x1204)
#define RCC_PREDIV60CFGR			U(0x1208)
#define RCC_PREDIV61CFGR			U(0x120C)
#define RCC_PREDIV62CFGR			U(0x1210)
#define RCC_PREDIV63CFGR			U(0x1214)
#define RCC_PREDIVSR1				U(0x1218)
#define RCC_PREDIVSR2				U(0x121C)
#define RCC_FINDIV0CFGR				U(0x1224)
#define RCC_FINDIV1CFGR				U(0x1228)
#define RCC_FINDIV2CFGR				U(0x122C)
#define RCC_FINDIV3CFGR				U(0x1230)
#define RCC_FINDIV4CFGR				U(0x1234)
#define RCC_FINDIV5CFGR				U(0x1238)
#define RCC_FINDIV6CFGR				U(0x123C)
#define RCC_FINDIV7CFGR				U(0x1240)
#define RCC_FINDIV8CFGR				U(0x1244)
#define RCC_FINDIV9CFGR				U(0x1248)
#define RCC_FINDIV10CFGR			U(0x124C)
#define RCC_FINDIV11CFGR			U(0x1250)
#define RCC_FINDIV12CFGR			U(0x1254)
#define RCC_FINDIV13CFGR			U(0x1258)
#define RCC_FINDIV14CFGR			U(0x125C)
#define RCC_FINDIV15CFGR			U(0x1260)
#define RCC_FINDIV16CFGR			U(0x1264)
#define RCC_FINDIV17CFGR			U(0x1268)
#define RCC_FINDIV18CFGR			U(0x126C)
#define RCC_FINDIV19CFGR			U(0x1270)
#define RCC_FINDIV20CFGR			U(0x1274)
#define RCC_FINDIV21CFGR			U(0x1278)
#define RCC_FINDIV22CFGR			U(0x127C)
#define RCC_FINDIV23CFGR			U(0x1280)
#define RCC_FINDIV24CFGR			U(0x1284)
#define RCC_FINDIV25CFGR			U(0x1288)
#define RCC_FINDIV26CFGR			U(0x128C)
#define RCC_FINDIV27CFGR			U(0x1290)
#define RCC_FINDIV28CFGR			U(0x1294)
#define RCC_FINDIV29CFGR			U(0x1298)
#define RCC_FINDIV30CFGR			U(0x129C)
#define RCC_FINDIV31CFGR			U(0x12A0)
#define RCC_FINDIV32CFGR			U(0x12A4)
#define RCC_FINDIV33CFGR			U(0x12A8)
#define RCC_FINDIV34CFGR			U(0x12AC)
#define RCC_FINDIV35CFGR			U(0x12B0)
#define RCC_FINDIV36CFGR			U(0x12B4)
#define RCC_FINDIV37CFGR			U(0x12B8)
#define RCC_FINDIV38CFGR			U(0x12BC)
#define RCC_FINDIV39CFGR			U(0x12C0)
#define RCC_FINDIV40CFGR			U(0x12C4)
#define RCC_FINDIV41CFGR			U(0x12C8)
#define RCC_FINDIV42CFGR			U(0x12CC)
#define RCC_FINDIV43CFGR			U(0x12D0)
#define RCC_FINDIV44CFGR			U(0x12D4)
#define RCC_FINDIV45CFGR			U(0x12D8)
#define RCC_FINDIV46CFGR			U(0x12DC)
#define RCC_FINDIV47CFGR			U(0x12E0)
#define RCC_FINDIV48CFGR			U(0x12E4)
#define RCC_FINDIV49CFGR			U(0x12E8)
#define RCC_FINDIV50CFGR			U(0x12EC)
#define RCC_FINDIV51CFGR			U(0x12F0)
#define RCC_FINDIV52CFGR			U(0x12F4)
#define RCC_FINDIV53CFGR			U(0x12F8)
#define RCC_FINDIV54CFGR			U(0x12FC)
#define RCC_FINDIV55CFGR			U(0x1300)
#define RCC_FINDIV56CFGR			U(0x1304)
#define RCC_FINDIV57CFGR			U(0x1308)
#define RCC_FINDIV58CFGR			U(0x130C)
#define RCC_FINDIV59CFGR			U(0x1310)
#define RCC_FINDIV60CFGR			U(0x1314)
#define RCC_FINDIV61CFGR			U(0x1318)
#define RCC_FINDIV62CFGR			U(0x131C)
#define RCC_FINDIV63CFGR			U(0x1320)
#define RCC_FINDIVSR1				U(0x1324)
#define RCC_FINDIVSR2				U(0x1328)
#define RCC_FCALCOBS0CFGR			U(0x1340)
#define RCC_FCALCOBS1CFGR			U(0x1344)
#define RCC_FCALCREFCFGR			U(0x1348)
#define RCC_FCALCCR1				U(0x134C)
#define RCC_FCALCCR2				U(0x1354)
#define RCC_FCALCSR				U(0x1358)
#define RCC_PLL4CFGR1				U(0x1360)
#define RCC_PLL4CFGR2				U(0x1364)
#define RCC_PLL4CFGR3				U(0x1368)
#define RCC_PLL4CFGR4				U(0x136C)
#define RCC_PLL4CFGR5				U(0x1370)
#define RCC_PLL4CFGR6				U(0x1378)
#define RCC_PLL4CFGR7				U(0x137C)
#define RCC_PLL5CFGR1				U(0x1388)
#define RCC_PLL5CFGR2				U(0x138C)
#define RCC_PLL5CFGR3				U(0x1390)
#define RCC_PLL5CFGR4				U(0x1394)
#define RCC_PLL5CFGR5				U(0x1398)
#define RCC_PLL5CFGR6				U(0x13A0)
#define RCC_PLL5CFGR7				U(0x13A4)
#define RCC_PLL6CFGR1				U(0x13B0)
#define RCC_PLL6CFGR2				U(0x13B4)
#define RCC_PLL6CFGR3				U(0x13B8)
#define RCC_PLL6CFGR4				U(0x13BC)
#define RCC_PLL6CFGR5				U(0x13C0)
#define RCC_PLL6CFGR6				U(0x13C8)
#define RCC_PLL6CFGR7				U(0x13CC)
#define RCC_PLL7CFGR1				U(0x13D8)
#define RCC_PLL7CFGR2				U(0x13DC)
#define RCC_PLL7CFGR3				U(0x13E0)
#define RCC_PLL7CFGR4				U(0x13E4)
#define RCC_PLL7CFGR5				U(0x13E8)
#define RCC_PLL7CFGR6				U(0x13F0)
#define RCC_PLL7CFGR7				U(0x13F4)
#define RCC_PLL8CFGR1				U(0x1400)
#define RCC_PLL8CFGR2				U(0x1404)
#define RCC_PLL8CFGR3				U(0x1408)
#define RCC_PLL8CFGR4				U(0x140C)
#define RCC_PLL8CFGR5				U(0x1410)
#define RCC_PLL8CFGR6				U(0x1418)
#define RCC_PLL8CFGR7				U(0x141C)
#define RCC_VERR				U(0xFFF4)
#define RCC_IDR					U(0xFFF8)
#define RCC_SIDR				U(0xFFFC)

/* Offset between RCC_MP_xxxENSETR and RCC_MP_xxxENCLRR registers */
#define RCC_MP_ENCLRR_OFFSET			U(4)

/* RCC_SECCFGR3 register fields */
#define RCC_SECCFGR3_SEC_MASK			GENMASK_32(17, 0)
#define RCC_SECCFGR3_SEC_SHIFT			0

/* RCC_PRIVCFGR3 register fields */
#define RCC_PRIVCFGR3_PRIV_MASK			GENMASK_32(17, 0)
#define RCC_PRIVCFGR3_PRIV_SHIFT		0

/* RCC_RCFGLOCKR3 register fields */
#define RCC_RCFGLOCKR3_RLOCK_MASK		GENMASK_32(17, 0)
#define RCC_RCFGLOCKR3_RLOCK_SHIFT		0

/* RCC_R0CIDCFGR register fields */
#define RCC_R0CIDCFGR_CFEN			BIT(0)
#define RCC_R0CIDCFGR_SEM_EN			BIT(1)
#define RCC_R0CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R0CIDCFGR_SCID_SHIFT		4
#define RCC_R0CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R0CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R0SEMCR register fields */
#define RCC_R0SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R0SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R0SEMCR_SEMCID_SHIFT		4

/* RCC_R1CIDCFGR register fields */
#define RCC_R1CIDCFGR_CFEN			BIT(0)
#define RCC_R1CIDCFGR_SEM_EN			BIT(1)
#define RCC_R1CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R1CIDCFGR_SCID_SHIFT		4
#define RCC_R1CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R1CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R1SEMCR register fields */
#define RCC_R1SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R1SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R1SEMCR_SEMCID_SHIFT		4

/* RCC_R2CIDCFGR register fields */
#define RCC_R2CIDCFGR_CFEN			BIT(0)
#define RCC_R2CIDCFGR_SEM_EN			BIT(1)
#define RCC_R2CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R2CIDCFGR_SCID_SHIFT		4
#define RCC_R2CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R2CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R2SEMCR register fields */
#define RCC_R2SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R2SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R2SEMCR_SEMCID_SHIFT		4

/* RCC_R3CIDCFGR register fields */
#define RCC_R3CIDCFGR_CFEN			BIT(0)
#define RCC_R3CIDCFGR_SEM_EN			BIT(1)
#define RCC_R3CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R3CIDCFGR_SCID_SHIFT		4
#define RCC_R3CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R3CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R3SEMCR register fields */
#define RCC_R3SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R3SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R3SEMCR_SEMCID_SHIFT		4

/* RCC_R4CIDCFGR register fields */
#define RCC_R4CIDCFGR_CFEN			BIT(0)
#define RCC_R4CIDCFGR_SEM_EN			BIT(1)
#define RCC_R4CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R4CIDCFGR_SCID_SHIFT		4
#define RCC_R4CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R4CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R4SEMCR register fields */
#define RCC_R4SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R4SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R4SEMCR_SEMCID_SHIFT		4

/* RCC_R5CIDCFGR register fields */
#define RCC_R5CIDCFGR_CFEN			BIT(0)
#define RCC_R5CIDCFGR_SEM_EN			BIT(1)
#define RCC_R5CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R5CIDCFGR_SCID_SHIFT		4
#define RCC_R5CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R5CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R5SEMCR register fields */
#define RCC_R5SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R5SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R5SEMCR_SEMCID_SHIFT		4

/* RCC_R6CIDCFGR register fields */
#define RCC_R6CIDCFGR_CFEN			BIT(0)
#define RCC_R6CIDCFGR_SEM_EN			BIT(1)
#define RCC_R6CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R6CIDCFGR_SCID_SHIFT		4
#define RCC_R6CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R6CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R6SEMCR register fields */
#define RCC_R6SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R6SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R6SEMCR_SEMCID_SHIFT		4

/* RCC_R7CIDCFGR register fields */
#define RCC_R7CIDCFGR_CFEN			BIT(0)
#define RCC_R7CIDCFGR_SEM_EN			BIT(1)
#define RCC_R7CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R7CIDCFGR_SCID_SHIFT		4
#define RCC_R7CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R7CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R7SEMCR register fields */
#define RCC_R7SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R7SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R7SEMCR_SEMCID_SHIFT		4

/* RCC_R8CIDCFGR register fields */
#define RCC_R8CIDCFGR_CFEN			BIT(0)
#define RCC_R8CIDCFGR_SEM_EN			BIT(1)
#define RCC_R8CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R8CIDCFGR_SCID_SHIFT		4
#define RCC_R8CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R8CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R8SEMCR register fields */
#define RCC_R8SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R8SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R8SEMCR_SEMCID_SHIFT		4

/* RCC_R9CIDCFGR register fields */
#define RCC_R9CIDCFGR_CFEN			BIT(0)
#define RCC_R9CIDCFGR_SEM_EN			BIT(1)
#define RCC_R9CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_R9CIDCFGR_SCID_SHIFT		4
#define RCC_R9CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R9CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R9SEMCR register fields */
#define RCC_R9SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R9SEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_R9SEMCR_SEMCID_SHIFT		4

/* RCC_R10CIDCFGR register fields */
#define RCC_R10CIDCFGR_CFEN			BIT(0)
#define RCC_R10CIDCFGR_SEM_EN			BIT(1)
#define RCC_R10CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R10CIDCFGR_SCID_SHIFT		4
#define RCC_R10CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R10CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R10SEMCR register fields */
#define RCC_R10SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R10SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R10SEMCR_SEMCID_SHIFT		4

/* RCC_R11CIDCFGR register fields */
#define RCC_R11CIDCFGR_CFEN			BIT(0)
#define RCC_R11CIDCFGR_SEM_EN			BIT(1)
#define RCC_R11CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R11CIDCFGR_SCID_SHIFT		4
#define RCC_R11CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R11CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R11SEMCR register fields */
#define RCC_R11SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R11SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R11SEMCR_SEMCID_SHIFT		4

/* RCC_R12CIDCFGR register fields */
#define RCC_R12CIDCFGR_CFEN			BIT(0)
#define RCC_R12CIDCFGR_SEM_EN			BIT(1)
#define RCC_R12CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R12CIDCFGR_SCID_SHIFT		4
#define RCC_R12CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R12CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R12SEMCR register fields */
#define RCC_R12SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R12SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R12SEMCR_SEMCID_SHIFT		4

/* RCC_R13CIDCFGR register fields */
#define RCC_R13CIDCFGR_CFEN			BIT(0)
#define RCC_R13CIDCFGR_SEM_EN			BIT(1)
#define RCC_R13CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R13CIDCFGR_SCID_SHIFT		4
#define RCC_R13CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R13CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R13SEMCR register fields */
#define RCC_R13SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R13SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R13SEMCR_SEMCID_SHIFT		4

/* RCC_R14CIDCFGR register fields */
#define RCC_R14CIDCFGR_CFEN			BIT(0)
#define RCC_R14CIDCFGR_SEM_EN			BIT(1)
#define RCC_R14CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R14CIDCFGR_SCID_SHIFT		4
#define RCC_R14CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R14CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R14SEMCR register fields */
#define RCC_R14SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R14SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R14SEMCR_SEMCID_SHIFT		4

/* RCC_R15CIDCFGR register fields */
#define RCC_R15CIDCFGR_CFEN			BIT(0)
#define RCC_R15CIDCFGR_SEM_EN			BIT(1)
#define RCC_R15CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R15CIDCFGR_SCID_SHIFT		4
#define RCC_R15CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R15CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R15SEMCR register fields */
#define RCC_R15SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R15SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R15SEMCR_SEMCID_SHIFT		4

/* RCC_R16CIDCFGR register fields */
#define RCC_R16CIDCFGR_CFEN			BIT(0)
#define RCC_R16CIDCFGR_SEM_EN			BIT(1)
#define RCC_R16CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R16CIDCFGR_SCID_SHIFT		4
#define RCC_R16CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R16CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R16SEMCR register fields */
#define RCC_R16SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R16SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R16SEMCR_SEMCID_SHIFT		4

/* RCC_R17CIDCFGR register fields */
#define RCC_R17CIDCFGR_CFEN			BIT(0)
#define RCC_R17CIDCFGR_SEM_EN			BIT(1)
#define RCC_R17CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R17CIDCFGR_SCID_SHIFT		4
#define RCC_R17CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R17CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R17SEMCR register fields */
#define RCC_R17SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R17SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R17SEMCR_SEMCID_SHIFT		4

/* RCC_R18CIDCFGR register fields */
#define RCC_R18CIDCFGR_CFEN			BIT(0)
#define RCC_R18CIDCFGR_SEM_EN			BIT(1)
#define RCC_R18CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R18CIDCFGR_SCID_SHIFT		4
#define RCC_R18CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R18CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R18SEMCR register fields */
#define RCC_R18SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R18SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R18SEMCR_SEMCID_SHIFT		4

/* RCC_R19CIDCFGR register fields */
#define RCC_R19CIDCFGR_CFEN			BIT(0)
#define RCC_R19CIDCFGR_SEM_EN			BIT(1)
#define RCC_R19CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R19CIDCFGR_SCID_SHIFT		4
#define RCC_R19CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R19CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R19SEMCR register fields */
#define RCC_R19SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R19SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R19SEMCR_SEMCID_SHIFT		4

/* RCC_R20CIDCFGR register fields */
#define RCC_R20CIDCFGR_CFEN			BIT(0)
#define RCC_R20CIDCFGR_SEM_EN			BIT(1)
#define RCC_R20CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R20CIDCFGR_SCID_SHIFT		4
#define RCC_R20CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R20CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R20SEMCR register fields */
#define RCC_R20SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R20SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R20SEMCR_SEMCID_SHIFT		4

/* RCC_R21CIDCFGR register fields */
#define RCC_R21CIDCFGR_CFEN			BIT(0)
#define RCC_R21CIDCFGR_SEM_EN			BIT(1)
#define RCC_R21CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R21CIDCFGR_SCID_SHIFT		4
#define RCC_R21CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R21CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R21SEMCR register fields */
#define RCC_R21SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R21SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R21SEMCR_SEMCID_SHIFT		4

/* RCC_R22CIDCFGR register fields */
#define RCC_R22CIDCFGR_CFEN			BIT(0)
#define RCC_R22CIDCFGR_SEM_EN			BIT(1)
#define RCC_R22CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R22CIDCFGR_SCID_SHIFT		4
#define RCC_R22CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R22CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R22SEMCR register fields */
#define RCC_R22SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R22SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R22SEMCR_SEMCID_SHIFT		4

/* RCC_R23CIDCFGR register fields */
#define RCC_R23CIDCFGR_CFEN			BIT(0)
#define RCC_R23CIDCFGR_SEM_EN			BIT(1)
#define RCC_R23CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R23CIDCFGR_SCID_SHIFT		4
#define RCC_R23CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R23CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R23SEMCR register fields */
#define RCC_R23SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R23SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R23SEMCR_SEMCID_SHIFT		4

/* RCC_R24CIDCFGR register fields */
#define RCC_R24CIDCFGR_CFEN			BIT(0)
#define RCC_R24CIDCFGR_SEM_EN			BIT(1)
#define RCC_R24CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R24CIDCFGR_SCID_SHIFT		4
#define RCC_R24CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R24CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R24SEMCR register fields */
#define RCC_R24SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R24SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R24SEMCR_SEMCID_SHIFT		4

/* RCC_R25CIDCFGR register fields */
#define RCC_R25CIDCFGR_CFEN			BIT(0)
#define RCC_R25CIDCFGR_SEM_EN			BIT(1)
#define RCC_R25CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R25CIDCFGR_SCID_SHIFT		4
#define RCC_R25CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R25CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R25SEMCR register fields */
#define RCC_R25SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R25SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R25SEMCR_SEMCID_SHIFT		4

/* RCC_R26CIDCFGR register fields */
#define RCC_R26CIDCFGR_CFEN			BIT(0)
#define RCC_R26CIDCFGR_SEM_EN			BIT(1)
#define RCC_R26CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R26CIDCFGR_SCID_SHIFT		4
#define RCC_R26CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R26CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R26SEMCR register fields */
#define RCC_R26SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R26SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R26SEMCR_SEMCID_SHIFT		4

/* RCC_R27CIDCFGR register fields */
#define RCC_R27CIDCFGR_CFEN			BIT(0)
#define RCC_R27CIDCFGR_SEM_EN			BIT(1)
#define RCC_R27CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R27CIDCFGR_SCID_SHIFT		4
#define RCC_R27CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R27CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R27SEMCR register fields */
#define RCC_R27SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R27SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R27SEMCR_SEMCID_SHIFT		4

/* RCC_R28CIDCFGR register fields */
#define RCC_R28CIDCFGR_CFEN			BIT(0)
#define RCC_R28CIDCFGR_SEM_EN			BIT(1)
#define RCC_R28CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R28CIDCFGR_SCID_SHIFT		4
#define RCC_R28CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R28CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R28SEMCR register fields */
#define RCC_R28SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R28SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R28SEMCR_SEMCID_SHIFT		4

/* RCC_R29CIDCFGR register fields */
#define RCC_R29CIDCFGR_CFEN			BIT(0)
#define RCC_R29CIDCFGR_SEM_EN			BIT(1)
#define RCC_R29CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R29CIDCFGR_SCID_SHIFT		4
#define RCC_R29CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R29CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R29SEMCR register fields */
#define RCC_R29SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R29SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R29SEMCR_SEMCID_SHIFT		4

/* RCC_R30CIDCFGR register fields */
#define RCC_R30CIDCFGR_CFEN			BIT(0)
#define RCC_R30CIDCFGR_SEM_EN			BIT(1)
#define RCC_R30CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R30CIDCFGR_SCID_SHIFT		4
#define RCC_R30CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R30CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R30SEMCR register fields */
#define RCC_R30SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R30SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R30SEMCR_SEMCID_SHIFT		4

/* RCC_R31CIDCFGR register fields */
#define RCC_R31CIDCFGR_CFEN			BIT(0)
#define RCC_R31CIDCFGR_SEM_EN			BIT(1)
#define RCC_R31CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R31CIDCFGR_SCID_SHIFT		4
#define RCC_R31CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R31CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R31SEMCR register fields */
#define RCC_R31SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R31SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R31SEMCR_SEMCID_SHIFT		4

/* RCC_R32CIDCFGR register fields */
#define RCC_R32CIDCFGR_CFEN			BIT(0)
#define RCC_R32CIDCFGR_SEM_EN			BIT(1)
#define RCC_R32CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R32CIDCFGR_SCID_SHIFT		4
#define RCC_R32CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R32CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R32SEMCR register fields */
#define RCC_R32SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R32SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R32SEMCR_SEMCID_SHIFT		4

/* RCC_R33CIDCFGR register fields */
#define RCC_R33CIDCFGR_CFEN			BIT(0)
#define RCC_R33CIDCFGR_SEM_EN			BIT(1)
#define RCC_R33CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R33CIDCFGR_SCID_SHIFT		4
#define RCC_R33CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R33CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R33SEMCR register fields */
#define RCC_R33SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R33SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R33SEMCR_SEMCID_SHIFT		4

/* RCC_R34CIDCFGR register fields */
#define RCC_R34CIDCFGR_CFEN			BIT(0)
#define RCC_R34CIDCFGR_SEM_EN			BIT(1)
#define RCC_R34CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R34CIDCFGR_SCID_SHIFT		4
#define RCC_R34CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R34CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R34SEMCR register fields */
#define RCC_R34SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R34SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R34SEMCR_SEMCID_SHIFT		4

/* RCC_R35CIDCFGR register fields */
#define RCC_R35CIDCFGR_CFEN			BIT(0)
#define RCC_R35CIDCFGR_SEM_EN			BIT(1)
#define RCC_R35CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R35CIDCFGR_SCID_SHIFT		4
#define RCC_R35CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R35CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R35SEMCR register fields */
#define RCC_R35SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R35SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R35SEMCR_SEMCID_SHIFT		4

/* RCC_R36CIDCFGR register fields */
#define RCC_R36CIDCFGR_CFEN			BIT(0)
#define RCC_R36CIDCFGR_SEM_EN			BIT(1)
#define RCC_R36CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R36CIDCFGR_SCID_SHIFT		4
#define RCC_R36CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R36CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R36SEMCR register fields */
#define RCC_R36SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R36SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R36SEMCR_SEMCID_SHIFT		4

/* RCC_R37CIDCFGR register fields */
#define RCC_R37CIDCFGR_CFEN			BIT(0)
#define RCC_R37CIDCFGR_SEM_EN			BIT(1)
#define RCC_R37CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R37CIDCFGR_SCID_SHIFT		4
#define RCC_R37CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R37CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R37SEMCR register fields */
#define RCC_R37SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R37SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R37SEMCR_SEMCID_SHIFT		4

/* RCC_R38CIDCFGR register fields */
#define RCC_R38CIDCFGR_CFEN			BIT(0)
#define RCC_R38CIDCFGR_SEM_EN			BIT(1)
#define RCC_R38CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R38CIDCFGR_SCID_SHIFT		4
#define RCC_R38CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R38CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R38SEMCR register fields */
#define RCC_R38SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R38SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R38SEMCR_SEMCID_SHIFT		4

/* RCC_R39CIDCFGR register fields */
#define RCC_R39CIDCFGR_CFEN			BIT(0)
#define RCC_R39CIDCFGR_SEM_EN			BIT(1)
#define RCC_R39CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R39CIDCFGR_SCID_SHIFT		4
#define RCC_R39CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R39CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R39SEMCR register fields */
#define RCC_R39SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R39SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R39SEMCR_SEMCID_SHIFT		4

/* RCC_R40CIDCFGR register fields */
#define RCC_R40CIDCFGR_CFEN			BIT(0)
#define RCC_R40CIDCFGR_SEM_EN			BIT(1)
#define RCC_R40CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R40CIDCFGR_SCID_SHIFT		4
#define RCC_R40CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R40CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R40SEMCR register fields */
#define RCC_R40SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R40SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R40SEMCR_SEMCID_SHIFT		4

/* RCC_R41CIDCFGR register fields */
#define RCC_R41CIDCFGR_CFEN			BIT(0)
#define RCC_R41CIDCFGR_SEM_EN			BIT(1)
#define RCC_R41CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R41CIDCFGR_SCID_SHIFT		4
#define RCC_R41CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R41CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R41SEMCR register fields */
#define RCC_R41SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R41SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R41SEMCR_SEMCID_SHIFT		4

/* RCC_R42CIDCFGR register fields */
#define RCC_R42CIDCFGR_CFEN			BIT(0)
#define RCC_R42CIDCFGR_SEM_EN			BIT(1)
#define RCC_R42CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R42CIDCFGR_SCID_SHIFT		4
#define RCC_R42CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R42CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R42SEMCR register fields */
#define RCC_R42SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R42SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R42SEMCR_SEMCID_SHIFT		4

/* RCC_R43CIDCFGR register fields */
#define RCC_R43CIDCFGR_CFEN			BIT(0)
#define RCC_R43CIDCFGR_SEM_EN			BIT(1)
#define RCC_R43CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R43CIDCFGR_SCID_SHIFT		4
#define RCC_R43CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R43CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R43SEMCR register fields */
#define RCC_R43SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R43SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R43SEMCR_SEMCID_SHIFT		4

/* RCC_R44CIDCFGR register fields */
#define RCC_R44CIDCFGR_CFEN			BIT(0)
#define RCC_R44CIDCFGR_SEM_EN			BIT(1)
#define RCC_R44CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R44CIDCFGR_SCID_SHIFT		4
#define RCC_R44CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R44CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R44SEMCR register fields */
#define RCC_R44SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R44SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R44SEMCR_SEMCID_SHIFT		4

/* RCC_R45CIDCFGR register fields */
#define RCC_R45CIDCFGR_CFEN			BIT(0)
#define RCC_R45CIDCFGR_SEM_EN			BIT(1)
#define RCC_R45CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R45CIDCFGR_SCID_SHIFT		4
#define RCC_R45CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R45CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R45SEMCR register fields */
#define RCC_R45SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R45SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R45SEMCR_SEMCID_SHIFT		4

/* RCC_R46CIDCFGR register fields */
#define RCC_R46CIDCFGR_CFEN			BIT(0)
#define RCC_R46CIDCFGR_SEM_EN			BIT(1)
#define RCC_R46CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R46CIDCFGR_SCID_SHIFT		4
#define RCC_R46CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R46CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R46SEMCR register fields */
#define RCC_R46SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R46SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R46SEMCR_SEMCID_SHIFT		4

/* RCC_R47CIDCFGR register fields */
#define RCC_R47CIDCFGR_CFEN			BIT(0)
#define RCC_R47CIDCFGR_SEM_EN			BIT(1)
#define RCC_R47CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R47CIDCFGR_SCID_SHIFT		4
#define RCC_R47CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R47CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R47SEMCR register fields */
#define RCC_R47SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R47SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R47SEMCR_SEMCID_SHIFT		4

/* RCC_R48CIDCFGR register fields */
#define RCC_R48CIDCFGR_CFEN			BIT(0)
#define RCC_R48CIDCFGR_SEM_EN			BIT(1)
#define RCC_R48CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R48CIDCFGR_SCID_SHIFT		4
#define RCC_R48CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R48CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R48SEMCR register fields */
#define RCC_R48SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R48SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R48SEMCR_SEMCID_SHIFT		4

/* RCC_R49CIDCFGR register fields */
#define RCC_R49CIDCFGR_CFEN			BIT(0)
#define RCC_R49CIDCFGR_SEM_EN			BIT(1)
#define RCC_R49CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R49CIDCFGR_SCID_SHIFT		4
#define RCC_R49CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R49CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R49SEMCR register fields */
#define RCC_R49SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R49SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R49SEMCR_SEMCID_SHIFT		4

/* RCC_R50CIDCFGR register fields */
#define RCC_R50CIDCFGR_CFEN			BIT(0)
#define RCC_R50CIDCFGR_SEM_EN			BIT(1)
#define RCC_R50CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R50CIDCFGR_SCID_SHIFT		4
#define RCC_R50CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R50CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R50SEMCR register fields */
#define RCC_R50SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R50SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R50SEMCR_SEMCID_SHIFT		4

/* RCC_R51CIDCFGR register fields */
#define RCC_R51CIDCFGR_CFEN			BIT(0)
#define RCC_R51CIDCFGR_SEM_EN			BIT(1)
#define RCC_R51CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R51CIDCFGR_SCID_SHIFT		4
#define RCC_R51CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R51CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R51SEMCR register fields */
#define RCC_R51SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R51SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R51SEMCR_SEMCID_SHIFT		4

/* RCC_R52CIDCFGR register fields */
#define RCC_R52CIDCFGR_CFEN			BIT(0)
#define RCC_R52CIDCFGR_SEM_EN			BIT(1)
#define RCC_R52CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R52CIDCFGR_SCID_SHIFT		4
#define RCC_R52CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R52CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R52SEMCR register fields */
#define RCC_R52SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R52SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R52SEMCR_SEMCID_SHIFT		4

/* RCC_R53CIDCFGR register fields */
#define RCC_R53CIDCFGR_CFEN			BIT(0)
#define RCC_R53CIDCFGR_SEM_EN			BIT(1)
#define RCC_R53CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R53CIDCFGR_SCID_SHIFT		4
#define RCC_R53CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R53CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R53SEMCR register fields */
#define RCC_R53SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R53SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R53SEMCR_SEMCID_SHIFT		4

/* RCC_R54CIDCFGR register fields */
#define RCC_R54CIDCFGR_CFEN			BIT(0)
#define RCC_R54CIDCFGR_SEM_EN			BIT(1)
#define RCC_R54CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R54CIDCFGR_SCID_SHIFT		4
#define RCC_R54CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R54CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R54SEMCR register fields */
#define RCC_R54SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R54SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R54SEMCR_SEMCID_SHIFT		4

/* RCC_R55CIDCFGR register fields */
#define RCC_R55CIDCFGR_CFEN			BIT(0)
#define RCC_R55CIDCFGR_SEM_EN			BIT(1)
#define RCC_R55CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R55CIDCFGR_SCID_SHIFT		4
#define RCC_R55CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R55CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R55SEMCR register fields */
#define RCC_R55SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R55SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R55SEMCR_SEMCID_SHIFT		4

/* RCC_R56CIDCFGR register fields */
#define RCC_R56CIDCFGR_CFEN			BIT(0)
#define RCC_R56CIDCFGR_SEM_EN			BIT(1)
#define RCC_R56CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R56CIDCFGR_SCID_SHIFT		4
#define RCC_R56CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R56CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R56SEMCR register fields */
#define RCC_R56SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R56SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R56SEMCR_SEMCID_SHIFT		4

/* RCC_R57CIDCFGR register fields */
#define RCC_R57CIDCFGR_CFEN			BIT(0)
#define RCC_R57CIDCFGR_SEM_EN			BIT(1)
#define RCC_R57CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R57CIDCFGR_SCID_SHIFT		4
#define RCC_R57CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R57CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R57SEMCR register fields */
#define RCC_R57SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R57SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R57SEMCR_SEMCID_SHIFT		4

/* RCC_R58CIDCFGR register fields */
#define RCC_R58CIDCFGR_CFEN			BIT(0)
#define RCC_R58CIDCFGR_SEM_EN			BIT(1)
#define RCC_R58CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R58CIDCFGR_SCID_SHIFT		4
#define RCC_R58CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R58CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R58SEMCR register fields */
#define RCC_R58SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R58SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R58SEMCR_SEMCID_SHIFT		4

/* RCC_R59CIDCFGR register fields */
#define RCC_R59CIDCFGR_CFEN			BIT(0)
#define RCC_R59CIDCFGR_SEM_EN			BIT(1)
#define RCC_R59CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R59CIDCFGR_SCID_SHIFT		4
#define RCC_R59CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R59CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R59SEMCR register fields */
#define RCC_R59SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R59SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R59SEMCR_SEMCID_SHIFT		4

/* RCC_R60CIDCFGR register fields */
#define RCC_R60CIDCFGR_CFEN			BIT(0)
#define RCC_R60CIDCFGR_SEM_EN			BIT(1)
#define RCC_R60CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R60CIDCFGR_SCID_SHIFT		4
#define RCC_R60CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R60CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R60SEMCR register fields */
#define RCC_R60SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R60SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R60SEMCR_SEMCID_SHIFT		4

/* RCC_R61CIDCFGR register fields */
#define RCC_R61CIDCFGR_CFEN			BIT(0)
#define RCC_R61CIDCFGR_SEM_EN			BIT(1)
#define RCC_R61CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R61CIDCFGR_SCID_SHIFT		4
#define RCC_R61CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R61CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R61SEMCR register fields */
#define RCC_R61SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R61SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R61SEMCR_SEMCID_SHIFT		4

/* RCC_R62CIDCFGR register fields */
#define RCC_R62CIDCFGR_CFEN			BIT(0)
#define RCC_R62CIDCFGR_SEM_EN			BIT(1)
#define RCC_R62CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R62CIDCFGR_SCID_SHIFT		4
#define RCC_R62CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R62CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R62SEMCR register fields */
#define RCC_R62SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R62SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R62SEMCR_SEMCID_SHIFT		4

/* RCC_R63CIDCFGR register fields */
#define RCC_R63CIDCFGR_CFEN			BIT(0)
#define RCC_R63CIDCFGR_SEM_EN			BIT(1)
#define RCC_R63CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R63CIDCFGR_SCID_SHIFT		4
#define RCC_R63CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R63CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R63SEMCR register fields */
#define RCC_R63SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R63SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R63SEMCR_SEMCID_SHIFT		4

/* RCC_R64CIDCFGR register fields */
#define RCC_R64CIDCFGR_CFEN			BIT(0)
#define RCC_R64CIDCFGR_SEM_EN			BIT(1)
#define RCC_R64CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R64CIDCFGR_SCID_SHIFT		4
#define RCC_R64CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R64CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R64SEMCR register fields */
#define RCC_R64SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R64SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R64SEMCR_SEMCID_SHIFT		4

/* RCC_R65CIDCFGR register fields */
#define RCC_R65CIDCFGR_CFEN			BIT(0)
#define RCC_R65CIDCFGR_SEM_EN			BIT(1)
#define RCC_R65CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R65CIDCFGR_SCID_SHIFT		4
#define RCC_R65CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R65CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R65SEMCR register fields */
#define RCC_R65SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R65SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R65SEMCR_SEMCID_SHIFT		4

/* RCC_R66CIDCFGR register fields */
#define RCC_R66CIDCFGR_CFEN			BIT(0)
#define RCC_R66CIDCFGR_SEM_EN			BIT(1)
#define RCC_R66CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R66CIDCFGR_SCID_SHIFT		4
#define RCC_R66CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R66CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R66SEMCR register fields */
#define RCC_R66SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R66SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R66SEMCR_SEMCID_SHIFT		4

/* RCC_R67CIDCFGR register fields */
#define RCC_R67CIDCFGR_CFEN			BIT(0)
#define RCC_R67CIDCFGR_SEM_EN			BIT(1)
#define RCC_R67CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R67CIDCFGR_SCID_SHIFT		4
#define RCC_R67CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R67CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R67SEMCR register fields */
#define RCC_R67SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R67SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R67SEMCR_SEMCID_SHIFT		4

/* RCC_R68CIDCFGR register fields */
#define RCC_R68CIDCFGR_CFEN			BIT(0)
#define RCC_R68CIDCFGR_SEM_EN			BIT(1)
#define RCC_R68CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R68CIDCFGR_SCID_SHIFT		4
#define RCC_R68CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R68CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R68SEMCR register fields */
#define RCC_R68SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R68SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R68SEMCR_SEMCID_SHIFT		4

/* RCC_R69CIDCFGR register fields */
#define RCC_R69CIDCFGR_CFEN			BIT(0)
#define RCC_R69CIDCFGR_SEM_EN			BIT(1)
#define RCC_R69CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R69CIDCFGR_SCID_SHIFT		4
#define RCC_R69CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R69CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R69SEMCR register fields */
#define RCC_R69SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R69SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R69SEMCR_SEMCID_SHIFT		4

/* RCC_R70CIDCFGR register fields */
#define RCC_R70CIDCFGR_CFEN			BIT(0)
#define RCC_R70CIDCFGR_SEM_EN			BIT(1)
#define RCC_R70CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R70CIDCFGR_SCID_SHIFT		4
#define RCC_R70CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R70CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R70SEMCR register fields */
#define RCC_R70SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R70SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R70SEMCR_SEMCID_SHIFT		4

/* RCC_R71CIDCFGR register fields */
#define RCC_R71CIDCFGR_CFEN			BIT(0)
#define RCC_R71CIDCFGR_SEM_EN			BIT(1)
#define RCC_R71CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R71CIDCFGR_SCID_SHIFT		4
#define RCC_R71CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R71CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R71SEMCR register fields */
#define RCC_R71SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R71SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R71SEMCR_SEMCID_SHIFT		4

/* RCC_R72CIDCFGR register fields */
#define RCC_R72CIDCFGR_CFEN			BIT(0)
#define RCC_R72CIDCFGR_SEM_EN			BIT(1)
#define RCC_R72CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R72CIDCFGR_SCID_SHIFT		4
#define RCC_R72CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R72CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R72SEMCR register fields */
#define RCC_R72SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R72SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R72SEMCR_SEMCID_SHIFT		4

/* RCC_R73CIDCFGR register fields */
#define RCC_R73CIDCFGR_CFEN			BIT(0)
#define RCC_R73CIDCFGR_SEM_EN			BIT(1)
#define RCC_R73CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R73CIDCFGR_SCID_SHIFT		4
#define RCC_R73CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R73CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R73SEMCR register fields */
#define RCC_R73SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R73SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R73SEMCR_SEMCID_SHIFT		4

/* RCC_R74CIDCFGR register fields */
#define RCC_R74CIDCFGR_CFEN			BIT(0)
#define RCC_R74CIDCFGR_SEM_EN			BIT(1)
#define RCC_R74CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R74CIDCFGR_SCID_SHIFT		4
#define RCC_R74CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R74CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R74SEMCR register fields */
#define RCC_R74SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R74SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R74SEMCR_SEMCID_SHIFT		4

/* RCC_R75CIDCFGR register fields */
#define RCC_R75CIDCFGR_CFEN			BIT(0)
#define RCC_R75CIDCFGR_SEM_EN			BIT(1)
#define RCC_R75CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R75CIDCFGR_SCID_SHIFT		4
#define RCC_R75CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R75CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R75SEMCR register fields */
#define RCC_R75SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R75SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R75SEMCR_SEMCID_SHIFT		4

/* RCC_R76CIDCFGR register fields */
#define RCC_R76CIDCFGR_CFEN			BIT(0)
#define RCC_R76CIDCFGR_SEM_EN			BIT(1)
#define RCC_R76CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R76CIDCFGR_SCID_SHIFT		4
#define RCC_R76CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R76CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R76SEMCR register fields */
#define RCC_R76SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R76SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R76SEMCR_SEMCID_SHIFT		4

/* RCC_R77CIDCFGR register fields */
#define RCC_R77CIDCFGR_CFEN			BIT(0)
#define RCC_R77CIDCFGR_SEM_EN			BIT(1)
#define RCC_R77CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R77CIDCFGR_SCID_SHIFT		4
#define RCC_R77CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R77CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R77SEMCR register fields */
#define RCC_R77SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R77SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R77SEMCR_SEMCID_SHIFT		4

/* RCC_R78CIDCFGR register fields */
#define RCC_R78CIDCFGR_CFEN			BIT(0)
#define RCC_R78CIDCFGR_SEM_EN			BIT(1)
#define RCC_R78CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R78CIDCFGR_SCID_SHIFT		4
#define RCC_R78CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R78CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R78SEMCR register fields */
#define RCC_R78SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R78SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R78SEMCR_SEMCID_SHIFT		4

/* RCC_R79CIDCFGR register fields */
#define RCC_R79CIDCFGR_CFEN			BIT(0)
#define RCC_R79CIDCFGR_SEM_EN			BIT(1)
#define RCC_R79CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R79CIDCFGR_SCID_SHIFT		4
#define RCC_R79CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R79CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R79SEMCR register fields */
#define RCC_R79SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R79SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R79SEMCR_SEMCID_SHIFT		4

/* RCC_R80CIDCFGR register fields */
#define RCC_R80CIDCFGR_CFEN			BIT(0)
#define RCC_R80CIDCFGR_SEM_EN			BIT(1)
#define RCC_R80CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R80CIDCFGR_SCID_SHIFT		4
#define RCC_R80CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R80CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R80SEMCR register fields */
#define RCC_R80SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R80SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R80SEMCR_SEMCID_SHIFT		4

/* RCC_R81CIDCFGR register fields */
#define RCC_R81CIDCFGR_CFEN			BIT(0)
#define RCC_R81CIDCFGR_SEM_EN			BIT(1)
#define RCC_R81CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R81CIDCFGR_SCID_SHIFT		4
#define RCC_R81CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R81CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R81SEMCR register fields */
#define RCC_R81SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R81SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R81SEMCR_SEMCID_SHIFT		4

/* RCC_R82CIDCFGR register fields */
#define RCC_R82CIDCFGR_CFEN			BIT(0)
#define RCC_R82CIDCFGR_SEM_EN			BIT(1)
#define RCC_R82CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R82CIDCFGR_SCID_SHIFT		4
#define RCC_R82CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R82CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R82SEMCR register fields */
#define RCC_R82SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R82SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R82SEMCR_SEMCID_SHIFT		4

/* RCC_R83CIDCFGR register fields */
#define RCC_R83CIDCFGR_CFEN			BIT(0)
#define RCC_R83CIDCFGR_SEM_EN			BIT(1)
#define RCC_R83CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R83CIDCFGR_SCID_SHIFT		4
#define RCC_R83CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R83CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R83SEMCR register fields */
#define RCC_R83SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R83SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R83SEMCR_SEMCID_SHIFT		4

/* RCC_R84CIDCFGR register fields */
#define RCC_R84CIDCFGR_CFEN			BIT(0)
#define RCC_R84CIDCFGR_SEM_EN			BIT(1)
#define RCC_R84CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R84CIDCFGR_SCID_SHIFT		4
#define RCC_R84CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R84CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R84SEMCR register fields */
#define RCC_R84SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R84SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R84SEMCR_SEMCID_SHIFT		4

/* RCC_R85CIDCFGR register fields */
#define RCC_R85CIDCFGR_CFEN			BIT(0)
#define RCC_R85CIDCFGR_SEM_EN			BIT(1)
#define RCC_R85CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R85CIDCFGR_SCID_SHIFT		4
#define RCC_R85CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R85CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R85SEMCR register fields */
#define RCC_R85SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R85SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R85SEMCR_SEMCID_SHIFT		4

/* RCC_R86CIDCFGR register fields */
#define RCC_R86CIDCFGR_CFEN			BIT(0)
#define RCC_R86CIDCFGR_SEM_EN			BIT(1)
#define RCC_R86CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R86CIDCFGR_SCID_SHIFT		4
#define RCC_R86CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R86CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R86SEMCR register fields */
#define RCC_R86SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R86SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R86SEMCR_SEMCID_SHIFT		4

/* RCC_R87CIDCFGR register fields */
#define RCC_R87CIDCFGR_CFEN			BIT(0)
#define RCC_R87CIDCFGR_SEM_EN			BIT(1)
#define RCC_R87CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R87CIDCFGR_SCID_SHIFT		4
#define RCC_R87CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R87CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R87SEMCR register fields */
#define RCC_R87SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R87SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R87SEMCR_SEMCID_SHIFT		4

/* RCC_R88CIDCFGR register fields */
#define RCC_R88CIDCFGR_CFEN			BIT(0)
#define RCC_R88CIDCFGR_SEM_EN			BIT(1)
#define RCC_R88CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R88CIDCFGR_SCID_SHIFT		4
#define RCC_R88CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R88CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R88SEMCR register fields */
#define RCC_R88SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R88SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R88SEMCR_SEMCID_SHIFT		4

/* RCC_R89CIDCFGR register fields */
#define RCC_R89CIDCFGR_CFEN			BIT(0)
#define RCC_R89CIDCFGR_SEM_EN			BIT(1)
#define RCC_R89CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R89CIDCFGR_SCID_SHIFT		4
#define RCC_R89CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R89CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R89SEMCR register fields */
#define RCC_R89SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R89SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R89SEMCR_SEMCID_SHIFT		4

/* RCC_R90CIDCFGR register fields */
#define RCC_R90CIDCFGR_CFEN			BIT(0)
#define RCC_R90CIDCFGR_SEM_EN			BIT(1)
#define RCC_R90CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R90CIDCFGR_SCID_SHIFT		4
#define RCC_R90CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R90CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R90SEMCR register fields */
#define RCC_R90SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R90SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R90SEMCR_SEMCID_SHIFT		4

/* RCC_R91CIDCFGR register fields */
#define RCC_R91CIDCFGR_CFEN			BIT(0)
#define RCC_R91CIDCFGR_SEM_EN			BIT(1)
#define RCC_R91CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R91CIDCFGR_SCID_SHIFT		4
#define RCC_R91CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R91CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R91SEMCR register fields */
#define RCC_R91SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R91SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R91SEMCR_SEMCID_SHIFT		4

/* RCC_R92CIDCFGR register fields */
#define RCC_R92CIDCFGR_CFEN			BIT(0)
#define RCC_R92CIDCFGR_SEM_EN			BIT(1)
#define RCC_R92CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R92CIDCFGR_SCID_SHIFT		4
#define RCC_R92CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R92CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R92SEMCR register fields */
#define RCC_R92SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R92SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R92SEMCR_SEMCID_SHIFT		4

/* RCC_R93CIDCFGR register fields */
#define RCC_R93CIDCFGR_CFEN			BIT(0)
#define RCC_R93CIDCFGR_SEM_EN			BIT(1)
#define RCC_R93CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R93CIDCFGR_SCID_SHIFT		4
#define RCC_R93CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R93CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R93SEMCR register fields */
#define RCC_R93SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R93SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R93SEMCR_SEMCID_SHIFT		4

/* RCC_R94CIDCFGR register fields */
#define RCC_R94CIDCFGR_CFEN			BIT(0)
#define RCC_R94CIDCFGR_SEM_EN			BIT(1)
#define RCC_R94CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R94CIDCFGR_SCID_SHIFT		4
#define RCC_R94CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R94CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R94SEMCR register fields */
#define RCC_R94SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R94SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R94SEMCR_SEMCID_SHIFT		4

/* RCC_R95CIDCFGR register fields */
#define RCC_R95CIDCFGR_CFEN			BIT(0)
#define RCC_R95CIDCFGR_SEM_EN			BIT(1)
#define RCC_R95CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R95CIDCFGR_SCID_SHIFT		4
#define RCC_R95CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R95CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R95SEMCR register fields */
#define RCC_R95SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R95SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R95SEMCR_SEMCID_SHIFT		4

/* RCC_R96CIDCFGR register fields */
#define RCC_R96CIDCFGR_CFEN			BIT(0)
#define RCC_R96CIDCFGR_SEM_EN			BIT(1)
#define RCC_R96CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R96CIDCFGR_SCID_SHIFT		4
#define RCC_R96CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R96CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R96SEMCR register fields */
#define RCC_R96SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R96SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R96SEMCR_SEMCID_SHIFT		4

/* RCC_R97CIDCFGR register fields */
#define RCC_R97CIDCFGR_CFEN			BIT(0)
#define RCC_R97CIDCFGR_SEM_EN			BIT(1)
#define RCC_R97CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R97CIDCFGR_SCID_SHIFT		4
#define RCC_R97CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R97CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R97SEMCR register fields */
#define RCC_R97SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R97SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R97SEMCR_SEMCID_SHIFT		4

/* RCC_R98CIDCFGR register fields */
#define RCC_R98CIDCFGR_CFEN			BIT(0)
#define RCC_R98CIDCFGR_SEM_EN			BIT(1)
#define RCC_R98CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R98CIDCFGR_SCID_SHIFT		4
#define RCC_R98CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R98CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R98SEMCR register fields */
#define RCC_R98SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R98SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R98SEMCR_SEMCID_SHIFT		4

/* RCC_R99CIDCFGR register fields */
#define RCC_R99CIDCFGR_CFEN			BIT(0)
#define RCC_R99CIDCFGR_SEM_EN			BIT(1)
#define RCC_R99CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R99CIDCFGR_SCID_SHIFT		4
#define RCC_R99CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R99CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R99SEMCR register fields */
#define RCC_R99SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R99SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R99SEMCR_SEMCID_SHIFT		4

/* RCC_R100CIDCFGR register fields */
#define RCC_R100CIDCFGR_CFEN			BIT(0)
#define RCC_R100CIDCFGR_SEM_EN			BIT(1)
#define RCC_R100CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R100CIDCFGR_SCID_SHIFT		4
#define RCC_R100CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R100CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R100SEMCR register fields */
#define RCC_R100SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R100SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R100SEMCR_SEMCID_SHIFT		4

/* RCC_R101CIDCFGR register fields */
#define RCC_R101CIDCFGR_CFEN			BIT(0)
#define RCC_R101CIDCFGR_SEM_EN			BIT(1)
#define RCC_R101CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R101CIDCFGR_SCID_SHIFT		4
#define RCC_R101CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R101CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R101SEMCR register fields */
#define RCC_R101SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R101SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R101SEMCR_SEMCID_SHIFT		4

/* RCC_R102CIDCFGR register fields */
#define RCC_R102CIDCFGR_CFEN			BIT(0)
#define RCC_R102CIDCFGR_SEM_EN			BIT(1)
#define RCC_R102CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R102CIDCFGR_SCID_SHIFT		4
#define RCC_R102CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R102CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R102SEMCR register fields */
#define RCC_R102SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R102SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R102SEMCR_SEMCID_SHIFT		4

/* RCC_R103CIDCFGR register fields */
#define RCC_R103CIDCFGR_CFEN			BIT(0)
#define RCC_R103CIDCFGR_SEM_EN			BIT(1)
#define RCC_R103CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R103CIDCFGR_SCID_SHIFT		4
#define RCC_R103CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R103CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R103SEMCR register fields */
#define RCC_R103SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R103SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R103SEMCR_SEMCID_SHIFT		4

/* RCC_R104CIDCFGR register fields */
#define RCC_R104CIDCFGR_CFEN			BIT(0)
#define RCC_R104CIDCFGR_SEM_EN			BIT(1)
#define RCC_R104CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R104CIDCFGR_SCID_SHIFT		4
#define RCC_R104CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R104CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R104SEMCR register fields */
#define RCC_R104SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R104SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R104SEMCR_SEMCID_SHIFT		4

/* RCC_R105CIDCFGR register fields */
#define RCC_R105CIDCFGR_CFEN			BIT(0)
#define RCC_R105CIDCFGR_SEM_EN			BIT(1)
#define RCC_R105CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R105CIDCFGR_SCID_SHIFT		4
#define RCC_R105CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R105CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R105SEMCR register fields */
#define RCC_R105SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R105SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R105SEMCR_SEMCID_SHIFT		4

/* RCC_R106CIDCFGR register fields */
#define RCC_R106CIDCFGR_CFEN			BIT(0)
#define RCC_R106CIDCFGR_SEM_EN			BIT(1)
#define RCC_R106CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R106CIDCFGR_SCID_SHIFT		4
#define RCC_R106CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R106CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R106SEMCR register fields */
#define RCC_R106SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R106SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R106SEMCR_SEMCID_SHIFT		4

/* RCC_R107CIDCFGR register fields */
#define RCC_R107CIDCFGR_CFEN			BIT(0)
#define RCC_R107CIDCFGR_SEM_EN			BIT(1)
#define RCC_R107CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R107CIDCFGR_SCID_SHIFT		4
#define RCC_R107CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R107CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R107SEMCR register fields */
#define RCC_R107SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R107SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R107SEMCR_SEMCID_SHIFT		4

/* RCC_R108CIDCFGR register fields */
#define RCC_R108CIDCFGR_CFEN			BIT(0)
#define RCC_R108CIDCFGR_SEM_EN			BIT(1)
#define RCC_R108CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R108CIDCFGR_SCID_SHIFT		4
#define RCC_R108CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R108CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R108SEMCR register fields */
#define RCC_R108SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R108SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R108SEMCR_SEMCID_SHIFT		4

/* RCC_R109CIDCFGR register fields */
#define RCC_R109CIDCFGR_CFEN			BIT(0)
#define RCC_R109CIDCFGR_SEM_EN			BIT(1)
#define RCC_R109CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R109CIDCFGR_SCID_SHIFT		4
#define RCC_R109CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R109CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R109SEMCR register fields */
#define RCC_R109SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R109SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R109SEMCR_SEMCID_SHIFT		4

/* RCC_R110CIDCFGR register fields */
#define RCC_R110CIDCFGR_CFEN			BIT(0)
#define RCC_R110CIDCFGR_SEM_EN			BIT(1)
#define RCC_R110CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R110CIDCFGR_SCID_SHIFT		4
#define RCC_R110CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R110CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R110SEMCR register fields */
#define RCC_R110SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R110SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R110SEMCR_SEMCID_SHIFT		4

/* RCC_R111CIDCFGR register fields */
#define RCC_R111CIDCFGR_CFEN			BIT(0)
#define RCC_R111CIDCFGR_SEM_EN			BIT(1)
#define RCC_R111CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R111CIDCFGR_SCID_SHIFT		4
#define RCC_R111CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R111CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R111SEMCR register fields */
#define RCC_R111SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R111SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R111SEMCR_SEMCID_SHIFT		4

/* RCC_R112CIDCFGR register fields */
#define RCC_R112CIDCFGR_CFEN			BIT(0)
#define RCC_R112CIDCFGR_SEM_EN			BIT(1)
#define RCC_R112CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R112CIDCFGR_SCID_SHIFT		4
#define RCC_R112CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R112CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R112SEMCR register fields */
#define RCC_R112SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R112SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R112SEMCR_SEMCID_SHIFT		4

/* RCC_R113CIDCFGR register fields */
#define RCC_R113CIDCFGR_CFEN			BIT(0)
#define RCC_R113CIDCFGR_SEM_EN			BIT(1)
#define RCC_R113CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define RCC_R113CIDCFGR_SCID_SHIFT		4
#define RCC_R113CIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_R113CIDCFGR_SEMWLC_SHIFT		16

/* RCC_R113SEMCR register fields */
#define RCC_R113SEMCR_SEM_MUTEX			BIT(0)
#define RCC_R113SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define RCC_R113SEMCR_SEMCID_SHIFT		4

/* RCC_RxCIDCFGR register fields */
#define RCC_RxCIDCFGR_CFEN			BIT(0)
#define RCC_RxCIDCFGR_SEM_EN			BIT(1)
#define RCC_RxCIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define RCC_RxCIDCFGR_SCID_SHIFT		4
#define RCC_RxCIDCFGR_SEMWLC_MASK		GENMASK_32(23, 16)
#define RCC_RxCIDCFGR_SEMWLC_SHIFT		16

/* RCC_RxSEMCR register fields */
#define RCC_RxSEMCR_SEM_MUTEX			BIT(0)
#define RCC_RxSEMCR_SEMCID_MASK			GENMASK_32(6, 4)
#define RCC_RxSEMCR_SEMCID_SHIFT		4

/* RCC_GRSTCSETR register fields */
#define RCC_GRSTCSETR_SYSRST			BIT(0)

/* RCC_C1RSTCSETR register fields */
#define RCC_C1RSTCSETR_C1RST			BIT(0)

/* RCC_C1P1RSTCSETR register fields */
#define RCC_C1P1RSTCSETR_C1P1PORRST		BIT(0)
#define RCC_C1P1RSTCSETR_C1P1RST		BIT(1)

/* RCC_C2RSTCSETR register fields */
#define RCC_C2RSTCSETR_C2RST			BIT(0)

/* RCC_CxRSTCSETR register fields */
#define RCC_CxRSTCSETR_CxRST			BIT(0)

/* RCC_HWRSTSCLRR register fields */
#define RCC_HWRSTSCLRR_PORRSTF			BIT(0)
#define RCC_HWRSTSCLRR_BORRSTF			BIT(1)
#define RCC_HWRSTSCLRR_PADRSTF			BIT(2)
#define RCC_HWRSTSCLRR_HCSSRSTF			BIT(3)
#define RCC_HWRSTSCLRR_VCORERSTF		BIT(4)
#define RCC_HWRSTSCLRR_SYSC1RSTF		BIT(5)
#define RCC_HWRSTSCLRR_SYSC2RSTF		BIT(6)
#define RCC_HWRSTSCLRR_IWDG1SYSRSTF		BIT(7)
#define RCC_HWRSTSCLRR_IWDG2SYSRSTF		BIT(8)
#define RCC_HWRSTSCLRR_IWDG3SYSRSTF		BIT(9)
#define RCC_HWRSTSCLRR_IWDG4SYSRSTF		BIT(10)
#define RCC_HWRSTSCLRR_IWDG5SYSRSTF		BIT(11)
#define RCC_HWRSTSCLRR_RETCRCERRRSTF		BIT(12)
#define RCC_HWRSTSCLRR_RETECCFAILCRCRSTF	BIT(13)
#define RCC_HWRSTSCLRR_RETECCFAILRESTRSTF	BIT(14)

/* RCC_C1HWRSTSCLRR register fields */
#define RCC_C1HWRSTSCLRR_VCPURSTF		BIT(0)
#define RCC_C1HWRSTSCLRR_C1RSTF			BIT(1)
#define RCC_C1HWRSTSCLRR_C1P1RSTF		BIT(2)

/* RCC_C2HWRSTSCLRR register fields */
#define RCC_C2HWRSTSCLRR_C2RSTF			BIT(0)

/* RCC_C1BOOTRSTSSETR register fields */
#define RCC_C1BOOTRSTSSETR_PORRSTF		BIT(0)
#define RCC_C1BOOTRSTSSETR_BORRSTF		BIT(1)
#define RCC_C1BOOTRSTSSETR_PADRSTF		BIT(2)
#define RCC_C1BOOTRSTSSETR_HCSSRSTF		BIT(3)
#define RCC_C1BOOTRSTSSETR_VCORERSTF		BIT(4)
#define RCC_C1BOOTRSTSSETR_VCPURSTF		BIT(5)
#define RCC_C1BOOTRSTSSETR_SYSC1RSTF		BIT(6)
#define RCC_C1BOOTRSTSSETR_SYSC2RSTF		BIT(7)
#define RCC_C1BOOTRSTSSETR_IWDG1SYSRSTF		BIT(8)
#define RCC_C1BOOTRSTSSETR_IWDG2SYSRSTF		BIT(9)
#define RCC_C1BOOTRSTSSETR_IWDG3SYSRSTF		BIT(10)
#define RCC_C1BOOTRSTSSETR_IWDG4SYSRSTF		BIT(11)
#define RCC_C1BOOTRSTSSETR_IWDG5SYSRSTF		BIT(12)
#define RCC_C1BOOTRSTSSETR_C1RSTF		BIT(13)
#define RCC_C1BOOTRSTSSETR_C1P1RSTF		BIT(16)
#define RCC_C1BOOTRSTSSETR_RETCRCERRRSTF	BIT(17)
#define RCC_C1BOOTRSTSSETR_RETECCFAILCRCRSTF	BIT(18)
#define RCC_C1BOOTRSTSSETR_RETECCFAILRESTRSTF	BIT(19)
#define RCC_C1BOOTRSTSSETR_STBYC1RSTF		BIT(20)
#define RCC_C1BOOTRSTSSETR_D1STBYRSTF		BIT(22)
#define RCC_C1BOOTRSTSSETR_D2STBYRSTF		BIT(23)

/* RCC_C1BOOTRSTSCLRR register fields */
#define RCC_C1BOOTRSTSCLRR_PORRSTF		BIT(0)
#define RCC_C1BOOTRSTSCLRR_BORRSTF		BIT(1)
#define RCC_C1BOOTRSTSCLRR_PADRSTF		BIT(2)
#define RCC_C1BOOTRSTSCLRR_HCSSRSTF		BIT(3)
#define RCC_C1BOOTRSTSCLRR_VCORERSTF		BIT(4)
#define RCC_C1BOOTRSTSCLRR_VCPURSTF		BIT(5)
#define RCC_C1BOOTRSTSCLRR_SYSC1RSTF		BIT(6)
#define RCC_C1BOOTRSTSCLRR_SYSC2RSTF		BIT(7)
#define RCC_C1BOOTRSTSCLRR_IWDG1SYSRSTF		BIT(8)
#define RCC_C1BOOTRSTSCLRR_IWDG2SYSRSTF		BIT(9)
#define RCC_C1BOOTRSTSCLRR_IWDG3SYSRSTF		BIT(10)
#define RCC_C1BOOTRSTSCLRR_IWDG4SYSRSTF		BIT(11)
#define RCC_C1BOOTRSTSCLRR_IWDG5SYSRSTF		BIT(12)
#define RCC_C1BOOTRSTSCLRR_C1RSTF		BIT(13)
#define RCC_C1BOOTRSTSCLRR_C1P1RSTF		BIT(16)
#define RCC_C1BOOTRSTSCLRR_RETCRCERRRSTF	BIT(17)
#define RCC_C1BOOTRSTSCLRR_RETECCFAILCRCRSTF	BIT(18)
#define RCC_C1BOOTRSTSCLRR_RETECCFAILRESTRSTF	BIT(19)
#define RCC_C1BOOTRSTSCLRR_STBYC1RSTF		BIT(20)
#define RCC_C1BOOTRSTSCLRR_D1STBYRSTF		BIT(22)
#define RCC_C1BOOTRSTSCLRR_D2STBYRSTF		BIT(23)

#define RCC_C1BOOTRSTSCLRR_IWDGXSYSRSTF (RCC_C1BOOTRSTSCLRR_IWDG1SYSRSTF | \
					 RCC_C1BOOTRSTSCLRR_IWDG2SYSRSTF | \
					 RCC_C1BOOTRSTSCLRR_IWDG3SYSRSTF | \
					 RCC_C1BOOTRSTSCLRR_IWDG4SYSRSTF | \
					 RCC_C1BOOTRSTSCLRR_IWDG5SYSRSTF)

/* RCC_C2BOOTRSTSSETR register fields */
#define RCC_C2BOOTRSTSSETR_PORRSTF		BIT(0)
#define RCC_C2BOOTRSTSSETR_BORRSTF		BIT(1)
#define RCC_C2BOOTRSTSSETR_PADRSTF		BIT(2)
#define RCC_C2BOOTRSTSSETR_HCSSRSTF		BIT(3)
#define RCC_C2BOOTRSTSSETR_VCORERSTF		BIT(4)
#define RCC_C2BOOTRSTSSETR_SYSC1RSTF		BIT(6)
#define RCC_C2BOOTRSTSSETR_SYSC2RSTF		BIT(7)
#define RCC_C2BOOTRSTSSETR_IWDG1SYSRSTF		BIT(8)
#define RCC_C2BOOTRSTSSETR_IWDG2SYSRSTF		BIT(9)
#define RCC_C2BOOTRSTSSETR_IWDG3SYSRSTF		BIT(10)
#define RCC_C2BOOTRSTSSETR_IWDG4SYSRSTF		BIT(11)
#define RCC_C2BOOTRSTSSETR_IWDG5SYSRSTF		BIT(12)
#define RCC_C2BOOTRSTSSETR_C2RSTF		BIT(14)
#define RCC_C2BOOTRSTSSETR_RETCRCERRRSTF	BIT(17)
#define RCC_C2BOOTRSTSSETR_RETECCFAILCRCRSTF	BIT(18)
#define RCC_C2BOOTRSTSSETR_RETECCFAILRESTRSTF	BIT(19)
#define RCC_C2BOOTRSTSSETR_STBYC2RSTF		BIT(21)
#define RCC_C2BOOTRSTSSETR_D2STBYRSTF		BIT(23)

/* RCC_C2BOOTRSTSCLRR register fields */
#define RCC_C2BOOTRSTSCLRR_PORRSTF		BIT(0)
#define RCC_C2BOOTRSTSCLRR_BORRSTF		BIT(1)
#define RCC_C2BOOTRSTSCLRR_PADRSTF		BIT(2)
#define RCC_C2BOOTRSTSCLRR_HCSSRSTF		BIT(3)
#define RCC_C2BOOTRSTSCLRR_VCORERSTF		BIT(4)
#define RCC_C2BOOTRSTSCLRR_SYSC1RSTF		BIT(6)
#define RCC_C2BOOTRSTSCLRR_SYSC2RSTF		BIT(7)
#define RCC_C2BOOTRSTSCLRR_IWDG1SYSRSTF		BIT(8)
#define RCC_C2BOOTRSTSCLRR_IWDG2SYSRSTF		BIT(9)
#define RCC_C2BOOTRSTSCLRR_IWDG3SYSRSTF		BIT(10)
#define RCC_C2BOOTRSTSCLRR_IWDG4SYSRSTF		BIT(11)
#define RCC_C2BOOTRSTSCLRR_IWDG5SYSRSTF		BIT(12)
#define RCC_C2BOOTRSTSCLRR_C2RSTF		BIT(14)
#define RCC_C2BOOTRSTSCLRR_RETCRCERRRSTF	BIT(17)
#define RCC_C2BOOTRSTSCLRR_RETECCFAILCRCRSTF	BIT(18)
#define RCC_C2BOOTRSTSCLRR_RETECCFAILRESTRSTF	BIT(19)
#define RCC_C2BOOTRSTSCLRR_STBYC2RSTF		BIT(21)
#define RCC_C2BOOTRSTSCLRR_D2STBYRSTF		BIT(23)

/* RCC_C1SREQSETR register fields */
#define RCC_C1SREQSETR_STPREQ_P0		BIT(0)
#define RCC_C1SREQSETR_STPREQ_P1		BIT(1)
#define RCC_C1SREQSETR_STPREQ_MASK		GENMASK_32(1, 0)
#define RCC_C1SREQSETR_ESLPREQ			BIT(16)

/* RCC_C1SREQCLRR register fields */
#define RCC_C1SREQCLRR_STPREQ_P0		BIT(0)
#define RCC_C1SREQCLRR_STPREQ_P1		BIT(1)
#define RCC_C1SREQCLRR_STPREQ_MASK		GENMASK_32(1, 0)
#define RCC_C1SREQCLRR_ESLPREQ			BIT(16)

/* RCC_CPUBOOTCR register fields */
#define RCC_CPUBOOTCR_BOOT_CPU2			BIT(0)
#define RCC_CPUBOOTCR_BOOT_CPU1			BIT(1)

/* RCC_STBYBOOTCR register fields */
#define RCC_STBYBOOTCR_CPU_BEN_SEL		BIT(1)
#define RCC_STBYBOOTCR_COLD_CPU2		BIT(2)
#define RCC_STBYBOOTCR_CPU2_HW_BEN		BIT(4)
#define RCC_STBYBOOTCR_CPU1_HW_BEN		BIT(5)
#define RCC_STBYBOOTCR_RET_CRCERR_RSTEN		BIT(8)

/* RCC_LEGBOOTCR register fields */
#define RCC_LEGBOOTCR_LEGACY_BEN		BIT(0)

/* RCC_BDCR register fields */
#define RCC_BDCR_LSEON				BIT(0)
#define RCC_BDCR_LSEBYP				BIT(1)
#define RCC_BDCR_LSERDY				BIT(2)
#define RCC_BDCR_LSEDIGBYP			BIT(3)
#define RCC_BDCR_LSEDRV_MASK			GENMASK_32(5, 4)
#define RCC_BDCR_LSEDRV_SHIFT			4
#define RCC_BDCR_LSECSSON			BIT(6)
#define RCC_BDCR_LSEGFON			BIT(7)
#define RCC_BDCR_LSECSSD			BIT(8)
#define RCC_BDCR_LSION				BIT(9)
#define RCC_BDCR_LSIRDY				BIT(10)
#define RCC_BDCR_RTCSRC_MASK			GENMASK_32(17, 16)
#define RCC_BDCR_RTCSRC_SHIFT			16
#define RCC_BDCR_RTCCKEN			BIT(20)
#define RCC_BDCR_MSIFREQSEL			BIT(24)
#define RCC_BDCR_C3SYSTICKSEL			BIT(25)
#define RCC_BDCR_VSWRST				BIT(31)
#define RCC_BDCR_LSEBYP_BIT			1
#define RCC_BDCR_LSEDIGBYP_BIT			3
#define RCC_BDCR_LSECSSON_BIT			6
#define RCC_BDCR_LSERDY_BIT			2
#define RCC_BDCR_LSIRDY_BIT			10

#define RCC_BDCR_LSEDRV_SHIFT			4
#define RCC_BDCR_LSEDRV_WIDTH			2

/* RCC_D3DCR register fields */
#define RCC_D3DCR_MSION				BIT(0)
#define RCC_D3DCR_MSIKERON			BIT(1)
#define RCC_D3DCR_MSIRDY			BIT(2)
#define RCC_D3DCR_D3PERCKSEL_MASK		GENMASK_32(17, 16)
#define RCC_D3DCR_D3PERCKSEL_SHIFT		16
#define RCC_D3DCR_MSIRDY_BIT			2

/* RCC_D3DSR register fields */
#define RCC_D3DSR_D3STATE_MASK			GENMASK_32(1, 0)
#define RCC_D3DSR_D3STATE_SHIFT			0

/* RCC_RDCR register fields */
#define RCC_RDCR_MRD_MASK			GENMASK_32(20, 16)
#define RCC_RDCR_MRD_SHIFT			16
#define RCC_RDCR_EADLY_MASK			GENMASK_32(27, 24)
#define RCC_RDCR_EADLY_SHIFT			24

/* RCC_C1MSRDCR register fields */
#define RCC_C1MSRDCR_C1MSRD_MASK		GENMASK_32(4, 0)
#define RCC_C1MSRDCR_C1MSRD_SHIFT		0
#define RCC_C1MSRDCR_C1MSRST			BIT(8)

/* RCC_PWRLPDLYCR register fields */
#define RCC_PWRLPDLYCR_PWRLP_DLY_MASK		GENMASK_32(21, 0)
#define RCC_PWRLPDLYCR_PWRLP_DLY_SHIFT		0
#define RCC_PWRLPDLYCR_CPU2TMPSKP		BIT(24)

/* RCC_C1CIESETR register fields */
#define RCC_C1CIESETR_LSIRDYIE			BIT(0)
#define RCC_C1CIESETR_LSERDYIE			BIT(1)
#define RCC_C1CIESETR_HSIRDYIE			BIT(2)
#define RCC_C1CIESETR_HSERDYIE			BIT(3)
#define RCC_C1CIESETR_CSIRDYIE			BIT(4)
#define RCC_C1CIESETR_PLL1RDYIE			BIT(5)
#define RCC_C1CIESETR_PLL2RDYIE			BIT(6)
#define RCC_C1CIESETR_PLL3RDYIE			BIT(7)
#define RCC_C1CIESETR_PLL4RDYIE			BIT(8)
#define RCC_C1CIESETR_PLL5RDYIE			BIT(9)
#define RCC_C1CIESETR_PLL6RDYIE			BIT(10)
#define RCC_C1CIESETR_PLL7RDYIE			BIT(11)
#define RCC_C1CIESETR_PLL8RDYIE			BIT(12)
#define RCC_C1CIESETR_LSECSSIE			BIT(16)
#define RCC_C1CIESETR_WKUPIE			BIT(20)

/* RCC_C1CIFCLRR register fields */
#define RCC_C1CIFCLRR_LSIRDYF			BIT(0)
#define RCC_C1CIFCLRR_LSERDYF			BIT(1)
#define RCC_C1CIFCLRR_HSIRDYF			BIT(2)
#define RCC_C1CIFCLRR_HSERDYF			BIT(3)
#define RCC_C1CIFCLRR_CSIRDYF			BIT(4)
#define RCC_C1CIFCLRR_PLL1RDYF			BIT(5)
#define RCC_C1CIFCLRR_PLL2RDYF			BIT(6)
#define RCC_C1CIFCLRR_PLL3RDYF			BIT(7)
#define RCC_C1CIFCLRR_PLL4RDYF			BIT(8)
#define RCC_C1CIFCLRR_PLL5RDYF			BIT(9)
#define RCC_C1CIFCLRR_PLL6RDYF			BIT(10)
#define RCC_C1CIFCLRR_PLL7RDYF			BIT(11)
#define RCC_C1CIFCLRR_PLL8RDYF			BIT(12)
#define RCC_C1CIFCLRR_LSECSSF			BIT(16)
#define RCC_C1CIFCLRR_WKUPF			BIT(20)

/* RCC_C2CIESETR register fields */
#define RCC_C2CIESETR_LSIRDYIE			BIT(0)
#define RCC_C2CIESETR_LSERDYIE			BIT(1)
#define RCC_C2CIESETR_HSIRDYIE			BIT(2)
#define RCC_C2CIESETR_HSERDYIE			BIT(3)
#define RCC_C2CIESETR_CSIRDYIE			BIT(4)
#define RCC_C2CIESETR_PLL1RDYIE			BIT(5)
#define RCC_C2CIESETR_PLL2RDYIE			BIT(6)
#define RCC_C2CIESETR_PLL3RDYIE			BIT(7)
#define RCC_C2CIESETR_PLL4RDYIE			BIT(8)
#define RCC_C2CIESETR_PLL5RDYIE			BIT(9)
#define RCC_C2CIESETR_PLL6RDYIE			BIT(10)
#define RCC_C2CIESETR_PLL7RDYIE			BIT(11)
#define RCC_C2CIESETR_PLL8RDYIE			BIT(12)
#define RCC_C2CIESETR_LSECSSIE			BIT(16)
#define RCC_C2CIESETR_WKUPIE			BIT(20)

/* RCC_C2CIFCLRR register fields */
#define RCC_C2CIFCLRR_LSIRDYF			BIT(0)
#define RCC_C2CIFCLRR_LSERDYF			BIT(1)
#define RCC_C2CIFCLRR_HSIRDYF			BIT(2)
#define RCC_C2CIFCLRR_HSERDYF			BIT(3)
#define RCC_C2CIFCLRR_CSIRDYF			BIT(4)
#define RCC_C2CIFCLRR_PLL1RDYF			BIT(5)
#define RCC_C2CIFCLRR_PLL2RDYF			BIT(6)
#define RCC_C2CIFCLRR_PLL3RDYF			BIT(7)
#define RCC_C2CIFCLRR_PLL4RDYF			BIT(8)
#define RCC_C2CIFCLRR_PLL5RDYF			BIT(9)
#define RCC_C2CIFCLRR_PLL6RDYF			BIT(10)
#define RCC_C2CIFCLRR_PLL7RDYF			BIT(11)
#define RCC_C2CIFCLRR_PLL8RDYF			BIT(12)
#define RCC_C2CIFCLRR_LSECSSF			BIT(16)
#define RCC_C2CIFCLRR_WKUPF			BIT(20)

/* RCC_CxCIESETR register fields */
#define RCC_CxCIESETR_LSIRDYIE			BIT(0)
#define RCC_CxCIESETR_LSERDYIE			BIT(1)
#define RCC_CxCIESETR_HSIRDYIE			BIT(2)
#define RCC_CxCIESETR_HSERDYIE			BIT(3)
#define RCC_CxCIESETR_CSIRDYIE			BIT(4)
#define RCC_CxCIESETR_SHSIRDYIE			BIT(5)
#define RCC_CxCIESETR_PLL1RDYIE			BIT(6)
#define RCC_CxCIESETR_PLL2RDYIE			BIT(7)
#define RCC_CxCIESETR_PLL3RDYIE			BIT(8)
#define RCC_CxCIESETR_PLL4RDYIE			BIT(9)
#define RCC_CxCIESETR_PLL5RDYIE			BIT(10)
#define RCC_CxCIESETR_PLL6RDYIE			BIT(11)
#define RCC_CxCIESETR_PLL7RDYIE			BIT(12)
#define RCC_CxCIESETR_PLL8RDYIE			BIT(13)
#define RCC_CxCIESETR_LSECSSIE			BIT(16)
#define RCC_CxCIESETR_WKUPIE			BIT(20)

/* RCC_CxCIFCLRR register fields */
#define RCC_CxCIFCLRR_LSIRDYF			BIT(0)
#define RCC_CxCIFCLRR_LSERDYF			BIT(1)
#define RCC_CxCIFCLRR_HSIRDYF			BIT(2)
#define RCC_CxCIFCLRR_HSERDYF			BIT(3)
#define RCC_CxCIFCLRR_CSIRDYF			BIT(4)
#define RCC_CxCIFCLRR_SHSIRDYF			BIT(5)
#define RCC_CxCIFCLRR_PLL1RDYF			BIT(6)
#define RCC_CxCIFCLRR_PLL2RDYF			BIT(7)
#define RCC_CxCIFCLRR_PLL3RDYF			BIT(8)
#define RCC_CxCIFCLRR_PLL4RDYF			BIT(9)
#define RCC_CxCIFCLRR_PLL5RDYF			BIT(10)
#define RCC_CxCIFCLRR_PLL6RDYF			BIT(11)
#define RCC_CxCIFCLRR_PLL7RDYF			BIT(12)
#define RCC_CxCIFCLRR_PLL8RDYF			BIT(13)
#define RCC_CxCIFCLRR_LSECSSF			BIT(16)
#define RCC_CxCIFCLRR_WKUPF			BIT(20)

/* RCC_IWDGC1FZSETR register fields */
#define RCC_IWDGC1FZSETR_FZ_IWDG1		BIT(0)
#define RCC_IWDGC1FZSETR_FZ_IWDG2		BIT(1)

/* RCC_IWDGC1FZCLRR register fields */
#define RCC_IWDGC1FZCLRR_FZ_IWDG1		BIT(0)
#define RCC_IWDGC1FZCLRR_FZ_IWDG2		BIT(1)

/* RCC_IWDGC1CFGSETR register fields */
#define RCC_IWDGC1CFGSETR_IWDG1_SYSRSTEN	BIT(0)
#define RCC_IWDGC1CFGSETR_IWDG2_SYSRSTEN	BIT(2)
#define RCC_IWDGC1CFGSETR_IWDG2_KERRST		BIT(18)

/* RCC_IWDGC1CFGCLRR register fields */
#define RCC_IWDGC1CFGCLRR_IWDG1_SYSRSTEN	BIT(0)
#define RCC_IWDGC1CFGCLRR_IWDG2_SYSRSTEN	BIT(2)
#define RCC_IWDGC1CFGCLRR_IWDG2_KERRST		BIT(18)

/* RCC_IWDGC2FZSETR register fields */
#define RCC_IWDGC2FZSETR_FZ_IWDG3		BIT(0)
#define RCC_IWDGC2FZSETR_FZ_IWDG4		BIT(1)

/* RCC_IWDGC2FZCLRR register fields */
#define RCC_IWDGC2FZCLRR_FZ_IWDG3		BIT(0)
#define RCC_IWDGC2FZCLRR_FZ_IWDG4		BIT(1)

/* RCC_IWDGC2CFGSETR register fields */
#define RCC_IWDGC2CFGSETR_IWDG3_SYSRSTEN	BIT(0)
#define RCC_IWDGC2CFGSETR_IWDG4_SYSRSTEN	BIT(2)
#define RCC_IWDGC2CFGSETR_IWDG4_KERRST		BIT(18)

/* RCC_IWDGC2CFGCLRR register fields */
#define RCC_IWDGC2CFGCLRR_IWDG3_SYSRSTEN	BIT(0)
#define RCC_IWDGC2CFGCLRR_IWDG4_SYSRSTEN	BIT(2)
#define RCC_IWDGC2CFGCLRR_IWDG4_KERRST		BIT(18)

/* RCC_IWDGC3CFGSETR register fields */
#define RCC_IWDGC3CFGSETR_IWDG5_SYSRSTEN	BIT(0)

/* RCC_IWDGC3CFGCLRR register fields */
#define RCC_IWDGC3CFGCLRR_IWDG5_SYSRSTEN	BIT(0)

/* RCC_C3CFGR register fields */
#define RCC_C3CFGR_C3RST			BIT(0)
#define RCC_C3CFGR_C3EN				BIT(1)
#define RCC_C3CFGR_C3LPEN			BIT(2)
#define RCC_C3CFGR_C3AMEN			BIT(3)
#define RCC_C3CFGR_LPTIM3C3EN			BIT(16)
#define RCC_C3CFGR_LPTIM4C3EN			BIT(17)
#define RCC_C3CFGR_LPTIM5C3EN			BIT(18)
#define RCC_C3CFGR_SPI8C3EN			BIT(19)
#define RCC_C3CFGR_LPUART1C3EN			BIT(20)
#define RCC_C3CFGR_I2C8C3EN			BIT(21)
#define RCC_C3CFGR_ADF1C3EN			BIT(23)
#define RCC_C3CFGR_GPIOZC3EN			BIT(24)
#define RCC_C3CFGR_LPDMAC3EN			BIT(25)
#define RCC_C3CFGR_RTCC3EN			BIT(26)
#define RCC_C3CFGR_I3C4C3EN			BIT(27)

/* RCC_MCO1CFGR register fields */
#define RCC_MCO1CFGR_MCO1SEL			BIT(0)
#define RCC_MCO1CFGR_MCO1ON			BIT(8)

/* RCC_MCO2CFGR register fields */
#define RCC_MCO2CFGR_MCO2SEL			BIT(0)
#define RCC_MCO2CFGR_MCO2ON			BIT(8)

/* RCC_MCOxCFGR register fields */
#define RCC_MCOxCFGR_MCOxSEL			BIT(0)
#define RCC_MCOxCFGR_MCOxON			BIT(8)

/* RCC_OCENSETR register fields */
#define RCC_OCENSETR_HSION			BIT(0)
#define RCC_OCENSETR_HSIKERON			BIT(1)
#define RCC_OCENSETR_HSEDIV2ON			BIT(5)
#define RCC_OCENSETR_HSEDIV2BYP			BIT(6)
#define RCC_OCENSETR_HSEDIGBYP			BIT(7)
#define RCC_OCENSETR_HSEON			BIT(8)
#define RCC_OCENSETR_HSEKERON			BIT(9)
#define RCC_OCENSETR_HSEBYP			BIT(10)
#define RCC_OCENSETR_HSECSSON			BIT(11)

/* RCC_OCENCLRR register fields */
#define RCC_OCENCLRR_HSION			BIT(0)
#define RCC_OCENCLRR_HSIKERON			BIT(1)
#define RCC_OCENCLRR_HSEDIV2ON			BIT(5)
#define RCC_OCENCLRR_HSEDIV2BYP			BIT(6)
#define RCC_OCENCLRR_HSEDIGBYP			BIT(7)
#define RCC_OCENCLRR_HSEON			BIT(8)
#define RCC_OCENCLRR_HSEKERON			BIT(9)
#define RCC_OCENCLRR_HSEBYP			BIT(10)

/* RCC_OCRDYR register fields */
#define RCC_OCRDYR_HSIRDY			BIT(0)
#define RCC_OCRDYR_HSERDY			BIT(8)
#define RCC_OCRDYR_CKREST			BIT(25)

#define RCC_OCRDYR_HSIRDY_BIT			0
#define RCC_OCRDYR_HSERDY_BIT			8

/* RCC_HSICFGR register fields */
#define RCC_HSICFGR_HSITRIM_MASK		GENMASK_32(14, 8)
#define RCC_HSICFGR_HSITRIM_SHIFT		8
#define RCC_HSICFGR_HSICAL_MASK			GENMASK_32(24, 16)
#define RCC_HSICFGR_HSICAL_SHIFT		16

/* RCC_CSICFGR register fields */
#define RCC_CSICFGR_CSITRIM_MASK		GENMASK_32(12, 8)
#define RCC_CSICFGR_CSITRIM_SHIFT		8
#define RCC_CSICFGR_CSICAL_MASK			GENMASK_32(23, 16)
#define RCC_CSICFGR_CSICAL_SHIFT		16

/* RCC_RTCDIVR register fields */
#define RCC_RTCDIVR_RTCDIV_MASK			GENMASK_32(5, 0)
#define RCC_RTCDIVR_RTCDIV_SHIFT		0

/* RCC_APB1DIVR register fields */
#define RCC_APB1DIVR_APB1DIV_MASK		GENMASK_32(2, 0)
#define RCC_APB1DIVR_APB1DIV_SHIFT		0
#define RCC_APB1DIVR_APB1DIVRDY			BIT(31)

/* RCC_APB2DIVR register fields */
#define RCC_APB2DIVR_APB2DIV_MASK		GENMASK_32(2, 0)
#define RCC_APB2DIVR_APB2DIV_SHIFT		0
#define RCC_APB2DIVR_APB2DIVRDY			BIT(31)

/* RCC_APB3DIVR register fields */
#define RCC_APB3DIVR_APB3DIV_MASK		GENMASK_32(2, 0)
#define RCC_APB3DIVR_APB3DIV_SHIFT		0
#define RCC_APB3DIVR_APB3DIVRDY			BIT(31)

/* RCC_APB4DIVR register fields */
#define RCC_APB4DIVR_APB4DIV_MASK		GENMASK_32(2, 0)
#define RCC_APB4DIVR_APB4DIV_SHIFT		0
#define RCC_APB4DIVR_APB4DIVRDY			BIT(31)

/* RCC_APBDBGDIVR register fields */
#define RCC_APBDBGDIVR_APBDBGDIV_MASK		GENMASK_32(2, 0)
#define RCC_APBDBGDIVR_APBDBGDIV_SHIFT		0
#define RCC_APBDBGDIVR_APBDBGDIVRDY		BIT(31)

/* RCC_APBxDIVR register fields */
#define RCC_APBxDIVR_APBxDIV_MASK		GENMASK_32(2, 0)
#define RCC_APBxDIVR_APBxDIV_SHIFT		0
#define RCC_APBxDIVR_APBxDIVRDY			BIT(31)

/* RCC_TIMG1PRER register fields */
#define RCC_TIMG1PRER_TIMG1PRE			BIT(0)
#define RCC_TIMG1PRER_TIMG1PRERDY		BIT(31)

/* RCC_TIMG2PRER register fields */
#define RCC_TIMG2PRER_TIMG2PRE			BIT(0)
#define RCC_TIMG2PRER_TIMG2PRERDY		BIT(31)

/* RCC_TIMGxPRER register fields */
#define RCC_TIMGxPRER_TIMGxPRE			BIT(0)
#define RCC_TIMGxPRER_TIMGxPRERDY		BIT(31)

/* RCC_LSMCUDIVR register fields */
#define RCC_LSMCUDIVR_LSMCUDIV			BIT(0)
#define RCC_LSMCUDIVR_LSMCUDIVRDY		BIT(31)

/* RCC_DDRCPCFGR register fields */
#define RCC_DDRCPCFGR_DDRCPRST			BIT(0)
#define RCC_DDRCPCFGR_DDRCPEN			BIT(1)
#define RCC_DDRCPCFGR_DDRCPLPEN			BIT(2)

/* RCC_DDRCAPBCFGR register fields */
#define RCC_DDRCAPBCFGR_DDRCAPBRST		BIT(0)
#define RCC_DDRCAPBCFGR_DDRCAPBEN		BIT(1)
#define RCC_DDRCAPBCFGR_DDRCAPBLPEN		BIT(2)

/* RCC_DDRPHYCAPBCFGR register fields */
#define RCC_DDRPHYCAPBCFGR_DDRPHYCAPBRST	BIT(0)
#define RCC_DDRPHYCAPBCFGR_DDRPHYCAPBEN		BIT(1)
#define RCC_DDRPHYCAPBCFGR_DDRPHYCAPBLPEN	BIT(2)

/* RCC_DDRPHYCCFGR register fields */
#define RCC_DDRPHYCCFGR_DDRPHYCEN		BIT(1)

/* RCC_DDRCFGR register fields */
#define RCC_DDRCFGR_DDRCFGRST			BIT(0)
#define RCC_DDRCFGR_DDRCFGEN			BIT(1)
#define RCC_DDRCFGR_DDRCFGLPEN			BIT(2)

/* RCC_DDRITFCFGR register fields */
#define RCC_DDRITFCFGR_DDRRST			BIT(0)
#define RCC_DDRITFCFGR_DDRCKMOD_MASK		GENMASK_32(5, 4)
#define RCC_DDRITFCFGR_DDRCKMOD_SHIFT		4
#define RCC_DDRITFCFGR_DDRCKMOD_HSR		BIT(5)
#define RCC_DDRITFCFGR_DDRSHR			BIT(8)
#define RCC_DDRITFCFGR_DDRPHYDLP		BIT(16)

/* RCC_SYSRAMCFGR register fields */
#define RCC_SYSRAMCFGR_SYSRAMEN			BIT(1)
#define RCC_SYSRAMCFGR_SYSRAMLPEN		BIT(2)

/* RCC_VDERAMCFGR register fields */
#define RCC_VDERAMCFGR_VDERAMEN			BIT(1)
#define RCC_VDERAMCFGR_VDERAMLPEN		BIT(2)

/* RCC_SRAM1CFGR register fields */
#define RCC_SRAM1CFGR_SRAM1EN			BIT(1)
#define RCC_SRAM1CFGR_SRAM1LPEN			BIT(2)

/* RCC_SRAM2CFGR register fields */
#define RCC_SRAM2CFGR_SRAM2EN			BIT(1)
#define RCC_SRAM2CFGR_SRAM2LPEN			BIT(2)

/* RCC_RETRAMCFGR register fields */
#define RCC_RETRAMCFGR_RETRAMEN			BIT(1)
#define RCC_RETRAMCFGR_RETRAMLPEN		BIT(2)

/* RCC_BKPSRAMCFGR register fields */
#define RCC_BKPSRAMCFGR_BKPSRAMEN		BIT(1)
#define RCC_BKPSRAMCFGR_BKPSRAMLPEN		BIT(2)

/* RCC_LPSRAM1CFGR register fields */
#define RCC_LPSRAM1CFGR_LPSRAM1EN		BIT(1)
#define RCC_LPSRAM1CFGR_LPSRAM1LPEN		BIT(2)
#define RCC_LPSRAM1CFGR_LPSRAM1AMEN		BIT(3)

/* RCC_LPSRAM2CFGR register fields */
#define RCC_LPSRAM2CFGR_LPSRAM2EN		BIT(1)
#define RCC_LPSRAM2CFGR_LPSRAM2LPEN		BIT(2)
#define RCC_LPSRAM2CFGR_LPSRAM2AMEN		BIT(3)

/* RCC_LPSRAM3CFGR register fields */
#define RCC_LPSRAM3CFGR_LPSRAM3EN		BIT(1)
#define RCC_LPSRAM3CFGR_LPSRAM3LPEN		BIT(2)
#define RCC_LPSRAM3CFGR_LPSRAM3AMEN		BIT(3)

/* RCC_OSPI1CFGR register fields */
#define RCC_OSPI1CFGR_OSPI1RST			BIT(0)
#define RCC_OSPI1CFGR_OSPI1EN			BIT(1)
#define RCC_OSPI1CFGR_OSPI1LPEN			BIT(2)
#define RCC_OSPI1CFGR_OTFDEC1RST		BIT(8)
#define RCC_OSPI1CFGR_OSPI1DLLRST		BIT(16)

/* RCC_OSPI2CFGR register fields */
#define RCC_OSPI2CFGR_OSPI2RST			BIT(0)
#define RCC_OSPI2CFGR_OSPI2EN			BIT(1)
#define RCC_OSPI2CFGR_OSPI2LPEN			BIT(2)
#define RCC_OSPI2CFGR_OTFDEC2RST		BIT(8)
#define RCC_OSPI2CFGR_OSPI2DLLRST		BIT(16)

/* RCC_OSPIxCFGR register fields */
#define RCC_OSPIxCFGR_OSPIxRST			BIT(0)
#define RCC_OSPIxCFGR_OSPIxEN			BIT(1)
#define RCC_OSPIxCFGR_OSPIxLPEN			BIT(2)
#define RCC_OSPIxCFGR_OTFDECxRST		BIT(8)
#define RCC_OSPIxCFGR_OSPIxDLLRST		BIT(16)

/* RCC_FMCCFGR register fields */
#define RCC_FMCCFGR_FMCRST			BIT(0)
#define RCC_FMCCFGR_FMCEN			BIT(1)
#define RCC_FMCCFGR_FMCLPEN			BIT(2)

/* RCC_DBGCFGR register fields */
#define RCC_DBGCFGR_DBGEN			BIT(8)
#define RCC_DBGCFGR_TRACEEN			BIT(9)
#define RCC_DBGCFGR_DBGRST			BIT(12)

/* RCC_STM500CFGR register fields */
#define RCC_STM500CFGR_STM500EN			BIT(1)
#define RCC_STM500CFGR_STM500LPEN		BIT(2)

/* RCC_ETRCFGR register fields */
#define RCC_ETRCFGR_ETREN			BIT(1)
#define RCC_ETRCFGR_ETRLPEN			BIT(2)

/* RCC_GPIOACFGR register fields */
#define RCC_GPIOACFGR_GPIOARST			BIT(0)
#define RCC_GPIOACFGR_GPIOAEN			BIT(1)
#define RCC_GPIOACFGR_GPIOALPEN			BIT(2)

/* RCC_GPIOBCFGR register fields */
#define RCC_GPIOBCFGR_GPIOBRST			BIT(0)
#define RCC_GPIOBCFGR_GPIOBEN			BIT(1)
#define RCC_GPIOBCFGR_GPIOBLPEN			BIT(2)

/* RCC_GPIOCCFGR register fields */
#define RCC_GPIOCCFGR_GPIOCRST			BIT(0)
#define RCC_GPIOCCFGR_GPIOCEN			BIT(1)
#define RCC_GPIOCCFGR_GPIOCLPEN			BIT(2)

/* RCC_GPIODCFGR register fields */
#define RCC_GPIODCFGR_GPIODRST			BIT(0)
#define RCC_GPIODCFGR_GPIODEN			BIT(1)
#define RCC_GPIODCFGR_GPIODLPEN			BIT(2)

/* RCC_GPIOECFGR register fields */
#define RCC_GPIOECFGR_GPIOERST			BIT(0)
#define RCC_GPIOECFGR_GPIOEEN			BIT(1)
#define RCC_GPIOECFGR_GPIOELPEN			BIT(2)

/* RCC_GPIOFCFGR register fields */
#define RCC_GPIOFCFGR_GPIOFRST			BIT(0)
#define RCC_GPIOFCFGR_GPIOFEN			BIT(1)
#define RCC_GPIOFCFGR_GPIOFLPEN			BIT(2)

/* RCC_GPIOGCFGR register fields */
#define RCC_GPIOGCFGR_GPIOGRST			BIT(0)
#define RCC_GPIOGCFGR_GPIOGEN			BIT(1)
#define RCC_GPIOGCFGR_GPIOGLPEN			BIT(2)

/* RCC_GPIOHCFGR register fields */
#define RCC_GPIOHCFGR_GPIOHRST			BIT(0)
#define RCC_GPIOHCFGR_GPIOHEN			BIT(1)
#define RCC_GPIOHCFGR_GPIOHLPEN			BIT(2)

/* RCC_GPIOICFGR register fields */
#define RCC_GPIOICFGR_GPIOIRST			BIT(0)
#define RCC_GPIOICFGR_GPIOIEN			BIT(1)
#define RCC_GPIOICFGR_GPIOILPEN			BIT(2)

/* RCC_GPIOJCFGR register fields */
#define RCC_GPIOJCFGR_GPIOJRST			BIT(0)
#define RCC_GPIOJCFGR_GPIOJEN			BIT(1)
#define RCC_GPIOJCFGR_GPIOJLPEN			BIT(2)

/* RCC_GPIOKCFGR register fields */
#define RCC_GPIOKCFGR_GPIOKRST			BIT(0)
#define RCC_GPIOKCFGR_GPIOKEN			BIT(1)
#define RCC_GPIOKCFGR_GPIOKLPEN			BIT(2)

/* RCC_GPIOZCFGR register fields */
#define RCC_GPIOZCFGR_GPIOZRST			BIT(0)
#define RCC_GPIOZCFGR_GPIOZEN			BIT(1)
#define RCC_GPIOZCFGR_GPIOZLPEN			BIT(2)
#define RCC_GPIOZCFGR_GPIOZAMEN			BIT(3)

/* RCC_GPIOxCFGR register fields */
#define RCC_GPIOxCFGR_GPIOxRST			BIT(0)
#define RCC_GPIOxCFGR_GPIOxEN			BIT(1)
#define RCC_GPIOxCFGR_GPIOxLPEN			BIT(2)
#define RCC_GPIOxCFGR_GPIOxAMEN			BIT(3)

/* RCC_HPDMA1CFGR register fields */
#define RCC_HPDMA1CFGR_HPDMA1RST		BIT(0)
#define RCC_HPDMA1CFGR_HPDMA1EN			BIT(1)
#define RCC_HPDMA1CFGR_HPDMA1LPEN		BIT(2)

/* RCC_HPDMA2CFGR register fields */
#define RCC_HPDMA2CFGR_HPDMA2RST		BIT(0)
#define RCC_HPDMA2CFGR_HPDMA2EN			BIT(1)
#define RCC_HPDMA2CFGR_HPDMA2LPEN		BIT(2)

/* RCC_HPDMA3CFGR register fields */
#define RCC_HPDMA3CFGR_HPDMA3RST		BIT(0)
#define RCC_HPDMA3CFGR_HPDMA3EN			BIT(1)
#define RCC_HPDMA3CFGR_HPDMA3LPEN		BIT(2)

/* RCC_HPDMAxCFGR register fields */
#define RCC_HPDMAxCFGR_HPDMAxRST		BIT(0)
#define RCC_HPDMAxCFGR_HPDMAxEN			BIT(1)
#define RCC_HPDMAxCFGR_HPDMAxLPEN		BIT(2)

/* RCC_LPDMACFGR register fields */
#define RCC_LPDMACFGR_LPDMARST			BIT(0)
#define RCC_LPDMACFGR_LPDMAEN			BIT(1)
#define RCC_LPDMACFGR_LPDMALPEN			BIT(2)
#define RCC_LPDMACFGR_LPDMAAMEN			BIT(3)

/* RCC_HSEMCFGR register fields */
#define RCC_HSEMCFGR_HSEMRST			BIT(0)
#define RCC_HSEMCFGR_HSEMEN			BIT(1)
#define RCC_HSEMCFGR_HSEMLPEN			BIT(2)
#define RCC_HSEMCFGR_HSEMAMEN			BIT(3)

/* RCC_IPCC1CFGR register fields */
#define RCC_IPCC1CFGR_IPCC1RST			BIT(0)
#define RCC_IPCC1CFGR_IPCC1EN			BIT(1)
#define RCC_IPCC1CFGR_IPCC1LPEN			BIT(2)

/* RCC_IPCC2CFGR register fields */
#define RCC_IPCC2CFGR_IPCC2RST			BIT(0)
#define RCC_IPCC2CFGR_IPCC2EN			BIT(1)
#define RCC_IPCC2CFGR_IPCC2LPEN			BIT(2)
#define RCC_IPCC2CFGR_IPCC2AMEN			BIT(3)

/* RCC_RTCCFGR register fields */
#define RCC_RTCCFGR_RTCEN			BIT(1)
#define RCC_RTCCFGR_RTCLPEN			BIT(2)
#define RCC_RTCCFGR_RTCAMEN			BIT(3)

/* RCC_SYSCPU1CFGR register fields */
#define RCC_SYSCPU1CFGR_SYSCPU1EN		BIT(1)
#define RCC_SYSCPU1CFGR_SYSCPU1LPEN		BIT(2)

/* RCC_BSECCFGR register fields */
#define RCC_BSECCFGR_BSECEN			BIT(1)
#define RCC_BSECCFGR_BSECLPEN			BIT(2)

/* RCC_IS2MCFGR register fields */
#define RCC_IS2MCFGR_IS2MRST			BIT(0)
#define RCC_IS2MCFGR_IS2MEN			BIT(1)
#define RCC_IS2MCFGR_IS2MLPEN			BIT(2)

/* RCC_PLL2CFGR1 register fields */
#define RCC_PLL2CFGR1_SSMODRST			BIT(0)
#define RCC_PLL2CFGR1_PLLEN			BIT(8)
#define RCC_PLL2CFGR1_PLLRDY			BIT(24)
#define RCC_PLL2CFGR1_CKREFST			BIT(28)

/* RCC_PLL2CFGR2 register fields */
#define RCC_PLL2CFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLL2CFGR2_FREFDIV_SHIFT		0
#define RCC_PLL2CFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLL2CFGR2_FBDIV_SHIFT		16

/* RCC_PLL2CFGR3 register fields */
#define RCC_PLL2CFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLL2CFGR3_FRACIN_SHIFT		0
#define RCC_PLL2CFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLL2CFGR3_DACEN			BIT(25)
#define RCC_PLL2CFGR3_SSCGDIS			BIT(26)

/* RCC_PLL2CFGR4 register fields */
#define RCC_PLL2CFGR4_DSMEN			BIT(8)
#define RCC_PLL2CFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLL2CFGR4_BYPASS			BIT(10)

/* RCC_PLL2CFGR5 register fields */
#define RCC_PLL2CFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLL2CFGR5_DIVVAL_SHIFT		0
#define RCC_PLL2CFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLL2CFGR5_SPREAD_SHIFT		16

/* RCC_PLL2CFGR6 register fields */
#define RCC_PLL2CFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLL2CFGR6_POSTDIV1_SHIFT		0

/* RCC_PLL2CFGR7 register fields */
#define RCC_PLL2CFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLL2CFGR7_POSTDIV2_SHIFT		0

/* RCC_PLL3CFGR1 register fields */
#define RCC_PLL3CFGR1_SSMODRST			BIT(0)
#define RCC_PLL3CFGR1_PLLEN			BIT(8)
#define RCC_PLL3CFGR1_PLLRDY			BIT(24)
#define RCC_PLL3CFGR1_CKREFST			BIT(28)

/* RCC_PLL3CFGR2 register fields */
#define RCC_PLL3CFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLL3CFGR2_FREFDIV_SHIFT		0
#define RCC_PLL3CFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLL3CFGR2_FBDIV_SHIFT		16

/* RCC_PLL3CFGR3 register fields */
#define RCC_PLL3CFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLL3CFGR3_FRACIN_SHIFT		0
#define RCC_PLL3CFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLL3CFGR3_DACEN			BIT(25)
#define RCC_PLL3CFGR3_SSCGDIS			BIT(26)

/* RCC_PLL3CFGR4 register fields */
#define RCC_PLL3CFGR4_DSMEN			BIT(8)
#define RCC_PLL3CFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLL3CFGR4_BYPASS			BIT(10)

/* RCC_PLL3CFGR5 register fields */
#define RCC_PLL3CFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLL3CFGR5_DIVVAL_SHIFT		0
#define RCC_PLL3CFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLL3CFGR5_SPREAD_SHIFT		16

/* RCC_PLL3CFGR6 register fields */
#define RCC_PLL3CFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLL3CFGR6_POSTDIV1_SHIFT		0

/* RCC_PLL3CFGR7 register fields */
#define RCC_PLL3CFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLL3CFGR7_POSTDIV2_SHIFT		0

/* RCC_PLLxCFGR1 register fields */
#define RCC_PLLxCFGR1_SSMODRST			BIT(0)
#define RCC_PLLxCFGR1_PLLEN			BIT(8)
#define RCC_PLLxCFGR1_PLLRDY			BIT(24)
#define RCC_PLLxCFGR1_CKREFST			BIT(28)

/* RCC_PLLxCFGR2 register fields */
#define RCC_PLLxCFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLLxCFGR2_FREFDIV_SHIFT		0
#define RCC_PLLxCFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLLxCFGR2_FBDIV_SHIFT		16

/* RCC_PLLxCFGR3 register fields */
#define RCC_PLLxCFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLLxCFGR3_FRACIN_SHIFT		0
#define RCC_PLLxCFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLLxCFGR3_DACEN			BIT(25)
#define RCC_PLLxCFGR3_SSCGDIS			BIT(26)

/* RCC_PLLxCFGR4 register fields */
#define RCC_PLLxCFGR4_DSMEN			BIT(8)
#define RCC_PLLxCFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLLxCFGR4_BYPASS			BIT(10)

/* RCC_PLLxCFGR5 register fields */
#define RCC_PLLxCFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLLxCFGR5_DIVVAL_SHIFT		0
#define RCC_PLLxCFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLLxCFGR5_SPREAD_SHIFT		16

/* RCC_PLLxCFGR6 register fields */
#define RCC_PLLxCFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLLxCFGR6_POSTDIV1_SHIFT		0

/* RCC_PLLxCFGR7 register fields */
#define RCC_PLLxCFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLLxCFGR7_POSTDIV2_SHIFT		0

/* RCC_HSIFMONCR register fields */
#define RCC_HSIFMONCR_HSIREF_MASK		GENMASK_32(10, 0)
#define RCC_HSIFMONCR_HSIREF_SHIFT		0
#define RCC_HSIFMONCR_HSIMONEN			BIT(15)
#define RCC_HSIFMONCR_HSIDEV_MASK		GENMASK_32(21, 16)
#define RCC_HSIFMONCR_HSIDEV_SHIFT		16
#define RCC_HSIFMONCR_HSIMONIE			BIT(30)
#define RCC_HSIFMONCR_HSIMONF			BIT(31)

/* RCC_HSIFVALR register fields */
#define RCC_HSIFVALR_HSIVAL_MASK		GENMASK_32(10, 0)
#define RCC_HSIFVALR_HSIVAL_SHIFT		0

/* RCC_TIM1CFGR register fields */
#define RCC_TIM1CFGR_TIM1RST			BIT(0)
#define RCC_TIM1CFGR_TIM1EN			BIT(1)
#define RCC_TIM1CFGR_TIM1LPEN			BIT(2)

/* RCC_TIM2CFGR register fields */
#define RCC_TIM2CFGR_TIM2RST			BIT(0)
#define RCC_TIM2CFGR_TIM2EN			BIT(1)
#define RCC_TIM2CFGR_TIM2LPEN			BIT(2)

/* RCC_TIM3CFGR register fields */
#define RCC_TIM3CFGR_TIM3RST			BIT(0)
#define RCC_TIM3CFGR_TIM3EN			BIT(1)
#define RCC_TIM3CFGR_TIM3LPEN			BIT(2)

/* RCC_TIM4CFGR register fields */
#define RCC_TIM4CFGR_TIM4RST			BIT(0)
#define RCC_TIM4CFGR_TIM4EN			BIT(1)
#define RCC_TIM4CFGR_TIM4LPEN			BIT(2)

/* RCC_TIM5CFGR register fields */
#define RCC_TIM5CFGR_TIM5RST			BIT(0)
#define RCC_TIM5CFGR_TIM5EN			BIT(1)
#define RCC_TIM5CFGR_TIM5LPEN			BIT(2)

/* RCC_TIM6CFGR register fields */
#define RCC_TIM6CFGR_TIM6RST			BIT(0)
#define RCC_TIM6CFGR_TIM6EN			BIT(1)
#define RCC_TIM6CFGR_TIM6LPEN			BIT(2)

/* RCC_TIM7CFGR register fields */
#define RCC_TIM7CFGR_TIM7RST			BIT(0)
#define RCC_TIM7CFGR_TIM7EN			BIT(1)
#define RCC_TIM7CFGR_TIM7LPEN			BIT(2)

/* RCC_TIM8CFGR register fields */
#define RCC_TIM8CFGR_TIM8RST			BIT(0)
#define RCC_TIM8CFGR_TIM8EN			BIT(1)
#define RCC_TIM8CFGR_TIM8LPEN			BIT(2)

/* RCC_TIM10CFGR register fields */
#define RCC_TIM10CFGR_TIM10RST			BIT(0)
#define RCC_TIM10CFGR_TIM10EN			BIT(1)
#define RCC_TIM10CFGR_TIM10LPEN			BIT(2)

/* RCC_TIM11CFGR register fields */
#define RCC_TIM11CFGR_TIM11RST			BIT(0)
#define RCC_TIM11CFGR_TIM11EN			BIT(1)
#define RCC_TIM11CFGR_TIM11LPEN			BIT(2)

/* RCC_TIM12CFGR register fields */
#define RCC_TIM12CFGR_TIM12RST			BIT(0)
#define RCC_TIM12CFGR_TIM12EN			BIT(1)
#define RCC_TIM12CFGR_TIM12LPEN			BIT(2)

/* RCC_TIM13CFGR register fields */
#define RCC_TIM13CFGR_TIM13RST			BIT(0)
#define RCC_TIM13CFGR_TIM13EN			BIT(1)
#define RCC_TIM13CFGR_TIM13LPEN			BIT(2)

/* RCC_TIM14CFGR register fields */
#define RCC_TIM14CFGR_TIM14RST			BIT(0)
#define RCC_TIM14CFGR_TIM14EN			BIT(1)
#define RCC_TIM14CFGR_TIM14LPEN			BIT(2)

/* RCC_TIM15CFGR register fields */
#define RCC_TIM15CFGR_TIM15RST			BIT(0)
#define RCC_TIM15CFGR_TIM15EN			BIT(1)
#define RCC_TIM15CFGR_TIM15LPEN			BIT(2)

/* RCC_TIM16CFGR register fields */
#define RCC_TIM16CFGR_TIM16RST			BIT(0)
#define RCC_TIM16CFGR_TIM16EN			BIT(1)
#define RCC_TIM16CFGR_TIM16LPEN			BIT(2)

/* RCC_TIM17CFGR register fields */
#define RCC_TIM17CFGR_TIM17RST			BIT(0)
#define RCC_TIM17CFGR_TIM17EN			BIT(1)
#define RCC_TIM17CFGR_TIM17LPEN			BIT(2)

/* RCC_TIM20CFGR register fields */
#define RCC_TIM20CFGR_TIM20RST			BIT(0)
#define RCC_TIM20CFGR_TIM20EN			BIT(1)
#define RCC_TIM20CFGR_TIM20LPEN			BIT(2)

/* RCC_LPTIM1CFGR register fields */
#define RCC_LPTIM1CFGR_LPTIM1RST		BIT(0)
#define RCC_LPTIM1CFGR_LPTIM1EN			BIT(1)
#define RCC_LPTIM1CFGR_LPTIM1LPEN		BIT(2)

/* RCC_LPTIM2CFGR register fields */
#define RCC_LPTIM2CFGR_LPTIM2RST		BIT(0)
#define RCC_LPTIM2CFGR_LPTIM2EN			BIT(1)
#define RCC_LPTIM2CFGR_LPTIM2LPEN		BIT(2)

/* RCC_LPTIM3CFGR register fields */
#define RCC_LPTIM3CFGR_LPTIM3RST		BIT(0)
#define RCC_LPTIM3CFGR_LPTIM3EN			BIT(1)
#define RCC_LPTIM3CFGR_LPTIM3LPEN		BIT(2)
#define RCC_LPTIM3CFGR_LPTIM3AMEN		BIT(3)

/* RCC_LPTIM4CFGR register fields */
#define RCC_LPTIM4CFGR_LPTIM4RST		BIT(0)
#define RCC_LPTIM4CFGR_LPTIM4EN			BIT(1)
#define RCC_LPTIM4CFGR_LPTIM4LPEN		BIT(2)
#define RCC_LPTIM4CFGR_LPTIM4AMEN		BIT(3)

/* RCC_LPTIM5CFGR register fields */
#define RCC_LPTIM5CFGR_LPTIM5RST		BIT(0)
#define RCC_LPTIM5CFGR_LPTIM5EN			BIT(1)
#define RCC_LPTIM5CFGR_LPTIM5LPEN		BIT(2)
#define RCC_LPTIM5CFGR_LPTIM5AMEN		BIT(3)

/* RCC_LPTIMxCFGR register fields */
#define RCC_LPTIMxCFGR_LPTIMxRST		BIT(0)
#define RCC_LPTIMxCFGR_LPTIMxEN			BIT(1)
#define RCC_LPTIMxCFGR_LPTIMxLPEN		BIT(2)
#define RCC_LPTIMxCFGR_LPTIMxAMEN		BIT(3)

/* RCC_SPI1CFGR register fields */
#define RCC_SPI1CFGR_SPI1RST			BIT(0)
#define RCC_SPI1CFGR_SPI1EN			BIT(1)
#define RCC_SPI1CFGR_SPI1LPEN			BIT(2)

/* RCC_SPI2CFGR register fields */
#define RCC_SPI2CFGR_SPI2RST			BIT(0)
#define RCC_SPI2CFGR_SPI2EN			BIT(1)
#define RCC_SPI2CFGR_SPI2LPEN			BIT(2)

/* RCC_SPI3CFGR register fields */
#define RCC_SPI3CFGR_SPI3RST			BIT(0)
#define RCC_SPI3CFGR_SPI3EN			BIT(1)
#define RCC_SPI3CFGR_SPI3LPEN			BIT(2)

/* RCC_SPI4CFGR register fields */
#define RCC_SPI4CFGR_SPI4RST			BIT(0)
#define RCC_SPI4CFGR_SPI4EN			BIT(1)
#define RCC_SPI4CFGR_SPI4LPEN			BIT(2)

/* RCC_SPI5CFGR register fields */
#define RCC_SPI5CFGR_SPI5RST			BIT(0)
#define RCC_SPI5CFGR_SPI5EN			BIT(1)
#define RCC_SPI5CFGR_SPI5LPEN			BIT(2)

/* RCC_SPI6CFGR register fields */
#define RCC_SPI6CFGR_SPI6RST			BIT(0)
#define RCC_SPI6CFGR_SPI6EN			BIT(1)
#define RCC_SPI6CFGR_SPI6LPEN			BIT(2)

/* RCC_SPI7CFGR register fields */
#define RCC_SPI7CFGR_SPI7RST			BIT(0)
#define RCC_SPI7CFGR_SPI7EN			BIT(1)
#define RCC_SPI7CFGR_SPI7LPEN			BIT(2)

/* RCC_SPI8CFGR register fields */
#define RCC_SPI8CFGR_SPI8RST			BIT(0)
#define RCC_SPI8CFGR_SPI8EN			BIT(1)
#define RCC_SPI8CFGR_SPI8LPEN			BIT(2)
#define RCC_SPI8CFGR_SPI8AMEN			BIT(3)

/* RCC_SPIxCFGR register fields */
#define RCC_SPIxCFGR_SPIxRST			BIT(0)
#define RCC_SPIxCFGR_SPIxEN			BIT(1)
#define RCC_SPIxCFGR_SPIxLPEN			BIT(2)
#define RCC_SPIxCFGR_SPIxAMEN			BIT(3)

/* RCC_SPDIFRXCFGR register fields */
#define RCC_SPDIFRXCFGR_SPDIFRXRST		BIT(0)
#define RCC_SPDIFRXCFGR_SPDIFRXEN		BIT(1)
#define RCC_SPDIFRXCFGR_SPDIFRXLPEN		BIT(2)

/* RCC_USART1CFGR register fields */
#define RCC_USART1CFGR_USART1RST		BIT(0)
#define RCC_USART1CFGR_USART1EN			BIT(1)
#define RCC_USART1CFGR_USART1LPEN		BIT(2)

/* RCC_USART2CFGR register fields */
#define RCC_USART2CFGR_USART2RST		BIT(0)
#define RCC_USART2CFGR_USART2EN			BIT(1)
#define RCC_USART2CFGR_USART2LPEN		BIT(2)

/* RCC_USART3CFGR register fields */
#define RCC_USART3CFGR_USART3RST		BIT(0)
#define RCC_USART3CFGR_USART3EN			BIT(1)
#define RCC_USART3CFGR_USART3LPEN		BIT(2)

/* RCC_UART4CFGR register fields */
#define RCC_UART4CFGR_UART4RST			BIT(0)
#define RCC_UART4CFGR_UART4EN			BIT(1)
#define RCC_UART4CFGR_UART4LPEN			BIT(2)

/* RCC_UART5CFGR register fields */
#define RCC_UART5CFGR_UART5RST			BIT(0)
#define RCC_UART5CFGR_UART5EN			BIT(1)
#define RCC_UART5CFGR_UART5LPEN			BIT(2)

/* RCC_USART6CFGR register fields */
#define RCC_USART6CFGR_USART6RST		BIT(0)
#define RCC_USART6CFGR_USART6EN			BIT(1)
#define RCC_USART6CFGR_USART6LPEN		BIT(2)

/* RCC_UART7CFGR register fields */
#define RCC_UART7CFGR_UART7RST			BIT(0)
#define RCC_UART7CFGR_UART7EN			BIT(1)
#define RCC_UART7CFGR_UART7LPEN			BIT(2)

/* RCC_UART8CFGR register fields */
#define RCC_UART8CFGR_UART8RST			BIT(0)
#define RCC_UART8CFGR_UART8EN			BIT(1)
#define RCC_UART8CFGR_UART8LPEN			BIT(2)

/* RCC_UART9CFGR register fields */
#define RCC_UART9CFGR_UART9RST			BIT(0)
#define RCC_UART9CFGR_UART9EN			BIT(1)
#define RCC_UART9CFGR_UART9LPEN			BIT(2)

/* RCC_USARTxCFGR register fields */
#define RCC_USARTxCFGR_USARTxRST		BIT(0)
#define RCC_USARTxCFGR_USARTxEN			BIT(1)
#define RCC_USARTxCFGR_USARTxLPEN		BIT(2)

/* RCC_UARTxCFGR register fields */
#define RCC_UARTxCFGR_UARTxRST			BIT(0)
#define RCC_UARTxCFGR_UARTxEN			BIT(1)
#define RCC_UARTxCFGR_UARTxLPEN			BIT(2)

/* RCC_LPUART1CFGR register fields */
#define RCC_LPUART1CFGR_LPUART1RST		BIT(0)
#define RCC_LPUART1CFGR_LPUART1EN		BIT(1)
#define RCC_LPUART1CFGR_LPUART1LPEN		BIT(2)
#define RCC_LPUART1CFGR_LPUART1AMEN		BIT(3)

/* RCC_I2C1CFGR register fields */
#define RCC_I2C1CFGR_I2C1RST			BIT(0)
#define RCC_I2C1CFGR_I2C1EN			BIT(1)
#define RCC_I2C1CFGR_I2C1LPEN			BIT(2)

/* RCC_I2C2CFGR register fields */
#define RCC_I2C2CFGR_I2C2RST			BIT(0)
#define RCC_I2C2CFGR_I2C2EN			BIT(1)
#define RCC_I2C2CFGR_I2C2LPEN			BIT(2)

/* RCC_I2C3CFGR register fields */
#define RCC_I2C3CFGR_I2C3RST			BIT(0)
#define RCC_I2C3CFGR_I2C3EN			BIT(1)
#define RCC_I2C3CFGR_I2C3LPEN			BIT(2)

/* RCC_I2C4CFGR register fields */
#define RCC_I2C4CFGR_I2C4RST			BIT(0)
#define RCC_I2C4CFGR_I2C4EN			BIT(1)
#define RCC_I2C4CFGR_I2C4LPEN			BIT(2)

/* RCC_I2C5CFGR register fields */
#define RCC_I2C5CFGR_I2C5RST			BIT(0)
#define RCC_I2C5CFGR_I2C5EN			BIT(1)
#define RCC_I2C5CFGR_I2C5LPEN			BIT(2)

/* RCC_I2C6CFGR register fields */
#define RCC_I2C6CFGR_I2C6RST			BIT(0)
#define RCC_I2C6CFGR_I2C6EN			BIT(1)
#define RCC_I2C6CFGR_I2C6LPEN			BIT(2)

/* RCC_I2C7CFGR register fields */
#define RCC_I2C7CFGR_I2C7RST			BIT(0)
#define RCC_I2C7CFGR_I2C7EN			BIT(1)
#define RCC_I2C7CFGR_I2C7LPEN			BIT(2)

/* RCC_I2C8CFGR register fields */
#define RCC_I2C8CFGR_I2C8RST			BIT(0)
#define RCC_I2C8CFGR_I2C8EN			BIT(1)
#define RCC_I2C8CFGR_I2C8LPEN			BIT(2)
#define RCC_I2C8CFGR_I2C8AMEN			BIT(3)

/* RCC_I2CxCFGR register fields */
#define RCC_I2CxCFGR_I2CxRST			BIT(0)
#define RCC_I2CxCFGR_I2CxEN			BIT(1)
#define RCC_I2CxCFGR_I2CxLPEN			BIT(2)
#define RCC_I2CxCFGR_I2CxAMEN			BIT(3)

/* RCC_SAI1CFGR register fields */
#define RCC_SAI1CFGR_SAI1RST			BIT(0)
#define RCC_SAI1CFGR_SAI1EN			BIT(1)
#define RCC_SAI1CFGR_SAI1LPEN			BIT(2)

/* RCC_SAI2CFGR register fields */
#define RCC_SAI2CFGR_SAI2RST			BIT(0)
#define RCC_SAI2CFGR_SAI2EN			BIT(1)
#define RCC_SAI2CFGR_SAI2LPEN			BIT(2)

/* RCC_SAI3CFGR register fields */
#define RCC_SAI3CFGR_SAI3RST			BIT(0)
#define RCC_SAI3CFGR_SAI3EN			BIT(1)
#define RCC_SAI3CFGR_SAI3LPEN			BIT(2)

/* RCC_SAI4CFGR register fields */
#define RCC_SAI4CFGR_SAI4RST			BIT(0)
#define RCC_SAI4CFGR_SAI4EN			BIT(1)
#define RCC_SAI4CFGR_SAI4LPEN			BIT(2)

/* RCC_SAIxCFGR register fields */
#define RCC_SAIxCFGR_SAIxRST			BIT(0)
#define RCC_SAIxCFGR_SAIxEN			BIT(1)
#define RCC_SAIxCFGR_SAIxLPEN			BIT(2)

/* RCC_MDF1CFGR register fields */
#define RCC_MDF1CFGR_MDF1RST			BIT(0)
#define RCC_MDF1CFGR_MDF1EN			BIT(1)
#define RCC_MDF1CFGR_MDF1LPEN			BIT(2)

/* RCC_ADF1CFGR register fields */
#define RCC_ADF1CFGR_ADF1RST			BIT(0)
#define RCC_ADF1CFGR_ADF1EN			BIT(1)
#define RCC_ADF1CFGR_ADF1LPEN			BIT(2)
#define RCC_ADF1CFGR_ADF1AMEN			BIT(3)

/* RCC_FDCANCFGR register fields */
#define RCC_FDCANCFGR_FDCANRST			BIT(0)
#define RCC_FDCANCFGR_FDCANEN			BIT(1)
#define RCC_FDCANCFGR_FDCANLPEN			BIT(2)

/* RCC_HDPCFGR register fields */
#define RCC_HDPCFGR_HDPRST			BIT(0)
#define RCC_HDPCFGR_HDPEN			BIT(1)

/* RCC_ADC12CFGR register fields */
#define RCC_ADC12CFGR_ADC12RST			BIT(0)
#define RCC_ADC12CFGR_ADC12EN			BIT(1)
#define RCC_ADC12CFGR_ADC12LPEN			BIT(2)
#define RCC_ADC12CFGR_ADC12KERSEL		BIT(12)

/* RCC_ADC3CFGR register fields */
#define RCC_ADC3CFGR_ADC3RST			BIT(0)
#define RCC_ADC3CFGR_ADC3EN			BIT(1)
#define RCC_ADC3CFGR_ADC3LPEN			BIT(2)
#define RCC_ADC3CFGR_ADC3KERSEL_MASK		GENMASK_32(13, 12)
#define RCC_ADC3CFGR_ADC3KERSEL_SHIFT		12

/* RCC_ETH1CFGR register fields */
#define RCC_ETH1CFGR_ETH1RST			BIT(0)
#define RCC_ETH1CFGR_ETH1MACEN			BIT(1)
#define RCC_ETH1CFGR_ETH1MACLPEN		BIT(2)
#define RCC_ETH1CFGR_ETH1STPEN			BIT(4)
#define RCC_ETH1CFGR_ETH1EN			BIT(5)
#define RCC_ETH1CFGR_ETH1LPEN			BIT(6)
#define RCC_ETH1CFGR_ETH1TXEN			BIT(8)
#define RCC_ETH1CFGR_ETH1TXLPEN			BIT(9)
#define RCC_ETH1CFGR_ETH1RXEN			BIT(10)
#define RCC_ETH1CFGR_ETH1RXLPEN			BIT(11)

/* RCC_ETH2CFGR register fields */
#define RCC_ETH2CFGR_ETH2RST			BIT(0)
#define RCC_ETH2CFGR_ETH2MACEN			BIT(1)
#define RCC_ETH2CFGR_ETH2MACLPEN		BIT(2)
#define RCC_ETH2CFGR_ETH2STPEN			BIT(4)
#define RCC_ETH2CFGR_ETH2EN			BIT(5)
#define RCC_ETH2CFGR_ETH2LPEN			BIT(6)
#define RCC_ETH2CFGR_ETH2TXEN			BIT(8)
#define RCC_ETH2CFGR_ETH2TXLPEN			BIT(9)
#define RCC_ETH2CFGR_ETH2RXEN			BIT(10)
#define RCC_ETH2CFGR_ETH2RXLPEN			BIT(11)

/* RCC_ETHxCFGR register fields */
#define RCC_ETHxCFGR_ETHxRST			BIT(0)
#define RCC_ETHxCFGR_ETHxMACEN			BIT(1)
#define RCC_ETHxCFGR_ETHxMACLPEN		BIT(2)
#define RCC_ETHxCFGR_ETHxSTPEN			BIT(4)
#define RCC_ETHxCFGR_ETHxEN			BIT(5)
#define RCC_ETHxCFGR_ETHxLPEN			BIT(6)
#define RCC_ETHxCFGR_ETHxTXEN			BIT(8)
#define RCC_ETHxCFGR_ETHxTXLPEN			BIT(9)
#define RCC_ETHxCFGR_ETHxRXEN			BIT(10)
#define RCC_ETHxCFGR_ETHxRXLPEN			BIT(11)

/* RCC_USB2CFGR register fields */
#define RCC_USB2CFGR_USB2RST			BIT(0)
#define RCC_USB2CFGR_USB2EN			BIT(1)
#define RCC_USB2CFGR_USB2LPEN			BIT(2)
#define RCC_USB2CFGR_USB2STPEN			BIT(4)

/* RCC_USB2PHY1CFGR register fields */
#define RCC_USB2PHY1CFGR_USB2PHY1RST		BIT(0)
#define RCC_USB2PHY1CFGR_USB2PHY1EN		BIT(1)
#define RCC_USB2PHY1CFGR_USB2PHY1LPEN		BIT(2)
#define RCC_USB2PHY1CFGR_USB2PHY1STPEN		BIT(4)
#define RCC_USB2PHY1CFGR_USB2PHY1CKREFSEL	BIT(15)

/* RCC_USB2PHY2CFGR register fields */
#define RCC_USB2PHY2CFGR_USB2PHY2RST		BIT(0)
#define RCC_USB2PHY2CFGR_USB2PHY2EN		BIT(1)
#define RCC_USB2PHY2CFGR_USB2PHY2LPEN		BIT(2)
#define RCC_USB2PHY2CFGR_USB2PHY2STPEN		BIT(4)
#define RCC_USB2PHY2CFGR_USB2PHY2CKREFSEL	BIT(15)

/* RCC_USB2PHYxCFGR register fields */
#define RCC_USB2PHYxCFGR_USB2PHY1RST		BIT(0)
#define RCC_USB2PHYxCFGR_USB2PHY1EN		BIT(1)
#define RCC_USB2PHYxCFGR_USB2PHY1LPEN		BIT(2)
#define RCC_USB2PHYxCFGR_USB2PHY1STPEN		BIT(4)
#define RCC_USB2PHYxCFGR_USB2PHY1CKREFSEL	BIT(15)

/* RCC_USB3DRCFGR register fields */
#define RCC_USB3DRCFGR_USB3DRRST		BIT(0)
#define RCC_USB3DRCFGR_USB3DREN			BIT(1)
#define RCC_USB3DRCFGR_USB3DRLPEN		BIT(2)
#define RCC_USB3DRCFGR_USB3DRSTPEN		BIT(4)

/* RCC_USB3PCIEPHYCFGR register fields */
#define RCC_USB3PCIEPHYCFGR_USB3PCIEPHYRST	BIT(0)
#define RCC_USB3PCIEPHYCFGR_USB3PCIEPHYEN	BIT(1)
#define RCC_USB3PCIEPHYCFGR_USB3PCIEPHYLPEN	BIT(2)
#define RCC_USB3PCIEPHYCFGR_USB3PCIEPHYSTPEN	BIT(4)
#define RCC_USB3PCIEPHYCFGR_USB3PCIEPHYCKREFSEL	BIT(15)

/* RCC_PCIECFGR register fields */
#define RCC_PCIECFGR_PCIERST			BIT(0)
#define RCC_PCIECFGR_PCIEEN			BIT(1)
#define RCC_PCIECFGR_PCIELPEN			BIT(2)
#define RCC_PCIECFGR_PCIESTPEN			BIT(4)

/* RCC_UCPDCFGR register fields */
#define RCC_UCPDCFGR_UCPDRST			BIT(0)
#define RCC_UCPDCFGR_UCPDEN			BIT(1)
#define RCC_UCPDCFGR_UCPDLPEN			BIT(2)

/* RCC_ETHSWCFGR register fields */
#define RCC_ETHSWCFGR_ETHSWRST			BIT(0)
#define RCC_ETHSWCFGR_ETHSWMACEN		BIT(1)
#define RCC_ETHSWCFGR_ETHSWMACLPEN		BIT(2)
#define RCC_ETHSWCFGR_ETHSWEN			BIT(5)
#define RCC_ETHSWCFGR_ETHSWLPEN			BIT(6)
#define RCC_ETHSWCFGR_ETHSWREFEN		BIT(21)
#define RCC_ETHSWCFGR_ETHSWREFLPEN		BIT(22)

/* RCC_ETHSWACMCFGR register fields */
#define RCC_ETHSWACMCFGR_ETHSWACMEN		BIT(1)
#define RCC_ETHSWACMCFGR_ETHSWACMLPEN		BIT(2)

/* RCC_ETHSWACMMSGCFGR register fields */
#define RCC_ETHSWACMMSGCFGR_ETHSWACMMSGEN	BIT(1)
#define RCC_ETHSWACMMSGCFGR_ETHSWACMMSGLPEN	BIT(2)

/* RCC_STGENCFGR register fields */
#define RCC_STGENCFGR_STGENEN			BIT(1)
#define RCC_STGENCFGR_STGENLPEN			BIT(2)
#define RCC_STGENCFGR_STGENSTPEN		BIT(4)

/* RCC_SDMMC1CFGR register fields */
#define RCC_SDMMC1CFGR_SDMMC1RST		BIT(0)
#define RCC_SDMMC1CFGR_SDMMC1EN			BIT(1)
#define RCC_SDMMC1CFGR_SDMMC1LPEN		BIT(2)
#define RCC_SDMMC1CFGR_SDMMC1DLLRST		BIT(16)

/* RCC_SDMMC2CFGR register fields */
#define RCC_SDMMC2CFGR_SDMMC2RST		BIT(0)
#define RCC_SDMMC2CFGR_SDMMC2EN			BIT(1)
#define RCC_SDMMC2CFGR_SDMMC2LPEN		BIT(2)
#define RCC_SDMMC2CFGR_SDMMC2DLLRST		BIT(16)

/* RCC_SDMMC3CFGR register fields */
#define RCC_SDMMC3CFGR_SDMMC3RST		BIT(0)
#define RCC_SDMMC3CFGR_SDMMC3EN			BIT(1)
#define RCC_SDMMC3CFGR_SDMMC3LPEN		BIT(2)
#define RCC_SDMMC3CFGR_SDMMC3DLLRST		BIT(16)

/* RCC_SDMMCxCFGR register fields */
#define RCC_SDMMCxCFGR_SDMMC1RST		BIT(0)
#define RCC_SDMMCxCFGR_SDMMC1EN			BIT(1)
#define RCC_SDMMCxCFGR_SDMMC1LPEN		BIT(2)
#define RCC_SDMMCxCFGR_SDMMC1DLLRST		BIT(16)

/* RCC_GPUCFGR register fields */
#define RCC_GPUCFGR_GPURST			BIT(0)
#define RCC_GPUCFGR_GPUEN			BIT(1)
#define RCC_GPUCFGR_GPULPEN			BIT(2)

/* RCC_LTDCCFGR register fields */
#define RCC_LTDCCFGR_LTDCRST			BIT(0)
#define RCC_LTDCCFGR_LTDCEN			BIT(1)
#define RCC_LTDCCFGR_LTDCLPEN			BIT(2)

/* RCC_DSICFGR register fields */
#define RCC_DSICFGR_DSIRST			BIT(0)
#define RCC_DSICFGR_DSIEN			BIT(1)
#define RCC_DSICFGR_DSILPEN			BIT(2)
#define RCC_DSICFGR_DSIBLSEL			BIT(12)
#define RCC_DSICFGR_DSIPHYCKREFSEL		BIT(15)

/* RCC_LVDSCFGR register fields */
#define RCC_LVDSCFGR_LVDSRST			BIT(0)
#define RCC_LVDSCFGR_LVDSEN			BIT(1)
#define RCC_LVDSCFGR_LVDSLPEN			BIT(2)
#define RCC_LVDSCFGR_LVDSPHYCKREFSEL		BIT(15)

/* RCC_CSI2CFGR register fields */
#define RCC_CSI2CFGR_CSI2RST			BIT(0)
#define RCC_CSI2CFGR_CSI2EN			BIT(1)
#define RCC_CSI2CFGR_CSI2LPEN			BIT(2)

/* RCC_DCMIPPCFGR register fields */
#define RCC_DCMIPPCFGR_DCMIPPRST		BIT(0)
#define RCC_DCMIPPCFGR_DCMIPPEN			BIT(1)
#define RCC_DCMIPPCFGR_DCMIPPLPEN		BIT(2)

/* RCC_CCICFGR register fields */
#define RCC_CCICFGR_CCIRST			BIT(0)
#define RCC_CCICFGR_CCIEN			BIT(1)
#define RCC_CCICFGR_CCILPEN			BIT(2)

/* RCC_VDECCFGR register fields */
#define RCC_VDECCFGR_VDECRST			BIT(0)
#define RCC_VDECCFGR_VDECEN			BIT(1)
#define RCC_VDECCFGR_VDECLPEN			BIT(2)

/* RCC_VENCCFGR register fields */
#define RCC_VENCCFGR_VENCRST			BIT(0)
#define RCC_VENCCFGR_VENCEN			BIT(1)
#define RCC_VENCCFGR_VENCLPEN			BIT(2)

/* RCC_RNGCFGR register fields */
#define RCC_RNGCFGR_RNGRST			BIT(0)
#define RCC_RNGCFGR_RNGEN			BIT(1)
#define RCC_RNGCFGR_RNGLPEN			BIT(2)

/* RCC_PKACFGR register fields */
#define RCC_PKACFGR_PKARST			BIT(0)
#define RCC_PKACFGR_PKAEN			BIT(1)
#define RCC_PKACFGR_PKALPEN			BIT(2)

/* RCC_SAESCFGR register fields */
#define RCC_SAESCFGR_SAESRST			BIT(0)
#define RCC_SAESCFGR_SAESEN			BIT(1)
#define RCC_SAESCFGR_SAESLPEN			BIT(2)

/* RCC_HASHCFGR register fields */
#define RCC_HASHCFGR_HASHRST			BIT(0)
#define RCC_HASHCFGR_HASHEN			BIT(1)
#define RCC_HASHCFGR_HASHLPEN			BIT(2)

/* RCC_CRYP1CFGR register fields */
#define RCC_CRYP1CFGR_CRYP1RST			BIT(0)
#define RCC_CRYP1CFGR_CRYP1EN			BIT(1)
#define RCC_CRYP1CFGR_CRYP1LPEN			BIT(2)

/* RCC_CRYP2CFGR register fields */
#define RCC_CRYP2CFGR_CRYP2RST			BIT(0)
#define RCC_CRYP2CFGR_CRYP2EN			BIT(1)
#define RCC_CRYP2CFGR_CRYP2LPEN			BIT(2)

/* RCC_CRYPxCFGR register fields */
#define RCC_CRYPxCFGR_CRYPxRST			BIT(0)
#define RCC_CRYPxCFGR_CRYPxEN			BIT(1)
#define RCC_CRYPxCFGR_CRYPxLPEN			BIT(2)

/* RCC_IWDG1CFGR register fields */
#define RCC_IWDG1CFGR_IWDG1EN			BIT(1)
#define RCC_IWDG1CFGR_IWDG1LPEN			BIT(2)

/* RCC_IWDG2CFGR register fields */
#define RCC_IWDG2CFGR_IWDG2EN			BIT(1)
#define RCC_IWDG2CFGR_IWDG2LPEN			BIT(2)

/* RCC_IWDG3CFGR register fields */
#define RCC_IWDG3CFGR_IWDG3EN			BIT(1)
#define RCC_IWDG3CFGR_IWDG3LPEN			BIT(2)

/* RCC_IWDG4CFGR register fields */
#define RCC_IWDG4CFGR_IWDG4EN			BIT(1)
#define RCC_IWDG4CFGR_IWDG4LPEN			BIT(2)

/* RCC_IWDGxCFGR register fields */
#define RCC_IWDGxCFGR_IWDGxEN			BIT(1)
#define RCC_IWDGxCFGR_IWDGxLPEN			BIT(2)

/* RCC_IWDG5CFGR register fields */
#define RCC_IWDG5CFGR_IWDG5EN			BIT(1)
#define RCC_IWDG5CFGR_IWDG5LPEN			BIT(2)
#define RCC_IWDG5CFGR_IWDG5AMEN			BIT(3)

/* RCC_WWDG1CFGR register fields */
#define RCC_WWDG1CFGR_WWDG1RST			BIT(0)
#define RCC_WWDG1CFGR_WWDG1EN			BIT(1)
#define RCC_WWDG1CFGR_WWDG1LPEN			BIT(2)

/* RCC_WWDG2CFGR register fields */
#define RCC_WWDG2CFGR_WWDG2RST			BIT(0)
#define RCC_WWDG2CFGR_WWDG2EN			BIT(1)
#define RCC_WWDG2CFGR_WWDG2LPEN			BIT(2)
#define RCC_WWDG2CFGR_WWDG2AMEN			BIT(3)

/* RCC_VREFCFGR register fields */
#define RCC_VREFCFGR_VREFRST			BIT(0)
#define RCC_VREFCFGR_VREFEN			BIT(1)
#define RCC_VREFCFGR_VREFLPEN			BIT(2)

/* RCC_TMPSENSCFGR register fields */
#define RCC_TMPSENSCFGR_TMPSENSRST		BIT(0)
#define RCC_TMPSENSCFGR_TMPSENSEN		BIT(1)
#define RCC_TMPSENSCFGR_TMPSENSLPEN		BIT(2)
#define RCC_TMPSENSCFGR_TMPSENSKERSEL_MASK	GENMASK_32(13, 12)
#define RCC_TMPSENSCFGR_TMPSENSKERSEL_SHIFT	12

/* RCC_CRCCFGR register fields */
#define RCC_CRCCFGR_CRCRST			BIT(0)
#define RCC_CRCCFGR_CRCEN			BIT(1)
#define RCC_CRCCFGR_CRCLPEN			BIT(2)

/* RCC_SERCCFGR register fields */
#define RCC_SERCCFGR_SERCRST			BIT(0)
#define RCC_SERCCFGR_SERCEN			BIT(1)
#define RCC_SERCCFGR_SERCLPEN			BIT(2)

/* RCC_OSPIIOMCFGR register fields */
#define RCC_OSPIIOMCFGR_OSPIIOMRST		BIT(0)
#define RCC_OSPIIOMCFGR_OSPIIOMEN		BIT(1)
#define RCC_OSPIIOMCFGR_OSPIIOMLPEN		BIT(2)

/* RCC_GICV2MCFGR register fields */
#define RCC_GICV2MCFGR_GICV2MEN			BIT(1)
#define RCC_GICV2MCFGR_GICV2MLPEN		BIT(2)

/* RCC_I3C1CFGR register fields */
#define RCC_I3C1CFGR_I3C1RST			BIT(0)
#define RCC_I3C1CFGR_I3C1EN			BIT(1)
#define RCC_I3C1CFGR_I3C1LPEN			BIT(2)

/* RCC_I3C2CFGR register fields */
#define RCC_I3C2CFGR_I3C2RST			BIT(0)
#define RCC_I3C2CFGR_I3C2EN			BIT(1)
#define RCC_I3C2CFGR_I3C2LPEN			BIT(2)

/* RCC_I3C3CFGR register fields */
#define RCC_I3C3CFGR_I3C3RST			BIT(0)
#define RCC_I3C3CFGR_I3C3EN			BIT(1)
#define RCC_I3C3CFGR_I3C3LPEN			BIT(2)

/* RCC_I3C4CFGR register fields */
#define RCC_I3C4CFGR_I3C4RST			BIT(0)
#define RCC_I3C4CFGR_I3C4EN			BIT(1)
#define RCC_I3C4CFGR_I3C4LPEN			BIT(2)
#define RCC_I3C4CFGR_I3C4AMEN			BIT(3)

/* RCC_I3CxCFGR register fields */
#define RCC_I3CxCFGR_I3CxRST			BIT(0)
#define RCC_I3CxCFGR_I3CxEN			BIT(1)
#define RCC_I3CxCFGR_I3CxLPEN			BIT(2)
#define RCC_I3CxCFGR_I3CxAMEN			BIT(3)

/* RCC_MUXSELCFGR register fields */
#define RCC_MUXSELCFGR_MUXSEL0_MASK		GENMASK_32(1, 0)
#define RCC_MUXSELCFGR_MUXSEL0_SHIFT		0
#define RCC_MUXSELCFGR_MUXSEL1_MASK		GENMASK_32(5, 4)
#define RCC_MUXSELCFGR_MUXSEL1_SHIFT		4
#define RCC_MUXSELCFGR_MUXSEL2_MASK		GENMASK_32(9, 8)
#define RCC_MUXSELCFGR_MUXSEL2_SHIFT		8
#define RCC_MUXSELCFGR_MUXSEL3_MASK		GENMASK_32(13, 12)
#define RCC_MUXSELCFGR_MUXSEL3_SHIFT		12
#define RCC_MUXSELCFGR_MUXSEL4_MASK		GENMASK_32(17, 16)
#define RCC_MUXSELCFGR_MUXSEL4_SHIFT		16
#define RCC_MUXSELCFGR_MUXSEL5_MASK		GENMASK_32(21, 20)
#define RCC_MUXSELCFGR_MUXSEL5_SHIFT		20
#define RCC_MUXSELCFGR_MUXSEL6_MASK		GENMASK_32(25, 24)
#define RCC_MUXSELCFGR_MUXSEL6_SHIFT		24
#define RCC_MUXSELCFGR_MUXSEL7_MASK		GENMASK_32(29, 28)
#define RCC_MUXSELCFGR_MUXSEL7_SHIFT		28

/* RCC_XBAR0CFGR register fields */
#define RCC_XBAR0CFGR_XBAR0SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR0CFGR_XBAR0SEL_SHIFT		0
#define RCC_XBAR0CFGR_XBAR0EN			BIT(6)
#define RCC_XBAR0CFGR_XBAR0STS			BIT(7)

/* RCC_XBAR1CFGR register fields */
#define RCC_XBAR1CFGR_XBAR1SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR1CFGR_XBAR1SEL_SHIFT		0
#define RCC_XBAR1CFGR_XBAR1EN			BIT(6)
#define RCC_XBAR1CFGR_XBAR1STS			BIT(7)

/* RCC_XBAR2CFGR register fields */
#define RCC_XBAR2CFGR_XBAR2SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR2CFGR_XBAR2SEL_SHIFT		0
#define RCC_XBAR2CFGR_XBAR2EN			BIT(6)
#define RCC_XBAR2CFGR_XBAR2STS			BIT(7)

/* RCC_XBAR3CFGR register fields */
#define RCC_XBAR3CFGR_XBAR3SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR3CFGR_XBAR3SEL_SHIFT		0
#define RCC_XBAR3CFGR_XBAR3EN			BIT(6)
#define RCC_XBAR3CFGR_XBAR3STS			BIT(7)

/* RCC_XBAR4CFGR register fields */
#define RCC_XBAR4CFGR_XBAR4SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR4CFGR_XBAR4SEL_SHIFT		0
#define RCC_XBAR4CFGR_XBAR4EN			BIT(6)
#define RCC_XBAR4CFGR_XBAR4STS			BIT(7)

/* RCC_XBAR5CFGR register fields */
#define RCC_XBAR5CFGR_XBAR5SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR5CFGR_XBAR5SEL_SHIFT		0
#define RCC_XBAR5CFGR_XBAR5EN			BIT(6)
#define RCC_XBAR5CFGR_XBAR5STS			BIT(7)

/* RCC_XBAR6CFGR register fields */
#define RCC_XBAR6CFGR_XBAR6SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR6CFGR_XBAR6SEL_SHIFT		0
#define RCC_XBAR6CFGR_XBAR6EN			BIT(6)
#define RCC_XBAR6CFGR_XBAR6STS			BIT(7)

/* RCC_XBAR7CFGR register fields */
#define RCC_XBAR7CFGR_XBAR7SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR7CFGR_XBAR7SEL_SHIFT		0
#define RCC_XBAR7CFGR_XBAR7EN			BIT(6)
#define RCC_XBAR7CFGR_XBAR7STS			BIT(7)

/* RCC_XBAR8CFGR register fields */
#define RCC_XBAR8CFGR_XBAR8SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR8CFGR_XBAR8SEL_SHIFT		0
#define RCC_XBAR8CFGR_XBAR8EN			BIT(6)
#define RCC_XBAR8CFGR_XBAR8STS			BIT(7)

/* RCC_XBAR9CFGR register fields */
#define RCC_XBAR9CFGR_XBAR9SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR9CFGR_XBAR9SEL_SHIFT		0
#define RCC_XBAR9CFGR_XBAR9EN			BIT(6)
#define RCC_XBAR9CFGR_XBAR9STS			BIT(7)

/* RCC_XBAR10CFGR register fields */
#define RCC_XBAR10CFGR_XBAR10SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR10CFGR_XBAR10SEL_SHIFT		0
#define RCC_XBAR10CFGR_XBAR10EN			BIT(6)
#define RCC_XBAR10CFGR_XBAR10STS		BIT(7)

/* RCC_XBAR11CFGR register fields */
#define RCC_XBAR11CFGR_XBAR11SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR11CFGR_XBAR11SEL_SHIFT		0
#define RCC_XBAR11CFGR_XBAR11EN			BIT(6)
#define RCC_XBAR11CFGR_XBAR11STS		BIT(7)

/* RCC_XBAR12CFGR register fields */
#define RCC_XBAR12CFGR_XBAR12SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR12CFGR_XBAR12SEL_SHIFT		0
#define RCC_XBAR12CFGR_XBAR12EN			BIT(6)
#define RCC_XBAR12CFGR_XBAR12STS		BIT(7)

/* RCC_XBAR13CFGR register fields */
#define RCC_XBAR13CFGR_XBAR13SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR13CFGR_XBAR13SEL_SHIFT		0
#define RCC_XBAR13CFGR_XBAR13EN			BIT(6)
#define RCC_XBAR13CFGR_XBAR13STS		BIT(7)

/* RCC_XBAR14CFGR register fields */
#define RCC_XBAR14CFGR_XBAR14SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR14CFGR_XBAR14SEL_SHIFT		0
#define RCC_XBAR14CFGR_XBAR14EN			BIT(6)
#define RCC_XBAR14CFGR_XBAR14STS		BIT(7)

/* RCC_XBAR15CFGR register fields */
#define RCC_XBAR15CFGR_XBAR15SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR15CFGR_XBAR15SEL_SHIFT		0
#define RCC_XBAR15CFGR_XBAR15EN			BIT(6)
#define RCC_XBAR15CFGR_XBAR15STS		BIT(7)

/* RCC_XBAR16CFGR register fields */
#define RCC_XBAR16CFGR_XBAR16SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR16CFGR_XBAR16SEL_SHIFT		0
#define RCC_XBAR16CFGR_XBAR16EN			BIT(6)
#define RCC_XBAR16CFGR_XBAR16STS		BIT(7)

/* RCC_XBAR17CFGR register fields */
#define RCC_XBAR17CFGR_XBAR17SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR17CFGR_XBAR17SEL_SHIFT		0
#define RCC_XBAR17CFGR_XBAR17EN			BIT(6)
#define RCC_XBAR17CFGR_XBAR17STS		BIT(7)

/* RCC_XBAR18CFGR register fields */
#define RCC_XBAR18CFGR_XBAR18SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR18CFGR_XBAR18SEL_SHIFT		0
#define RCC_XBAR18CFGR_XBAR18EN			BIT(6)
#define RCC_XBAR18CFGR_XBAR18STS		BIT(7)

/* RCC_XBAR19CFGR register fields */
#define RCC_XBAR19CFGR_XBAR19SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR19CFGR_XBAR19SEL_SHIFT		0
#define RCC_XBAR19CFGR_XBAR19EN			BIT(6)
#define RCC_XBAR19CFGR_XBAR19STS		BIT(7)

/* RCC_XBAR20CFGR register fields */
#define RCC_XBAR20CFGR_XBAR20SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR20CFGR_XBAR20SEL_SHIFT		0
#define RCC_XBAR20CFGR_XBAR20EN			BIT(6)
#define RCC_XBAR20CFGR_XBAR20STS		BIT(7)

/* RCC_XBAR21CFGR register fields */
#define RCC_XBAR21CFGR_XBAR21SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR21CFGR_XBAR21SEL_SHIFT		0
#define RCC_XBAR21CFGR_XBAR21EN			BIT(6)
#define RCC_XBAR21CFGR_XBAR21STS		BIT(7)

/* RCC_XBAR22CFGR register fields */
#define RCC_XBAR22CFGR_XBAR22SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR22CFGR_XBAR22SEL_SHIFT		0
#define RCC_XBAR22CFGR_XBAR22EN			BIT(6)
#define RCC_XBAR22CFGR_XBAR22STS		BIT(7)

/* RCC_XBAR23CFGR register fields */
#define RCC_XBAR23CFGR_XBAR23SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR23CFGR_XBAR23SEL_SHIFT		0
#define RCC_XBAR23CFGR_XBAR23EN			BIT(6)
#define RCC_XBAR23CFGR_XBAR23STS		BIT(7)

/* RCC_XBAR24CFGR register fields */
#define RCC_XBAR24CFGR_XBAR24SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR24CFGR_XBAR24SEL_SHIFT		0
#define RCC_XBAR24CFGR_XBAR24EN			BIT(6)
#define RCC_XBAR24CFGR_XBAR24STS		BIT(7)

/* RCC_XBAR25CFGR register fields */
#define RCC_XBAR25CFGR_XBAR25SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR25CFGR_XBAR25SEL_SHIFT		0
#define RCC_XBAR25CFGR_XBAR25EN			BIT(6)
#define RCC_XBAR25CFGR_XBAR25STS		BIT(7)

/* RCC_XBAR26CFGR register fields */
#define RCC_XBAR26CFGR_XBAR26SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR26CFGR_XBAR26SEL_SHIFT		0
#define RCC_XBAR26CFGR_XBAR26EN			BIT(6)
#define RCC_XBAR26CFGR_XBAR26STS		BIT(7)

/* RCC_XBAR27CFGR register fields */
#define RCC_XBAR27CFGR_XBAR27SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR27CFGR_XBAR27SEL_SHIFT		0
#define RCC_XBAR27CFGR_XBAR27EN			BIT(6)
#define RCC_XBAR27CFGR_XBAR27STS		BIT(7)

/* RCC_XBAR28CFGR register fields */
#define RCC_XBAR28CFGR_XBAR28SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR28CFGR_XBAR28SEL_SHIFT		0
#define RCC_XBAR28CFGR_XBAR28EN			BIT(6)
#define RCC_XBAR28CFGR_XBAR28STS		BIT(7)

/* RCC_XBAR29CFGR register fields */
#define RCC_XBAR29CFGR_XBAR29SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR29CFGR_XBAR29SEL_SHIFT		0
#define RCC_XBAR29CFGR_XBAR29EN			BIT(6)
#define RCC_XBAR29CFGR_XBAR29STS		BIT(7)

/* RCC_XBAR30CFGR register fields */
#define RCC_XBAR30CFGR_XBAR30SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR30CFGR_XBAR30SEL_SHIFT		0
#define RCC_XBAR30CFGR_XBAR30EN			BIT(6)
#define RCC_XBAR30CFGR_XBAR30STS		BIT(7)

/* RCC_XBAR31CFGR register fields */
#define RCC_XBAR31CFGR_XBAR31SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR31CFGR_XBAR31SEL_SHIFT		0
#define RCC_XBAR31CFGR_XBAR31EN			BIT(6)
#define RCC_XBAR31CFGR_XBAR31STS		BIT(7)

/* RCC_XBAR32CFGR register fields */
#define RCC_XBAR32CFGR_XBAR32SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR32CFGR_XBAR32SEL_SHIFT		0
#define RCC_XBAR32CFGR_XBAR32EN			BIT(6)
#define RCC_XBAR32CFGR_XBAR32STS		BIT(7)

/* RCC_XBAR33CFGR register fields */
#define RCC_XBAR33CFGR_XBAR33SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR33CFGR_XBAR33SEL_SHIFT		0
#define RCC_XBAR33CFGR_XBAR33EN			BIT(6)
#define RCC_XBAR33CFGR_XBAR33STS		BIT(7)

/* RCC_XBAR34CFGR register fields */
#define RCC_XBAR34CFGR_XBAR34SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR34CFGR_XBAR34SEL_SHIFT		0
#define RCC_XBAR34CFGR_XBAR34EN			BIT(6)
#define RCC_XBAR34CFGR_XBAR34STS		BIT(7)

/* RCC_XBAR35CFGR register fields */
#define RCC_XBAR35CFGR_XBAR35SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR35CFGR_XBAR35SEL_SHIFT		0
#define RCC_XBAR35CFGR_XBAR35EN			BIT(6)
#define RCC_XBAR35CFGR_XBAR35STS		BIT(7)

/* RCC_XBAR36CFGR register fields */
#define RCC_XBAR36CFGR_XBAR36SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR36CFGR_XBAR36SEL_SHIFT		0
#define RCC_XBAR36CFGR_XBAR36EN			BIT(6)
#define RCC_XBAR36CFGR_XBAR36STS		BIT(7)

/* RCC_XBAR37CFGR register fields */
#define RCC_XBAR37CFGR_XBAR37SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR37CFGR_XBAR37SEL_SHIFT		0
#define RCC_XBAR37CFGR_XBAR37EN			BIT(6)
#define RCC_XBAR37CFGR_XBAR37STS		BIT(7)

/* RCC_XBAR38CFGR register fields */
#define RCC_XBAR38CFGR_XBAR38SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR38CFGR_XBAR38SEL_SHIFT		0
#define RCC_XBAR38CFGR_XBAR38EN			BIT(6)
#define RCC_XBAR38CFGR_XBAR38STS		BIT(7)

/* RCC_XBAR39CFGR register fields */
#define RCC_XBAR39CFGR_XBAR39SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR39CFGR_XBAR39SEL_SHIFT		0
#define RCC_XBAR39CFGR_XBAR39EN			BIT(6)
#define RCC_XBAR39CFGR_XBAR39STS		BIT(7)

/* RCC_XBAR40CFGR register fields */
#define RCC_XBAR40CFGR_XBAR40SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR40CFGR_XBAR40SEL_SHIFT		0
#define RCC_XBAR40CFGR_XBAR40EN			BIT(6)
#define RCC_XBAR40CFGR_XBAR40STS		BIT(7)

/* RCC_XBAR41CFGR register fields */
#define RCC_XBAR41CFGR_XBAR41SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR41CFGR_XBAR41SEL_SHIFT		0
#define RCC_XBAR41CFGR_XBAR41EN			BIT(6)
#define RCC_XBAR41CFGR_XBAR41STS		BIT(7)

/* RCC_XBAR42CFGR register fields */
#define RCC_XBAR42CFGR_XBAR42SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR42CFGR_XBAR42SEL_SHIFT		0
#define RCC_XBAR42CFGR_XBAR42EN			BIT(6)
#define RCC_XBAR42CFGR_XBAR42STS		BIT(7)

/* RCC_XBAR43CFGR register fields */
#define RCC_XBAR43CFGR_XBAR43SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR43CFGR_XBAR43SEL_SHIFT		0
#define RCC_XBAR43CFGR_XBAR43EN			BIT(6)
#define RCC_XBAR43CFGR_XBAR43STS		BIT(7)

/* RCC_XBAR44CFGR register fields */
#define RCC_XBAR44CFGR_XBAR44SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR44CFGR_XBAR44SEL_SHIFT		0
#define RCC_XBAR44CFGR_XBAR44EN			BIT(6)
#define RCC_XBAR44CFGR_XBAR44STS		BIT(7)

/* RCC_XBAR45CFGR register fields */
#define RCC_XBAR45CFGR_XBAR45SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR45CFGR_XBAR45SEL_SHIFT		0
#define RCC_XBAR45CFGR_XBAR45EN			BIT(6)
#define RCC_XBAR45CFGR_XBAR45STS		BIT(7)

/* RCC_XBAR46CFGR register fields */
#define RCC_XBAR46CFGR_XBAR46SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR46CFGR_XBAR46SEL_SHIFT		0
#define RCC_XBAR46CFGR_XBAR46EN			BIT(6)
#define RCC_XBAR46CFGR_XBAR46STS		BIT(7)

/* RCC_XBAR47CFGR register fields */
#define RCC_XBAR47CFGR_XBAR47SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR47CFGR_XBAR47SEL_SHIFT		0
#define RCC_XBAR47CFGR_XBAR47EN			BIT(6)
#define RCC_XBAR47CFGR_XBAR47STS		BIT(7)

/* RCC_XBAR48CFGR register fields */
#define RCC_XBAR48CFGR_XBAR48SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR48CFGR_XBAR48SEL_SHIFT		0
#define RCC_XBAR48CFGR_XBAR48EN			BIT(6)
#define RCC_XBAR48CFGR_XBAR48STS		BIT(7)

/* RCC_XBAR49CFGR register fields */
#define RCC_XBAR49CFGR_XBAR49SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR49CFGR_XBAR49SEL_SHIFT		0
#define RCC_XBAR49CFGR_XBAR49EN			BIT(6)
#define RCC_XBAR49CFGR_XBAR49STS		BIT(7)

/* RCC_XBAR50CFGR register fields */
#define RCC_XBAR50CFGR_XBAR50SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR50CFGR_XBAR50SEL_SHIFT		0
#define RCC_XBAR50CFGR_XBAR50EN			BIT(6)
#define RCC_XBAR50CFGR_XBAR50STS		BIT(7)

/* RCC_XBAR51CFGR register fields */
#define RCC_XBAR51CFGR_XBAR51SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR51CFGR_XBAR51SEL_SHIFT		0
#define RCC_XBAR51CFGR_XBAR51EN			BIT(6)
#define RCC_XBAR51CFGR_XBAR51STS		BIT(7)

/* RCC_XBAR52CFGR register fields */
#define RCC_XBAR52CFGR_XBAR52SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR52CFGR_XBAR52SEL_SHIFT		0
#define RCC_XBAR52CFGR_XBAR52EN			BIT(6)
#define RCC_XBAR52CFGR_XBAR52STS		BIT(7)

/* RCC_XBAR53CFGR register fields */
#define RCC_XBAR53CFGR_XBAR53SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR53CFGR_XBAR53SEL_SHIFT		0
#define RCC_XBAR53CFGR_XBAR53EN			BIT(6)
#define RCC_XBAR53CFGR_XBAR53STS		BIT(7)

/* RCC_XBAR54CFGR register fields */
#define RCC_XBAR54CFGR_XBAR54SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR54CFGR_XBAR54SEL_SHIFT		0
#define RCC_XBAR54CFGR_XBAR54EN			BIT(6)
#define RCC_XBAR54CFGR_XBAR54STS		BIT(7)

/* RCC_XBAR55CFGR register fields */
#define RCC_XBAR55CFGR_XBAR55SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR55CFGR_XBAR55SEL_SHIFT		0
#define RCC_XBAR55CFGR_XBAR55EN			BIT(6)
#define RCC_XBAR55CFGR_XBAR55STS		BIT(7)

/* RCC_XBAR56CFGR register fields */
#define RCC_XBAR56CFGR_XBAR56SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR56CFGR_XBAR56SEL_SHIFT		0
#define RCC_XBAR56CFGR_XBAR56EN			BIT(6)
#define RCC_XBAR56CFGR_XBAR56STS		BIT(7)

/* RCC_XBAR57CFGR register fields */
#define RCC_XBAR57CFGR_XBAR57SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR57CFGR_XBAR57SEL_SHIFT		0
#define RCC_XBAR57CFGR_XBAR57EN			BIT(6)
#define RCC_XBAR57CFGR_XBAR57STS		BIT(7)

/* RCC_XBAR58CFGR register fields */
#define RCC_XBAR58CFGR_XBAR58SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR58CFGR_XBAR58SEL_SHIFT		0
#define RCC_XBAR58CFGR_XBAR58EN			BIT(6)
#define RCC_XBAR58CFGR_XBAR58STS		BIT(7)

/* RCC_XBAR59CFGR register fields */
#define RCC_XBAR59CFGR_XBAR59SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR59CFGR_XBAR59SEL_SHIFT		0
#define RCC_XBAR59CFGR_XBAR59EN			BIT(6)
#define RCC_XBAR59CFGR_XBAR59STS		BIT(7)

/* RCC_XBAR60CFGR register fields */
#define RCC_XBAR60CFGR_XBAR60SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR60CFGR_XBAR60SEL_SHIFT		0
#define RCC_XBAR60CFGR_XBAR60EN			BIT(6)
#define RCC_XBAR60CFGR_XBAR60STS		BIT(7)

/* RCC_XBAR61CFGR register fields */
#define RCC_XBAR61CFGR_XBAR61SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR61CFGR_XBAR61SEL_SHIFT		0
#define RCC_XBAR61CFGR_XBAR61EN			BIT(6)
#define RCC_XBAR61CFGR_XBAR61STS		BIT(7)

/* RCC_XBAR62CFGR register fields */
#define RCC_XBAR62CFGR_XBAR62SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR62CFGR_XBAR62SEL_SHIFT		0
#define RCC_XBAR62CFGR_XBAR62EN			BIT(6)
#define RCC_XBAR62CFGR_XBAR62STS		BIT(7)

/* RCC_XBAR63CFGR register fields */
#define RCC_XBAR63CFGR_XBAR63SEL_MASK		GENMASK_32(3, 0)
#define RCC_XBAR63CFGR_XBAR63SEL_SHIFT		0
#define RCC_XBAR63CFGR_XBAR63EN			BIT(6)
#define RCC_XBAR63CFGR_XBAR63STS		BIT(7)

/* RCC_XBARxCFGR register fields */
#define RCC_XBARxCFGR_XBARxSEL_MASK		GENMASK_32(3, 0)
#define RCC_XBARxCFGR_XBARxSEL_SHIFT		0
#define RCC_XBARxCFGR_XBARxEN			BIT(6)
#define RCC_XBARxCFGR_XBARxSTS			BIT(7)

/* RCC_PREDIV0CFGR register fields */
#define RCC_PREDIV0CFGR_PREDIV0_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV0CFGR_PREDIV0_SHIFT		0

/* RCC_PREDIV1CFGR register fields */
#define RCC_PREDIV1CFGR_PREDIV1_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV1CFGR_PREDIV1_SHIFT		0

/* RCC_PREDIV2CFGR register fields */
#define RCC_PREDIV2CFGR_PREDIV2_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV2CFGR_PREDIV2_SHIFT		0

/* RCC_PREDIV3CFGR register fields */
#define RCC_PREDIV3CFGR_PREDIV3_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV3CFGR_PREDIV3_SHIFT		0

/* RCC_PREDIV4CFGR register fields */
#define RCC_PREDIV4CFGR_PREDIV4_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV4CFGR_PREDIV4_SHIFT		0

/* RCC_PREDIV5CFGR register fields */
#define RCC_PREDIV5CFGR_PREDIV5_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV5CFGR_PREDIV5_SHIFT		0

/* RCC_PREDIV6CFGR register fields */
#define RCC_PREDIV6CFGR_PREDIV6_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV6CFGR_PREDIV6_SHIFT		0

/* RCC_PREDIV7CFGR register fields */
#define RCC_PREDIV7CFGR_PREDIV7_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV7CFGR_PREDIV7_SHIFT		0

/* RCC_PREDIV8CFGR register fields */
#define RCC_PREDIV8CFGR_PREDIV8_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV8CFGR_PREDIV8_SHIFT		0

/* RCC_PREDIV9CFGR register fields */
#define RCC_PREDIV9CFGR_PREDIV9_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV9CFGR_PREDIV9_SHIFT		0

/* RCC_PREDIV10CFGR register fields */
#define RCC_PREDIV10CFGR_PREDIV10_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV10CFGR_PREDIV10_SHIFT		0

/* RCC_PREDIV11CFGR register fields */
#define RCC_PREDIV11CFGR_PREDIV11_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV11CFGR_PREDIV11_SHIFT		0

/* RCC_PREDIV12CFGR register fields */
#define RCC_PREDIV12CFGR_PREDIV12_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV12CFGR_PREDIV12_SHIFT		0

/* RCC_PREDIV13CFGR register fields */
#define RCC_PREDIV13CFGR_PREDIV13_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV13CFGR_PREDIV13_SHIFT		0

/* RCC_PREDIV14CFGR register fields */
#define RCC_PREDIV14CFGR_PREDIV14_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV14CFGR_PREDIV14_SHIFT		0

/* RCC_PREDIV15CFGR register fields */
#define RCC_PREDIV15CFGR_PREDIV15_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV15CFGR_PREDIV15_SHIFT		0

/* RCC_PREDIV16CFGR register fields */
#define RCC_PREDIV16CFGR_PREDIV16_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV16CFGR_PREDIV16_SHIFT		0

/* RCC_PREDIV17CFGR register fields */
#define RCC_PREDIV17CFGR_PREDIV17_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV17CFGR_PREDIV17_SHIFT		0

/* RCC_PREDIV18CFGR register fields */
#define RCC_PREDIV18CFGR_PREDIV18_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV18CFGR_PREDIV18_SHIFT		0

/* RCC_PREDIV19CFGR register fields */
#define RCC_PREDIV19CFGR_PREDIV19_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV19CFGR_PREDIV19_SHIFT		0

/* RCC_PREDIV20CFGR register fields */
#define RCC_PREDIV20CFGR_PREDIV20_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV20CFGR_PREDIV20_SHIFT		0

/* RCC_PREDIV21CFGR register fields */
#define RCC_PREDIV21CFGR_PREDIV21_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV21CFGR_PREDIV21_SHIFT		0

/* RCC_PREDIV22CFGR register fields */
#define RCC_PREDIV22CFGR_PREDIV22_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV22CFGR_PREDIV22_SHIFT		0

/* RCC_PREDIV23CFGR register fields */
#define RCC_PREDIV23CFGR_PREDIV23_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV23CFGR_PREDIV23_SHIFT		0

/* RCC_PREDIV24CFGR register fields */
#define RCC_PREDIV24CFGR_PREDIV24_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV24CFGR_PREDIV24_SHIFT		0

/* RCC_PREDIV25CFGR register fields */
#define RCC_PREDIV25CFGR_PREDIV25_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV25CFGR_PREDIV25_SHIFT		0

/* RCC_PREDIV26CFGR register fields */
#define RCC_PREDIV26CFGR_PREDIV26_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV26CFGR_PREDIV26_SHIFT		0

/* RCC_PREDIV27CFGR register fields */
#define RCC_PREDIV27CFGR_PREDIV27_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV27CFGR_PREDIV27_SHIFT		0

/* RCC_PREDIV28CFGR register fields */
#define RCC_PREDIV28CFGR_PREDIV28_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV28CFGR_PREDIV28_SHIFT		0

/* RCC_PREDIV29CFGR register fields */
#define RCC_PREDIV29CFGR_PREDIV29_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV29CFGR_PREDIV29_SHIFT		0

/* RCC_PREDIV30CFGR register fields */
#define RCC_PREDIV30CFGR_PREDIV30_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV30CFGR_PREDIV30_SHIFT		0

/* RCC_PREDIV31CFGR register fields */
#define RCC_PREDIV31CFGR_PREDIV31_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV31CFGR_PREDIV31_SHIFT		0

/* RCC_PREDIV32CFGR register fields */
#define RCC_PREDIV32CFGR_PREDIV32_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV32CFGR_PREDIV32_SHIFT		0

/* RCC_PREDIV33CFGR register fields */
#define RCC_PREDIV33CFGR_PREDIV33_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV33CFGR_PREDIV33_SHIFT		0

/* RCC_PREDIV34CFGR register fields */
#define RCC_PREDIV34CFGR_PREDIV34_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV34CFGR_PREDIV34_SHIFT		0

/* RCC_PREDIV35CFGR register fields */
#define RCC_PREDIV35CFGR_PREDIV35_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV35CFGR_PREDIV35_SHIFT		0

/* RCC_PREDIV36CFGR register fields */
#define RCC_PREDIV36CFGR_PREDIV36_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV36CFGR_PREDIV36_SHIFT		0

/* RCC_PREDIV37CFGR register fields */
#define RCC_PREDIV37CFGR_PREDIV37_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV37CFGR_PREDIV37_SHIFT		0

/* RCC_PREDIV38CFGR register fields */
#define RCC_PREDIV38CFGR_PREDIV38_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV38CFGR_PREDIV38_SHIFT		0

/* RCC_PREDIV39CFGR register fields */
#define RCC_PREDIV39CFGR_PREDIV39_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV39CFGR_PREDIV39_SHIFT		0

/* RCC_PREDIV40CFGR register fields */
#define RCC_PREDIV40CFGR_PREDIV40_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV40CFGR_PREDIV40_SHIFT		0

/* RCC_PREDIV41CFGR register fields */
#define RCC_PREDIV41CFGR_PREDIV41_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV41CFGR_PREDIV41_SHIFT		0

/* RCC_PREDIV42CFGR register fields */
#define RCC_PREDIV42CFGR_PREDIV42_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV42CFGR_PREDIV42_SHIFT		0

/* RCC_PREDIV43CFGR register fields */
#define RCC_PREDIV43CFGR_PREDIV43_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV43CFGR_PREDIV43_SHIFT		0

/* RCC_PREDIV44CFGR register fields */
#define RCC_PREDIV44CFGR_PREDIV44_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV44CFGR_PREDIV44_SHIFT		0

/* RCC_PREDIV45CFGR register fields */
#define RCC_PREDIV45CFGR_PREDIV45_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV45CFGR_PREDIV45_SHIFT		0

/* RCC_PREDIV46CFGR register fields */
#define RCC_PREDIV46CFGR_PREDIV46_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV46CFGR_PREDIV46_SHIFT		0

/* RCC_PREDIV47CFGR register fields */
#define RCC_PREDIV47CFGR_PREDIV47_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV47CFGR_PREDIV47_SHIFT		0

/* RCC_PREDIV48CFGR register fields */
#define RCC_PREDIV48CFGR_PREDIV48_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV48CFGR_PREDIV48_SHIFT		0

/* RCC_PREDIV49CFGR register fields */
#define RCC_PREDIV49CFGR_PREDIV49_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV49CFGR_PREDIV49_SHIFT		0

/* RCC_PREDIV50CFGR register fields */
#define RCC_PREDIV50CFGR_PREDIV50_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV50CFGR_PREDIV50_SHIFT		0

/* RCC_PREDIV51CFGR register fields */
#define RCC_PREDIV51CFGR_PREDIV51_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV51CFGR_PREDIV51_SHIFT		0

/* RCC_PREDIV52CFGR register fields */
#define RCC_PREDIV52CFGR_PREDIV52_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV52CFGR_PREDIV52_SHIFT		0

/* RCC_PREDIV53CFGR register fields */
#define RCC_PREDIV53CFGR_PREDIV53_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV53CFGR_PREDIV53_SHIFT		0

/* RCC_PREDIV54CFGR register fields */
#define RCC_PREDIV54CFGR_PREDIV54_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV54CFGR_PREDIV54_SHIFT		0

/* RCC_PREDIV55CFGR register fields */
#define RCC_PREDIV55CFGR_PREDIV55_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV55CFGR_PREDIV55_SHIFT		0

/* RCC_PREDIV56CFGR register fields */
#define RCC_PREDIV56CFGR_PREDIV56_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV56CFGR_PREDIV56_SHIFT		0

/* RCC_PREDIV57CFGR register fields */
#define RCC_PREDIV57CFGR_PREDIV57_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV57CFGR_PREDIV57_SHIFT		0

/* RCC_PREDIV58CFGR register fields */
#define RCC_PREDIV58CFGR_PREDIV58_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV58CFGR_PREDIV58_SHIFT		0

/* RCC_PREDIV59CFGR register fields */
#define RCC_PREDIV59CFGR_PREDIV59_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV59CFGR_PREDIV59_SHIFT		0

/* RCC_PREDIV60CFGR register fields */
#define RCC_PREDIV60CFGR_PREDIV60_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV60CFGR_PREDIV60_SHIFT		0

/* RCC_PREDIV61CFGR register fields */
#define RCC_PREDIV61CFGR_PREDIV61_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV61CFGR_PREDIV61_SHIFT		0

/* RCC_PREDIV62CFGR register fields */
#define RCC_PREDIV62CFGR_PREDIV62_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV62CFGR_PREDIV62_SHIFT		0

/* RCC_PREDIV63CFGR register fields */
#define RCC_PREDIV63CFGR_PREDIV63_MASK		GENMASK_32(9, 0)
#define RCC_PREDIV63CFGR_PREDIV63_SHIFT		0

/* RCC_PREDIVxCFGR register fields */
#define RCC_PREDIVxCFGR_PREDIVx_MASK		GENMASK_32(9, 0)
#define RCC_PREDIVxCFGR_PREDIVx_SHIFT		0

/* RCC_FINDIV0CFGR register fields */
#define RCC_FINDIV0CFGR_FINDIV0_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV0CFGR_FINDIV0_SHIFT		0
#define RCC_FINDIV0CFGR_FINDIV0EN		BIT(6)

/* RCC_FINDIV1CFGR register fields */
#define RCC_FINDIV1CFGR_FINDIV1_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV1CFGR_FINDIV1_SHIFT		0
#define RCC_FINDIV1CFGR_FINDIV1EN		BIT(6)

/* RCC_FINDIV2CFGR register fields */
#define RCC_FINDIV2CFGR_FINDIV2_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV2CFGR_FINDIV2_SHIFT		0
#define RCC_FINDIV2CFGR_FINDIV2EN		BIT(6)

/* RCC_FINDIV3CFGR register fields */
#define RCC_FINDIV3CFGR_FINDIV3_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV3CFGR_FINDIV3_SHIFT		0
#define RCC_FINDIV3CFGR_FINDIV3EN		BIT(6)

/* RCC_FINDIV4CFGR register fields */
#define RCC_FINDIV4CFGR_FINDIV4_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV4CFGR_FINDIV4_SHIFT		0
#define RCC_FINDIV4CFGR_FINDIV4EN		BIT(6)

/* RCC_FINDIV5CFGR register fields */
#define RCC_FINDIV5CFGR_FINDIV5_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV5CFGR_FINDIV5_SHIFT		0
#define RCC_FINDIV5CFGR_FINDIV5EN		BIT(6)

/* RCC_FINDIV6CFGR register fields */
#define RCC_FINDIV6CFGR_FINDIV6_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV6CFGR_FINDIV6_SHIFT		0
#define RCC_FINDIV6CFGR_FINDIV6EN		BIT(6)

/* RCC_FINDIV7CFGR register fields */
#define RCC_FINDIV7CFGR_FINDIV7_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV7CFGR_FINDIV7_SHIFT		0
#define RCC_FINDIV7CFGR_FINDIV7EN		BIT(6)

/* RCC_FINDIV8CFGR register fields */
#define RCC_FINDIV8CFGR_FINDIV8_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV8CFGR_FINDIV8_SHIFT		0
#define RCC_FINDIV8CFGR_FINDIV8EN		BIT(6)

/* RCC_FINDIV9CFGR register fields */
#define RCC_FINDIV9CFGR_FINDIV9_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV9CFGR_FINDIV9_SHIFT		0
#define RCC_FINDIV9CFGR_FINDIV9EN		BIT(6)

/* RCC_FINDIV10CFGR register fields */
#define RCC_FINDIV10CFGR_FINDIV10_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV10CFGR_FINDIV10_SHIFT		0
#define RCC_FINDIV10CFGR_FINDIV10EN		BIT(6)

/* RCC_FINDIV11CFGR register fields */
#define RCC_FINDIV11CFGR_FINDIV11_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV11CFGR_FINDIV11_SHIFT		0
#define RCC_FINDIV11CFGR_FINDIV11EN		BIT(6)

/* RCC_FINDIV12CFGR register fields */
#define RCC_FINDIV12CFGR_FINDIV12_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV12CFGR_FINDIV12_SHIFT		0
#define RCC_FINDIV12CFGR_FINDIV12EN		BIT(6)

/* RCC_FINDIV13CFGR register fields */
#define RCC_FINDIV13CFGR_FINDIV13_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV13CFGR_FINDIV13_SHIFT		0
#define RCC_FINDIV13CFGR_FINDIV13EN		BIT(6)

/* RCC_FINDIV14CFGR register fields */
#define RCC_FINDIV14CFGR_FINDIV14_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV14CFGR_FINDIV14_SHIFT		0
#define RCC_FINDIV14CFGR_FINDIV14EN		BIT(6)

/* RCC_FINDIV15CFGR register fields */
#define RCC_FINDIV15CFGR_FINDIV15_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV15CFGR_FINDIV15_SHIFT		0
#define RCC_FINDIV15CFGR_FINDIV15EN		BIT(6)

/* RCC_FINDIV16CFGR register fields */
#define RCC_FINDIV16CFGR_FINDIV16_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV16CFGR_FINDIV16_SHIFT		0
#define RCC_FINDIV16CFGR_FINDIV16EN		BIT(6)

/* RCC_FINDIV17CFGR register fields */
#define RCC_FINDIV17CFGR_FINDIV17_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV17CFGR_FINDIV17_SHIFT		0
#define RCC_FINDIV17CFGR_FINDIV17EN		BIT(6)

/* RCC_FINDIV18CFGR register fields */
#define RCC_FINDIV18CFGR_FINDIV18_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV18CFGR_FINDIV18_SHIFT		0
#define RCC_FINDIV18CFGR_FINDIV18EN		BIT(6)

/* RCC_FINDIV19CFGR register fields */
#define RCC_FINDIV19CFGR_FINDIV19_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV19CFGR_FINDIV19_SHIFT		0
#define RCC_FINDIV19CFGR_FINDIV19EN		BIT(6)

/* RCC_FINDIV20CFGR register fields */
#define RCC_FINDIV20CFGR_FINDIV20_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV20CFGR_FINDIV20_SHIFT		0
#define RCC_FINDIV20CFGR_FINDIV20EN		BIT(6)

/* RCC_FINDIV21CFGR register fields */
#define RCC_FINDIV21CFGR_FINDIV21_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV21CFGR_FINDIV21_SHIFT		0
#define RCC_FINDIV21CFGR_FINDIV21EN		BIT(6)

/* RCC_FINDIV22CFGR register fields */
#define RCC_FINDIV22CFGR_FINDIV22_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV22CFGR_FINDIV22_SHIFT		0
#define RCC_FINDIV22CFGR_FINDIV22EN		BIT(6)

/* RCC_FINDIV23CFGR register fields */
#define RCC_FINDIV23CFGR_FINDIV23_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV23CFGR_FINDIV23_SHIFT		0
#define RCC_FINDIV23CFGR_FINDIV23EN		BIT(6)

/* RCC_FINDIV24CFGR register fields */
#define RCC_FINDIV24CFGR_FINDIV24_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV24CFGR_FINDIV24_SHIFT		0
#define RCC_FINDIV24CFGR_FINDIV24EN		BIT(6)

/* RCC_FINDIV25CFGR register fields */
#define RCC_FINDIV25CFGR_FINDIV25_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV25CFGR_FINDIV25_SHIFT		0
#define RCC_FINDIV25CFGR_FINDIV25EN		BIT(6)

/* RCC_FINDIV26CFGR register fields */
#define RCC_FINDIV26CFGR_FINDIV26_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV26CFGR_FINDIV26_SHIFT		0
#define RCC_FINDIV26CFGR_FINDIV26EN		BIT(6)

/* RCC_FINDIV27CFGR register fields */
#define RCC_FINDIV27CFGR_FINDIV27_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV27CFGR_FINDIV27_SHIFT		0
#define RCC_FINDIV27CFGR_FINDIV27EN		BIT(6)

/* RCC_FINDIV28CFGR register fields */
#define RCC_FINDIV28CFGR_FINDIV28_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV28CFGR_FINDIV28_SHIFT		0
#define RCC_FINDIV28CFGR_FINDIV28EN		BIT(6)

/* RCC_FINDIV29CFGR register fields */
#define RCC_FINDIV29CFGR_FINDIV29_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV29CFGR_FINDIV29_SHIFT		0
#define RCC_FINDIV29CFGR_FINDIV29EN		BIT(6)

/* RCC_FINDIV30CFGR register fields */
#define RCC_FINDIV30CFGR_FINDIV30_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV30CFGR_FINDIV30_SHIFT		0
#define RCC_FINDIV30CFGR_FINDIV30EN		BIT(6)

/* RCC_FINDIV31CFGR register fields */
#define RCC_FINDIV31CFGR_FINDIV31_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV31CFGR_FINDIV31_SHIFT		0
#define RCC_FINDIV31CFGR_FINDIV31EN		BIT(6)

/* RCC_FINDIV32CFGR register fields */
#define RCC_FINDIV32CFGR_FINDIV32_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV32CFGR_FINDIV32_SHIFT		0
#define RCC_FINDIV32CFGR_FINDIV32EN		BIT(6)

/* RCC_FINDIV33CFGR register fields */
#define RCC_FINDIV33CFGR_FINDIV33_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV33CFGR_FINDIV33_SHIFT		0
#define RCC_FINDIV33CFGR_FINDIV33EN		BIT(6)

/* RCC_FINDIV34CFGR register fields */
#define RCC_FINDIV34CFGR_FINDIV34_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV34CFGR_FINDIV34_SHIFT		0
#define RCC_FINDIV34CFGR_FINDIV34EN		BIT(6)

/* RCC_FINDIV35CFGR register fields */
#define RCC_FINDIV35CFGR_FINDIV35_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV35CFGR_FINDIV35_SHIFT		0
#define RCC_FINDIV35CFGR_FINDIV35EN		BIT(6)

/* RCC_FINDIV36CFGR register fields */
#define RCC_FINDIV36CFGR_FINDIV36_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV36CFGR_FINDIV36_SHIFT		0
#define RCC_FINDIV36CFGR_FINDIV36EN		BIT(6)

/* RCC_FINDIV37CFGR register fields */
#define RCC_FINDIV37CFGR_FINDIV37_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV37CFGR_FINDIV37_SHIFT		0
#define RCC_FINDIV37CFGR_FINDIV37EN		BIT(6)

/* RCC_FINDIV38CFGR register fields */
#define RCC_FINDIV38CFGR_FINDIV38_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV38CFGR_FINDIV38_SHIFT		0
#define RCC_FINDIV38CFGR_FINDIV38EN		BIT(6)

/* RCC_FINDIV39CFGR register fields */
#define RCC_FINDIV39CFGR_FINDIV39_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV39CFGR_FINDIV39_SHIFT		0
#define RCC_FINDIV39CFGR_FINDIV39EN		BIT(6)

/* RCC_FINDIV40CFGR register fields */
#define RCC_FINDIV40CFGR_FINDIV40_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV40CFGR_FINDIV40_SHIFT		0
#define RCC_FINDIV40CFGR_FINDIV40EN		BIT(6)

/* RCC_FINDIV41CFGR register fields */
#define RCC_FINDIV41CFGR_FINDIV41_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV41CFGR_FINDIV41_SHIFT		0
#define RCC_FINDIV41CFGR_FINDIV41EN		BIT(6)

/* RCC_FINDIV42CFGR register fields */
#define RCC_FINDIV42CFGR_FINDIV42_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV42CFGR_FINDIV42_SHIFT		0
#define RCC_FINDIV42CFGR_FINDIV42EN		BIT(6)

/* RCC_FINDIV43CFGR register fields */
#define RCC_FINDIV43CFGR_FINDIV43_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV43CFGR_FINDIV43_SHIFT		0
#define RCC_FINDIV43CFGR_FINDIV43EN		BIT(6)

/* RCC_FINDIV44CFGR register fields */
#define RCC_FINDIV44CFGR_FINDIV44_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV44CFGR_FINDIV44_SHIFT		0
#define RCC_FINDIV44CFGR_FINDIV44EN		BIT(6)

/* RCC_FINDIV45CFGR register fields */
#define RCC_FINDIV45CFGR_FINDIV45_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV45CFGR_FINDIV45_SHIFT		0
#define RCC_FINDIV45CFGR_FINDIV45EN		BIT(6)

/* RCC_FINDIV46CFGR register fields */
#define RCC_FINDIV46CFGR_FINDIV46_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV46CFGR_FINDIV46_SHIFT		0
#define RCC_FINDIV46CFGR_FINDIV46EN		BIT(6)

/* RCC_FINDIV47CFGR register fields */
#define RCC_FINDIV47CFGR_FINDIV47_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV47CFGR_FINDIV47_SHIFT		0
#define RCC_FINDIV47CFGR_FINDIV47EN		BIT(6)

/* RCC_FINDIV48CFGR register fields */
#define RCC_FINDIV48CFGR_FINDIV48_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV48CFGR_FINDIV48_SHIFT		0
#define RCC_FINDIV48CFGR_FINDIV48EN		BIT(6)

/* RCC_FINDIV49CFGR register fields */
#define RCC_FINDIV49CFGR_FINDIV49_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV49CFGR_FINDIV49_SHIFT		0
#define RCC_FINDIV49CFGR_FINDIV49EN		BIT(6)

/* RCC_FINDIV50CFGR register fields */
#define RCC_FINDIV50CFGR_FINDIV50_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV50CFGR_FINDIV50_SHIFT		0
#define RCC_FINDIV50CFGR_FINDIV50EN		BIT(6)

/* RCC_FINDIV51CFGR register fields */
#define RCC_FINDIV51CFGR_FINDIV51_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV51CFGR_FINDIV51_SHIFT		0
#define RCC_FINDIV51CFGR_FINDIV51EN		BIT(6)

/* RCC_FINDIV52CFGR register fields */
#define RCC_FINDIV52CFGR_FINDIV52_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV52CFGR_FINDIV52_SHIFT		0
#define RCC_FINDIV52CFGR_FINDIV52EN		BIT(6)

/* RCC_FINDIV53CFGR register fields */
#define RCC_FINDIV53CFGR_FINDIV53_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV53CFGR_FINDIV53_SHIFT		0
#define RCC_FINDIV53CFGR_FINDIV53EN		BIT(6)

/* RCC_FINDIV54CFGR register fields */
#define RCC_FINDIV54CFGR_FINDIV54_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV54CFGR_FINDIV54_SHIFT		0
#define RCC_FINDIV54CFGR_FINDIV54EN		BIT(6)

/* RCC_FINDIV55CFGR register fields */
#define RCC_FINDIV55CFGR_FINDIV55_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV55CFGR_FINDIV55_SHIFT		0
#define RCC_FINDIV55CFGR_FINDIV55EN		BIT(6)

/* RCC_FINDIV56CFGR register fields */
#define RCC_FINDIV56CFGR_FINDIV56_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV56CFGR_FINDIV56_SHIFT		0
#define RCC_FINDIV56CFGR_FINDIV56EN		BIT(6)

/* RCC_FINDIV57CFGR register fields */
#define RCC_FINDIV57CFGR_FINDIV57_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV57CFGR_FINDIV57_SHIFT		0
#define RCC_FINDIV57CFGR_FINDIV57EN		BIT(6)

/* RCC_FINDIV58CFGR register fields */
#define RCC_FINDIV58CFGR_FINDIV58_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV58CFGR_FINDIV58_SHIFT		0
#define RCC_FINDIV58CFGR_FINDIV58EN		BIT(6)

/* RCC_FINDIV59CFGR register fields */
#define RCC_FINDIV59CFGR_FINDIV59_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV59CFGR_FINDIV59_SHIFT		0
#define RCC_FINDIV59CFGR_FINDIV59EN		BIT(6)

/* RCC_FINDIV60CFGR register fields */
#define RCC_FINDIV60CFGR_FINDIV60_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV60CFGR_FINDIV60_SHIFT		0
#define RCC_FINDIV60CFGR_FINDIV60EN		BIT(6)

/* RCC_FINDIV61CFGR register fields */
#define RCC_FINDIV61CFGR_FINDIV61_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV61CFGR_FINDIV61_SHIFT		0
#define RCC_FINDIV61CFGR_FINDIV61EN		BIT(6)

/* RCC_FINDIV62CFGR register fields */
#define RCC_FINDIV62CFGR_FINDIV62_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV62CFGR_FINDIV62_SHIFT		0
#define RCC_FINDIV62CFGR_FINDIV62EN		BIT(6)

/* RCC_FINDIV63CFGR register fields */
#define RCC_FINDIV63CFGR_FINDIV63_MASK		GENMASK_32(5, 0)
#define RCC_FINDIV63CFGR_FINDIV63_SHIFT		0
#define RCC_FINDIV63CFGR_FINDIV63EN		BIT(6)

/* RCC_FINDIVxCFGR register fields */
#define RCC_FINDIVxCFGR_FINDIVx_MASK		GENMASK_32(5, 0)
#define RCC_FINDIVxCFGR_FINDIVx_SHIFT		0
#define RCC_FINDIVxCFGR_FINDIVxEN		BIT(6)

/* RCC_FCALCOBS0CFGR register fields */
#define RCC_FCALCOBS0CFGR_CKINTSEL_MASK		GENMASK_32(7, 0)
#define RCC_FCALCOBS0CFGR_CKINTSEL_SHIFT	0
#define RCC_FCALCOBS0CFGR_CKEXTSEL_MASK		GENMASK_32(10, 8)
#define RCC_FCALCOBS0CFGR_CKEXTSEL_SHIFT	8
#define RCC_FCALCOBS0CFGR_FCALCCKEXTSEL		BIT(15)
#define RCC_FCALCOBS0CFGR_CKOBSEXTSEL		BIT(16)
#define RCC_FCALCOBS0CFGR_FCALCCKINV		BIT(17)
#define RCC_FCALCOBS0CFGR_CKOBSINV		BIT(18)
#define RCC_FCALCOBS0CFGR_CKOBSDIV_MASK		GENMASK_32(24, 22)
#define RCC_FCALCOBS0CFGR_CKOBSDIV_SHIFT	22
#define RCC_FCALCOBS0CFGR_FCALCCKEN		BIT(25)
#define RCC_FCALCOBS0CFGR_CKOBSEN		BIT(26)

/* RCC_FCALCOBS1CFGR register fields */
#define RCC_FCALCOBS1CFGR_CKINTSEL_MASK		GENMASK_32(7, 0)
#define RCC_FCALCOBS1CFGR_CKINTSEL_SHIFT	0
#define RCC_FCALCOBS1CFGR_CKEXTSEL_MASK		GENMASK_32(10, 8)
#define RCC_FCALCOBS1CFGR_CKEXTSEL_SHIFT	8
#define RCC_FCALCOBS1CFGR_CKOBSEXTSEL		BIT(16)
#define RCC_FCALCOBS1CFGR_CKOBSINV		BIT(18)
#define RCC_FCALCOBS1CFGR_CKOBSDIV_MASK		GENMASK_32(24, 22)
#define RCC_FCALCOBS1CFGR_CKOBSDIV_SHIFT	22
#define RCC_FCALCOBS1CFGR_CKOBSEN		BIT(26)
#define RCC_FCALCOBS1CFGR_FCALCRSTN		BIT(27)

/* RCC_FCALCREFCFGR register fields */
#define RCC_FCALCREFCFGR_FCALCREFCKSEL_MASK	GENMASK_32(2, 0)
#define RCC_FCALCREFCFGR_FCALCREFCKSEL_SHIFT	0

/* RCC_FCALCCR1 register fields */
#define RCC_FCALCCR1_FCALCRUN			BIT(0)

/* RCC_FCALCCR2 register fields */
#define RCC_FCALCCR2_FCALCMD_MASK		GENMASK_32(4, 3)
#define RCC_FCALCCR2_FCALCMD_SHIFT		3
#define RCC_FCALCCR2_FCALCTWC_MASK		GENMASK_32(14, 11)
#define RCC_FCALCCR2_FCALCTWC_SHIFT		11
#define RCC_FCALCCR2_FCALCTYP_MASK		GENMASK_32(21, 17)
#define RCC_FCALCCR2_FCALCTYP_SHIFT		17

/* RCC_FCALCSR register fields */
#define RCC_FCALCSR_FVAL_MASK			GENMASK_32(16, 0)
#define RCC_FCALCSR_FVAL_SHIFT			0
#define RCC_FCALCSR_FCALCSTS			BIT(19)

/* RCC_PLL4CFGR1 register fields */
#define RCC_PLL4CFGR1_SSMODRST			BIT(0)
#define RCC_PLL4CFGR1_PLLEN			BIT(8)
#define RCC_PLL4CFGR1_PLLRDY			BIT(24)
#define RCC_PLL4CFGR1_CKREFST			BIT(28)

/* RCC_PLL4CFGR2 register fields */
#define RCC_PLL4CFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLL4CFGR2_FREFDIV_SHIFT		0
#define RCC_PLL4CFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLL4CFGR2_FBDIV_SHIFT		16

/* RCC_PLL4CFGR3 register fields */
#define RCC_PLL4CFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLL4CFGR3_FRACIN_SHIFT		0
#define RCC_PLL4CFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLL4CFGR3_DACEN			BIT(25)
#define RCC_PLL4CFGR3_SSCGDIS			BIT(26)

/* RCC_PLL4CFGR4 register fields */
#define RCC_PLL4CFGR4_DSMEN			BIT(8)
#define RCC_PLL4CFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLL4CFGR4_BYPASS			BIT(10)

/* RCC_PLL4CFGR5 register fields */
#define RCC_PLL4CFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLL4CFGR5_DIVVAL_SHIFT		0
#define RCC_PLL4CFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLL4CFGR5_SPREAD_SHIFT		16

/* RCC_PLL4CFGR6 register fields */
#define RCC_PLL4CFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLL4CFGR6_POSTDIV1_SHIFT		0

/* RCC_PLL4CFGR7 register fields */
#define RCC_PLL4CFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLL4CFGR7_POSTDIV2_SHIFT		0

/* RCC_PLL5CFGR1 register fields */
#define RCC_PLL5CFGR1_SSMODRST			BIT(0)
#define RCC_PLL5CFGR1_PLLEN			BIT(8)
#define RCC_PLL5CFGR1_PLLRDY			BIT(24)
#define RCC_PLL5CFGR1_CKREFST			BIT(28)

/* RCC_PLL5CFGR2 register fields */
#define RCC_PLL5CFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLL5CFGR2_FREFDIV_SHIFT		0
#define RCC_PLL5CFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLL5CFGR2_FBDIV_SHIFT		16

/* RCC_PLL5CFGR3 register fields */
#define RCC_PLL5CFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLL5CFGR3_FRACIN_SHIFT		0
#define RCC_PLL5CFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLL5CFGR3_DACEN			BIT(25)
#define RCC_PLL5CFGR3_SSCGDIS			BIT(26)

/* RCC_PLL5CFGR4 register fields */
#define RCC_PLL5CFGR4_DSMEN			BIT(8)
#define RCC_PLL5CFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLL5CFGR4_BYPASS			BIT(10)

/* RCC_PLL5CFGR5 register fields */
#define RCC_PLL5CFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLL5CFGR5_DIVVAL_SHIFT		0
#define RCC_PLL5CFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLL5CFGR5_SPREAD_SHIFT		16

/* RCC_PLL5CFGR6 register fields */
#define RCC_PLL5CFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLL5CFGR6_POSTDIV1_SHIFT		0

/* RCC_PLL5CFGR7 register fields */
#define RCC_PLL5CFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLL5CFGR7_POSTDIV2_SHIFT		0

/* RCC_PLL6CFGR1 register fields */
#define RCC_PLL6CFGR1_SSMODRST			BIT(0)
#define RCC_PLL6CFGR1_PLLEN			BIT(8)
#define RCC_PLL6CFGR1_PLLRDY			BIT(24)
#define RCC_PLL6CFGR1_CKREFST			BIT(28)

/* RCC_PLL6CFGR2 register fields */
#define RCC_PLL6CFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLL6CFGR2_FREFDIV_SHIFT		0
#define RCC_PLL6CFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLL6CFGR2_FBDIV_SHIFT		16

/* RCC_PLL6CFGR3 register fields */
#define RCC_PLL6CFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLL6CFGR3_FRACIN_SHIFT		0
#define RCC_PLL6CFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLL6CFGR3_DACEN			BIT(25)
#define RCC_PLL6CFGR3_SSCGDIS			BIT(26)

/* RCC_PLL6CFGR4 register fields */
#define RCC_PLL6CFGR4_DSMEN			BIT(8)
#define RCC_PLL6CFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLL6CFGR4_BYPASS			BIT(10)

/* RCC_PLL6CFGR5 register fields */
#define RCC_PLL6CFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLL6CFGR5_DIVVAL_SHIFT		0
#define RCC_PLL6CFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLL6CFGR5_SPREAD_SHIFT		16

/* RCC_PLL6CFGR6 register fields */
#define RCC_PLL6CFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLL6CFGR6_POSTDIV1_SHIFT		0

/* RCC_PLL6CFGR7 register fields */
#define RCC_PLL6CFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLL6CFGR7_POSTDIV2_SHIFT		0

/* RCC_PLL7CFGR1 register fields */
#define RCC_PLL7CFGR1_SSMODRST			BIT(0)
#define RCC_PLL7CFGR1_PLLEN			BIT(8)
#define RCC_PLL7CFGR1_PLLRDY			BIT(24)
#define RCC_PLL7CFGR1_CKREFST			BIT(28)

/* RCC_PLL7CFGR2 register fields */
#define RCC_PLL7CFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLL7CFGR2_FREFDIV_SHIFT		0
#define RCC_PLL7CFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLL7CFGR2_FBDIV_SHIFT		16

/* RCC_PLL7CFGR3 register fields */
#define RCC_PLL7CFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLL7CFGR3_FRACIN_SHIFT		0
#define RCC_PLL7CFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLL7CFGR3_DACEN			BIT(25)
#define RCC_PLL7CFGR3_SSCGDIS			BIT(26)

/* RCC_PLL7CFGR4 register fields */
#define RCC_PLL7CFGR4_DSMEN			BIT(8)
#define RCC_PLL7CFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLL7CFGR4_BYPASS			BIT(10)

/* RCC_PLL7CFGR5 register fields */
#define RCC_PLL7CFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLL7CFGR5_DIVVAL_SHIFT		0
#define RCC_PLL7CFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLL7CFGR5_SPREAD_SHIFT		16

/* RCC_PLL7CFGR6 register fields */
#define RCC_PLL7CFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLL7CFGR6_POSTDIV1_SHIFT		0

/* RCC_PLL7CFGR7 register fields */
#define RCC_PLL7CFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLL7CFGR7_POSTDIV2_SHIFT		0

/* RCC_PLL8CFGR1 register fields */
#define RCC_PLL8CFGR1_SSMODRST			BIT(0)
#define RCC_PLL8CFGR1_PLLEN			BIT(8)
#define RCC_PLL8CFGR1_PLLRDY			BIT(24)
#define RCC_PLL8CFGR1_CKREFST			BIT(28)

/* RCC_PLL8CFGR2 register fields */
#define RCC_PLL8CFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLL8CFGR2_FREFDIV_SHIFT		0
#define RCC_PLL8CFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLL8CFGR2_FBDIV_SHIFT		16

/* RCC_PLL8CFGR3 register fields */
#define RCC_PLL8CFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLL8CFGR3_FRACIN_SHIFT		0
#define RCC_PLL8CFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLL8CFGR3_DACEN			BIT(25)
#define RCC_PLL8CFGR3_SSCGDIS			BIT(26)

/* RCC_PLL8CFGR4 register fields */
#define RCC_PLL8CFGR4_DSMEN			BIT(8)
#define RCC_PLL8CFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLL8CFGR4_BYPASS			BIT(10)

/* RCC_PLL8CFGR5 register fields */
#define RCC_PLL8CFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLL8CFGR5_DIVVAL_SHIFT		0
#define RCC_PLL8CFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLL8CFGR5_SPREAD_SHIFT		16

/* RCC_PLL8CFGR6 register fields */
#define RCC_PLL8CFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLL8CFGR6_POSTDIV1_SHIFT		0

/* RCC_PLL8CFGR7 register fields */
#define RCC_PLL8CFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLL8CFGR7_POSTDIV2_SHIFT		0

/* RCC_PLLxCFGR1 register fields */
#define RCC_PLLxCFGR1_SSMODRST			BIT(0)
#define RCC_PLLxCFGR1_PLLEN			BIT(8)
#define RCC_PLLxCFGR1_PLLRDY			BIT(24)
#define RCC_PLLxCFGR1_CKREFST			BIT(28)

/* RCC_PLLxCFGR2 register fields */
#define RCC_PLLxCFGR2_FREFDIV_MASK		GENMASK_32(5, 0)
#define RCC_PLLxCFGR2_FREFDIV_SHIFT		0
#define RCC_PLLxCFGR2_FBDIV_MASK		GENMASK_32(27, 16)
#define RCC_PLLxCFGR2_FBDIV_SHIFT		16

/* RCC_PLLxCFGR3 register fields */
#define RCC_PLLxCFGR3_FRACIN_MASK		GENMASK_32(23, 0)
#define RCC_PLLxCFGR3_FRACIN_SHIFT		0
#define RCC_PLLxCFGR3_DOWNSPREAD		BIT(24)
#define RCC_PLLxCFGR3_DACEN			BIT(25)
#define RCC_PLLxCFGR3_SSCGDIS			BIT(26)

/* RCC_PLLxCFGR4 register fields */
#define RCC_PLLxCFGR4_DSMEN			BIT(8)
#define RCC_PLLxCFGR4_FOUTPOSTDIVEN		BIT(9)
#define RCC_PLLxCFGR4_BYPASS			BIT(10)

/* RCC_PLLxCFGR5 register fields */
#define RCC_PLLxCFGR5_DIVVAL_MASK		GENMASK_32(3, 0)
#define RCC_PLLxCFGR5_DIVVAL_SHIFT		0
#define RCC_PLLxCFGR5_SPREAD_MASK		GENMASK_32(20, 16)
#define RCC_PLLxCFGR5_SPREAD_SHIFT		16

/* RCC_PLLxCFGR6 register fields */
#define RCC_PLLxCFGR6_POSTDIV1_MASK		GENMASK_32(2, 0)
#define RCC_PLLxCFGR6_POSTDIV1_SHIFT		0

/* RCC_PLLxCFGR7 register fields */
#define RCC_PLLxCFGR7_POSTDIV2_MASK		GENMASK_32(2, 0)
#define RCC_PLLxCFGR7_POSTDIV2_SHIFT		0

/* RCC_VERR register fields */
#define RCC_VERR_MINREV_MASK			GENMASK_32(3, 0)
#define RCC_VERR_MINREV_SHIFT			0
#define RCC_VERR_MAJREV_MASK			GENMASK_32(7, 4)
#define RCC_VERR_MAJREV_SHIFT			4

#endif /* STM32MP2_RCC_H */
