/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MT_SPM_HWREQ_H
#define MT_SPM_HWREQ_H

#include <drivers/spm/mt_spm_resource_req.h>
#include <mt_spm_common_v1.h>

/* ddren, apsrc and emi resource have become hw resource_req.
 * So we don't need to use HW CG for request resource.
 */
#define SPM_HWCG_DDREN_PWR_MB		0
#define SPM_HWCG_DDREN_PWR_MSB_MB	0
#define SPM_HWCG_DDREN_MODULE_BUSY_MB	0

/* VRF18 */
#define SPM_HWCG_VRF18_PWR_MB		0
#define SPM_HWCG_VRF18_PWR_MSB_MB	0
#define SPM_HWCG_VRF18_MODULE_BUSY_MB	0

/* INFRA */
#define SPM_HWCG_INFRA_PWR_MB		SPM_HWCG_VRF18_PWR_MB
#define SPM_HWCG_INFRA_PWR_MSB_MB	SPM_HWCG_VRF18_PWR_MSB_MB
#define SPM_HWCG_INFRA_MODULE_BUSY_MB	0

/* PMIC */
#define SPM_HWCG_PMIC_PWR_MB		SPM_HWCG_VRF18_PWR_MB
#define SPM_HWCG_PMIC_PWR_MSB_MB	SPM_HWCG_VRF18_PWR_MSB_MB
#define SPM_HWCG_PMIC_MODULE_BUSY_MB	0

/* F26M */
#define SPM_HWCG_F26M_PWR_MB		SPM_HWCG_PMIC_PWR_MB
#define SPM_HWCG_F26M_PWR_MSB_MB	SPM_HWCG_PMIC_PWR_MSB_MB
#define SPM_HWCG_F26M_MODULE_BUSY_MB	0

/* VCORE */
#define SPM_HWCG_VCORE_PWR_MB		SPM_HWCG_F26M_PWR_MB
#define SPM_HWCG_VCORE_PWR_MSB_MB	SPM_HWCG_F26M_PWR_MSB_MB
#define SPM_HWCG_VCORE_MODULE_BUSY_MB	SPM_HWCG_F26M_MODULE_BUSY_MB

#define INFRA_SW_CG_MB			0

#define PERI_REQ_EN_MASK		0x3FFFFF

/* Resource requirement which HW CG support */
enum {
	HWCG_DDREN = 0,
	HWCG_VRF18,
	HWCG_INFRA,
	HWCG_PMIC,
	HWCG_F26M,
	HWCG_VCORE,
	HWCG_MAX
};

enum spm_pwr_status {
	HWCG_PWR_MD1 = 0,
	HWCG_PWR_CONN,
	HWCG_PWR_APIFR_IO,
	HWCG_PWR_APIFR_MEM,
	HWCG_PWR_PERI,
	HWCG_PWR_PERI_ETHER,
	HWCG_PWR_SSUSB_PD_PHY_P0,
	HWCG_PWR_SSUSB_P0,
	HWCG_PWR_SSUSB_P1,
	HWCG_PWR_SSUSB_P23,
	HWCG_PWR_SSUSB_PHY_P2,
	HWCG_PWR_UFS0,
	HWCG_PWR_UFS0_PHY,
	HWCG_PWR_PEXTP_MAC0,
	HWCG_PWR_PEXTP_MAC1,
	HWCG_PWR_PEXTP_MAC2,
	HWCG_PWR_PEXTP_PHY0,
	HWCG_PWR_PEXTP_PHY1,
	HWCG_PWR_PEXTP_PHY3,
	HWCG_PWR_AUDIO,
	HWCG_PWR_ADSP_CORE1,
	HWCG_PWR_ADSP_TOP,
	HWCG_PWR_ADSP_INFRA,
	HWCG_PWR_ADSP_AO,
	HWCG_PWR_MM_PROC,
	HWCG_PWR_SCP,
	HWCG_PWR_SCP2,
	HWCG_PWR_DPYD0,
	HWCG_PWR_DPYD1,
	HWCG_PWR_DPYD2,
	HWCG_PWR_DPYD3,
	HWCG_PWR_DPYA0
};

CASSERT(HWCG_PWR_SSUSB_P1 == 8, spm_pwr_status_err);
CASSERT(HWCG_PWR_PEXTP_PHY0 == 16, spm_pwr_status_err);
CASSERT(HWCG_PWR_MM_PROC == 24, spm_pwr_status_err);

enum spm_hwcg_module_busy {
	HWCG_MODULE_ADSP = 0,
	HWCG_MODULE_MMPLL,
	HWCG_MODULE_TVDPLL,
	HWCG_MODULE_MSDCPLL,
	HWCG_MODULE_UNIVPLL
};

/* Resource requirement which PERI REQ support */
enum spm_peri_req {
	PERI_REQ_F26M = 0,
	PERI_REQ_INFRA,
	PERI_REQ_SYSPLL,
	PERI_REQ_APSRC,
	PERI_REQ_EMI,
	PERI_REQ_DDREN,
	PERI_REQ_MAX
};

enum spm_peri_req_en {
	PERI_REQ_EN_FLASHIF = 0,
	PERI_REQ_EN_AP_DMA,
	PERI_REQ_EN_UART0,
	PERI_REQ_EN_UART1,
	PERI_REQ_EN_UART2,
	PERI_REQ_EN_UART3,
	PERI_REQ_EN_UART4,
	PERI_REQ_EN_UART5,
	PERI_REQ_EN_PWM,
	PERI_REQ_EN_SPI0,
	PERI_REQ_EN_SPI0_INCR16,
	PERI_REQ_EN_SPI1,
	PERI_REQ_EN_SPI2,
	PERI_REQ_EN_SPI3,
	PERI_REQ_EN_SPI4,
	PERI_REQ_EN_SPI5,
	PERI_REQ_EN_SPI6,
	PERI_REQ_EN_SPI7,
	PERI_REQ_EN_IMP_IIC,
	PERI_REQ_EN_MSDC1,
	PERI_REQ_EN_MSDC2,
	PERI_REQ_EN_USB,
	PERI_REQ_EN_UFS0,
	PERI_REQ_EN_PEXTP1,
	PERI_REQ_EN_PEXTP0,
	PERI_REQ_EN_RSV_DUMMY0,
	PERI_REQ_EN_PERI_BUS_TRAFFIC,
	PERI_REQ_EN_RSV_DUMMY1,
	PERI_REQ_EN_RSV_FOR_MSDC,
	PERI_REQ_EN_MAX
};

CASSERT(PERI_REQ_EN_PWM == 8, spm_peri_req_en_err);
CASSERT(PERI_REQ_EN_SPI6 == 16, spm_peri_req_en_err);
CASSERT(PERI_REQ_EN_PEXTP0 == 24, spm_peri_req_en_err);

#define INFRA_AO_OFFSET(offset)		(INFRACFG_AO_BASE + offset)
#define INFRA_SW_CG_MASK		INFRA_AO_OFFSET(0x060)

#define REG_PERI_REQ_EN(N)	(PERICFG_AO_BASE + 0x070 + 0x4 * (N))
#define REG_PERI_REQ_STA(N)	(PERICFG_AO_BASE + 0x0A0 + 0x4 * (N))

static inline uint32_t spm_hwcg_num(void)
{
	return HWCG_MAX;
}

static inline uint32_t spm_peri_req_num(void)
{
	return PERI_REQ_MAX;
}

#endif /* MT_SPM_HWREQ_H */
