/*
 * Copyright (c) 2025, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MTK_SOC_TEMP_LVTS_H
#define MTK_SOC_TEMP_LVTS_H

/* Definition or macro function */
#define THERM_MODULE_SW_CG_0_SET (INFRACFG_AO_BASE + 0x80)
#define THERM_MODULE_SW_CG_0_CLR (INFRACFG_AO_BASE + 0x84)
#define THERM_BIT                (10)

#define THERMAL_REBOOT_TEMPERATURE (119000)

#define DEFAULT_EFUSE_GOLDEN_TEMP (50)
#define DEFAULT_EFUSE_GOLDEN_TEMP_HT (170)
#define DEFAULT_EFUSE_COUNT (35000)
#define DEFAULT_EFUSE_COUNT_RC (2750)

/* LVTS reset address */
#define THERM_AP_RESET_SET_OFFSET 0xf50
#define THERM_AP_RESET_CLR_OFFSET 0xf54
#define THERM_AP_RESET_SET_BITNUM 23
#define THERM_AP_RESET_CLR_BITNUM 23

#define THERM_MCU_RESET_SET_OFFSET 0xf20
#define THERM_MCU_RESET_CLR_OFFSET 0xf24
#define THERM_MCU_RESET_SET_BITNUM 12
#define THERM_MCU_RESET_CLR_BITNUM 12

/* LVTS efuse address */
#define NUM_EFUSE_ADDR 23

/* LVTS v1 common code */
#define SET_LVTS_MANUAL_RCK_V1 (DEVICE_WRITE | RG_TSV2F_CTRL_6 << 8 | 0x00)
#define SELECT_SENSOR_RCK_V1(id) (DEVICE_WRITE | RG_TSV2F_CTRL_5 << 8 | id)
#define KICK_OFF_RCK_COUNTING_V1 (DEVICE_WRITE | RG_TSFM_CTRL_0 << 8 | 0x02)
#define SET_SENSOR_NO_RCK_V1 (DEVICE_WRITE | RG_TSV2F_CTRL_5 << 8 | 0x10)
#define SET_DEVICE_LOW_POWER_SINGLE_MODE_V1 (DEVICE_WRITE \
					     | RG_TSFM_CTRL_3 << 8 | 0xF8)

/* LVTS MT8189 */
#define SET_DEVICE_SINGLE_MODE_8189 (DEVICE_WRITE | RG_TSFM_CTRL_3 << 8 | 0x78)
#define SET_TS_DIS_8189 (DEVICE_WRITE | RG_TSV2F_CTRL_0 << 8 | 0xF1)
#define SET_LVTS_MANUAL_RCK_OPERATION_8189 (DEVICE_WRITE \
					    | RG_TSV2F_CTRL_6 << 8 | 0x00)
#define SET_TS_DIV_EN_8189 (DEVICE_WRITE | RG_TSV2F_CTRL_0 << 8 | 0xF5)
#define SET_VCO_RST_8189 (DEVICE_WRITE | RG_TSV2F_CTRL_0 << 8 | 0xFD)
#define COF_A_T_SLP_GLD 219960
#define COF_A_COUNT_R_GLD 14437
#define COF_A_CONST_OFS 280000
#define COF_A_OFS (COF_A_T_SLP_GLD - COF_A_CONST_OFS)

#endif /* MTK_SOC_TEMP_LVTS_H */
