/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.NoSuchElementException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.NiceIterator;
import virtuoso.jena.driver.VirtGraph;

public class VirtResSetIter
extends NiceIterator<Triple> {
    protected Statement v_stmt;
    protected ResultSet v_resultSet;
    protected Triple v_row;
    protected Triple v_in;
    protected boolean v_finished = false;
    protected boolean v_prefetched = false;
    protected VirtGraph v_graph = null;

    public VirtResSetIter() {
        this.v_finished = true;
    }

    public VirtResSetIter(VirtGraph graph, Statement stmt, ResultSet resultSet, Triple in) {
        this.v_stmt = stmt;
        this.v_resultSet = resultSet;
        this.v_in = in;
        this.v_graph = graph;
    }

    public boolean hasNext() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        return !this.v_finished;
    }

    public Triple removeNext() {
        Triple ret = this.next();
        this.remove();
        return ret;
    }

    public Triple next() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        this.v_prefetched = false;
        if (this.v_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        if (this.v_row != null && this.v_graph != null) {
            this.v_graph.delete(this.v_row);
            this.v_row = null;
        }
    }

    protected void moveForward() {
        try {
            if (!this.v_finished && this.v_resultSet.next()) {
                this.extractRow();
                this.v_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    protected void extractRow() throws Exception {
        Node NodeS = this.v_in.getMatchSubject() != null ? this.v_in.getMatchSubject() : VirtGraph.Object2Node(this.v_resultSet.getObject("s"));
        Node NodeP = this.v_in.getMatchPredicate() != null ? this.v_in.getMatchPredicate() : VirtGraph.Object2Node(this.v_resultSet.getObject("p"));
        Node NodeO = this.v_in.getMatchObject() != null ? this.v_in.getMatchObject() : VirtGraph.Object2Node(this.v_resultSet.getObject("o"));
        this.v_row = Triple.create((Node)NodeS, (Node)NodeP, (Node)NodeO);
    }

    protected Triple getRow() {
        return this.v_row;
    }

    public void close() {
        if (!this.v_finished) {
            if (this.v_resultSet != null) {
                try {
                    this.v_resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.v_resultSet = null;
            }
            if (this.v_stmt != null) {
                try {
                    this.v_stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.v_stmt = null;
            }
        }
        this.v_finished = true;
    }
}

