#!/bin/sh
#
#  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
#  project.
#
#  Copyright (C) 1998-2025 OpenLink Software
#
#  This project is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; only version 2 of the License, dated June 1991.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#

# ----------------------------------------------------------------------
#  Fix issues with LOCALE
# ----------------------------------------------------------------------
LANG=C
LC_ALL=POSIX
export LANG LC_ALL

cache_file()
{
  rawfile=$1
  directory=introspection
  arrayname=cres_`echo ${rawfile} | sed 's/[.-]/_/g'`
  filename=${fileprefix}${rawfile}
  uri=${uriprefix}${rawfile}
  publicid=$2${rawfile}
  pdate=${publishingdate}
  comment=$3
  echo "static const char * ${arrayname}[] =" >> texts.tmp
  awk -f ../cached_resources/res_to_c.awk $directory/$filename >> texts.tmp
  echo "" >> texts.tmp
  echo "    virt_bootstrap_cache_resource (${arrayname}, \"${uri}\", \"${publicid}\", \"${pdate}\", \"${comment}\");" >> function.tmp
}

echo '#include "graphql.h"' > texts.tmp
echo "" > function.tmp

fileprefix=''
uriprefix='http://www.openlinksw.com/graphql/'
publishingdate='2022-09-10 00:00'
cache_file 'graphql-intro.ttl'	        ''	'Introspection Data for GQL bridge'
cache_file 'graphql-intro-schema.ttl'	''	'Introspection Schema for GQL bridge'

echo "/* This file is automatically generated */"
echo
cat texts.tmp
echo "void graphql_cache_resources (void)"
echo "{"
cat function.tmp
echo "}"
