/********************************************************************************
*                                                                               *
*                              C o l o r   N a m e s                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997,2025 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU Lesser General Public License as published by   *
* the Free Software Foundation; either version 3 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU Lesser General Public License for more details.                           *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public License      *
* along with this program.  If not, see <http://www.gnu.org/licenses/>          *
********************************************************************************/
#ifndef FXCOLORS_H
#define FXCOLORS_H


namespace FX {

namespace FXColors {

/// Big list of colors you can reference by name
const FXColor AliceBlue            = FXRGBA(240,248,255,255);
const FXColor AntiqueWhite         = FXRGBA(250,235,215,255);
const FXColor AntiqueWhite1        = FXRGBA(255,239,219,255);
const FXColor AntiqueWhite2        = FXRGBA(238,223,204,255);
const FXColor AntiqueWhite3        = FXRGBA(205,192,176,255);
const FXColor AntiqueWhite4        = FXRGBA(139,131,120,255);
const FXColor Aqua                 = FXRGBA(  0,255,255,255);
const FXColor Aquamarine           = FXRGBA(127,255,212,255);
const FXColor Aquamarine1          = FXRGBA(127,255,212,255);
const FXColor Aquamarine2          = FXRGBA(118,238,198,255);
const FXColor Aquamarine3          = FXRGBA(102,205,170,255);
const FXColor Aquamarine4          = FXRGBA( 69,139,116,255);
const FXColor Azure                = FXRGBA(240,255,255,255);
const FXColor Azure1               = FXRGBA(240,255,255,255);
const FXColor Azure2               = FXRGBA(224,238,238,255);
const FXColor Azure3               = FXRGBA(193,205,205,255);
const FXColor Azure4               = FXRGBA(131,139,139,255);
const FXColor Banana               = FXRGBA(227,207, 87,255);
const FXColor Beige                = FXRGBA(245,245,220,255);
const FXColor Bisque               = FXRGBA(255,228,196,255);
const FXColor Bisque1              = FXRGBA(255,228,196,255);
const FXColor Bisque2              = FXRGBA(238,213,183,255);
const FXColor Bisque3              = FXRGBA(205,183,158,255);
const FXColor Bisque4              = FXRGBA(139,125,107,255);
const FXColor Black                = FXRGBA(  0,  0,  0,255);
const FXColor BlanchedAlmond       = FXRGBA(255,235,205,255);
const FXColor Blue                 = FXRGBA(  0,  0,255,255);
const FXColor Blue1                = FXRGBA(  0,  0,255,255);
const FXColor Blue2                = FXRGBA(  0,  0,238,255);
const FXColor Blue3                = FXRGBA(  0,  0,205,255);
const FXColor Blue4                = FXRGBA(  0,  0,139,255);
const FXColor BlueViolet           = FXRGBA(138, 43,226,255);
const FXColor Brick                = FXRGBA(156,102, 31,255);
const FXColor Brown                = FXRGBA(165, 42, 42,255);
const FXColor Brown1               = FXRGBA(255, 64, 64,255);
const FXColor Brown2               = FXRGBA(238, 59, 59,255);
const FXColor Brown3               = FXRGBA(205, 51, 51,255);
const FXColor Brown4               = FXRGBA(139, 35, 35,255);
const FXColor Burlywood            = FXRGBA(222,184,135,255);
const FXColor Burlywood1           = FXRGBA(255,211,155,255);
const FXColor Burlywood2           = FXRGBA(238,197,145,255);
const FXColor Burlywood3           = FXRGBA(205,170,125,255);
const FXColor Burlywood4           = FXRGBA(139,115, 85,255);
const FXColor BurnedSienna         = FXRGBA(138, 54, 15,255);
const FXColor BurnedUmber          = FXRGBA(138, 51, 36,255);
const FXColor CadetBlue            = FXRGBA( 95,158,160,255);
const FXColor CadetBlue1           = FXRGBA(152,245,255,255);
const FXColor CadetBlue2           = FXRGBA(142,229,238,255);
const FXColor CadetBlue3           = FXRGBA(122,197,205,255);
const FXColor CadetBlue4           = FXRGBA( 83,134,139,255);
const FXColor CadmiumOrange        = FXRGBA(255, 97,  3,255);
const FXColor CadmiumRed           = FXRGBA(227, 23, 13,255);
const FXColor CadmiumYellow        = FXRGBA(255,153, 18,255);
const FXColor Carrot               = FXRGBA(237,145, 33,255);
const FXColor Chartreuse           = FXRGBA(127,255,  0,255);
const FXColor Chartreuse1          = FXRGBA(127,255,  0,255);
const FXColor Chartreuse2          = FXRGBA(118,238,  0,255);
const FXColor Chartreuse3          = FXRGBA(102,205,  0,255);
const FXColor Chartreuse4          = FXRGBA( 69,139,  0,255);
const FXColor Chocolate            = FXRGBA(210,105, 30,255);
const FXColor Chocolate1           = FXRGBA(255,127, 36,255);
const FXColor Chocolate2           = FXRGBA(238,118, 33,255);
const FXColor Chocolate3           = FXRGBA(205,102, 29,255);
const FXColor Chocolate4           = FXRGBA(139, 69, 19,255);
const FXColor Clear                = FXRGBA(  0,  0,  0,  0);    // Transparent
const FXColor Cobalt               = FXRGBA( 61, 89,171,255);
const FXColor CobaltGreen          = FXRGBA( 61,145, 64,255);
const FXColor ColdGray             = FXRGBA(128,138,135,255);
const FXColor Coral                = FXRGBA(255,127, 80,255);
const FXColor Coral1               = FXRGBA(255,114, 86,255);
const FXColor Coral2               = FXRGBA(238,106, 80,255);
const FXColor Coral3               = FXRGBA(205, 91, 69,255);
const FXColor Coral4               = FXRGBA(139, 62, 47,255);
const FXColor CornflowerBlue       = FXRGBA(100,149,237,255);
const FXColor Cornsilk             = FXRGBA(255,248,220,255);
const FXColor Cornsilk1            = FXRGBA(255,248,220,255);
const FXColor Cornsilk2            = FXRGBA(238,232,205,255);
const FXColor Cornsilk3            = FXRGBA(205,200,177,255);
const FXColor Cornsilk4            = FXRGBA(139,136,120,255);
const FXColor Crimson              = FXRGBA(220, 20, 60,255);
const FXColor Cyan                 = FXRGBA(  0,255,255,255);
const FXColor Cyan1                = FXRGBA(  0,255,255,255);
const FXColor Cyan2                = FXRGBA(  0,238,238,255);
const FXColor Cyan3                = FXRGBA(  0,205,205,255);
const FXColor Cyan4                = FXRGBA(  0,139,139,255);
const FXColor DarkBlue             = FXRGBA(  0,  0,139,255);
const FXColor DarkCyan             = FXRGBA(  0,139,139,255);
const FXColor DarkGoldenrod        = FXRGBA(184,134, 11,255);
const FXColor DarkGoldenrod1       = FXRGBA(255,185, 15,255);
const FXColor DarkGoldenrod2       = FXRGBA(238,173, 14,255);
const FXColor DarkGoldenrod3       = FXRGBA(205,149, 12,255);
const FXColor DarkGoldenrod4       = FXRGBA(139,101,  8,255);
const FXColor DarkGray             = FXRGBA(169,169,169,255);
const FXColor DarkGreen            = FXRGBA(  0,100,  0,255);
const FXColor DarkKhaki            = FXRGBA(189,183,107,255);
const FXColor DarkMagenta          = FXRGBA(139,  0,139,255);
const FXColor DarkOliveGreen       = FXRGBA( 85,107, 47,255);
const FXColor DarkOliveGreen1      = FXRGBA(202,255,112,255);
const FXColor DarkOliveGreen2      = FXRGBA(188,238,104,255);
const FXColor DarkOliveGreen3      = FXRGBA(162,205, 90,255);
const FXColor DarkOliveGreen4      = FXRGBA(110,139, 61,255);
const FXColor DarkOrange           = FXRGBA(255,140,  0,255);
const FXColor DarkOrange1          = FXRGBA(255,127,  0,255);
const FXColor DarkOrange2          = FXRGBA(238,118,  0,255);
const FXColor DarkOrange3          = FXRGBA(205,102,  0,255);
const FXColor DarkOrange4          = FXRGBA(139, 69,  0,255);
const FXColor DarkOrchid           = FXRGBA(153, 50,204,255);
const FXColor DarkOrchid1          = FXRGBA(191, 62,255,255);
const FXColor DarkOrchid2          = FXRGBA(178, 58,238,255);
const FXColor DarkOrchid3          = FXRGBA(154, 50,205,255);
const FXColor DarkOrchid4          = FXRGBA(104, 34,139,255);
const FXColor DarkRed              = FXRGBA(139,  0,  0,255);
const FXColor DarkSalmon           = FXRGBA(233,150,122,255);
const FXColor DarkSeaGreen         = FXRGBA(143,188,143,255);
const FXColor DarkSeaGreen1        = FXRGBA(193,255,193,255);
const FXColor DarkSeaGreen2        = FXRGBA(180,238,180,255);
const FXColor DarkSeaGreen3        = FXRGBA(155,205,155,255);
const FXColor DarkSeaGreen4        = FXRGBA(105,139,105,255);
const FXColor DarkSlateBlue        = FXRGBA( 72, 61,139,255);
const FXColor DarkSlateGray        = FXRGBA( 47, 79, 79,255);
const FXColor DarkSlateGray1       = FXRGBA(151,255,255,255);
const FXColor DarkSlateGray2       = FXRGBA(141,238,238,255);
const FXColor DarkSlateGray3       = FXRGBA(121,205,205,255);
const FXColor DarkSlateGray4       = FXRGBA( 82,139,139,255);
const FXColor DarkTurquoise        = FXRGBA(  0,206,209,255);
const FXColor DarkViolet           = FXRGBA(148,  0,211,255);
const FXColor DeepPink             = FXRGBA(255, 20,147,255);
const FXColor DeepPink1            = FXRGBA(255, 20,147,255);
const FXColor DeepPink2            = FXRGBA(238, 18,137,255);
const FXColor DeepPink3            = FXRGBA(205, 16,118,255);
const FXColor DeepPink4            = FXRGBA(139, 10, 80,255);
const FXColor DeepSkyBlue          = FXRGBA(  0,191,255,255);
const FXColor DeepSkyBlue1         = FXRGBA(  0,191,255,255);
const FXColor DeepSkyBlue2         = FXRGBA(  0,178,238,255);
const FXColor DeepSkyBlue3         = FXRGBA(  0,154,205,255);
const FXColor DeepSkyBlue4         = FXRGBA(  0,104,139,255);
const FXColor DimGray              = FXRGBA(105,105,105,255);
const FXColor DodgerBlue           = FXRGBA( 30,144,255,255);
const FXColor DodgerBlue1          = FXRGBA( 30,144,255,255);
const FXColor DodgerBlue2          = FXRGBA( 28,134,238,255);
const FXColor DodgerBlue3          = FXRGBA( 24,116,205,255);
const FXColor DodgerBlue4          = FXRGBA( 16, 78,139,255);
const FXColor Eggshell             = FXRGBA(252,230,201,255);
const FXColor EmeraldGreen         = FXRGBA(  0,201, 87,255);
const FXColor Firebrick            = FXRGBA(178, 34, 34,255);
const FXColor Firebrick1           = FXRGBA(255, 48, 48,255);
const FXColor Firebrick2           = FXRGBA(238, 44, 44,255);
const FXColor Firebrick3           = FXRGBA(205, 38, 38,255);
const FXColor Firebrick4           = FXRGBA(139, 26, 26,255);
const FXColor FloralWhite          = FXRGBA(255,250,240,255);
const FXColor ForestGreen          = FXRGBA( 34,139, 34,255);
const FXColor Fuchsia              = FXRGBA(255,  0,255,255);
const FXColor Gainsboro            = FXRGBA(220,220,220,255);
const FXColor GhostWhite           = FXRGBA(248,248,255,255);
const FXColor Gold                 = FXRGBA(255,215,  0,255);
const FXColor Gold1                = FXRGBA(255,215,  0,255);
const FXColor Gold2                = FXRGBA(238,201,  0,255);
const FXColor Gold3                = FXRGBA(205,173,  0,255);
const FXColor Gold4                = FXRGBA(139,117,  0,255);
const FXColor Goldenrod            = FXRGBA(218,165, 32,255);
const FXColor Goldenrod1           = FXRGBA(255,193, 37,255);
const FXColor Goldenrod2           = FXRGBA(238,180, 34,255);
const FXColor Goldenrod3           = FXRGBA(205,155, 29,255);
const FXColor Goldenrod4           = FXRGBA(139,105, 20,255);
const FXColor Gray                 = FXRGBA(190,190,190,255);
const FXColor Gray0                = FXRGBA(  0,  0,  0,255);   // More than Fifty Shades of Grey
const FXColor Gray1                = FXRGBA(  3,  3,  3,255);
const FXColor Gray2                = FXRGBA(  5,  5,  5,255);
const FXColor Gray3                = FXRGBA(  8,  8,  8,255);
const FXColor Gray4                = FXRGBA( 10, 10, 10,255);
const FXColor Gray5                = FXRGBA( 13, 13, 13,255);
const FXColor Gray6                = FXRGBA( 15, 15, 15,255);
const FXColor Gray7                = FXRGBA( 18, 18, 18,255);
const FXColor Gray8                = FXRGBA( 20, 20, 20,255);
const FXColor Gray9                = FXRGBA( 23, 23, 23,255);
const FXColor Gray10               = FXRGBA( 26, 26, 26,255);
const FXColor Gray11               = FXRGBA( 28, 28, 28,255);
const FXColor Gray12               = FXRGBA( 31, 31, 31,255);
const FXColor Gray13               = FXRGBA( 33, 33, 33,255);
const FXColor Gray14               = FXRGBA( 36, 36, 36,255);
const FXColor Gray15               = FXRGBA( 38, 38, 38,255);
const FXColor Gray16               = FXRGBA( 41, 41, 41,255);
const FXColor Gray17               = FXRGBA( 43, 43, 43,255);
const FXColor Gray18               = FXRGBA( 46, 46, 46,255);
const FXColor Gray19               = FXRGBA( 48, 48, 48,255);
const FXColor Gray20               = FXRGBA( 51, 51, 51,255);
const FXColor Gray21               = FXRGBA( 54, 54, 54,255);
const FXColor Gray22               = FXRGBA( 56, 56, 56,255);
const FXColor Gray23               = FXRGBA( 59, 59, 59,255);
const FXColor Gray24               = FXRGBA( 61, 61, 61,255);
const FXColor Gray25               = FXRGBA( 64, 64, 64,255);
const FXColor Gray26               = FXRGBA( 66, 66, 66,255);
const FXColor Gray27               = FXRGBA( 69, 69, 69,255);
const FXColor Gray28               = FXRGBA( 71, 71, 71,255);
const FXColor Gray29               = FXRGBA( 74, 74, 74,255);
const FXColor Gray30               = FXRGBA( 77, 77, 77,255);
const FXColor Gray31               = FXRGBA( 79, 79, 79,255);
const FXColor Gray32               = FXRGBA( 82, 82, 82,255);
const FXColor Gray33               = FXRGBA( 84, 84, 84,255);
const FXColor Gray34               = FXRGBA( 87, 87, 87,255);
const FXColor Gray35               = FXRGBA( 89, 89, 89,255);
const FXColor Gray36               = FXRGBA( 92, 92, 92,255);
const FXColor Gray37               = FXRGBA( 94, 94, 94,255);
const FXColor Gray38               = FXRGBA( 97, 97, 97,255);
const FXColor Gray39               = FXRGBA( 99, 99, 99,255);
const FXColor Gray40               = FXRGBA(102,102,102,255);
const FXColor Gray41               = FXRGBA(105,105,105,255);
const FXColor Gray42               = FXRGBA(107,107,107,255);
const FXColor Gray43               = FXRGBA(110,110,110,255);
const FXColor Gray44               = FXRGBA(112,112,112,255);
const FXColor Gray45               = FXRGBA(115,115,115,255);
const FXColor Gray46               = FXRGBA(117,117,117,255);
const FXColor Gray47               = FXRGBA(120,120,120,255);
const FXColor Gray48               = FXRGBA(122,122,122,255);
const FXColor Gray49               = FXRGBA(125,125,125,255);
const FXColor Gray50               = FXRGBA(127,127,127,255);
const FXColor Gray51               = FXRGBA(130,130,130,255);
const FXColor Gray52               = FXRGBA(133,133,133,255);
const FXColor Gray53               = FXRGBA(135,135,135,255);
const FXColor Gray54               = FXRGBA(138,138,138,255);
const FXColor Gray55               = FXRGBA(140,140,140,255);
const FXColor Gray56               = FXRGBA(143,143,143,255);
const FXColor Gray57               = FXRGBA(145,145,145,255);
const FXColor Gray58               = FXRGBA(148,148,148,255);
const FXColor Gray59               = FXRGBA(150,150,150,255);
const FXColor Gray60               = FXRGBA(153,153,153,255);
const FXColor Gray61               = FXRGBA(156,156,156,255);
const FXColor Gray62               = FXRGBA(158,158,158,255);
const FXColor Gray63               = FXRGBA(161,161,161,255);
const FXColor Gray64               = FXRGBA(163,163,163,255);
const FXColor Gray65               = FXRGBA(166,166,166,255);
const FXColor Gray66               = FXRGBA(168,168,168,255);
const FXColor Gray67               = FXRGBA(171,171,171,255);
const FXColor Gray68               = FXRGBA(173,173,173,255);
const FXColor Gray69               = FXRGBA(176,176,176,255);
const FXColor Gray70               = FXRGBA(179,179,179,255);
const FXColor Gray71               = FXRGBA(181,181,181,255);
const FXColor Gray72               = FXRGBA(184,184,184,255);
const FXColor Gray73               = FXRGBA(186,186,186,255);
const FXColor Gray74               = FXRGBA(189,189,189,255);
const FXColor Gray75               = FXRGBA(191,191,191,255);
const FXColor Gray76               = FXRGBA(194,194,194,255);
const FXColor Gray77               = FXRGBA(196,196,196,255);
const FXColor Gray78               = FXRGBA(199,199,199,255);
const FXColor Gray79               = FXRGBA(201,201,201,255);
const FXColor Gray80               = FXRGBA(204,204,204,255);
const FXColor Gray81               = FXRGBA(207,207,207,255);
const FXColor Gray82               = FXRGBA(209,209,209,255);
const FXColor Gray83               = FXRGBA(212,212,212,255);
const FXColor Gray84               = FXRGBA(214,214,214,255);
const FXColor Gray85               = FXRGBA(217,217,217,255);
const FXColor Gray86               = FXRGBA(219,219,219,255);
const FXColor Gray87               = FXRGBA(222,222,222,255);
const FXColor Gray88               = FXRGBA(224,224,224,255);
const FXColor Gray89               = FXRGBA(227,227,227,255);
const FXColor Gray90               = FXRGBA(229,229,229,255);
const FXColor Gray91               = FXRGBA(232,232,232,255);
const FXColor Gray92               = FXRGBA(235,235,235,255);
const FXColor Gray93               = FXRGBA(237,237,237,255);
const FXColor Gray94               = FXRGBA(240,240,240,255);
const FXColor Gray95               = FXRGBA(242,242,242,255);
const FXColor Gray96               = FXRGBA(245,245,245,255);
const FXColor Gray97               = FXRGBA(247,247,247,255);
const FXColor Gray98               = FXRGBA(250,250,250,255);
const FXColor Gray99               = FXRGBA(252,252,252,255);
const FXColor Gray100              = FXRGBA(255,255,255,255);
const FXColor Green                = FXRGBA(  0,255,  0,255);
const FXColor Green1               = FXRGBA(  0,255,  0,255);
const FXColor Green2               = FXRGBA(  0,238,  0,255);
const FXColor Green3               = FXRGBA(  0,205,  0,255);
const FXColor Green4               = FXRGBA(  0,139,  0,255);
const FXColor GreenYellow          = FXRGBA(173,255, 47,255);
const FXColor Honeydew             = FXRGBA(240,255,240,255);
const FXColor Honeydew1            = FXRGBA(240,255,240,255);
const FXColor Honeydew2            = FXRGBA(224,238,224,255);
const FXColor Honeydew3            = FXRGBA(193,205,193,255);
const FXColor Honeydew4            = FXRGBA(131,139,131,255);
const FXColor HotPink              = FXRGBA(255,105,180,255);
const FXColor HotPink1             = FXRGBA(255,110,180,255);
const FXColor HotPink2             = FXRGBA(238,106,167,255);
const FXColor HotPink3             = FXRGBA(205, 96,144,255);
const FXColor HotPink4             = FXRGBA(139, 58, 98,255);
const FXColor IndianRed            = FXRGBA(205, 92, 92,255);
const FXColor IndianRed1           = FXRGBA(255,106,106,255);
const FXColor IndianRed2           = FXRGBA(238, 99, 99,255);
const FXColor IndianRed3           = FXRGBA(205, 85, 85,255);
const FXColor IndianRed4           = FXRGBA(139, 58, 58,255);
const FXColor Indigo               = FXRGBA( 75,  0,130,255);
const FXColor Ivory                = FXRGBA(255,255,240,255);
const FXColor Ivory1               = FXRGBA(255,255,240,255);
const FXColor Ivory2               = FXRGBA(238,238,224,255);
const FXColor Ivory3               = FXRGBA(205,205,193,255);
const FXColor Ivory4               = FXRGBA(139,139,131,255);
const FXColor Khaki                = FXRGBA(240,230,140,255);
const FXColor Khaki1               = FXRGBA(255,246,143,255);
const FXColor Khaki2               = FXRGBA(238,230,133,255);
const FXColor Khaki3               = FXRGBA(205,198,115,255);
const FXColor Khaki4               = FXRGBA(139,134, 78,255);
const FXColor Lavender             = FXRGBA(230,230,250,255);
const FXColor LavenderBlush        = FXRGBA(255,240,245,255);
const FXColor LavenderBlush1       = FXRGBA(255,240,245,255);
const FXColor LavenderBlush2       = FXRGBA(238,224,229,255);
const FXColor LavenderBlush3       = FXRGBA(205,193,197,255);
const FXColor LavenderBlush4       = FXRGBA(139,131,134,255);
const FXColor LawnGreen            = FXRGBA(124,252,  0,255);
const FXColor LemonChiffon         = FXRGBA(255,250,205,255);
const FXColor LemonChiffon1        = FXRGBA(255,250,205,255);
const FXColor LemonChiffon2        = FXRGBA(238,233,191,255);
const FXColor LemonChiffon3        = FXRGBA(205,201,165,255);
const FXColor LemonChiffon4        = FXRGBA(139,137,112,255);
const FXColor LightBlue            = FXRGBA(173,216,230,255);
const FXColor LightBlue1           = FXRGBA(191,239,255,255);
const FXColor LightBlue2           = FXRGBA(178,223,238,255);
const FXColor LightBlue3           = FXRGBA(154,192,205,255);
const FXColor LightBlue4           = FXRGBA(104,131,139,255);
const FXColor LightCoral           = FXRGBA(240,128,128,255);
const FXColor LightCyan            = FXRGBA(224,255,255,255);
const FXColor LightCyan1           = FXRGBA(224,255,255,255);
const FXColor LightCyan2           = FXRGBA(209,238,238,255);
const FXColor LightCyan3           = FXRGBA(180,205,205,255);
const FXColor LightCyan4           = FXRGBA(122,139,139,255);
const FXColor LightGoldenrod       = FXRGBA(238,221,130,255);
const FXColor LightGoldenrod1      = FXRGBA(255,236,139,255);
const FXColor LightGoldenrod2      = FXRGBA(238,220,130,255);
const FXColor LightGoldenrod3      = FXRGBA(205,190,112,255);
const FXColor LightGoldenrod4      = FXRGBA(139,129, 76,255);
const FXColor LightGoldenrodYellow = FXRGBA(250,250,210,255);
const FXColor LightGray            = FXRGBA(211,211,211,255);
const FXColor LightGreen           = FXRGBA(144,238,144,255);
const FXColor LightPink            = FXRGBA(255,182,193,255);
const FXColor LightPink1           = FXRGBA(255,174,185,255);
const FXColor LightPink2           = FXRGBA(238,162,173,255);
const FXColor LightPink3           = FXRGBA(205,140,149,255);
const FXColor LightPink4           = FXRGBA(139, 95,101,255);
const FXColor LightSalmon          = FXRGBA(255,160,122,255);
const FXColor LightSalmon1         = FXRGBA(255,160,122,255);
const FXColor LightSalmon2         = FXRGBA(238,149,114,255);
const FXColor LightSalmon3         = FXRGBA(205,129, 98,255);
const FXColor LightSalmon4         = FXRGBA(139, 87, 66,255);
const FXColor LightSeaGreen        = FXRGBA( 32,178,170,255);
const FXColor LightSkyBlue         = FXRGBA(135,206,250,255);
const FXColor LightSkyBlue1        = FXRGBA(176,226,255,255);
const FXColor LightSkyBlue2        = FXRGBA(164,211,238,255);
const FXColor LightSkyBlue3        = FXRGBA(141,182,205,255);
const FXColor LightSkyBlue4        = FXRGBA( 96,123,139,255);
const FXColor LightSlateBlue       = FXRGBA(132,112,255,255);
const FXColor LightSlateGray       = FXRGBA(119,136,153,255);
const FXColor LightSteelBlue       = FXRGBA(176,196,222,255);
const FXColor LightSteelBlue1      = FXRGBA(202,225,255,255);
const FXColor LightSteelBlue2      = FXRGBA(188,210,238,255);
const FXColor LightSteelBlue3      = FXRGBA(162,181,205,255);
const FXColor LightSteelBlue4      = FXRGBA(110,123,139,255);
const FXColor LightYellow          = FXRGBA(255,255,224,255);
const FXColor LightYellow1         = FXRGBA(255,255,224,255);
const FXColor LightYellow2         = FXRGBA(238,238,209,255);
const FXColor LightYellow3         = FXRGBA(205,205,180,255);
const FXColor LightYellow4         = FXRGBA(139,139,122,255);
const FXColor Lime                 = FXRGBA(  0,255,  0,255);
const FXColor LimeGreen            = FXRGBA( 50,205, 50,255);
const FXColor Linen                = FXRGBA(250,240,230,255);
const FXColor Magenta              = FXRGBA(255,  0,255,255);
const FXColor Magenta1             = FXRGBA(255,  0,255,255);
const FXColor Magenta2             = FXRGBA(238,  0,238,255);
const FXColor Magenta3             = FXRGBA(205,  0,205,255);
const FXColor Magenta4             = FXRGBA(139,  0,139,255);
const FXColor Maroon               = FXRGBA(176, 48, 96,255);
const FXColor Maroon1              = FXRGBA(255, 52,179,255);
const FXColor Maroon2              = FXRGBA(238, 48,167,255);
const FXColor Maroon3              = FXRGBA(205, 41,144,255);
const FXColor Maroon4              = FXRGBA(139, 28, 98,255);
const FXColor MediumAquamarine     = FXRGBA(102,205,170,255);
const FXColor MediumBlue           = FXRGBA(  0,  0,205,255);
const FXColor MediumOrchid         = FXRGBA(186, 85,211,255);
const FXColor MediumOrchid1        = FXRGBA(224,102,255,255);
const FXColor MediumOrchid2        = FXRGBA(209, 95,238,255);
const FXColor MediumOrchid3        = FXRGBA(180, 82,205,255);
const FXColor MediumOrchid4        = FXRGBA(122, 55,139,255);
const FXColor MediumPurple         = FXRGBA(147,112,219,255);
const FXColor MediumPurple1        = FXRGBA(171,130,255,255);
const FXColor MediumPurple2        = FXRGBA(159,121,238,255);
const FXColor MediumPurple3        = FXRGBA(137,104,205,255);
const FXColor MediumPurple4        = FXRGBA( 93, 71,139,255);
const FXColor MediumSeaGreen       = FXRGBA( 60,179,113,255);
const FXColor MediumSlateBlue      = FXRGBA(123,104,238,255);
const FXColor MediumSpringGreen    = FXRGBA(  0,250,154,255);
const FXColor MediumTurquoise      = FXRGBA( 72,209,204,255);
const FXColor MediumVioletRed      = FXRGBA(199, 21,133,255);
const FXColor MidnightBlue         = FXRGBA( 25, 25,112,255);
const FXColor MintCream            = FXRGBA(245,255,250,255);
const FXColor MistyRose            = FXRGBA(255,228,225,255);
const FXColor MistyRose1           = FXRGBA(255,228,225,255);
const FXColor MistyRose2           = FXRGBA(238,213,210,255);
const FXColor MistyRose3           = FXRGBA(205,183,181,255);
const FXColor MistyRose4           = FXRGBA(139,125,123,255);
const FXColor Moccasin             = FXRGBA(255,228,181,255);
const FXColor NavajoWhite          = FXRGBA(255,222,173,255);
const FXColor NavajoWhite1         = FXRGBA(255,222,173,255);
const FXColor NavajoWhite2         = FXRGBA(238,207,161,255);
const FXColor NavajoWhite3         = FXRGBA(205,179,139,255);
const FXColor NavajoWhite4         = FXRGBA(139,121, 94,255);
const FXColor Navy                 = FXRGBA(  0,  0,128,255);
const FXColor NavyBlue             = FXRGBA(  0,  0,128,255);
const FXColor OldLace              = FXRGBA(253,245,230,255);
const FXColor Olive                = FXRGBA(128,128,  0,255);
const FXColor OliveDrab            = FXRGBA(107,142, 35,255);
const FXColor OliveDrab1           = FXRGBA(192,255, 62,255);
const FXColor OliveDrab2           = FXRGBA(179,238, 58,255);
const FXColor OliveDrab3           = FXRGBA(154,205, 50,255);
const FXColor OliveDrab4           = FXRGBA(105,139, 34,255);
const FXColor Orange               = FXRGBA(255,165,  0,255);
const FXColor Orange1              = FXRGBA(255,165,  0,255);
const FXColor Orange2              = FXRGBA(238,154,  0,255);
const FXColor Orange3              = FXRGBA(205,133,  0,255);
const FXColor Orange4              = FXRGBA(139, 90,  0,255);
const FXColor OrangeRed            = FXRGBA(255, 69,  0,255);
const FXColor OrangeRed1           = FXRGBA(255, 69,  0,255);
const FXColor OrangeRed2           = FXRGBA(238, 64,  0,255);
const FXColor OrangeRed3           = FXRGBA(205, 55,  0,255);
const FXColor OrangeRed4           = FXRGBA(139, 37,  0,255);
const FXColor Orchid               = FXRGBA(218,112,214,255);
const FXColor Orchid1              = FXRGBA(255,131,250,255);
const FXColor Orchid2              = FXRGBA(238,122,233,255);
const FXColor Orchid3              = FXRGBA(205,105,201,255);
const FXColor Orchid4              = FXRGBA(139, 71,137,255);
const FXColor PaleGoldenrod        = FXRGBA(238,232,170,255);
const FXColor PaleGreen            = FXRGBA(152,251,152,255);
const FXColor PaleGreen1           = FXRGBA(154,255,154,255);
const FXColor PaleGreen2           = FXRGBA(144,238,144,255);
const FXColor PaleGreen3           = FXRGBA(124,205,124,255);
const FXColor PaleGreen4           = FXRGBA( 84,139, 84,255);
const FXColor PaleTurquoise        = FXRGBA(175,238,238,255);
const FXColor PaleTurquoise1       = FXRGBA(187,255,255,255);
const FXColor PaleTurquoise2       = FXRGBA(174,238,238,255);
const FXColor PaleTurquoise3       = FXRGBA(150,205,205,255);
const FXColor PaleTurquoise4       = FXRGBA(102,139,139,255);
const FXColor PaleVioletRed        = FXRGBA(219,112,147,255);
const FXColor PaleVioletRed1       = FXRGBA(255,130,171,255);
const FXColor PaleVioletRed2       = FXRGBA(238,121,159,255);
const FXColor PaleVioletRed3       = FXRGBA(205,104,137,255);
const FXColor PaleVioletRed4       = FXRGBA(139, 71, 93,255);
const FXColor PapayaWhip           = FXRGBA(255,239,213,255);
const FXColor PeachPuff            = FXRGBA(255,218,185,255);
const FXColor PeachPuff1           = FXRGBA(255,218,185,255);
const FXColor PeachPuff2           = FXRGBA(238,203,173,255);
const FXColor PeachPuff3           = FXRGBA(205,175,149,255);
const FXColor PeachPuff4           = FXRGBA(139,119,101,255);
const FXColor Peru                 = FXRGBA(205,133, 63,255);
const FXColor Pink                 = FXRGBA(255,192,203,255);
const FXColor Pink1                = FXRGBA(255,181,197,255);
const FXColor Pink2                = FXRGBA(238,169,184,255);
const FXColor Pink3                = FXRGBA(205,145,158,255);
const FXColor Pink4                = FXRGBA(139, 99,108,255);
const FXColor Plum                 = FXRGBA(221,160,221,255);
const FXColor Plum1                = FXRGBA(255,187,255,255);
const FXColor Plum2                = FXRGBA(238,174,238,255);
const FXColor Plum3                = FXRGBA(205,150,205,255);
const FXColor Plum4                = FXRGBA(139,102,139,255);
const FXColor PowderBlue           = FXRGBA(176,224,230,255);
const FXColor Purple               = FXRGBA(160, 32,240,255);
const FXColor Purple1              = FXRGBA(155, 48,255,255);
const FXColor Purple2              = FXRGBA(145, 44,238,255);
const FXColor Purple3              = FXRGBA(125, 38,205,255);
const FXColor Purple4              = FXRGBA( 85, 26,139,255);
const FXColor Raspberry            = FXRGBA(135, 38, 87,255);
const FXColor Red                  = FXRGBA(255,  0,  0,255);
const FXColor Red1                 = FXRGBA(255,  0,  0,255);
const FXColor Red2                 = FXRGBA(238,  0,  0,255);
const FXColor Red3                 = FXRGBA(205,  0,  0,255);
const FXColor Red4                 = FXRGBA(139,  0,  0,255);
const FXColor RosyBrown            = FXRGBA(188,143,143,255);
const FXColor RosyBrown1           = FXRGBA(255,193,193,255);
const FXColor RosyBrown2           = FXRGBA(238,180,180,255);
const FXColor RosyBrown3           = FXRGBA(205,155,155,255);
const FXColor RosyBrown4           = FXRGBA(139,105,105,255);
const FXColor RoyalBlue            = FXRGBA( 65,105,225,255);
const FXColor RoyalBlue1           = FXRGBA( 72,118,255,255);
const FXColor RoyalBlue2           = FXRGBA( 67,110,238,255);
const FXColor RoyalBlue3           = FXRGBA( 58, 95,205,255);
const FXColor RoyalBlue4           = FXRGBA( 39, 64,139,255);
const FXColor SaddleBrown          = FXRGBA(139, 69, 19,255);
const FXColor Salmon               = FXRGBA(250,128,114,255);
const FXColor Salmon1              = FXRGBA(255,140,105,255);
const FXColor Salmon2              = FXRGBA(238,130, 98,255);
const FXColor Salmon3              = FXRGBA(205,112, 84,255);
const FXColor Salmon4              = FXRGBA(139, 76, 57,255);
const FXColor SandyBrown           = FXRGBA(244,164, 96,255);
const FXColor SeaGreen             = FXRGBA( 46,139, 87,255);
const FXColor SeaGreen1            = FXRGBA( 84,255,159,255);
const FXColor SeaGreen2            = FXRGBA( 78,238,148,255);
const FXColor SeaGreen3            = FXRGBA( 67,205,128,255);
const FXColor SeaGreen4            = FXRGBA( 46,139, 87,255);
const FXColor Seashell             = FXRGBA(255,245,238,255);
const FXColor Seashell1            = FXRGBA(255,245,238,255);
const FXColor Seashell2            = FXRGBA(238,229,222,255);
const FXColor Seashell3            = FXRGBA(205,197,191,255);
const FXColor Seashell4            = FXRGBA(139,134,130,255);
const FXColor Sepia                = FXRGBA( 94, 38, 18,255);
const FXColor Sienna               = FXRGBA(160, 82, 45,255);
const FXColor Sienna1              = FXRGBA(255,130, 71,255);
const FXColor Sienna2              = FXRGBA(238,121, 66,255);
const FXColor Sienna3              = FXRGBA(205,104, 57,255);
const FXColor Sienna4              = FXRGBA(139, 71, 38,255);
const FXColor Silver               = FXRGBA(192,192,192,255);
const FXColor SkyBlue              = FXRGBA(135,206,235,255);
const FXColor SkyBlue1             = FXRGBA(135,206,255,255);
const FXColor SkyBlue2             = FXRGBA(126,192,238,255);
const FXColor SkyBlue3             = FXRGBA(108,166,205,255);
const FXColor SkyBlue4             = FXRGBA( 74,112,139,255);
const FXColor SlateBlue            = FXRGBA(106, 90,205,255);
const FXColor SlateBlue1           = FXRGBA(131,111,255,255);
const FXColor SlateBlue2           = FXRGBA(122,103,238,255);
const FXColor SlateBlue3           = FXRGBA(105, 89,205,255);
const FXColor SlateBlue4           = FXRGBA( 71, 60,139,255);
const FXColor SlateGray            = FXRGBA(112,128,144,255);
const FXColor SlateGray1           = FXRGBA(198,226,255,255);
const FXColor SlateGray2           = FXRGBA(185,211,238,255);
const FXColor SlateGray3           = FXRGBA(159,182,205,255);
const FXColor SlateGray4           = FXRGBA(108,123,139,255);
const FXColor Snow                 = FXRGBA(255,250,250,255);
const FXColor Snow1                = FXRGBA(255,250,250,255);
const FXColor Snow2                = FXRGBA(238,233,233,255);
const FXColor Snow3                = FXRGBA(205,201,201,255);
const FXColor Snow4                = FXRGBA(139,137,137,255);
const FXColor SpringGreen          = FXRGBA(  0,255,127,255);
const FXColor SpringGreen1         = FXRGBA(  0,255,127,255);
const FXColor SpringGreen2         = FXRGBA(  0,238,118,255);
const FXColor SpringGreen3         = FXRGBA(  0,205,102,255);
const FXColor SpringGreen4         = FXRGBA(  0,139, 69,255);
const FXColor SteelBlue            = FXRGBA( 70,130,180,255);
const FXColor SteelBlue1           = FXRGBA( 99,184,255,255);
const FXColor SteelBlue2           = FXRGBA( 92,172,238,255);
const FXColor SteelBlue3           = FXRGBA( 79,148,205,255);
const FXColor SteelBlue4           = FXRGBA( 54,100,139,255);
const FXColor Tan                  = FXRGBA(210,180,140,255);
const FXColor Tan1                 = FXRGBA(255,165, 79,255);
const FXColor Tan2                 = FXRGBA(238,154, 73,255);
const FXColor Tan3                 = FXRGBA(205,133, 63,255);
const FXColor Tan4                 = FXRGBA(139, 90, 43,255);
const FXColor Teal                 = FXRGBA(  0,128,128,255);
const FXColor Thistle              = FXRGBA(216,191,216,255);
const FXColor Thistle1             = FXRGBA(255,225,255,255);
const FXColor Thistle2             = FXRGBA(238,210,238,255);
const FXColor Thistle3             = FXRGBA(205,181,205,255);
const FXColor Thistle4             = FXRGBA(139,123,139,255);
const FXColor Tomato               = FXRGBA(255, 99, 71,255);
const FXColor Tomato1              = FXRGBA(255, 99, 71,255);
const FXColor Tomato2              = FXRGBA(238, 92, 66,255);
const FXColor Tomato3              = FXRGBA(205, 79, 57,255);
const FXColor Tomato4              = FXRGBA(139, 54, 38,255);
const FXColor Turquoise            = FXRGBA( 64,224,208,255);
const FXColor Turquoise1           = FXRGBA(  0,245,255,255);
const FXColor Turquoise2           = FXRGBA(  0,229,238,255);
const FXColor Turquoise3           = FXRGBA(  0,197,205,255);
const FXColor Turquoise4           = FXRGBA(  0,134,139,255);
const FXColor Ultramarine          = FXRGBA(  0, 42,143,255);
const FXColor Violet               = FXRGBA(238,130,238,255);
const FXColor VioletRed            = FXRGBA(208, 32,144,255);
const FXColor VioletRed1           = FXRGBA(255, 62,150,255);
const FXColor VioletRed2           = FXRGBA(238, 58,140,255);
const FXColor VioletRed3           = FXRGBA(205, 50,120,255);
const FXColor VioletRed4           = FXRGBA(139, 34, 82,255);
const FXColor WarmGray             = FXRGBA(128,128,105,255);
const FXColor Wheat                = FXRGBA(245,222,179,255);
const FXColor Wheat1               = FXRGBA(255,231,186,255);
const FXColor Wheat2               = FXRGBA(238,216,174,255);
const FXColor Wheat3               = FXRGBA(205,186,150,255);
const FXColor Wheat4               = FXRGBA(139,126,102,255);
const FXColor White                = FXRGBA(255,255,255,255);
const FXColor WhiteSmoke           = FXRGBA(245,245,245,255);
const FXColor Yellow               = FXRGBA(255,255,  0,255);
const FXColor Yellow1              = FXRGBA(255,255,  0,255);
const FXColor Yellow2              = FXRGBA(238,238,  0,255);
const FXColor Yellow3              = FXRGBA(205,205,  0,255);
const FXColor Yellow4              = FXRGBA(139,139,  0,255);
const FXColor YellowGreen          = FXRGBA(154,205, 50,255);

}


/// Names of commonly used colors
extern FXAPI const FXchar *const colorName[683];


/// Values of corresponding colors
extern FXAPI const FXColor colorValue[683];


/**
* Determine the color value, given a color name.
*/
extern FXAPI FXColor colorFromName(const FXString& name);
extern FXAPI FXColor colorFromName(const FXchar* name);


/**
* Determine the color name, given a color value.
*/
extern FXAPI FXString nameFromColor(FXColor color);
extern FXAPI FXchar* nameFromColor(FXchar *name,FXColor color);


/**
* Blend source color over background color.
*/
extern FXAPI FXColor blendOverBackground(FXColor back,FXColor clr);


/**
* Blend source color over black background color.
*/
extern FXAPI FXColor blendOverBlack(FXColor clr);


/**
* Blend source color over white background color.
*/
extern FXAPI FXColor blendOverWhite(FXColor clr);


/**
* Blend color src toward color dst by a given percentage.
*/
extern FXAPI FXColor makeBlendColor(FXColor src,FXColor dst,FXint percent=50);


/**
* Compute a highlight color given a base color, brighten it up
* toward white by given percentage.
*/
extern FXAPI FXColor makeHiliteColor(FXColor clr,FXint percent=33);


/**
* Compute a shadow color given a base color, darken it down toward
* black by given percentage.
*/
extern FXAPI FXColor makeShadowColor(FXColor clr,FXint percent=33);

}

#endif
