/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractConcurrentInitializerTest<T>
extends AbstractLangTest {
    protected abstract ConcurrentInitializer<T> createInitializer();

    @Test
    public void testGet() throws ConcurrentException {
        Assertions.assertNotNull((Object)this.createInitializer().get(), (String)"No managed object");
    }

    @Test
    public void testGetConcurrent() throws ConcurrentException, InterruptedException {
        ConcurrentInitializer<T> initializer = this.createInitializer();
        int threadCount = 20;
        CountDownLatch startLatch = new CountDownLatch(1);
        GetThread[] threads = new GetThread[20];
        for (int i = 0; i < 20; ++i) {
            threads[i] = new GetThread(startLatch, initializer);
            threads[i].start();
        }
        startLatch.countDown();
        for (GetThread t : threads) {
            t.join();
        }
        Object managedObject = initializer.get();
        for (GetThread t : threads) {
            Assertions.assertEquals((Object)managedObject, (Object)t.object, (String)"Wrong object");
        }
    }

    @Test
    public void testGetMultipleTimes() throws ConcurrentException {
        ConcurrentInitializer<T> initializer = this.createInitializer();
        Object obj = initializer.get();
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)obj, (Object)initializer.get(), (String)("Got different object at " + i));
        }
    }

    @Test
    public void testisInitialized() throws Throwable {
        ConcurrentInitializer<T> initializer = this.createInitializer();
        if (initializer instanceof AbstractConcurrentInitializer) {
            AbstractConcurrentInitializer castedInitializer = (AbstractConcurrentInitializer)initializer;
            Assertions.assertFalse((boolean)castedInitializer.isInitialized(), (String)"was initialized before get()");
            Assertions.assertNotNull((Object)castedInitializer.get(), (String)"No managed object");
            Assertions.assertTrue((boolean)castedInitializer.isInitialized(), (String)"was not initialized after get()");
        }
    }

    static final class GetThread
    extends Thread {
        private Object object;
        private final CountDownLatch startLatch;
        private final ConcurrentInitializer<?> initializer;

        GetThread(CountDownLatch startLatch, ConcurrentInitializer<?> initializer) {
            this.startLatch = startLatch;
            this.initializer = initializer;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.object = this.initializer.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ConcurrentException cex) {
                this.object = cex;
            }
        }
    }
}

