#!/bin/sh
set -e
rev=$(git rev-parse HEAD)
ref=$(git for-each-ref 'refs/tags' --format='%(refname)' --sort=taggerdate | tail -n1)
last_tag=${ref#refs/tags/}

if [ -n "$1" ]; then
	tag="$1"
else
	ifs=$IFS; IFS=-
	set -- $(git describe --tags)
	IFS=$ifs
	tag=$(($1 + $2))
fi

cat <<EOF
Making tag: $tag at revision $rev

You probably want to fill git shortlog from last tag $last_tag as annotated tag message:

  git shortlog $last_tag..HEAD

Press ENTER to continue, Ctrl+C to abort
EOF
read a

git tag -a "$tag" $rev

cat <<EOF

To push tag, execute:

  git push origin "refs/tags/$tag"
EOF
