#!/bin/sh
# geninitrd mod: bcache
# requires 3.10 kernel
# http://bcache.evilpiepirate.org/
USE_BCACHE=${USE_BCACHE:-yes}

# setup geninitrd module
# @access   public
setup_mod_bcache() {
	if [ ! -d /sys/fs/bcache ]; then
		USE_BCACHE=no
	fi

	if [ ! -x /lib/udev/bcache-register ]; then
		USE_BCACHE=no
	fi
}

# find modules for $devpath
# @param	$devpath	device to be examined
# @access	public
find_modules_bcache() {
	if ! is_yes "$USE_BCACHE"; then
		return
	fi

	local devpath="$1"
	local dev=${devpath#/dev/}
	local slavedir=/sys/block/$dev/slaves

	if [ ! -d $slavedir ]; then
		die "Cannot inspect $slavedir for $devpath"
	fi

	for dev in $slavedir/*; do
		dev=${dev#$slavedir/}
		find_modules_for_devpath /dev/$dev
	done

	find_module "bcache"
}

# generate initrd fragment
# @access   public
initrd_gen_bcache() {
	if ! is_yes "$USE_BCACHE"; then
		return
	fi

	verbose "Adding bcache support to initrd"

	inst_rules 69-bcache.rules
	inst_exec /lib/udev/bcache-register /lib/udev
}
