#!/bin/sh
# geninitrd mod: fbsplash
FB_SPLASH=${FB_SPLASH:-no}

# requires splashutils package to operate

# setup geninitrd module
# @access	public
setup_mod_fbsplash() {
	fbsplash_geninitramfs=$(find_tool /usr/sbin/splash_geninitramfs /usr/bin/splash_geninitramfs)
	if [ ! -x "$fbsplash_geninitramfs" ]; then
		FB_SPLASH=no
		return
	fi

	if is_yes "$FB_SPLASH" && [ "$INITRDFS" != "initramfs" ]; then
		warn "Using fbsplash requires INITRDFS=initramfs; skipping fbsplash generation"
		FB_SPLASH=no
	fi

	# NOTE: this check must be also in bootsplash module as the order of module load may change
	if is_yes "$FB_SPLASH"  && is_yes "$BOOT_SPLASH"; then
		warn "bootsplash and fbsplash are exclusive!"
	fi
}

# find modules for for fbsplash
# @access	public
find_modules_fbsplash() {
	if ! is_yes "$FB_SPLASH"; then
		return
	fi

	find_module "-evdev"
}

# generate initrd fragment
# @access	public
initrd_gen_fbsplash() {
	if ! is_yes "$FB_SPLASH"; then
		return
	fi
	verbose "Generating fbsplash"

	if [ -r /etc/sysconfig/fbsplash ]; then
		. /etc/sysconfig/fbsplash
	fi

	if [ -z "$SPLASH_THEME" ]; then
		warn "Please configure your /etc/sysconfig/fbsplash first."
		warn "Generating fbsplashes skipped."
		return
	fi

	if [ -z "$FB_SPLASH_RESOLUTIONS" ]; then
		warn "No FB_SPLASH_RESOLUTIONS specified in /etc/sysconfig/fbsplash."
		warn "Not adding fbsplash to initramfs."
		return
	fi

	local res
	for res in $FB_SPLASH_RESOLUTIONS; do
		if [ -f "/etc/splash/$SPLASH_THEME/$res.cfg" ]; then
			$fbsplash_geninitramfs -c $DESTDIR -r $res $SPLASH_THEME && \
			verbose "Added $res $SPLASH_THEME theme to initramfs."
		else
			warn "/etc/splash/$SPLASH_THEME/$res.cfg doesn't exist, skipped"
		fi
	done
}
