#!/bin/sh
# geninitrd mod: sata

find_modules_sata() {
	verbose "Finding SATA modules (class=0x0106)"

	# Classes (we want only 0106)
	# http://pci-ids.ucw.cz/read/PD/01
	# 0100 - SCSI
	# 0101 - IDE/PATA
	# 0106 - SATA/AHCI
	# 0107 - SAS
	local m modules=$(find_modules_by_class 0106)

	# sort modules that ones who depend on libata are first
	# this is best we could think of now :)
	local left right
	for m in $modules; do
		if NEW_MODINFO=1 modinfo -k $kernel -F depends $m | grep -q libata; then
			left="$left $m"
		else
			right="$right $m"
		fi
	done

	for m in $left $right; do
		find_module $m
	done
}
