#!/bin/sh
# geninitrd mod: scsi

# it should be safe to remove scsi_mod from here, but I'm not sure...
PRESCSIMODS="-scsi_mod unknown -sd_mod"

# ???
ide_only_root=${ide_only_root:-no}

# allow forcing loading IDE modules, likely from sysconfig/geninitrd
ADDIDE=${ADDIDE:-no}

# return true if node is scsi device
# @param	string $node device node to be examined
# @access	public
is_scsi() {
	local node="$1"
	if [ ! -e "$node" ]; then
		warn "is_scsi(): node $node doesn't exist!"
		return 1
	fi

	# TODO: more sophisticated check, not just pathname check
	if is_yes "$(echo "$node" | awk '/^\/dev\/(sd|scsi|vd)/ { print "yes"; }')"; then
		return 0
	fi

	return 1
}

# find modules for $devpath
# @param	$devpath	device to be examined
# @access	public
find_modules_scsi() {
	local devpath=$1

	local n
	for n in $PRESCSIMODS; do
		if [ "X$n" = "Xunknown" ]; then
			verbose "Finding SCSI modules using scsi_hostadapter"
			local mod scsimodules=$(modprobe_conf | awk '/scsi_hostadapter/ { print $3 }')
			for mod in $scsimodules; do
				# for now allow scsi modules to come from anywhere. There are some
				# RAID controllers with drivers in block
				find_module "$mod"
			done
		else
			find_module "$n"
		fi
	done
	find_module "-scsi_wait_scan"
}


# generate initrd fragment for ide device init
# @access	public
initrd_gen_scsi() {
	# nothing to do here
	return 0
}
