#!/bin/sh
# for is_yes
. /etc/rc.d/init.d/functions

. ./setup-test.sh
flags=$-

sysfs=${sysfs:-/sys}
have_lspci=yes

lowercase() {
	echo "$1" | LC_ALL=C tr '[A-Z]' '[a-z]'
}

find_modules_by_class() {
	set -$flags

	# XXX: not sure, which to prefer, /sys or lspci
	if is_yes "$have_lspci"; then
		pcimap='modules.pcimap-2.6.33.4-1'
		lspci='cat lspci-mod-sata.txt'
		local module vendordev
		vendordev=$($lspci | awk '/0106/{ gsub(/:/," "); print "0x0000"$4 " " "0x0000"$5}')
		module=$(grep "$vendordev" "$pcimap" | awk '{print $1}')
		echo $module
	fi

	local path module class="$1"
	for path in $(grep -l $class $sysfs/bus/pci/devices/*/class); do
		module=$(readlink ${path%/class}/driver)
		module=${module##*/}
		# 2.6.16 (at least) has this uppercased, workaround
		lowercase $module
	done
}


find_modules_sata() {
	set -$flags

	find_modules_by_class 0x0101
}

find_modules_xata() {
	set -$flags

	find_modules_by_class 0x0106
}

runtest_run() {
	have_lspci=no sysfs=sysfs find_modules_sata
}
runtest <<'EOF'
ata_piix
ata_piix
EOF

runtest_run() {
	have_lspci=yes find_modules_xata
}
runtest <<'EOF'
ahci
EOF

echo "OK: $ok; FAIL: $fail"
