#!/bin/sh
# test for initrd_gen_initramfs_switchroot parsing

. ./setup-test.sh
proc=${proc:-/proc}
partitions=$proc/partitions
flags=$-

mount() {
	echo "mount $@"
}

mknod() {
	: echo "mknod $@"
}

	# parse 'root=xxx' kernel commandline
	# We support passing root as hda3 /dev/hda3 0303 0x0303 and 303
#	add_linuxrc <<-'EOF'
runtest_run() {
	set -$flags

		device=
		eval "$(
		busybox awk -v root="$ROOT" '
			# http://9fans.net/archive/2006/09/261
			function h2d(str, hstr, res, num, n, digit, i) {
				hstr = "0123456789abdcef";
				res = 0;
				n = split(tolower(str), digit, "");

				for (i = 1; i <= n; i++) {
					num = index(hstr, digit[i]) - 1;
					res = res + (num * 16 ^ (n - i));
				}
printf("# h2d(%s) -> [%s]\n", str, res);

				return res;
			}
			BEGIN {

				num_pattern_short = "[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]";
				num_pattern = "[0-9a-fA-F]" num_pattern_short;
				dev_pattern = "[hms][a-z][a-z]([0-9])+";
				partition = "";
				min = -1; maj = -1;

				# see if we have /dev/hdX or hdX, we can just take partition name
				if (root ~ "^\/dev\/" dev_pattern "$" || root ~ "^" dev_pattern "$") {
					partition = root
					sub("^/dev/", "", partition);
					printf("# partition regexp=%s;\n", partition);

				} else {
					# unify values first
					if (root ~ "^" num_pattern_short "$")  {
						# change "303" => "0x0303"
						root = "0x0" root
					} else if (root ~ "^" num_pattern "$")  {
						# change "0303" => "0x0303"
						root = "0x" root
					}

					maj = h2d(substr(root, 3, 2));
					min = h2d(substr(root, 5, 2));
printf("# BEGIN: root=[%s] maj=%s, min=%s\n", root, maj, min);
				}
			}
{ printf("# maj:[%s], min:[%s], part:[%s]\n", $1, $2, $4) }

			partition && $4 == partition { maj = $1; min = $2; printf("# found partition: %s\n", partition) }
			$1 == maj && $2 == min { partition = $4; printf("# found maj and min: %s, %s\n", maj, min)}

			END {
				if (maj >= 0 && min >= 0) {
					printf("maj=%s; min=%s;\n", maj, min);
				}
				if (partition) {
					printf("device=/dev/%s;\n", partition);
				}
			}
			' $partitions
		)"

		if [ -z "$device" ]; then
			device=$ROOT
		fi

		if [ "$device" -a ! -b $device ]; then
			mknod $device b $maj $min
		fi

		[ -n "$ROOTFLAGS" ] && ROOTFLAGS="-o $ROOTFLAGS"

		mount -t $ROOTFS -r $device $ROOTFLAGS /newroot || echo "Mount of rootfs failed."
		init=$INIT
		if [ -z "$init" -o ! -x "/newroot$init" ]; then
			init=/sbin/init
		fi
#	EOF
#	echo "init=$init"
}

partitions=./partitions
ROOTFS=xfs

# We support passing root as hda3 /dev/hda3 0303 0x0303 and 303
ROOT=sda3
runtest <<'EOF'
mount -t xfs -r /dev/sda3 /newroot
EOF

ROOT=/dev/sda3
runtest <<'EOF'
mount -t xfs -r /dev/sda3 /newroot
EOF

ROOT=0803
runtest <<'EOF'
mount -t xfs -r /dev/sda3 /newroot
EOF

ROOT=0x0803
runtest <<'EOF'
mount -t xfs -r /dev/sda3 /newroot
EOF

ROOT=803
runtest <<'EOF'
mount -t xfs -r /dev/sda3 /newroot
EOF

ROOT=805
runtest <<'EOF'
mount -t xfs -r /dev/sda5 /newroot
EOF

# lilo for dm-0
partitions=./partitions2
ROOT=fe00
runtest <<'EOF'
mount -t xfs -r /dev/dm-0 /newroot
EOF

# lilo for dm-0
partitions=./partitions2
ROOT=FE00
runtest <<'EOF'
mount -t xfs -r /dev/dm-0 /newroot
EOF
